/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.vecmath.Point3d;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.image.ImageManager;
import thunderheadeng.scene3d.IntermediateGraphicsXfer;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.MerlinOp;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.VentusData;
import ventus.data.image.BGImage;
import ventus.data.image.ImageGroup;
import ventus.data.image.RasterImage;
import ventus.geom.Geometry;
import ventus.gui.guiUtil;
import ventus.mv.MerlinColors;

public class AddBGImage
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("ventus/icons/backgroundImage16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new AddBGImage(), Intl.intl("New Background Image..."), ICON);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(VentusApp app, VentusData md) {
        IntermediateGraphicsXfer igx = new IntermediateGraphicsXfer();
        try {
            UnitDouble defZ = md.activeFloor().getWorkingZ();
            BGImageDlg.ImageInfo info = md.ui(() -> AddBGImage.newBGImage(app.getMainFrame(), defZ, igx));
            if (info == null) {
                return;
            }
            BGImage newImg = new BGImage(info.image.getFilename(), info.image);
            AddBGImage.applyBGInfo(newImg, info);
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("New Image"));
                AddBGImage.addBGImage(md, newImg);
                Undo.end(md);
            }
        }
        finally {
            igx.release();
        }
    }

    public static BGImageDlg.ImageInfo newBGImage(Window parent, UnitDouble defZ, IntermediateGraphicsXfer<String> igx) {
        return AddBGImage.showBGImageDlg(parent, null, igx, defZ);
    }

    public static BGImageDlg.ImageInfo editBGImage(Window parent, BGImage img, IntermediateGraphicsXfer<String> igx) {
        double defZ = img.getAnchorModel().z();
        return AddBGImage.showBGImageDlg(parent, img, igx, new UnitDouble(defZ, Geometry.LENGTH_UNIT));
    }

    private static BGImageDlg.ImageInfo showBGImageDlg(Window parent, BGImage img, IntermediateGraphicsXfer<String> igx, UnitDouble defZ) {
        VentusApp app = VentusApp.getApp();
        HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>> colorMap = new HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>>();
        colorMap.put(BGImageDlg.Colors.AXIS, MerlinColors.AXIS_COLOR);
        colorMap.put(BGImageDlg.Colors.AXIS_BOX, MerlinColors.AXIS_BOX_COLOR);
        colorMap.put(BGImageDlg.Colors.AXIS_TEXT, MerlinColors.AXIS_TEXT_COLOR);
        colorMap.put(BGImageDlg.Colors.BACKGROUND, MerlinColors.BACKGROUND_COLOR);
        colorMap.put(BGImageDlg.Colors.ORIGIN, MerlinColors.ORIGIN2D_COLOR);
        ImageLoader imgLoader = new ImageLoader(parent, defZ);
        BGImageDlg.ImageInfo existing = null;
        if (img != null) {
            existing = new BGImageDlg.ImageInfo(img.getImage(), img.getTransformInfo(), img.getOpacity());
        }
        return BGImageDlg.editImage(parent, app.getModelView().getRenderComp(), app.getColorManager(), colorMap, imgLoader, app.getUnitSystem().getLength(), igx, existing);
    }

    public static void applyBGInfo(BGImage img, BGImageDlg.ImageInfo info) {
        img.setImage(info.image);
        img.setFilename(info.image.getFilename());
        img.setTransformInfo(info.xform.anchorImage, new UnitPoint3D(info.xform.anchorModel, Geometry.LENGTH_UNIT), info.xform.aImage, info.xform.bImage, new UnitDouble(info.xform.distABModel, Geometry.LENGTH_UNIT), new UnitDouble(info.xform.abAngle, Geometry.ANGLE_UNIT));
        img.setOpacity(info.opacity);
    }

    public static void addBGImage(VentusData md, RasterImage image) {
        ImageGroup ig = AddBGImage.getBGGroup(md);
        Undo.insertUndoEntry_delete(md, ig, image);
        ig.add(image);
        Undo.insertUndoEntry_restoreSelection(md);
        md.selection.set(image);
    }

    private static ImageGroup getBGGroup(VentusData md) {
        Collection<ImageGroup> igroups = md.sceneGeom.getMembers(ImageGroup.class);
        if (!igroups.isEmpty()) {
            return igroups.iterator().next();
        }
        ImageGroup ig = new ImageGroup();
        Undo.insertUndoEntry_delete(md, md.sceneGeom, ig);
        md.sceneGeom.insert(Arrays.asList(ig), 0);
        return ig;
    }

    private static class ImageLoader
    implements BGImageDlg.IImageLoader {
        private static final String[] FILTERS = new String[]{"bmp", Intl.intl("BMP Files"), "gif", Intl.intl("GIF Files"), "jpg", Intl.intl("JPEG Files"), "jpeg", Intl.intl("JPEG Files"), "jif", Intl.intl("JPEG Files"), "jpe", Intl.intl("JPEG Files"), "png", Intl.intl("PNG Files"), "pdf", Intl.intl("PDF Files"), "tif", Intl.intl("TIF Files"), "tga", Intl.intl("TARGA Files"), "targa", Intl.intl("TARGA Files")};
        public final UnitDouble d_defZ;
        private final Window d_dlgParent;

        public ImageLoader(Window dlgParent, UnitDouble defZ) {
            this.d_dlgParent = dlgParent;
            this.d_defZ = defZ;
        }

        @Override
        public File choose(Component parent, File currFile) {
            guiJFXFileChooser chooser = new guiJFXFileChooser(currFile != null ? currFile.getAbsolutePath() : null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)true, (Boolean)true, (Boolean)false, FileFilters.EXT_FILTER_BMP, FileFilters.EXT_FILTER_GIF, FileFilters.EXT_FILTER_JPEG_ALL, FileFilters.EXT_FILTER_PNG, FileFilters.EXT_FILTER_TIFF, FileFilters.EXT_FILTER_TARGA);
            File f = chooser.showOpenDialog();
            if (f != null) {
                MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
            }
            return f;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private File convertPdfToTempImage(File pdfFile) {
            try (PDDocument pdfDoc = PDDocument.load(pdfFile);){
                guiDialog dlg = new guiDialog(this.d_dlgParent, Intl.intl("PDF Options"), 9);
                dlg.setResizable(true);
                IntVR pageRange = IntVR.between(1, pdfDoc.getNumberOfPages(), true, true);
                ValueField<Integer> pageField = ValueFields.intFld(pageRange);
                if (pdfDoc.getNumberOfPages() == 1) {
                    pageField.setEditable(false);
                }
                guiComboBox<PdfOptions.Quality> qualityBox = new guiComboBox<PdfOptions.Quality>(PdfOptions.Quality.values());
                qualityBox.setSelectedItem((Object)PdfOptions.Quality.MEDIUM);
                GridBagHelper gbh = new GridBagHelper(dlg.getDialogPane());
                gbh.addRow(String.format(Intl.intl("Page (%s - %s):"), 1, pdfDoc.getNumberOfPages()), pageField, 1.0);
                gbh.addRow(Intl.intl("Quality:"), qualityBox);
                gbh.finalizeRows();
                if (dlg.doModal() == 1) {
                    PdfOptions pdfOptionsInput = new PdfOptions(qualityBox.getSelectedItem(), (Integer)pageField.getValue());
                    PDFRenderer render = new PDFRenderer(pdfDoc);
                    BufferedImage img = render.renderImageWithDPI(pdfOptionsInput.pageOneBased - 1, pdfOptionsInput.quality.dpi);
                    File tempFile = File.createTempFile(pdfFile.getName(), ".jpg", pdfFile.getParentFile());
                    tempFile.deleteOnExit();
                    ImageIO.write((RenderedImage)img, "jpg", tempFile);
                    File file = tempFile;
                    return file;
                }
                File file2 = null;
                return file2;
            }
            catch (IOException e) {
                e.printStackTrace();
                guiUtil.showError(this.d_dlgParent, Intl.intl("Error"), Intl.intl("Error rendering PDF"), (Throwable)e);
                return null;
            }
        }

        @Override
        public Pair<Image, BGImageXform> load(File file) throws IOException {
            String filename = file.getAbsolutePath();
            IImage img = ImageManager.getImage(filename);
            if (img == null) {
                throw new IOException(Intl.intl("Could not load image."));
            }
            BGImageXform xform = new BGImageXform(null, new Point3d(0.0, 0.0, this.d_defZ.getValue(Geometry.LENGTH_UNIT)), null, null, Double.NaN, 0.0);
            return new Pair<Image, BGImageXform>((Image)img, xform);
        }
    }

    private static class PdfOptions {
        public final Quality quality;
        public final int pageOneBased;

        public PdfOptions(Quality quality, int pageOneBased) {
            this.quality = quality;
            this.pageOneBased = pageOneBased;
        }

        public static enum Quality {
            LOW(72, Intl.intl("Low - 72 dpi")),
            MEDIUM(150, Intl.intl("Medium - 150 dpi")),
            HIGH(300, Intl.intl("High - 300 dpi"));

            final int dpi;
            final String desc;

            private Quality(int dpi, String desc) {
                this.dpi = dpi;
                this.desc = desc;
            }

            public String toString() {
                return this.desc;
            }
        }
    }
}

