/*
 * Decompiled with CFR 0.152.
 */
package ventus;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ResourcePaths;
import thunderheadeng.gui.ThemeChooserMenu;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiMenu;
import thunderheadeng.gui.guiToolBar;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.KeyboardAcceleratorIO;
import thunderheadeng.license3.LicensePrompt;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.VersionUtil;
import ventus.AdditionalLogParams;
import ventus.CrashHandler;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusLM;
import ventus.actions.AMerlinOp;
import ventus.actions.AboutAction;
import ventus.actions.AddBGImage;
import ventus.actions.AddBackgroundQuad;
import ventus.actions.CaptureCamera;
import ventus.actions.ChangeGroupAction;
import ventus.actions.CheckForUpdatesAction;
import ventus.actions.ClearSelection;
import ventus.actions.CloseGapsAction;
import ventus.actions.Delete;
import ventus.actions.EditPreferences;
import ventus.actions.EditProps;
import ventus.actions.EnableAction;
import ventus.actions.Exit;
import ventus.actions.ExportObj;
import ventus.actions.FilterVisible;
import ventus.actions.FindAction;
import ventus.actions.Hide;
import ventus.actions.License;
import ventus.actions.ManageMaterials;
import ventus.actions.MergeImportedGeomAction;
import ventus.actions.MerlinActionMap;
import ventus.actions.New;
import ventus.actions.NewFloor;
import ventus.actions.NewGroup;
import ventus.actions.NewViewFromCamera;
import ventus.actions.Open;
import ventus.actions.RecentFilesAction;
import ventus.actions.RemoveImportedUVAction;
import ventus.actions.RenameAction;
import ventus.actions.Save;
import ventus.actions.SaveAs;
import ventus.actions.SaveOutputLogAction;
import ventus.actions.Screenshot;
import ventus.actions.SelectByColor;
import ventus.actions.SelectByMaterial;
import ventus.actions.SelectConflictingComps;
import ventus.actions.SelectInvalidObjs;
import ventus.actions.SelectNonGroupDescendents;
import ventus.actions.SelectReferencing;
import ventus.actions.SelectSubitems;
import ventus.actions.SetActiveFloor;
import ventus.actions.SetZAction;
import ventus.actions.Show;
import ventus.actions.ShowAll;
import ventus.actions.ShowAllFloors;
import ventus.actions.ShowLowerActiveLevel;
import ventus.actions.ShowReferencingObjects;
import ventus.actions.ShowView;
import ventus.actions.SortAlphaAction;
import ventus.actions.SortByFloor;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.UnitsAction;
import ventus.actions.copypaste.Copy;
import ventus.actions.copypaste.Paste;
import ventus.actions.geomops.CleanupRooms;
import ventus.actions.geomops.MergeGeom;
import ventus.actions.geomops.SeparateGeom;
import ventus.actions.importgeom.Import;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.Feature;
import ventus.feature.ahs.AHSFeature;
import ventus.feature.ahssimple.SimpleAHSFeature;
import ventus.feature.comps.IAppMenuItem;
import ventus.feature.comps.IAppToolbarButton;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.comps.IDataModel;
import ventus.feature.comps.IHotkey;
import ventus.feature.coreextensions.ExtendCoreFeature;
import ventus.feature.export.ExportFeature;
import ventus.feature.flowpaths.FlowPathsFeature;
import ventus.feature.help.ContamDocsFeature;
import ventus.feature.help.SupportSiteFeature;
import ventus.feature.help.UserManualFeature;
import ventus.feature.levels.LevelFeature;
import ventus.feature.model.NewGroupFeature;
import ventus.feature.model.NewViewFeature;
import ventus.feature.plot.PlotFeature;
import ventus.feature.results.ResultsFeature;
import ventus.feature.runsim.RunSimFeature;
import ventus.feature.simparams.SimParamsFeature;
import ventus.feature.sourcesink.SourceSinkFeature;
import ventus.feature.species.SpeciesFeature;
import ventus.feature.tags.TagFeature;
import ventus.feature.weather.WeatherFeature;
import ventus.feature.windprofiles.WindProfileFeature;
import ventus.feature.zone.ZoneFeature;
import ventus.gui.ActivationDlg;
import ventus.gui.CheckForUpdatesDlg;
import ventus.gui.FloorComboBox;
import ventus.gui.guiUtil;
import ventus.mv.MerlinColors;
import ventus.mv.ModelView;
import ventus.treeview.TreeView;
import ventus.unitsystem.EnglishUS;
import ventus.unitsystem.SIUS;
import ventus.unitsystem.UnitSystem;

public class VentusApp
extends Application {
    private final VentusData d_data;
    private final Collection<Feature> d_features;
    private final MerlinColors d_colorMgr;
    private final TreeView d_tv;
    private final ModelView d_mv;
    private final RecentFilesAction d_recentFilesAction;
    private final Undo.StackSizePrefObserver d_undoStackSize;
    private final Undo.RecentUndosAction d_recentUndosAction;
    private final Undo.RecentRedosAction d_recentRedosAction;
    private final MerlinActionMap d_hotkeys;
    private final ResourcePaths d_docPaths;
    private final JToolBar d_toolbar;
    public static final Object VENTUS_INIT = "MerlinApp.VENTUS_INIT";
    private final TitleUpdater d_titleUpdater = new TitleUpdater();
    public static final KeyStroke AWT_CRASH_ACCEL = KeyStroke.getKeyStroke(117, 640);
    private static final AWTCrashAction AWT_CRASH_VENTUS = new AWTCrashAction();
    public static final KeyStroke WORKER_CRASH_ACCEL = KeyStroke.getKeyStroke(118, 640);
    public static final KeyStroke WORKER_AWT_CRASH_ACCEL = KeyStroke.getKeyStroke(119, 640);

    private static native void setNativeInstallDir(String var0);

    private static native void addNativeResourceDir(String var0);

    public VentusApp(String[] cmdLineArgs, boolean minimalStartupForTesting) {
        super("Ventus", cmdLineArgs, VentusApp.class.getResource("ventus-splash.png"), 1);
        this.d_features = Arrays.asList(ResultsFeature.create(), RunSimFeature.create(), FlowPathsFeature.create(), UserManualFeature.create(), ContamDocsFeature.create(), SupportSiteFeature.create(), NewGroupFeature.create(), NewViewFeature.create(), WeatherFeature.create(), SimParamsFeature.create(), ZoneFeature.create(), WindProfileFeature.create(), LevelFeature.create(), SimpleAHSFeature.create(), AHSFeature.create(), TagFeature.create(), ExtendCoreFeature.create(), SpeciesFeature.create(), SourceSinkFeature.create(), ExportFeature.create(), PlotFeature.create());
        this.d_docPaths = new ResourcePaths(this, "");
        Stream.of("../Results/lib", "../thunderheadeng/lib").forEach(d -> {
            this.getResourcePaths().addDir((String)d);
            VentusApp.addNativeResourceDir(d);
        });
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        VentusApp.setNativeInstallDir(this.getInstallDir() + "\\");
        this.getMainFrame().setTitle("Ventus 2024.2.1120");
        if (!Application.isDev()) {
            CrashCatcher.install("Ventus", "2024.2.1120", CrashHandler.INSTANCE, AdditionalLogParams.INSTANCE, 3, new Thread[0]);
        }
        try {
            if (this.getPrefs().get(MerlinPrefs.VERSION) <= 4) {
                CrashCatcher.logAction("Changing theme to default Light theme");
                UIManager.setLookAndFeel(FlatLightLaf.class.getName());
                ThemeChooserMenu.updateUIKeys(FlatLightLaf.class.getName());
                FlatLaf.updateUI();
                SwingUtilities.updateComponentTreeUI(this.getMainFrame());
                this.setPreference("Theme.LaFPackageName", FlatLightLaf.class.getName());
            }
        }
        catch (Exception e) {
            CrashCatcher.logAction(e.toString());
        }
        try {
            this.getMainFrame().setIconImages(Arrays.asList(ImageIO.read(this.getClass().getResource("/ventus/icons/ventus_16x16.png")), ImageIO.read(this.getClass().getResource("/ventus/icons/ventus_40x40.png"))));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.getComponents(IDataModel.class).forEach(IDataModel::registerEntryPointData);
        this.d_colorMgr = new MerlinColors();
        this.d_colorMgr.load(this.d_props);
        this.d_data = new VentusData(true);
        this.d_colorMgr.addColorChangedListener(c -> this.d_data.floors.getDeepMembers(SchematicRoom.class).forEach(SchematicRoom::colorPropsChanged));
        String unitSystemPref = this.getPrefs().getString(MerlinPrefs.KEY_UNITSYSTEM_PROP);
        if (unitSystemPref != null && unitSystemPref.equals(EnglishUS.getInstance().getSystemName())) {
            this.d_data.setInitialUnitSystem(EnglishUS.getInstance());
        } else {
            this.d_data.setInitialUnitSystem(SIUS.getInstance());
        }
        this.d_undoStackSize = new Undo.StackSizePrefObserver(this);
        this.d_recentFilesAction = new RecentFilesAction(this.d_data);
        this.d_recentFilesAction.init(this.d_props);
        this.d_recentUndosAction = new Undo.RecentUndosAction(this.d_data);
        this.d_recentRedosAction = new Undo.RecentRedosAction(this.d_data);
        this.d_toolbar = this.createMainToolbar();
        this.d_mv = new ModelView(this.d_data, this.d_colorMgr);
        this.d_hotkeys = new MerlinActionMap(this, this.d_mv);
        this.d_tv = new TreeView(this.d_data);
        JScrollPane tvSP = new JScrollPane(this.d_tv);
        tvSP.setHorizontalScrollBarPolicy(32);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.setName("MerlinApp.treePanel");
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel activeFloorPanel = new JPanel(new GridBagLayout());
        GridBagHelper gb = new GridBagHelper(activeFloorPanel);
        gb.addBorder(1, 6, 1, 6);
        gb.add(Intl.intl("Level:"), new FloorComboBox(this.d_data), 1.0, 0);
        this.registerHorizontalViewToolbar(activeFloorPanel);
        JToolBar tbTree = new JToolBar(0);
        tbTree.add(this.d_tv.getAutoExpandButton());
        tbTree.addSeparator();
        tbTree.add(this.d_tv.getCollapseAllButton());
        tbTree.add(this.d_tv.getExpandAllButton());
        tbTree.setFloatable(false);
        Utils.noToolBarFocus(tbTree);
        northPanel.add((Component)activeFloorPanel, "North");
        northPanel.add((Component)new JSeparator(0), "Center");
        northPanel.add((Component)tbTree, "South");
        treePanel.add((Component)northPanel, "North");
        treePanel.add((Component)tvSP, "Center");
        this.createMainMenuBar();
        JComponent panel3d = this.d_mv.getMainPanel();
        JFrame frm = this.getMainFrame();
        Container pane = frm.getContentPane();
        JPanel panel3dCont = new JPanel(new BorderLayout());
        panel3dCont.setName("MerlinApp.panel3dCont");
        panel3dCont.add((Component)panel3d, "Center");
        JSplitPane splitPane = new JSplitPane(1, true, treePanel, panel3dCont);
        splitPane.setName("MerlinApp.splitPane");
        splitPane.setDividerLocation(200);
        splitPane.setDividerSize(9);
        pane.add((Component)this.d_toolbar, "North");
        pane.add((Component)splitPane, "Center");
        this.d_data.getEvents().addObserver(this.d_titleUpdater);
        this.getComponents(IEventObserver.class).forEach(obj -> this.d_data.getEvents().addObserver((IEventObserver)obj));
        if (minimalStartupForTesting) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.checkLicense();
            MerlinPrefs.instance();
            VersionUtil.checkForUpdatesOnStartup("Ventus", this.getPrefs(), MerlinPrefs.CHECK_VERSION_STARTUP, MerlinPrefs.SKIP_UPDATE, MerlinPrefs.SKIP_UPDATE_VERSION, VersionUtil.getVersionSupplier(VentusLM.getInstance()), versionSource -> new CheckForUpdatesDlg(this, true, CompletableFuture.completedFuture(versionSource)), checkOnStartup -> this.getPrefs().set(MerlinPrefs.CHECK_VERSION_STARTUP, checkOnStartup));
            AMerlinOp matdbOp = new AMerlinOp(this){

                @Override
                public void run(VentusApp app, VentusData md) {
                    try (VentusData.WriteLock writeLock = md.lockWrite();){
                        md.materials.scan();
                        md.modified = false;
                        md.getEvents().changed(md, VentusData.MODIFIED_CHANGED);
                        md.reset();
                    }
                }
            };
            UIHook.run(null, String.format("Scanning material database", new Object[0]), matdbOp, 0);
            KeyboardAcceleratorIO.loadHotKeys(this.getHotkeys().getIoHelper(this));
            this.registerHeadlessUIHooks(panel3dCont);
            final File initFile = this.procArgs(cmdLineArgs);
            if (initFile != null) {
                AMerlinOp op = new AMerlinOp(){

                    @Override
                    public void run(VentusApp app, VentusData md) {
                        Open.open(VentusApp.this, VentusApp.this.getData(), initFile.getPath());
                        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, initFile.getAbsolutePath());
                    }
                };
                UIHook.run(null, String.format("Open initial file: %s", initFile.getAbsolutePath()), op, 0);
            }
            AMerlinOp showIntelWarning = new AMerlinOp(){

                @Override
                public void run(VentusApp app, VentusData md) {
                    VentusApp.this.d_mv.showIntelWarning();
                }
            };
            UIHook.run(null, "Showing Intel warning", showIntelWarning, 0);
        });
    }

    public static TeciProps loadAppPreferences() throws IOException {
        return VentusApp.loadPreferences("Ventus");
    }

    @Override
    public void saveKeyboardAccelerators() {
        KeyboardAcceleratorIO.exportHotKeys(this.getHotkeys().getIoHelper(this));
    }

    public static <T> void removePref(TypedProp<T> prop) {
        TeciProps prefs = VentusApp.getApp().getPrefs();
        if (prefs.isDefined(prop)) {
            prefs.remove(prop);
            VentusData mod = VentusApp.getApp().getData();
            mod.getEvents().changed(mod, prop);
            mod.getEvents().changed(mod, VentusData.PREFS_CHANGED);
        }
    }

    public static <T> void setPref(TypedProp<T> prop, T val) {
        TeciProps prefs = VentusApp.getApp().getPrefs();
        T existing = prefs.get(prop);
        if (Objects.equals(val, existing)) {
            return;
        }
        MerlinPrefs.set(prop, val);
        VentusData mod = VentusApp.getApp().getData();
        mod.getEvents().changed(mod, prop);
        mod.getEvents().changed(mod, VentusData.PREFS_CHANGED);
    }

    public static void setPrefs(TeciProps srcPrefs) {
        IdentityHashMap keyPropMap = new IdentityHashMap();
        for (IPropertySet.Prop<?> prop : IPropertySet.getAllDeclaredPublicStaticProps(MerlinPrefs.class)) {
            keyPropMap.put(prop.key, prop);
        }
        VentusData mod = VentusApp.getApp().getData();
        TeciProps prefs = VentusApp.getApp().getPrefs();
        boolean modified = false;
        for (Map.Entry<Object, Object> entry : srcPrefs.entrySet()) {
            Object existing = prefs.put(entry.getKey(), entry.getValue());
            if (Objects.equals(existing, entry.getValue())) continue;
            modified = true;
            IPropertySet.Prop prop = (IPropertySet.Prop)keyPropMap.get(entry.getKey());
            if (prop == null) continue;
            mod.getEvents().changed(mod, prop);
        }
        if (modified) {
            mod.getEvents().changed(mod, VentusData.PREFS_CHANGED);
        }
    }

    @Override
    public boolean isInstallFolder(File folder) {
        return IOUtil.testFolderContainsAll(folder, "lib", "third-party", "contam-3.4.0.5-win32");
    }

    @Override
    protected void loadSafeModeProps(TeciProps props) {
        super.loadSafeModeProps(props);
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10, Boolean.valueOf(false));
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140, Boolean.valueOf(false));
        props.set(MerlinPrefs.KEY_RFIXED_MAX_VB_SIZE, Long.valueOf(0x2000000L));
        RenderPrefs.loadSafeModeProps(props);
    }

    @Override
    protected void loadLibraries() {
        VentusApp.loadLib("FreeImage", "FreeImaged");
        try {
            VentusApp.loadLib("Ventus_jni", new String[0]);
        }
        catch (Throwable t) {
            VentusApp.loadLib("jawt", new String[0]);
            VentusApp.loadLib("Ventus_jni", new String[0]);
        }
    }

    private void checkLicense() {
        VentusLM licenseMgr = null;
        try {
            licenseMgr = VentusLM.getInstance();
            assert (licenseMgr != null);
            boolean status = licenseMgr.startFromPrefs(this.getPrefs(), MerlinPrefs.KEY_LICENSEDIR_PROP, MerlinPrefs.KEY_LICENSEDSERVER_PROP);
            System.out.println(licenseMgr.getDescription());
            if (!status) {
                ActivationDlg rlmdlg = new ActivationDlg(this.getMainFrame(), licenseMgr);
                rlmdlg.doModal();
            }
        }
        catch (Throwable everything) {
            everything.printStackTrace();
            System.exit(-1);
        }
        if (licenseMgr == null || !licenseMgr.isAuthorized()) {
            this.quit(false);
            return;
        }
        MerlinPrefs.save();
        super.savePreferences();
        LicensePrompt.checkRenewPrompt(this.getActiveFrame(), licenseMgr, "Ventus", "www.thunderheadeng.com/ventus", null, License.UI_HOOK, 30, null);
    }

    public File procArgs(String[] args) {
        File initFile = null;
        for (String arg : args) {
            if (arg.startsWith("-sz")) {
                try {
                    String[] sz = arg.substring(3).split("x");
                    this.getActiveFrame().setSize(Integer.parseInt(sz[0]), Integer.parseInt(sz[1]));
                    this.getActiveFrame().setLocationRelativeTo(null);
                }
                catch (NumberFormatException t) {
                    t.printStackTrace();
                }
                continue;
            }
            if (initFile == null && !arg.startsWith("-")) {
                File f = new File(arg);
                if (!f.exists() || !f.canRead()) continue;
                initFile = f;
                continue;
            }
            System.out.println("Unused Parameter: " + arg);
        }
        return initFile;
    }

    private JMenuBar createMainMenuBar() {
        GroupedSequence root = new GroupedSequence("", 0, new JMenuBar());
        root.add("file", 0, new guiMenu(Intl.intl("&File"))).addAll(0, New.UI_HOOK.getMenuItem(), Open.UI_HOOK.getMenuItem()).addAll(10, new JPopupMenu.Separator(), Save.UI_HOOK.getMenuItem(), SaveAs.UI_HOOK.getMenuItem()).addAll(20, new JPopupMenu.Separator(), EditPreferences.UI_HOOK.getMenuItem()).addAll(30, new JPopupMenu.Separator(), Import.UI_HOOK.getMenuItem());
        root.getNode("file").add("export", (Object)new guiMenu(Intl.intl("Export")));
        root.getNode("file").addAll(root.seq, Screenshot.UI_HOOK.getMenuItem()).addAll(40, new JPopupMenu.Separator(), this.d_recentFilesAction.getMenu()).addAll(50, new JPopupMenu.Separator(), Exit.UI_HOOK.getMenuItem());
        root.add("edit", 10, new guiMenu(Intl.intl("&Edit"))).addAll(0, this.d_recentUndosAction.getMenu(), Undo.UI_HOOK_UNDO_MAJOR.getMenuItem(), this.d_recentRedosAction.getMenu(), Undo.UI_HOOK_REDO_MAJOR.getMenuItem()).addAll(10, new JPopupMenu.Separator(), Copy.UI_HOOK.getMenuItem(), Paste.UI_HOOK.getMenuItem()).addAll(20, new JPopupMenu.Separator(), Delete.UI_HOOK.getMenuItem()).addAll(30, new JPopupMenu.Separator(), FindAction.UI_HOOK.getMenuItem(), Hide.UI_HOOK.getMenuItem(), Show.UI_HOOK.getMenuItem(), FilterVisible.UI_HOOK.getMenuItem(), ShowAll.UI_HOOK.getMenuItem());
        root.add("model", 20, new guiMenu(Intl.intl("&Model"))).addAll(0, ManageMaterials.UI_HOOK.getMenuItem(), new JPopupMenu.Separator()).addAll(35, new JPopupMenu.Separator()).addAll(60, AddBGImage.UI_HOOK.getMenuItem()).addAll(70, new JPopupMenu.Separator(), MergeGeom.UI_HOOK.getMenuItem(), SeparateGeom.UI_HOOK.getMenuItem());
        root.add("simulation", 30, new guiMenu(Intl.intl("&Analysis")));
        root.add("results", 40, new guiMenu(Intl.intl("&Results")));
        root.add(this.d_mv.getMainMenu());
        root.add(this.createHelpMenu());
        if (VentusApp.isDev()) {
            root.getNode("file").add(35, (Object)ExportObj.UI_HOOK.getMenuItem());
        }
        this.getComponents(IAppMenuItem.class).forEach(obj -> obj.addMenuItems(root));
        JFrame frame = this.getMainFrame();
        frame.getRootPane().getInputMap(1).put(AWT_CRASH_ACCEL, AWT_CRASH_VENTUS);
        frame.getRootPane().getActionMap().put(AWT_CRASH_VENTUS, AWT_CRASH_VENTUS);
        frame.getRootPane().getInputMap(1).put(WORKER_CRASH_ACCEL, WorkerCrashAction.UI_HOOK);
        frame.getRootPane().getActionMap().put(WorkerCrashAction.UI_HOOK, WorkerCrashAction.UI_HOOK);
        frame.getRootPane().getInputMap(1).put(WORKER_AWT_CRASH_ACCEL, WorkerAWTCrashAction.UI_HOOK);
        frame.getRootPane().getActionMap().put(WorkerAWTCrashAction.UI_HOOK, WorkerAWTCrashAction.UI_HOOK);
        root.traverse(obj -> {
            if (obj.current.id.equals("export") && obj.current.getChildNodes().isEmpty()) {
                return;
            }
            if (obj.parent != null) {
                guiUtil.add(obj.parent.data, obj.current.data);
            }
        });
        JMenuBar menuBar = (JMenuBar)root.data;
        frame.setJMenuBar(menuBar);
        return menuBar;
    }

    public ResourcePaths getDocPaths() {
        return this.d_docPaths;
    }

    public GroupedSequence createHelpMenu() {
        GroupedSequence helpGroup = new GroupedSequence("help", 60, new guiMenu(Intl.intl("&Help")));
        helpGroup.addAll(10, new JPopupMenu.Separator(), License.UI_HOOK.getMenuItem(), CheckForUpdatesAction.UI_HOOK.getMenuItem()).addAll(20, new JPopupMenu.Separator(), SaveOutputLogAction.UI_HOOK.getMenuItem(), AboutAction.UI_HOOK.getMenuItem());
        return helpGroup;
    }

    private JToolBar createMainToolbar() {
        guiToolBar toolbar = new guiToolBar();
        toolbar.setFloatable(false);
        toolbar.setMinimumSize(new Dimension(0, 0));
        GroupedSequence root = new GroupedSequence("", 0, toolbar);
        root.addAll(0, New.UI_HOOK, Open.UI_HOOK, Save.UI_HOOK, Import.UI_HOOK).addAll(10, new JToolBar.Separator(null), new Undo.UndoDropdownButton(this.d_data), new Undo.RedoDropdownButton(this.d_data));
        root.add(20, (Object)new JToolBar.Separator(null));
        List<JToggleButton> buttons = guiUtil.createMEToolbarItems(UnitsAction.SI_ACTION, UnitsAction.ENGLISH_ACTION);
        buttons.forEach(obj -> root.add(obj));
        this.getComponents(IAppToolbarButton.class).forEach(obj -> obj.addToolbarButtons(root));
        root.traverse(obj -> {
            if (obj.parent != null) {
                guiUtil.add(obj.parent.data, obj.current.data);
            }
        });
        Utils.noToolBarFocus(toolbar);
        return (JToolBar)root.data;
    }

    private static void addHook(List<UIHook> hooks, UIHook hook) {
        if (hook.isEnabled()) {
            hooks.add(hook);
        }
    }

    private static void addSeparatorHook(List<UIHook> hooks) {
        if (hooks.size() > 0 && hooks.get(hooks.size() - 1) != null) {
            hooks.add(null);
        }
    }

    public JPopupMenu getContextMenu() {
        GroupedSequence root = new GroupedSequence("", 0, null);
        root.add("results", -10, null);
        root.add("enable-select", 0, null).addAll(0, EnableAction.UI_ENABLE_HOOK, EnableAction.UI_DISABLE_HOOK, AddBackgroundQuad.UI_HOOK, SelectSubitems.UI_HOOK, SelectInvalidObjs.CRITICAL_HOOK, SelectInvalidObjs.MODERATE_HOOK, SelectConflictingComps.UI_HOOK, SelectReferencing.UI_HOOK, ShowReferencingObjects.UI_HOOK);
        root.add("admin", 10, null).addAll(0, SetActiveFloor.UI_HOOK, ChangeGroupAction.UI_HOOK, Delete.UI_HOOK, RenameAction.UI_HOOK, SortAlphaAction.UI_HOOK, SortByFloor.UI_HOOK);
        root.add("copy-paste", 20, null).addAll(0, Copy.UI_HOOK, Paste.UI_HOOK);
        root.add("views-selectby", 30, null).addAll(0, ShowView.CONTEXT_HOOK, CaptureCamera.CONTEXT_HOOK, SelectByColor.UI_HOOK, SelectByMaterial.UI_HOOK, SelectNonGroupDescendents.UI_HOOK, RemoveImportedUVAction.UI_HOOK);
        root.add("create", 40, null);
        root.add("modify", 50, null).addAll(0, MergeGeom.UI_HOOK, MergeImportedGeomAction.UI_HOOK, SeparateGeom.UI_HOOK, CloseGapsAction.UI_HOOK, CleanupRooms.UI_HOOK, SetZAction.UI_HOOK);
        root.add("visibility", 60, null).addAll(0, Hide.UI_HOOK, Show.UI_HOOK, FilterVisible.UI_HOOK, ShowAll.UI_HOOK);
        root.add("edit", null).addAll(0, EditProps.UI_HOOK);
        this.getComponents(IContextMenuItem.class).forEach(obj -> obj.addContextMenuItem(root));
        ArrayList items = new ArrayList();
        root.traverse(obj -> {
            if (obj.current.data == null && !items.isEmpty() && items.get(items.size() - 1) != null) {
                items.add(null);
            } else {
                Object patt0$temp = obj.current.data;
                if (patt0$temp instanceof UIHook) {
                    UIHook hook = (UIHook)patt0$temp;
                    if (hook.isEnabled()) {
                        items.add(hook);
                    }
                } else {
                    JMenuItem submenu;
                    Object patt1$temp = obj.current.data;
                    if (patt1$temp instanceof JMenuItem && (submenu = (JMenuItem)patt1$temp).isEnabled()) {
                        items.add(submenu);
                    }
                }
            }
        });
        if (items.get(items.size() - 1) == null) {
            items.remove(items.size() - 1);
        }
        JPopupMenu menu = new JPopupMenu();
        for (Object item : items) {
            if (item instanceof UIHook) {
                UIHook uiHook = (UIHook)item;
                menu.add(uiHook);
                continue;
            }
            if (item instanceof JMenuItem) {
                JMenuItem submenu = (JMenuItem)item;
                menu.add(submenu);
                continue;
            }
            if (item != null) {
                assert (false) : "Unexpected type: " + item.getClass().getName();
                continue;
            }
            menu.addSeparator();
        }
        return menu;
    }

    public void registerHeadlessUIHooks(JPanel comp) {
        Stream.of(EnableAction.UI_ENABLE_HOOK, EnableAction.UI_DISABLE_HOOK, AddBackgroundQuad.UI_HOOK, SelectSubitems.UI_HOOK, SelectInvalidObjs.CRITICAL_HOOK, SelectInvalidObjs.MODERATE_HOOK, SelectConflictingComps.UI_HOOK, SelectReferencing.UI_HOOK, ShowReferencingObjects.UI_HOOK, NewViewFromCamera.CONTEXT_HOOK, SetActiveFloor.UI_HOOK, NewGroup.CONTEXT_HOOK, ChangeGroupAction.UI_HOOK, Delete.UI_HOOK, RenameAction.UI_HOOK, SelectNonGroupDescendents.UI_HOOK, SortAlphaAction.UI_HOOK, SortByFloor.UI_HOOK, ShowView.CONTEXT_HOOK, CaptureCamera.CONTEXT_HOOK, SelectByColor.UI_HOOK, SelectByMaterial.UI_HOOK, RemoveImportedUVAction.UI_HOOK, MergeGeom.UI_HOOK, SeparateGeom.UI_HOOK, CloseGapsAction.UI_HOOK, CleanupRooms.UI_HOOK, SetZAction.UI_HOOK, MergeImportedGeomAction.UI_HOOK, Hide.UI_HOOK, Show.UI_HOOK, FilterVisible.UI_HOOK, ShowAll.UI_HOOK, EditProps.UI_HOOK, NewFloor.UI_HOOK, ShowAllFloors.UI_HOOK, ShowLowerActiveLevel.UI_HOOK, ClearSelection.UI_HOOK).forEach(hook -> hook.registerUIComponent(comp));
        VentusApp.getApp().getComponents(IHotkey.class).stream().filter(IHotkey::isHeadless).map(IHotkey::getKeyboardShortcut).filter(shortcut -> shortcut.getOperator() instanceof UIHook).map(shortcut -> (UIHook)shortcut.getOperator()).forEach(hook -> hook.registerUIComponent(comp));
    }

    public static void crash(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        while (t.getCause() != null) {
            t = t.getCause();
        }
        throw new RuntimeException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitOn() {
        VentusApp ventusApp = VentusApp.getApp();
        synchronized (ventusApp) {
            try {
                VentusApp.getApp().wait();
                return true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAwaiting() {
        VentusApp ventusApp = VentusApp.getApp();
        synchronized (ventusApp) {
            VentusApp.getApp().notifyAll();
        }
    }

    public static VentusApp getApp() {
        Application app = Application.getApp();
        return app instanceof VentusApp ? (VentusApp)app : null;
    }

    public static Optional<VentusApp> getAppOpt() {
        return Optional.ofNullable(VentusApp.getApp());
    }

    public static VentusData getAppData() {
        VentusApp app = VentusApp.getApp();
        return app != null ? app.getData() : null;
    }

    public VentusData getData() {
        return this.d_data;
    }

    public ModelView getModelView() {
        return this.d_mv;
    }

    public TreeView getTreeView() {
        return this.d_tv;
    }

    public AMerlinOp getQuitOp(final boolean allowCancel) {
        return new AMerlinOp(){

            @Override
            public void run(VentusApp app, VentusData md) {
                int numSims = 0;
                if (numSims > 0) {
                    if (!allowCancel) {
                        String msg = String.format(Intl.intl("%d simulation(s) will terminate."), numSims);
                        JOptionPane.showMessageDialog(VentusApp.this.getMainFrame(), msg, Intl.intl("Simulation(s) in Progress"), 1);
                    } else {
                        int sel = JOptionPane.showConfirmDialog(VentusApp.this.getMainFrame(), String.format(Intl.intl("Exit and terminate %d simulation(s)?"), numSims), Intl.intl("Simulation(s) in Progress"), 2);
                        if (sel != 0 && allowCancel) {
                            return;
                        }
                    }
                }
                boolean cancelled = !VentusApp.this.promptSaveIfModified();
                VentusApp.this.d_recentFilesAction.store(VentusApp.this.d_props);
                if (!cancelled || !allowCancel) {
                    md.ui(() -> {
                        VentusLM.getInstance().closeLM();
                        VentusApp.super.quit(allowCancel);
                    });
                }
            }
        };
    }

    @Override
    public void quit(boolean allowCancel) {
        AMerlinOp op = this.getQuitOp(allowCancel);
        UIHook.run(null, "quit", op, 0);
    }

    public boolean promptSaveIfModified() {
        if (this.d_data.modified) {
            String msg = Intl.intl("Save changes to current model?");
            String title = Intl.intl("Save Changes");
            int opts = 1;
            int result = JOptionPane.showConfirmDialog(this.getActiveFrame(), msg, title, opts);
            switch (result) {
                case 0: {
                    return Save.saveToFile(this, this.d_data, false);
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void savePreferences() {
        MerlinPrefs.save();
        this.d_mv.savePreferences();
        this.getPrefs().set(MerlinPrefs.KEY_UNITSYSTEM_PROP, this.d_data.getUnitSystem().getSystemName());
        this.d_colorMgr.store(this.d_props);
        super.savePreferences();
    }

    @Override
    public void readPreferences() {
        super.readPreferences();
        MerlinPrefs.Version ver = MerlinPrefs.getVersion();
        if (ver.ordinal() < MerlinPrefs.Version.VER_0004.ordinal() && this.d_props.get(RenderPrefs.PREF_ANISOTROPIC_FILTERING) == 16.0) {
            this.d_props.set(RenderPrefs.PREF_ANISOTROPIC_FILTERING, (Double)RenderPrefs.PREF_ANISOTROPIC_FILTERING.defVal);
        }
    }

    public UnitSystem getUnitSystem() {
        return this.d_data.getUnitSystem();
    }

    public MerlinColors getColorManager() {
        return this.d_colorMgr;
    }

    public MerlinActionMap getHotkeys() {
        return this.d_hotkeys;
    }

    public <T> Collection<T> getComponents(Class<T> type) {
        return this.d_features.stream().flatMap(f -> f.getComponents(type).stream()).collect(Collectors.toSet());
    }

    public <T> T getComponent(Class<T> type) {
        Optional comp = this.d_features.stream().flatMap(f -> f.getComponents(type).stream()).findAny();
        assert (comp.isPresent());
        return (T)comp.get();
    }

    private class TitleUpdater
    implements IEventObserver {
        private TitleUpdater() {
        }

        @Override
        public void update(Events e) {
            Object filename = VentusApp.this.d_data.filename;
            if (filename == null || ((String)filename).compareTo("null") == 0) {
                filename = "untitled";
            } else {
                for (int i = ((String)filename).length() - 2; i >= 0; --i) {
                    if (((String)filename).charAt(i) != '\\') continue;
                    filename = ((String)filename).substring(i + 1);
                    break;
                }
            }
            if (VentusApp.this.d_data.modified) {
                filename = "*" + (String)filename;
            }
            filename = " - " + (String)filename;
            VentusApp.this.getMainFrame().setTitle("Ventus 2024.2.1120" + (String)filename);
        }
    }

    private static class AWTCrashAction
    extends guiAction {
        private static final long serialVersionUID = -2960229483197444995L;

        public AWTCrashAction() {
            super("x_x");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new RuntimeException();
        }
    }

    private static class WorkerCrashAction
    extends AMerlinOp {
        private static final UIHook UI_HOOK = new UIHook(new WorkerCrashAction(), "Worker Crash Test");

        private WorkerCrashAction() {
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            throw new RuntimeException();
        }
    }

    private static class WorkerAWTCrashAction
    extends AMerlinOp {
        private static final UIHook UI_HOOK = new UIHook(new WorkerAWTCrashAction(), "Worker AWT Crash Test");

        private WorkerAWTCrashAction() {
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            throw new RuntimeException();
        }
    }
}

