/*
 * Decompiled with CFR 0.152.
 */
package ventus.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import ventus.VentusApp;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.ImportedGeom;
import ventus.data.Proxy;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.data.schematics.elevators.Elevator;
import ventus.data.schematics.elevators.ElevatorRoom;
import ventus.data.schematics.geom.ISchematicConnector;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicCorridor;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.comps.TypeDependency;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.species.Species;
import ventus.feature.tags.Tag;
import ventus.util.MerlinUtil;

public class Dependencies {
    public static void getObjReferences(VentusData md, Predicate<? super IMerlinObj> referencedTest, BiConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        Dependencies.getObjReferences(md, Predicates.alwaysTrue(), referencedTest, references);
    }

    private static boolean test(int types, int type) {
        return (types & type) == type;
    }

    public static void getObjReferences(VentusData md, int types, Predicate<? super IMerlinObj> referencedTest, BiConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        Pair<Predicate<Class<? extends IMerlinObj>>, Predicate<? super IMerlinObj>> predicates = Dependencies.finalizePredicates(types, referencedTest);
        Dependencies.getObjReferences(md, (Predicate<Class<? extends IMerlinObj>>)((Predicate)predicates.v1), (Predicate<? super IMerlinObj>)((Predicate)predicates.v2), references);
    }

    private static Pair<Predicate<Class<? extends IMerlinObj>>, Predicate<? super IMerlinObj>> finalizePredicates(int types, Predicate<? super IMerlinObj> referencedTest) {
        ArrayList clazzes = new ArrayList();
        for (Type type : Type.values()) {
            if (!Dependencies.test(types, type.flag)) continue;
            clazzes.add(type.mtype);
        }
        return new Pair<Predicate<Class<? extends IMerlinObj>>, Predicate<? super IMerlinObj>>(new ClassTest(clazzes), referencedTest);
    }

    public static <T extends IMerlinObj> LinkedIdentityHashSet<T> getObjReferences(VentusData md, Class<T> type, Predicate<? super T> referencedTest) {
        LinkedIdentityHashSet result = new LinkedIdentityHashSet();
        Dependencies.getObjReferences(md, (Class<? extends IMerlinObj> t) -> type.isAssignableFrom((Class<?>)t), (? super IMerlinObj o) -> referencedTest.test(o), (? super IMerlinObj src, ? super IMerlinObj target) -> result.add(target));
        return result;
    }

    public static <T> void getObjReferences(VentusData md, Class<T> type, Predicate<? super T> referencedTest, BiConsumer<? super IMerlinObj, ? super T> references) {
        Dependencies.getObjReferences(md, (Class<? extends IMerlinObj> t) -> type.isAssignableFrom((Class<?>)t), (? super IMerlinObj o) -> referencedTest.test(o), (? super IMerlinObj src, ? super IMerlinObj target) -> references.accept((IMerlinObj)src, (Object)target));
    }

    public static void getObjReferences(VentusData md, Predicate<Class<? extends IMerlinObj>> types, Predicate<? super IMerlinObj> referencedTest, BiConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        for (ReferencingType depType : Dependencies.getRefTypes()) {
            if (!Dependencies.testAny(types, depType.targetTypes)) continue;
            Dependencies.getObjReferences(depType.getSources.apply(md), types, referencedTest, references);
        }
    }

    private static boolean testAny(Predicate<Class<? extends IMerlinObj>> test, Class<? extends IMerlinObj> ... types) {
        for (Class<? extends IMerlinObj> type : types) {
            if (!test.test(type)) continue;
            return true;
        }
        return false;
    }

    public static <T extends IMerlinObj> void getObjReferences(Collection<? extends IMerlinObj> sourceObjs, Class<T> type, Predicate<? super T> referencedTest, BiConsumer<? super IMerlinObj, ? super T> references) {
        Dependencies.getObjReferences(sourceObjs, (Class<? extends IMerlinObj> t) -> type.isAssignableFrom((Class<?>)t), (? super IMerlinObj o) -> referencedTest.test(o), (? super IMerlinObj src, ? super IMerlinObj target) -> references.accept((IMerlinObj)src, (Object)target));
    }

    public static void getObjReferences(Collection<? extends IMerlinObj> sourceObjs, final Predicate<Class<? extends IMerlinObj>> types, final Predicate<? super IMerlinObj> referencedTest, final BiConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        IGetDepsCallback callback = new IGetDepsCallback(){

            @Override
            public boolean addRef(IMerlinObj src, IMerlinObj target) {
                if (src == null || target == null) {
                    return true;
                }
                if (types.test(target.getClass()) && referencedTest.test(target)) {
                    if (references != null) {
                        references.accept(src, target);
                    } else {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public <TargetT extends IMerlinObj> boolean addRefs(IMerlinObj src, Class<TargetT> targetType, Collection<? extends TargetT> targets) {
                if (types.test(targetType)) {
                    return this.addRefs(src, targets);
                }
                return true;
            }
        };
        for (ReferencingType dep : Dependencies.getRefTypes()) {
            if (!dep.testTypes(types)) continue;
            for (IMerlinObj iMerlinObj : MerlinUtil.flatten(sourceObjs, dep.srcType)) {
                dep.getDeps.get(iMerlinObj, callback);
            }
        }
    }

    public static Collection<ReferencingType> getRefTypes() {
        ArrayList<ReferencingType> refTypeInfo = new ArrayList<ReferencingType>();
        refTypeInfo.addAll(Dependencies.getPlatformRefTypes());
        VentusApp.getApp().getComponents(TypeDependency.class).stream().flatMap(td -> td.getRefTypeInfo().stream()).collect(Collectors.toCollection(() -> refTypeInfo));
        return refTypeInfo;
    }

    private static Collection<ReferencingType> getPlatformRefTypes() {
        return List.of(new ReferencingType(ImportedGeom.class, md -> md.sceneGeom.getMembers(), (ig, callback) -> {
            IPrimProps pprops;
            int numPrims = ig.getGeom().getNumPrims(7);
            IPropsSrc props = ig.getDisplayProps();
            for (int offset = 0; offset < numPrims && callback.addRef(ig, (Material)(pprops = props.get(offset)).getMaterial()); offset += props.getUniformCount(offset, numPrims - offset)) {
            }
        }, Material.class), new ReferencingType(Proxy.class, md -> md.proxies.getAllProxies(), (proxy, callback) -> callback.addRef(proxy, (IMerlinObj)proxy.getObj()), ICompElement.class), new ReferencingType(SchematicRoom.class, md -> md.floors.getMembers(), (room, callback) -> {
            IMaterial mat = room.getMaterial();
            callback.addRef(room, (Material)mat);
        }, Material.class), new ReferencingType(ElevatorRoom.class, md -> md.elevators.getMembers(), (room, callback) -> {
            IMaterial mat = room.getMaterial();
            callback.addRef(room, (Material)mat);
        }, Material.class), new ReferencingType(SchematicCorridor.class, md -> md.floors.getMembers(), (corr, callback) -> {
            IMaterial mat = corr.getMaterial();
            callback.addRef(corr, (Material)mat);
        }, Material.class));
    }

    public static enum Type {
        TYPE_ELEVATOR(Elevator.class),
        TYPE_ROOM(ISchematicRoom.class),
        TYPE_MATERIAL(Material.class),
        TYPE_DOOR(ISchematicConnector.class),
        TYPE_FLOWELEMENT(FlowElement.class),
        TYPE_TAG(Tag.class),
        TYPE_SPECIES(Species.class),
        TYPE_SOURCE_SINK_ELEMENT(SourceSinkElement.class),
        TYPE_AIR_HANDLING_SYSTEM(SimpleAHS.class);

        public final int flag = 1 << this.ordinal();
        public final Class<? extends IMerlinObj> mtype;

        private Type(Class<? extends IMerlinObj> mtype) {
            this.mtype = mtype;
        }
    }

    private static class ClassTest<T>
    implements Predicate<Class<? extends T>> {
        private final List<Class<? extends T>> types;

        public ClassTest(List<Class<? extends T>> types) {
            this.types = types;
        }

        @Override
        public boolean test(Class<? extends T> t) {
            for (Class<T> type : this.types) {
                if (!type.isAssignableFrom(t) && !t.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ReferencingType {
        public final Class<? extends IMerlinObj> srcType;
        public final GetDeps<IMerlinObj> getDeps;
        public final Function<VentusData, Collection<? extends ICompElement>> getSources;
        public final Class<? extends IMerlinObj>[] targetTypes;

        public <SrcType extends IMerlinObj> ReferencingType(Class<SrcType> srcType, Function<VentusData, Collection<? extends ICompElement>> getSources, GetDeps<SrcType> getDeps, Class<? extends IMerlinObj> ... targetTypes) {
            this.srcType = srcType;
            this.getDeps = (source, callback) -> getDeps.get(source, callback);
            this.getSources = getSources;
            this.targetTypes = targetTypes;
        }

        public boolean testTypes(Predicate<Class<? extends IMerlinObj>> test) {
            return Dependencies.testAny(test, this.targetTypes);
        }
    }

    public static interface GetDeps<SrcType extends IMerlinObj> {
        public void get(SrcType var1, IGetDepsCallback var2);
    }

    public static interface IGetDepsCallback {
        public boolean addRef(IMerlinObj var1, IMerlinObj var2);

        default public boolean addRefs(IMerlinObj src, Collection<? extends IMerlinObj> targets) {
            for (IMerlinObj iMerlinObj : targets) {
                if (this.addRef(src, iMerlinObj)) continue;
                return false;
            }
            return true;
        }

        public <TargetT extends IMerlinObj> boolean addRefs(IMerlinObj var1, Class<TargetT> var2, Collection<? extends TargetT> var3);
    }
}

