/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapInfo;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.geom.Geometry;
import ventus.mv.tools.IPointPickListener;
import ventus.util.MerlinUtil;

public class PointPicker
extends AToolFunction<CursorTool> {
    private final VentusData d_data;
    private IPointPickListener d_listener;

    public PointPicker(VentusData data, Component renderComp) {
        this.d_data = data;
    }

    public void setListener(IPointPickListener listener) {
        this.d_listener = listener;
    }

    @Override
    public Cursor getCursor(CursorTool tool) {
        return null;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getSnapInfo(CursorTool tool) {
        return this.d_listener != null ? this.d_listener.getSnapInfo(tool) : new Pair<SnapMode, IIsectFilter>(SnapMode.NONE, null);
    }

    @Override
    public boolean showDragGuides(CursorTool tool) {
        return false;
    }

    @Override
    public void mouseMoved(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseDragged(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mousePressed(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseReleased(CursorTool tool, MouseEvent e) {
        if (tool.getP0() == null || this.d_listener == null) {
            return;
        }
        if (e.getButton() != 1) {
            this.d_listener.stopPicking();
            return;
        }
        Collection<IsectInfo> isects = tool.getP1().snaps;
        if (isects.isEmpty()) {
            if (this.d_listener.allowPickFromFloorZ()) {
                Floor activeFloor = this.d_data.floors.getActive();
                if (activeFloor == null) {
                    return;
                }
                double z = activeFloor.getWorkingZ().get(Geometry.LENGTH_UNIT);
                CursorTool.Ray pickRay = tool.getPickRay();
                Point3d isect = Inter3D.rayPlaneIntersection(pickRay.begin, pickRay.dir, new Plane3d(0.0, 0.0, 1.0, -z), 1.0E-9);
                if (isect != null) {
                    this.d_listener.pointPicked(null, MerlinUtil.getUPoint3D(isect));
                }
            }
            return;
        }
        this.d_listener.pointSnapped(tool.getP1());
    }

    public void cancel() {
        if (this.d_listener != null) {
            this.d_listener.stopPicking();
        }
    }

    @Override
    public String getStatusMessage(CursorTool tool) {
        SnapInfo snap = tool.getP1();
        if (snap == null || snap.constrained.isEmpty()) {
            snap = tool.getP0();
        }
        if (snap == null || snap.constrained.isEmpty()) {
            return super.getStatusMessage(tool);
        }
        return String.format(Intl.intl("Pick Location: %s"), tool.toString(snap.getFinalSnapLocation()));
    }
}

