/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.CreateElevator;
import ventus.actions.NewGroup;
import ventus.actions.SetActiveFloor;
import ventus.actions.SetWorkingGroup;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.floorextract.GenerateModelFromBIM;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.ICompElement;
import ventus.data.IOpacity;
import ventus.data.IRestorable;
import ventus.data.ImportType;
import ventus.data.ImportedGeom;
import ventus.data.MerlinSelectionModel;
import ventus.data.NamedMerlinObj;
import ventus.data.Opacity;
import ventus.data.VentusData;
import ventus.data.camera.Camera;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.FloorOptions;
import ventus.data.schematics.elevators.Elevator;
import ventus.data.schematics.elevators.ITimingModel;
import ventus.data.schematics.geom.ISchematicConnector;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicCorridor;
import ventus.data.schematics.geom.SchematicDoor;
import ventus.data.schematics.geom.SchematicDoorDir;
import ventus.data.schematics.geom.SchematicStair;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.comps.INameRibbonPropProvider;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.results.DataNode;
import ventus.geom.Geometry;
import ventus.geom.IMerlinGeomSrc;
import ventus.gui.BasicFloorComboBox;
import ventus.gui.ElevatorLevelDlg;
import ventus.gui.MaterialBtn;
import ventus.gui.MerlinComboBox;
import ventus.gui.MerlinUDF;
import ventus.gui.NewElevatorDlg;
import ventus.gui.NodeComboBox;
import ventus.gui.NodeComboModel;
import ventus.gui.PriorityChooser;
import ventus.gui.guiUtil;
import ventus.gui.value.DiscreteVarEditor;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;
import ventus.unitsystem.UnitSystem;
import ventus.util.MerlinUtil;

public final class SelectionRibbonEditorPanel
extends SelectionEditorPanel<ISelectionRibbon> {
    static final long serialVersionUID = 1L;
    private final SelectionEditorPanel.EditorPanel d_floorSect;
    private final SelectionEditorPanel.EditorPanel d_roomInfoSect;
    private final SelectionEditorPanel.EditorPanel d_doorSect1;
    private final SelectionEditorPanel.EditorPanel d_corrSect;
    private final SelectionEditorPanel.EditorPanel d_stairSect;
    private final SelectionEditorPanel.EditorPanel d_rampSect;
    private final SelectionEditorPanel.EditorPanel d_extraCorrInfoSect1;
    private final SelectionEditorPanel.EditorPanel d_extraCorrInfoSect2;
    private final SelectionEditorPanel.EditorPanel d_elevatorPropSect;
    private final SelectionEditorPanel.EditorPanel d_elevatorLevelSect;
    private final SelectionEditorPanel.EditorPanel d_elevatorExtraSect;
    private final BoundsSect d_boundsSect;
    private final SelectionEditorPanel.EditorPanel d_cameraControlSect;
    private final SelectionEditorPanel.EditorPanel d_cameraOrientSect;
    private final SelectionEditorPanel.EditorPanel d_cameraLimitsSect;
    private final SelectionEditorPanel.EditorPanel d_sceneGeomSect;
    private final NewCompGroupPnl d_newCompGroupPnl;
    private final FloorSortPnl d_floorSortPnl;
    private final ActiveFloorPnl d_activeFloorPnl;
    private final SelectionEditorPanel.EditorPanel d_generateModelFromBIM;
    private final SelectionEditorPanel.EditorPanel d_generateModelFromBIMSel;
    private static final guiLabel s_dmyLbl = new guiLabel("blah");

    public SelectionRibbonEditorPanel(VentusData vd) {
        super(vd, () -> VentusApp.getApp().getComponents(ISelectionRibbon.class));
        this.d_newCompGroupPnl = new NewCompGroupPnl(vd);
        this.d_floorSortPnl = new FloorSortPnl(vd);
        this.d_activeFloorPnl = new ActiveFloorPnl(vd);
        this.d_generateModelFromBIM = new GenerateModelSect(true);
        this.d_generateModelFromBIMSel = new GenerateModelSect(false);
        this.d_floorSect = new FloorSect();
        this.d_roomInfoSect = new RoomInfoSect();
        this.d_doorSect1 = new DoorSect1();
        this.d_corrSect = new CorridorSect();
        this.d_extraCorrInfoSect1 = new CorridorExtraPnl1();
        this.d_extraCorrInfoSect2 = new CorridorExtraPnl2();
        this.d_stairSect = new StairSect();
        this.d_rampSect = new RampSect();
        this.d_boundsSect = new BoundsSect();
        this.d_cameraControlSect = new CameraControlSect();
        this.d_cameraOrientSect = new CameraOrientSect();
        this.d_cameraLimitsSect = new CameraLimitsSect();
        this.d_sceneGeomSect = new SceneGeomPnl();
        this.d_elevatorPropSect = new ElevatorDataPnl();
        this.d_elevatorLevelSect = new ElevatorLevelPnl();
        this.d_elevatorExtraSect = new ElevatorExtraPnl();
        this.updatePanels();
        this.updateLayout();
    }

    private static void adjustHeight(JComponent comp) {
        comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, SelectionRibbonEditorPanel.s_dmyLbl.getPreferredSize().height - 2));
    }

    @Override
    protected List<SelectionEditorPanel.EditorPanel> getActivePanels(Set<ICompElement> objs) {
        ArrayList<SelectionEditorPanel.EditorPanel> activePanels = new ArrayList<SelectionEditorPanel.EditorPanel>();
        MerlinSelectionModel sel = this.d_md.selection;
        if (objs.isEmpty()) {
            activePanels.add(this.d_floorSortPnl);
            activePanels.add(this.d_newCompGroupPnl);
            activePanels.add(this.d_activeFloorPnl);
            return activePanels;
        }
        boolean hasSpecialNamePanel = false;
        Set<Object> propTypes = Composite.getPropTypes(2, objs);
        Set<Object> unshared = Composite.getPropTypes(0, objs);
        GridBagHelper propgb = new GridBagHelper(new SelectionEditorPanel.EditorPanel());
        propgb.rowSpace = 1;
        GroupedSequence nameRoot = new GroupedSequence("nameRoot", 0, null);
        if (SelectionRibbonEditorPanel.shouldAddNameProp(propTypes, unshared)) {
            nameRoot.add(0, (panel, rowPropgb) -> SelectionRibbonEditorPanel.addNameProp(panel, rowPropgb, objs.stream().allMatch(obj -> EntryPointFactory.get(obj).tvEntryPoint.canRename(this.d_md, (ICompElement)obj))));
        }
        if (SelectionRibbonEditorPanel.shouldAddVisibilityProp(propTypes, unshared)) {
            nameRoot.add(50, SelectionRibbonEditorPanel::addVisibilityProp);
        }
        for (INameRibbonPropProvider provider : VentusApp.getApp().getComponents(INameRibbonPropProvider.class)) {
            if (!provider.isEnabled(propTypes, unshared)) continue;
            provider.addPropAdders(nameRoot);
        }
        GridBagHelper namePropgb = propgb;
        nameRoot.traverse(seq -> {
            Object patt0$temp = seq.current.data;
            if (patt0$temp instanceof INameRibbonPropProvider.INameRibbonPropAdder) {
                INameRibbonPropProvider.INameRibbonPropAdder adder = (INameRibbonPropProvider.INameRibbonPropAdder)patt0$temp;
                GridBagHelper rowPropgb = SelectionRibbonEditorPanel.prepareNewPropRow(namePropgb, activePanels, 1);
                SelectionEditorPanel.EditorPanel panel = (SelectionEditorPanel.EditorPanel)rowPropgb.getPanel();
                adder.add(panel, rowPropgb);
            }
        });
        int colorCount = 0;
        if (SelectionRibbonEditorPanel.testMaterialProp(propTypes, unshared)) {
            ++colorCount;
        }
        if (SelectionRibbonEditorPanel.testColorProp(propTypes)) {
            ++colorCount;
        }
        if (SelectionRibbonEditorPanel.testOpacityProp(propTypes)) {
            ++colorCount;
        }
        propgb = SelectionRibbonEditorPanel.prepareNewPropRow(propgb, activePanels, colorCount);
        SelectionRibbonEditorPanel.addMaterialProp(propTypes, unshared, propgb);
        SelectionRibbonEditorPanel.addColorProp(propTypes, propgb, sel);
        SelectionRibbonEditorPanel.addOpacityProp(propTypes, propgb);
        SelectionRibbonEditorPanel.finalizePropPnl(propgb, activePanels);
        activePanels.addAll(this.loadEditorsFromRibbons(propTypes, unshared));
        if (propTypes.contains(ISchematicRoom.AREA)) {
            activePanels.add(this.d_roomInfoSect);
        }
        for (ICompElement ice : objs) {
            if (!(ice instanceof IMerlinGeomSrc)) continue;
            activePanels.add(this.d_boundsSect);
            break;
        }
        if (propTypes.contains(Floor.WORKING_Z) && propTypes.contains(Floor.ZMIN_FILTER) && propTypes.contains(Floor.ZMAX_FILTER)) {
            activePanels.add(this.d_floorSect);
        }
        if (propTypes.contains(SchematicDoor.WIDTH)) {
            activePanels.add(this.d_doorSect1);
        }
        if (propTypes.contains(SchematicStair.TREAD_RISE) && propTypes.contains(SchematicStair.TREAD_RUN)) {
            activePanels.add(this.d_stairSect);
        }
        if (propTypes.contains(SchematicCorridor.SLOPE) && !propTypes.contains(SchematicStair.TREAD_RISE)) {
            activePanels.add(this.d_rampSect);
        }
        if (SelectionRibbonEditorPanel.filter(objs, FlowPath.class).size() > 0) {
            activePanels.remove(this.d_boundsSect);
        }
        if (SelectionRibbonEditorPanel.filter(objs, AHSPoint.class).size() > 0) {
            activePanels.remove(this.d_boundsSect);
        }
        if (SelectionRibbonEditorPanel.filter(objs, DataNode.VisLeaf.class).size() > 0) {
            activePanels.remove(this.d_boundsSect);
        }
        if (propTypes.contains(SchematicCorridor.BOTTOM_DOOR) && propTypes.contains(SchematicCorridor.TOP_DOOR) && propTypes.contains(SchematicCorridor.LENGTH) && propTypes.contains(SchematicCorridor.WIDTH)) {
            activePanels.remove(this.d_boundsSect);
            activePanels.add(this.d_corrSect);
            activePanels.add(this.d_extraCorrInfoSect1);
            activePanels.add(this.d_extraCorrInfoSect2);
        }
        if (unshared.contains(Elevator.PROP_OPEN_DELAY)) {
            activePanels.add(this.d_elevatorPropSect);
        }
        if (unshared.contains(Elevator.PROP_DISCHARGE_FLOOR)) {
            activePanels.add(this.d_elevatorLevelSect);
            activePanels.add(this.d_elevatorExtraSect);
        }
        if (VentusApp.isFP() && propTypes.contains(Camera.PROP_SECURITY)) {
            activePanels.add(this.d_cameraControlSect);
            activePanels.add(this.d_cameraOrientSect);
            activePanels.add(this.d_cameraLimitsSect);
        }
        if (propTypes.contains(ImportedGeom.PROP_OBJECT_TYPE) && propTypes.contains(ImportedGeom.PROP_IMPORTED_TYPE)) {
            activePanels.add(this.d_sceneGeomSect);
        }
        return activePanels;
    }

    @Override
    protected void updateLayout() {
        EventQueue.invokeLater(() -> {
            this.removeAll();
            for (SelectionEditorPanel.EditorPanel panel : this.d_activePanels) {
                this.addSeparator();
                this.addSection(panel);
            }
            SwingUtilities.updateComponentTreeUI(this);
        });
    }

    private static boolean shouldAddNameProp(Set<Object> shared, Set<Object> unshared) {
        return shared.contains(NamedMerlinObj.NAME);
    }

    private static void addNameProp(SelectionEditorPanel.EditorPanel panel, GridBagHelper propgb, boolean editable) {
        guiTextField fldName = new guiTextField();
        Dimension d = fldName.getPreferredSize();
        fldName.setPreferredSize(new Dimension((int)(1.5 * (double)d.width), d.height));
        fldName.setEditable(editable);
        panel.addConnection(new PropConnections.NamePropConnection(fldName));
        propgb.addRow(Intl.intl("Name:"), fldName, 0, 1.0);
    }

    public static boolean shouldAddVisibilityProp(Set<Object> shared, Set<Object> unshared) {
        return shared.contains(VentusData.VISIBILITY);
    }

    private static void addVisibilityProp(SelectionEditorPanel.EditorPanel panel, GridBagHelper propgb) {
        guiMultiStateCheckBox ckVisible = new guiMultiStateCheckBox(Intl.intl("Visible"));
        panel.addConnection(new PropConnections.VisPropConnection(ckVisible));
        propgb.addRow(ckVisible, 0);
    }

    private static GridBagHelper prepareNewPropRow(GridBagHelper gb, List<SelectionEditorPanel.EditorPanel> panels, int rowsToAdd) {
        if (gb.getCurrentRow() + rowsToAdd > 3) {
            panels.add((SelectionEditorPanel.EditorPanel)gb.getPanel());
            SelectionEditorPanel.EditorPanel panel = new SelectionEditorPanel.EditorPanel();
            gb = new GridBagHelper(panel);
            gb.rowSpace = 1;
        }
        return gb;
    }

    private static void finalizePropPnl(GridBagHelper gb, List<SelectionEditorPanel.EditorPanel> panels) {
        if (gb.getCurrentRow() > 0) {
            panels.add((SelectionEditorPanel.EditorPanel)gb.getPanel());
        }
    }

    private static boolean testMaterialProp(Set<Object> propTypes, Set<Object> propTypesUnion) {
        return propTypes.contains(VentusData.MATERIAL) || SelectionRibbonEditorPanel.testColorProp(propTypes) && propTypesUnion.contains(VentusData.MATERIAL);
    }

    private static void addMaterialProp(Set<Object> propTypes, Set<Object> propTypesUnion, GridBagHelper propgb) {
        if (SelectionRibbonEditorPanel.testMaterialProp(propTypes, propTypesUnion)) {
            MaterialBtn btn = new MaterialBtn(true);
            ((SelectionEditorPanel.EditorPanel)propgb.getPanel()).addConnection(new PropConnections.MaterialConn(btn));
            propgb.addRow(Intl.intl("Material:"), btn, 1.0, 0);
        }
    }

    private static boolean testColorProp(Set<Object> propTypes) {
        return propTypes.contains(VentusData.COLOR);
    }

    private static void addColorProp(Set<Object> propTypes, GridBagHelper propgb, MerlinSelectionModel sel) {
        if (SelectionRibbonEditorPanel.testColorProp(propTypes)) {
            JComponent lblComp;
            ColorButton cb = SelectionRibbonEditorPanel.newColorButton();
            ((SelectionEditorPanel.EditorPanel)propgb.getPanel()).addConnection(new PropConnections.ColorConn(cb));
            if (sel.isDeepEmpty(ImportedGeom.class)) {
                guiMultiStateCheckBox colorCB = new guiMultiStateCheckBox(Intl.intl("Color:"));
                LinkStatus.link((AbstractButton)colorCB, cb);
                ((SelectionEditorPanel.EditorPanel)propgb.getPanel()).addConnection(new PropConnections.BoolPropConnection(new ColorDefProp(), colorCB));
                lblComp = colorCB;
            } else {
                lblComp = new guiLabel(Intl.intl("Color:"));
            }
            propgb.addRow(lblComp, cb, 1.0, 0);
        }
    }

    private static boolean testOpacityProp(Set<Object> propTypes) {
        return propTypes.contains(VentusData.OPACITY);
    }

    private static void addOpacityProp(Set<Object> propTypes, GridBagHelper propgb) {
        if (SelectionRibbonEditorPanel.testOpacityProp(propTypes)) {
            MerlinUDF opacityFld = new MerlinUDF(NonSI.PERCENT);
            ((SelectionEditorPanel.EditorPanel)propgb.getPanel()).addConnection(new OpacityConn(opacityFld));
            propgb.addRow(Intl.intl("Opacity:"), opacityFld, 1.0);
        }
    }

    private static ColorButton newColorButton() {
        ColorButton cb = new ColorButton(1);
        cb.setText(Intl.intl("<multiple>"));
        Insets margin = cb.getMargin();
        cb.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        return cb;
    }

    private static void addCorridorDoorState(SelectionEditorPanel.EditorPanel pnl, GridBagHelper gb) {
        HTMLBtn stateBtn = new HTMLBtn("");
        DiscreteVarEditor varEditor = new DiscreteVarEditor(true, Intl.intl("Open"), false, Intl.intl("Closed"));
        pnl.addConnection(new PropConnections.VariantProp(Intl.intl("Door State"), new CompElementActions.DefProp(ISchematicConnector.STATE), stateBtn, varEditor));
        gb.addRow(Intl.intl("State:"), stateBtn, 1.0, 0);
    }

    private static void addConnectorState(SelectionEditorPanel.EditorPanel pnl, GridBagHelper gb) {
        HTMLBtn stateBtn = new HTMLBtn("");
        DiscreteVarEditor<SchematicDoorDir> varEditor = new DiscreteVarEditor<SchematicDoorDir>(SchematicDoorDir.getMap(Predicates.alwaysTrue()));
        pnl.addConnection(new PropConnections.VariantProp<SchematicDoorDir>(Intl.intl("Door State"), new CompElementActions.DefProp(ISchematicConnector.STATE), stateBtn, varEditor));
        gb.addRow(Intl.intl("State:"), stateBtn, 1.0, 0);
    }

    private static Set<Elevator> getElevators(Collection<? extends ICompElement> objs) {
        LinkedIdentityHashSet<Elevator> elevators = new LinkedIdentityHashSet<Elevator>();
        for (ICompElement iCompElement : objs) {
            if (iCompElement instanceof Elevator) {
                elevators.add((Elevator)iCompElement);
                continue;
            }
            if (!(iCompElement instanceof Composite)) continue;
            elevators.addAll(((Composite)iCompElement).getDeepMembers(Elevator.class));
        }
        return elevators;
    }

    private static class NewCompGroupPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 5997508668479008215L;
        private final VentusData d_md;
        private final NodeComboBox<?> d_nodeCB;
        private final guiLabel d_nodeLbl;

        public NewCompGroupPnl(VentusData md) {
            this.d_md = md;
            SchematicNodeComboModel nodeModel = new SchematicNodeComboModel(md);
            this.d_nodeCB = new NodeComboBox<GeomComposite>(nodeModel);
            Dimension prefSize = this.d_nodeCB.getPreferredSize();
            if (prefSize.width < 300) {
                prefSize.width = 120;
                this.d_nodeCB.setPreferredSize(prefSize);
            }
            SelectionRibbonEditorPanel.adjustHeight(this.d_nodeCB);
            this.d_nodeLbl = new guiLabel(Intl.intl("Group:"));
            guiLabel title = new guiLabel(Intl.intl("New Schematic Components"));
            title.setFont(title.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this, false);
            gb.rowSpace = 1;
            gb.addRow(title, 0);
            gb.addIdentRow(this.d_nodeLbl, this.d_nodeCB);
            gb.finalizeRows();
        }

        private void updateEnabledStatus() {
            boolean nodeEnabled = this.d_md.floorOptions.get(FloorOptions.AUTO_SELECT_FLOOR) == false;
            this.d_nodeLbl.setEnabled(nodeEnabled);
            this.d_nodeCB.setEnabled(nodeEnabled);
        }

        @Override
        public void bind(Collection<ICompElement> arg0) {
            super.bind(arg0);
            this.updateEnabledStatus();
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(FloorOptions.class)) {
                this.updateEnabledStatus();
            }
        }
    }

    private static class FloorSortPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -1767295841240590359L;
        private final guiMultiStateCheckBox d_autoCreateFloorsCB = new guiMultiStateCheckBox(Intl.intl("Automatically create levels"));
        private final guiUnitDoubleField d_autoFloorDistFld;
        private final guiMultiStateCheckBox d_autoSortCompsCB;

        public FloorSortPnl(VentusData md) {
            guiUtil.setLongTooltip(this.d_autoCreateFloorsCB, Intl.intl("Automatically create new levels when adding/modifying schematics\ncomponents if they are outside the <b>Level height</b> of the previous level."));
            guiLabel distLbl = new guiLabel(Intl.intl("Default Height:"));
            distLbl.setToolTipText(Intl.intl("The minimum distance between levels to automatically create a new level."));
            this.d_autoFloorDistFld = new MerlinUDF(0, DoubleVR.above(0.0, false));
            this.d_autoSortCompsCB = new guiMultiStateCheckBox(Intl.intl("Auto sort schematics components"));
            guiUtil.setLongTooltip(this.d_autoSortCompsCB, Intl.intl("Automatically sort new and modified schematics components (rooms, doors, etc.)\ninto appropriate levels."));
            this.d_autoFloorDistFld.setPreferredSize(new Dimension(this.d_autoFloorDistFld.getPreferredSize().width, this.d_autoCreateFloorsCB.getPreferredSize().height - 2));
            LinkStatus.link2((AbstractButton)this.d_autoCreateFloorsCB, distLbl, this.d_autoFloorDistFld);
            LinkStatus.link2((AbstractButton)this.d_autoSortCompsCB, this.d_autoCreateFloorsCB, distLbl, this.d_autoFloorDistFld);
            this.addConnection(new FloorBoolConn(FloorOptions.AUTO_SELECT_FLOOR, this.d_autoSortCompsCB));
            this.addConnection(new AutoFloorDistUDConn(FloorOptions.MIN_AUTO_FLOOR_DIST, this.d_autoFloorDistFld));
            this.addConnection(new FloorBoolConn(FloorOptions.AUTO_CREATE_FLOOR, this.d_autoCreateFloorsCB));
            guiLabel title = new guiLabel(Intl.intl("Level Creation/Sorting"));
            title.setFont(title.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(title, 2);
            gb.indent();
            gb.addRow(this.d_autoSortCompsCB, GridBagHelper.REMAINING);
            gb.addRow(this.d_autoCreateFloorsCB, GridBagHelper.REMAINING);
            gb.indent();
            gb.addRow(distLbl, this.d_autoFloorDistFld);
            gb.finalizeRows();
        }

        @Override
        public void update(Events events) {
            if (!events.isAffected(FloorOptions.class)) {
                return;
            }
            super.update(events);
        }
    }

    private static class ActiveFloorPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 0L;

        public ActiveFloorPnl(VentusData md) {
            guiMultiStateCheckBox showPrevLevel = new guiMultiStateCheckBox(Intl.intl("Show lower level"));
            showPrevLevel.setToolTipText(Intl.intl("Shows the level immediately below the active level. This also applies when making a level active."));
            TriConsumer<VentusData, Collection<? extends ICompElement>, Boolean> additionalAction = (vd, objs, showBelow) -> SetActiveFloor.setFloorBelowVisible(md, md.floors.getActive(), showBelow);
            this.addConnection(new FloorBoolConn(FloorOptions.SHOW_LOWER_FLOOR, showPrevLevel, additionalAction));
            guiMultiStateCheckBox limitSelActive = new guiMultiStateCheckBox(Intl.intl("Limit selection to active floor"));
            limitSelActive.setToolTipText("<html>" + Intl.intl("If only the active level and the level below are visible, 2D/3D selection<br>is limited to objects on the active level."));
            this.addConnection(new FloorBoolConn(FloorOptions.LIMIT_SELECTION_TO_ACTIVE, limitSelActive));
            guiUtil.link((AbstractButton)showPrevLevel, limitSelActive);
            guiLabel title = new guiLabel(Intl.intl("Active Level"));
            title.setFont(title.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this, false);
            gb.rowSpace = 1;
            gb.addRow(title, 0);
            gb.addIdentRow(showPrevLevel, 0);
            gb.addIdentRow(limitSelActive, 0);
            gb.finalizeRows();
        }

        @Override
        public void update(Events events) {
            if (!events.isAffected(FloorOptions.class)) {
                return;
            }
            super.update(events);
        }
    }

    private static class GenerateModelSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -4666497424727293639L;

        public GenerateModelSect(boolean global) {
            JButton btn = global ? new JButton(GenerateModelFromBIM.UI_HOOK_GLOBAL) : new JButton(GenerateModelFromBIM.UI_HOOK_CONTEXT);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(btn, 1.0, 0);
        }
    }

    private static class FloorSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 5269600870831455532L;

        public FloorSect() {
            MerlinUDF workingZFld = new MerlinUDF(0);
            MerlinUDF heightFld = new MerlinUDF(0);
            MerlinUDF zminFld = new MerlinUDF(0);
            zminFld.aliasValue(Floor.CURR_FLOOR, Intl.intl("CURR_LEVEL"), "");
            MerlinUDF zmaxFld = new MerlinUDF(0);
            zmaxFld.aliasValue(Floor.NEXT_FLOOR, Intl.intl("NEXT_LEVEL"), "");
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Floor.WORKING_Z), workingZFld));
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Floor.HEIGHT), heightFld));
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Floor.ZMIN_FILTER), zminFld));
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Floor.ZMAX_FILTER), zmaxFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            gb.addRow(Intl.intl("Working Z:"), workingZFld, 1.0, 0);
            gb.addRow(Intl.intl("Level Height:"), heightFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Min Filter:"), zminFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Max Filter:"), zmaxFld, 1.0, 0);
        }
    }

    private static class RoomInfoSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -7471856652914712994L;
        private final guiUnitDoubleField d_fldArea;
        private final guiUnitDoubleField d_fldVolume;
        private final guiUnitDoubleField d_fldHeight;
        private volatile Thread d_lastUpdaterThread = null;
        private final guiLabel d_labArea = guiUtil.lbl(Intl.intl("Area:"), Intl.intl("The total floor area of the selection."));
        private final guiLabel d_labVolume;
        private final guiLabel d_labHeight;

        public RoomInfoSect() {
            this.d_fldArea = new MerlinUDF(2);
            this.d_fldArea.setEditable(false);
            this.d_labVolume = guiUtil.lbl(Intl.intl("Volume:"), Intl.intl("The total volume of the selection."));
            this.d_fldVolume = new MerlinUDF(16);
            this.d_fldVolume.setEditable(false);
            this.d_labHeight = guiUtil.lbl(Intl.intl("Height:"), Intl.intl("The level height of the selection."));
            this.d_fldHeight = new MerlinUDF(0);
            this.d_fldHeight.setEditable(false);
            Dimension preferredSize = this.d_fldArea.getPreferredSize();
            preferredSize.width = (int)((double)preferredSize.width * 1.15);
            this.d_fldArea.setPreferredSize(preferredSize);
            this.d_fldVolume.setPreferredSize(preferredSize);
            this.d_fldHeight.setPreferredSize(preferredSize);
            guiPanel p = new guiPanel(new GridBagLayout());
            GridBagUtil.add(p, this.d_labVolume, 0, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldVolume, 1, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_labArea, 0, 1, 1, 1, 3, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldArea, 1, 1, 1, 1, 3, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_labHeight, 0, 2, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldHeight, 1, 2, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
            this.addConnection(new Updater());
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(ISchematicRoom.HEIGHT), this.d_fldHeight));
        }

        public void addToLayout(GridBagHelper gb) {
            gb.pushSpacing(gb.colSpace, 3);
            gb.addRow(this.d_labArea, this.d_fldArea, 1.0, 0);
            gb.addRow(this.d_labVolume, this.d_fldVolume, 1.0, 0);
            gb.popSpacing();
        }

        private UnitDouble accumulateUD(Object prop, Collection<ICompElement> objs, Unit defUnit) {
            UnitDouble udSum = null;
            Collection<ICompElement> dColl = MerlinUtil.flattenComposites(objs);
            for (ICompElement leaf : dColl) {
                if (this.d_lastUpdaterThread != Thread.currentThread()) {
                    return new UnitDouble(0.0, defUnit);
                }
                Object property = leaf.getProperty(prop);
                if (property == null || property == ICompElement.NOT_SUPPORTED) continue;
                UnitDouble ud = (UnitDouble)property;
                if (udSum == null) {
                    udSum = ud;
                    continue;
                }
                udSum = udSum.add(ud);
            }
            if (udSum == null) {
                udSum = new UnitDouble(0.0, defUnit);
            }
            return udSum;
        }

        private class Updater
        implements PropConnections.IPropConnection {
            private Collection<ICompElement> d_objs;

            private Updater() {
            }

            @Override
            public void bind(Collection<ICompElement> objs) {
                this.d_objs = objs;
                this.update(null);
            }

            @Override
            public void commit() {
            }

            @Override
            public void release() {
                this.d_objs = Collections.EMPTY_LIST;
                RoomInfoSect.this.d_lastUpdaterThread = null;
            }

            @Override
            public void update(Events events) {
                RoomInfoSect.this.d_lastUpdaterThread = new Thread(new PropUpdater(this.d_objs));
                RoomInfoSect.this.d_lastUpdaterThread.start();
            }
        }

        private class PropUpdater
        implements Runnable {
            private final Collection<ICompElement> d_elements;

            public PropUpdater(Collection<ICompElement> elements) {
                this.d_elements = elements;
            }

            @Override
            public void run() {
                VentusData vd = VentusApp.getAppData();
                try (VentusData.ReadLock lock = vd.lockRead();){
                    UnitSystem us = VentusApp.getApp().getUnitSystem();
                    UnitDouble area = RoomInfoSect.this.accumulateUD(ISchematicRoom.AREA, this.d_elements, us.getUnit(2));
                    UnitDouble volume = RoomInfoSect.this.accumulateUD(ISchematicRoom.VOLUME, this.d_elements, us.getUnit(16));
                    if (RoomInfoSect.this.d_lastUpdaterThread != Thread.currentThread()) {
                        return;
                    }
                    EventQueue.invokeLater(() -> {
                        RoomInfoSect.this.d_fldArea.setValue(area);
                        RoomInfoSect.this.d_fldVolume.setValue(volume);
                    });
                }
            }
        }
    }

    private static class DoorSect1
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -7130843676944061083L;

        public DoorSect1() {
            MerlinUDF fldWid = new MerlinUDF(4);
            PropConnections.UDPropConnection connWid = new PropConnections.UDPropConnection(new PropConnections.DToUDProp<ICompElement>(SI.METER, new DoorWidthProp(SchematicDoor.WIDTH)), fldWid);
            this.addConnection(connWid);
            guiPanel p = new guiPanel();
            GridBagHelper gb = new GridBagHelper(p);
            gb.rowSpace = 2;
            gb.addRow(Intl.intl("Width:"), fldWid, 0, 1.0);
            SelectionRibbonEditorPanel.addConnectorState(this, gb);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
        }
    }

    private static class CorridorSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 4575635054810992752L;

        public CorridorSect() {
            MerlinUDF fldWidth = new MerlinUDF(4);
            PropConnections.UDPropConnection connWidth = new PropConnections.UDPropConnection(new CorridorDoorWidthProp(), fldWidth);
            this.addConnection(connWidth);
            CorridorDoorAction topDoorAction = new CorridorDoorAction(this, Intl.intl("Top Door Properties"), SchematicCorridor.TOP_DOOR);
            HTMLBtn topDoorBtn = new HTMLBtn(Intl.intl("Edit"));
            topDoorBtn.addActionListener(topDoorAction);
            this.addConnection(topDoorAction);
            CorridorDoorAction bottomDoorAction = new CorridorDoorAction(this, Intl.intl("Bottom Door Properties"), SchematicCorridor.BOTTOM_DOOR);
            HTMLBtn bottomDoorBtn = new HTMLBtn(Intl.intl("Edit"));
            bottomDoorBtn.addActionListener(bottomDoorAction);
            this.addConnection(bottomDoorAction);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Width:"), fldWidth);
            gb.addRow(Intl.intl("Top Door:"), topDoorBtn, 0);
            gb.addRow(Intl.intl("Bottom Door:"), bottomDoorBtn, 0);
        }
    }

    private static class CorridorExtraPnl1
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -1516979897630973821L;

        public CorridorExtraPnl1() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
        }
    }

    private static class CorridorExtraPnl2
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 5678849257367198406L;

        public CorridorExtraPnl2() {
            HTMLBtn extraInfoBtn = new HTMLBtn(Intl.intl("Additional Info"));
            ViewMoreProp vmProp = new ViewMoreProp(extraInfoBtn);
            this.addConnection(vmProp);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(extraInfoBtn, 0);
        }

        private static class ViewMoreProp
        implements PropConnections.IPropConnection,
        ActionListener {
            private final Component d_parent;
            private Collection<ICompElement> d_objs;

            public ViewMoreProp(HTMLBtn btn) {
                this.d_parent = btn;
                btn.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                BoundsSect bounds = new BoundsSect();
                RoomInfoSect roomInfo = new RoomInfoSect();
                guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this.d_parent), Intl.intl("Stair and Ramp Information"), 16);
                guiPanel mainPnl = dlg.getDialogPane();
                GridBagHelper gb = new GridBagHelper(mainPnl);
                gb.addFilledRow(new TitleSeparator(Intl.intl("Bounds")));
                gb.indent();
                bounds.addToLayout(gb);
                gb.unindent();
                gb.addFilledRow(new TitleSeparator(Intl.intl("Occupancy")));
                gb.indent();
                roomInfo.addToLayout(gb);
                gb.finalizeRows();
                bounds.bind(this.d_objs);
                roomInfo.bind(this.d_objs);
                dlg.setResizable(true);
                dlg.doModal();
            }

            @Override
            public void bind(Collection<ICompElement> objs) {
                this.d_objs = objs;
            }

            @Override
            public void release() {
                this.d_objs = null;
            }

            @Override
            public void commit() {
            }

            @Override
            public void update(Events events) {
            }
        }
    }

    private static class StairSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -5785590882396541290L;

        public StairSect() {
            MerlinUDF fldRiser = new MerlinUDF(4);
            PropConnections.UDPropConnection connRiser = new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(SchematicStair.TREAD_RISE), fldRiser);
            this.addConnection(connRiser);
            MerlinUDF fldTread = new MerlinUDF(4);
            PropConnections.UDPropConnection connTread = new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(SchematicStair.TREAD_RUN), fldTread);
            this.addConnection(connTread);
            MerlinUDF fldLen = new MerlinUDF(0);
            fldLen.setEditable(false);
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(SchematicCorridor.LENGTH), fldLen));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Riser:"), fldRiser);
            gb.addRow(Intl.intl("Tread:"), fldTread);
            gb.addRow(Intl.intl("Length:"), fldLen);
        }
    }

    private static class RampSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 8041411753500460637L;

        public RampSect() {
            guiDoubleField fldSlope = new guiDoubleField();
            fldSlope.setEditable(false);
            this.addConnection(new PropConnections.DoublePropConn(new CompElementActions.DefProp<ICompElement, Double>(SchematicCorridor.SLOPE), fldSlope));
            MerlinUDF fldSlopeAngle = new MerlinUDF(5);
            fldSlopeAngle.setEditable(false);
            this.addConnection(new SlopeAngleConn(fldSlopeAngle));
            MerlinUDF fldLen = new MerlinUDF(0);
            fldLen.setEditable(false);
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(SchematicCorridor.LENGTH), fldLen));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Incline Angle:"), fldSlopeAngle);
            gb.addRow(Intl.intl("Incline (rise/run):"), fldSlope);
            gb.addRow(Intl.intl("Length:"), fldLen);
        }

        public static UnitDouble getSlopeAngle(double slope) {
            if (Double.isNaN(slope)) {
                return new UnitDouble(slope, SI.RADIAN);
            }
            double slopeAngle = Math.atan(slope);
            return new UnitDouble(slopeAngle, SI.RADIAN);
        }

        private static class SlopeAngleConn
        extends PropConnections.UDPropConnection {
            public SlopeAngleConn(guiUnitDoubleField field) {
                super(new CompElementActions.DefProp<ICompElement, UnitDouble>(SchematicCorridor.SLOPE), field);
            }

            @Override
            public void initFromVal(Object val, guiValueField<UnitDouble> comp) {
                if (val instanceof Double) {
                    val = RampSect.getSlopeAngle((Double)val);
                }
                super.initFromVal(val, comp);
            }
        }
    }

    private static class BoundsSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -6736958249381526284L;
        private final guiTextField d_xBoundsFld;
        private final guiTextField d_yBoundsFld;
        private final guiTextField d_zBoundsFld;
        private volatile Thread d_lastUpdaterThread = null;

        public BoundsSect() {
            this.setPreferredSize(new Dimension(150, 70));
            this.d_xBoundsFld = new guiTextField();
            this.d_yBoundsFld = new guiTextField();
            this.d_zBoundsFld = new guiTextField();
            this.d_xBoundsFld.setEditable(false);
            this.d_yBoundsFld.setEditable(false);
            this.d_zBoundsFld.setEditable(false);
            Dimension preferredSize = this.d_xBoundsFld.getPreferredSize();
            preferredSize.width = (int)((double)preferredSize.width * 1.3);
            this.d_xBoundsFld.setPreferredSize(preferredSize);
            this.d_yBoundsFld.setPreferredSize(preferredSize);
            this.d_zBoundsFld.setPreferredSize(preferredSize);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            gb.addRow(Intl.intl("X Bounds:"), this.d_xBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Y Bounds:"), this.d_yBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Bounds:"), this.d_zBoundsFld, 1.0, 0);
            this.addConnection(new Updater());
        }

        public void addToLayout(GridBagHelper gb) {
            gb.pushSpacing(gb.colSpace, 3);
            gb.addRow(Intl.intl("X Bounds:"), this.d_xBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Y Bounds:"), this.d_yBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Bounds:"), this.d_zBoundsFld, 1.0, 0);
            gb.popSpacing();
        }

        private void updateMinMax(Set<ICompElement> objs) {
            AABox bb = new AABox();
            if (objs != null) {
                for (ICompElement ice : objs) {
                    if (!(ice instanceof IMerlinGeomSrc)) continue;
                    AABox box = ((IMerlinGeomSrc)((Object)ice)).getBounds();
                    bb.add(box);
                }
            }
            Unit u = Geometry.LENGTH_UNIT;
            Point3d boundsMin = bb.getMin();
            Point3d boundsMax = bb.getMax();
            UnitSystem us = VentusApp.getApp().getUnitSystem();
            Unit length = us.getLength();
            BiFunction<Double, Double, String> formatBounds = (min, max) -> {
                if (min > max) {
                    return Intl.intl("<unknown>");
                }
                if (max - min >= Double.MAX_VALUE) {
                    return Intl.intl("<infinite>");
                }
                return String.format("%1.2f %s, %1.2f %s", UnitDouble.convert(min, u, length), length, UnitDouble.convert(max, u, length), length);
            };
            TriConsumer<guiTextField, Double, Double> updateFld = (fld, min, max) -> {
                String boundsStr = (String)formatBounds.apply((Double)min, (Double)max);
                fld.setText(boundsStr);
                fld.setToolTipText(boundsStr);
                fld.setCaretPosition(0);
            };
            updateFld.accept(this.d_xBoundsFld, boundsMin.x, boundsMax.x);
            updateFld.accept(this.d_yBoundsFld, boundsMin.y, boundsMax.y);
            updateFld.accept(this.d_zBoundsFld, boundsMin.z, boundsMax.z);
        }

        private class Updater
        implements PropConnections.IPropConnection {
            private Updater() {
            }

            @Override
            public void bind(Collection<ICompElement> objs) {
                this.update(null);
            }

            @Override
            public void commit() {
            }

            @Override
            public void release() {
                BoundsSect.this.d_lastUpdaterThread = null;
            }

            @Override
            public void update(Events events) {
                BoundsSect.this.d_lastUpdaterThread = new Thread(new PropUpdater());
                BoundsSect.this.d_lastUpdaterThread.start();
            }
        }

        private class PropUpdater
        implements Runnable {
            @Override
            public void run() {
                if (BoundsSect.this.d_lastUpdaterThread != Thread.currentThread()) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MerlinSelectionModel sel = VentusApp.getApp().getData().selection;
                        Set<ICompElement> objs = sel.getSelected(ICompElement.class);
                        BoundsSect.this.updateMinMax(objs);
                    }
                });
            }
        }
    }

    private static class CameraControlSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 735559975360379055L;

        public CameraControlSect() {
            guiMultiStateCheckBox controllableCB = new guiMultiStateCheckBox(Intl.intl("Security Camera"));
            controllableCB.setToolTipText(Intl.intl("Treats the camera as a security camera that can be controlled during the simulation."));
            this.addConnection(new PropConnections.BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(Camera.PROP_SECURITY), controllableCB));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(controllableCB);
        }
    }

    private static class CameraOrientSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 6159519025359868412L;

        public CameraOrientSect() {
            int numCols = 5;
            guiDoubleField xfld = new guiDoubleField();
            xfld.setColumns(numCols);
            this.addConnection(new PropConnections.DoublePropConn(new VectorProp(Camera.PROP_PTZ_ORIENT, 0), xfld));
            guiDoubleField yfld = new guiDoubleField();
            yfld.setColumns(numCols);
            this.addConnection(new PropConnections.DoublePropConn(new VectorProp(Camera.PROP_PTZ_ORIENT, 1), yfld));
            guiDoubleField zfld = new guiDoubleField();
            zfld.setColumns(numCols);
            this.addConnection(new PropConnections.DoublePropConn(new VectorProp(Camera.PROP_PTZ_ORIENT, 2), zfld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Pan Axis (X):"), xfld, 0);
            gb.addRow(Intl.intl("Pan Axis (Y):"), yfld, 0);
            gb.addRow(Intl.intl("Pan Axis (Z):"), zfld, 0);
        }
    }

    private static class CameraLimitsSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -8095722618467231604L;
        private Collection<? extends ICompElement> d_boundObjs = Collections.EMPTY_LIST;

        public CameraLimitsSect() {
            GridBagHelper gb = new GridBagHelper(this, false);
            gb.rowSpace = 1;
            this.addPTZSpec(gb, Intl.intl("Pan"), Camera.PROP_PAN_INFO, 5, SI.RADIAN, UnitDoubleVR.UNBOUNDED, 11, SI.RADIAN.divide(SI.SECOND), UnitDoubleVR.above(0.0, SI.RADIAN.divide(SI.SECOND), true));
            this.addPTZSpec(gb, Intl.intl("Tilt"), Camera.PROP_TILT_INFO, 5, SI.RADIAN, UnitDoubleVR.between(-90.0, 90.0, NonSI.DEGREE_ANGLE, true, true), 11, SI.RADIAN.divide(SI.SECOND), UnitDoubleVR.above(0.0, SI.RADIAN.divide(SI.SECOND), true));
            this.addPTZSpec(gb, Intl.intl("Zoom"), Camera.PROP_ZOOM_INFO, 9, Unit.ONE, UnitDoubleVR.above(1.0, Unit.ONE, true), 12, Unit.ONE.divide(SI.SECOND), UnitDoubleVR.above(0.0, Unit.ONE.divide(SI.SECOND), true));
        }

        private void addPTZSpec(GridBagHelper gb, String name, IPropertySet.Prop<Camera.PTZSpec> prop, int rangeUnitType, Unit rangeStoreUnit, UnitDoubleVR rangeRange, int speedUnitType, Unit speedStoreUnit, UnitDoubleVR speedRange) {
            guiUnitDoubleField minFld = CameraLimitsSect.newField(rangeUnitType, rangeRange);
            this.addConnection(new PropConnections.UDPropConnection(new CameraRangeProp(prop, rangeStoreUnit, 0), minFld));
            guiUnitDoubleField maxFld = CameraLimitsSect.newField(rangeUnitType, rangeRange);
            this.addConnection(new PropConnections.UDPropConnection(new CameraRangeProp(prop, rangeStoreUnit, 1), maxFld));
            guiUnitDoubleField speedFld = CameraLimitsSect.newField(speedUnitType, speedRange);
            this.addConnection(new PropConnections.UDPropConnection(new CameraRangeProp(prop, speedStoreUnit, 2), speedFld));
            gb.addRow(CameraLimitsSect.getBoldLbl(name), Intl.intl("Min:"), minFld, Intl.intl("Max:"), maxFld, Intl.intl("Max Speed:"), speedFld);
        }

        private static guiUnitDoubleField newField(int unitType, UnitDoubleVR range) {
            MerlinUDF fld = new MerlinUDF(unitType, range);
            fld.setColumns(7);
            return fld;
        }

        private static guiLabel getBoldLbl(String text) {
            return new guiLabel("<html><b>" + text + "</b></html>");
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            objs = new ArrayList<Camera>(MerlinUtil.flatten(objs, Camera.class));
            super.bind(objs);
            this.d_boundObjs = objs;
            this.updateEnabled();
        }

        @Override
        public void release() {
            super.release();
            this.d_boundObjs = Collections.EMPTY_LIST;
        }

        @Override
        public void update(Events events) {
            super.update(events);
            this.updateEnabled();
        }

        private void updateEnabled() {
            Object oval = Composite.getProperty(Camera.PROP_SECURITY, this.d_boundObjs);
            this.setEnabled(oval instanceof Boolean && (Boolean)oval != false || oval == ICompElement.NON_UNIFORM);
        }
    }

    private static class SceneGeomPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 7501610581410197415L;

        public SceneGeomPnl() {
            guiTextField objType = new guiTextField();
            this.addConnection(new PropConnections.TextPropConnection((Object)ImportedGeom.PROP_OBJECT_TYPE, objType));
            objType.setEnabled(false);
            guiComboBox<ImportType> importTypes = guiUtil.newCombo(type -> {
                if (type == null) {
                    return new Pair<String, Object>("", null);
                }
                return new Pair<String, String>(type.name, type.desc);
            }, Stream.of(ImportType.values()).sorted((t1, t2) -> {
                if (t1 == t2) {
                    return 0;
                }
                if (t1 == ImportType.IGNORED) {
                    return -1;
                }
                if (t2 == ImportType.IGNORED) {
                    return 1;
                }
                return t1.name.compareToIgnoreCase(t2.name);
            }).collect(Collectors.toList()));
            this.addConnection(new PropConnections.ComboPropConn<ImportType>(new CompElementActions.DefProp(ImportedGeom.PROP_IMPORTED_TYPE), importTypes));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 3;
            guiLabel typelbl = new guiLabel(Intl.intl("Object Type:"));
            typelbl.setToolTipText(Intl.intl("The object type as specified in the imported file."));
            guiLabel itypelbl = new guiLabel(Intl.intl("Import Type:"));
            itypelbl.setToolTipText("<html>" + Intl.intl("The object type used when generating model elements.<br>This is determined automatically if imported from an IFC file."));
            gb.addRow(typelbl, objType, 1.0, 0);
            gb.addRow(itypelbl, importTypes, 1.0, 0);
        }
    }

    private static class ElevatorDataPnl
    extends ElevatorPnl {
        private static final long serialVersionUID = 8065547898578052044L;

        public ElevatorDataPnl() {
            MerlinUDF sepFld = new MerlinUDF(7);
            sepFld.setToolTipText(Intl.intl("The approximate number of people in a full load."));
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_NOMINAL_LOAD), sepFld));
            MerlinUDF openDelayFld = new MerlinUDF(1);
            openDelayFld.setToolTipText(Intl.intl("The minimum time an elevator door stays open on a pickup floor."));
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_OPEN_DELAY), openDelayFld));
            MerlinUDF closeDelayFld = new MerlinUDF(1);
            closeDelayFld.setToolTipText(Intl.intl("The door closing delay after the last occupant goes through on a pickup floor."));
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_CLOSE_DELAY), closeDelayFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Nominal Load:"), sepFld);
            gb.addRow(Intl.intl("Open Delay:"), openDelayFld);
            gb.addRow(Intl.intl("Close Delay:"), closeDelayFld);
        }
    }

    private static class ElevatorLevelPnl
    extends ElevatorPnl {
        private static final long serialVersionUID = -5390926138045470372L;
        private Set<Elevator> d_objs;

        public ElevatorLevelPnl() {
            BasicFloorComboBox dischargeCB = new BasicFloorComboBox(VentusApp.getApp().getData());
            this.addConnection(new ElevatorFloorConn(new CompElementActions.DefProp<ICompElement, Floor>(Elevator.PROP_DISCHARGE_FLOOR), dischargeCB, true, new Component[0]));
            HTMLBtn levelBtn = new HTMLBtn(Intl.intl("Edit"));
            levelBtn.addActionListener(new LevelActionListener());
            VentusData md = VentusApp.getApp().getData();
            PriorityChooser<Floor> priorityChooser = new PriorityChooser<Floor>(md, Intl.intl("Floor Priority"), Intl.intl("top-down"), md.floors, Floor.class, null);
            priorityChooser.setSorter(new Comparator<Floor>(this){

                @Override
                public int compare(Floor o1, Floor o2) {
                    return o2.getWorkingZ().compareTo(o1.getWorkingZ());
                }
            });
            this.addConnection(new ElevatorPriorityConn(Elevator.PROP_FLOOR_PRIORITY, priorityChooser));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Discharge Floor:"), dischargeCB);
            gb.addRow(Intl.intl("Floor Priority:"), priorityChooser);
            gb.addRow(Intl.intl("Level Data:"), levelBtn);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_objs = SelectionRibbonEditorPanel.getElevators(objs);
            super.bind(objs);
        }

        @Override
        public void release() {
            this.d_objs = Collections.EMPTY_SET;
            super.release();
        }

        private class LevelActionListener
        implements ActionListener {
            private LevelActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                VentusData md = VentusApp.getApp().getData();
                IdentityHashMap<Floor, Elevator.LevelData> levelData = new IdentityHashMap<Floor, Elevator.LevelData>();
                Elevator toPass = null;
                boolean uniqueDischarge = false;
                for (Elevator elevator : ElevatorLevelPnl.this.d_objs) {
                    if (!uniqueDischarge) {
                        toPass = elevator;
                        uniqueDischarge = true;
                    } else if (uniqueDischarge) {
                        toPass = null;
                    }
                    Map<Floor, Elevator.LevelData> eLevelData = elevator.getLevelData();
                    for (Map.Entry<Floor, Elevator.LevelData> entry : eLevelData.entrySet()) {
                        Floor floor = entry.getKey();
                        Elevator.LevelData ld = entry.getValue();
                        if (!levelData.containsKey(floor)) {
                            levelData.put(floor, ld);
                            continue;
                        }
                        Elevator.LevelData existing = (Elevator.LevelData)levelData.get(floor);
                        if (existing == null || existing.equals(ld)) continue;
                        levelData.put(floor, null);
                    }
                }
                ElevatorLevelDlg dlg = new ElevatorLevelDlg((Window)VentusApp.getApp().getActiveFrame(), levelData, toPass);
                if (dlg.doModal() == 1) {
                    md.pauseUpdates();
                    Undo.begin(Intl.intl("Edit Elevator Levels"));
                    Undo.insertUndoEntry_propRestore(md, ElevatorLevelPnl.this.d_objs, Elevator.PROP_LEVEL_DATA);
                    Map<Floor, Elevator.LevelData> newLevelData = dlg.getLevelData();
                    for (Elevator elevator : ElevatorLevelPnl.this.d_objs) {
                        elevator.setLevelData(newLevelData);
                    }
                    Undo.end(md);
                    md.resumeUpdates();
                }
            }
        }
    }

    private static class ElevatorExtraPnl
    extends ElevatorPnl {
        private static final long serialVersionUID = 6230900399034401889L;

        public ElevatorExtraPnl() {
            BasicFloorComboBox initFloorCB = new BasicFloorComboBox(VentusApp.getApp().getData());
            MerlinUDF callDistFld = new MerlinUDF(0, DoubleVR.above(0.0, true));
            callDistFld.setToolTipText(Intl.intl("The distance away from the elevator door at which an occupant can call the elevator."));
            this.addConnection(new ElevatorFloorConn(new CompElementActions.DefProp<ICompElement, Floor>(Elevator.PROP_INIT_FLOOR), initFloorCB, false, callDistFld));
            this.addConnection(new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_CALL_DISTANCE), callDistFld));
            guiMultiStateCheckBox doubleDeckCb = new guiMultiStateCheckBox(Intl.intl("Double-Deck"), false);
            doubleDeckCb.setToolTipText(String.format("<html>" + Intl.intl("If checked, the elevator will use two decks to transport occupants.<br>Additionally to the discharge level, the level on top of the discharge level will also be used for discharge.") + "</html>", new Object[0]));
            this.addConnection(new PropConnections.BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(Elevator.PROP_DOUBLE_DECK), doubleDeckCb));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Initial Floor:"), initFloorCB);
            gb.addRow(Intl.intl("Call Distance:"), callDistFld);
            gb.addRow(doubleDeckCb);
        }
    }

    private static class ColorDefProp
    extends CompElementActions.DefProp<ICompElement, Boolean> {
        public ColorDefProp() {
            super(VentusData.COLOR);
        }

        @Override
        protected Object get(VentusData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val == null) {
                return false;
            }
            if (val instanceof Color) {
                return true;
            }
            return val;
        }

        @Override
        protected void set(VentusData md, Object prop, ICompElement obj, Boolean newVal) {
            Color newColor = this.getNewColor(md, prop, obj, newVal);
            obj.setProperty(prop, newColor);
        }

        private Color getNewColor(VentusData md, Object prop, ICompElement obj, Boolean newVal) {
            if (!newVal.booleanValue()) {
                return null;
            }
            return Color.WHITE;
        }
    }

    private static class OpacityConn
    extends PropConnections.UDPropConnection {
        public OpacityConn(guiUnitDoubleField fld) {
            super(new OpacityUDProp(), fld);
            fld.setEmptyAllowed(true);
            fld.setValueRange(UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true));
            fld.setColumns(5);
        }

        private static class OpacityUDProp
        implements CompElementActions.IObjectProp<ICompElement, UnitDouble> {
            private final CompElementActions.IObjectProp<ICompElement, IOpacity> d_opacity = new CompElementActions.DefProp<ICompElement, IOpacity>(VentusData.OPACITY);

            private OpacityUDProp() {
            }

            @Override
            public Object get(VentusData md, Collection<? extends ICompElement> objs) {
                Object val = this.d_opacity.get(md, objs);
                if (!(val instanceof IOpacity)) {
                    return val;
                }
                Double cval = ((IOpacity)val).getValue();
                return new UnitDouble(Math.round(cval * 100.0), NonSI.PERCENT);
            }

            @Override
            public void set(VentusData md, Collection<? extends ICompElement> objs, UnitDouble newVal) {
                UnitDouble udval = newVal;
                Opacity opacityVal = new Opacity((float)(udval.getValue(NonSI.PERCENT) * 0.01));
                this.d_opacity.set(md, objs, opacityVal);
            }
        }
    }

    private static class CorridorDoorAction
    implements PropConnections.IPropConnection,
    ActionListener {
        private final Component d_parent;
        private final String d_dlgTitle;
        private final Object d_doorProp;
        private Collection<ICompElement> d_objs;

        public CorridorDoorAction(Component parent, String dlgTitle, Object doorProp) {
            this.d_parent = parent;
            this.d_dlgTitle = dlgTitle;
            this.d_doorProp = doorProp;
        }

        @Override
        public void update(Events events) {
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_objs = objs;
        }

        @Override
        public void release() {
            this.d_objs = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.d_objs == null) {
                return;
            }
            final CorridorDoorPnl pnl = new CorridorDoorPnl(this.d_doorProp);
            pnl.bind(this.d_objs);
            guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this.d_parent), this.d_dlgTitle, 9);
            guiPanel mainPanel = dlg.getDialogPane();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add(pnl);
            if (dlg.doModal() == 1) {
                AMerlinOp op = new AMerlinOp(){

                    @Override
                    public void run(VentusApp app, VentusData md) {
                        try (VentusData.WriteLock lock = md.lockWrite();){
                            Undo.begin(Intl.intl("Edit Door"));
                            pnl.save(md, d_objs);
                            Undo.end(md);
                        }
                    }
                };
                SwingUtilities.invokeLater(() -> UIHook.run(UIHook.getComponent(e), "SelectionEditorPane.CorridorDoorAction.actionPerformed", op, 16));
            }
        }

        @Override
        public void commit() {
        }
    }

    private static class CorridorDoorWidthProp
    extends CompElementActions.DefProp<ICompElement, UnitDouble> {
        public CorridorDoorWidthProp() {
            super(SchematicCorridor.WIDTH);
        }

        @Override
        protected void saveState(VentusData md, Object prop, Collection<? extends ICompElement> objs, UnitDouble newVal) {
            List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(prop, objs);
            Undo.insertUndoEntry_restore(md, theUtil.filter(modObjs, IRestorable.class));
        }
    }

    private static class CameraRangeProp
    extends CompElementActions.DefProp<ICompElement, UnitDouble> {
        private final int d_ix;
        private final Unit d_storeUnit;

        public CameraRangeProp(IPropertySet.Prop<Camera.PTZSpec> prop, Unit storeUnit, int ix) {
            super(prop);
            this.d_storeUnit = storeUnit;
            this.d_ix = ix;
        }

        private static double[] asList(Camera.PTZSpec range) {
            return new double[]{range.rangeMin, range.rangeMax, range.maxSpeed};
        }

        private static Camera.PTZSpec newSpec(double[] list) {
            return new Camera.PTZSpec(list[0], list[1], list[2]);
        }

        @Override
        protected Object get(VentusData md, Object prop, ICompElement obj) {
            if (!(obj instanceof Camera)) {
                return ICompElement.NOT_SUPPORTED;
            }
            Camera cam = (Camera)obj;
            IPropertySet.Prop rprop = (IPropertySet.Prop)prop;
            Camera.PTZSpec spec = (Camera.PTZSpec)cam.get(rprop);
            return new UnitDouble(CameraRangeProp.asList(spec)[this.d_ix], this.d_storeUnit);
        }

        @Override
        protected void set(VentusData md, Object prop, ICompElement obj, UnitDouble newVal) {
            if (!(obj instanceof Camera)) {
                return;
            }
            IPropertySet.Prop rprop = (IPropertySet.Prop)prop;
            Camera cam = (Camera)obj;
            Camera.PTZSpec spec = (Camera.PTZSpec)cam.get(rprop);
            double[] newSpecList = CameraRangeProp.asList(spec);
            newSpecList[this.d_ix] = newVal.getValue(this.d_storeUnit);
            Camera.PTZSpec newSpec = CameraRangeProp.newSpec(newSpecList);
            if (spec.equals(newSpec)) {
                return;
            }
            cam.set(rprop, newSpec);
        }
    }

    private static class VectorProp
    extends CompElementActions.DefProp<ICompElement, Double> {
        private final int d_ix;

        public VectorProp(Object prop, int ix) {
            super(prop);
            this.d_ix = ix;
        }

        @Override
        protected Object get(VentusData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val instanceof Vector3d) {
                Vector3d vec = (Vector3d)val;
                switch (this.d_ix) {
                    case 0: {
                        return vec.x;
                    }
                    case 1: {
                        return vec.y;
                    }
                }
                return vec.z;
            }
            return val;
        }

        @Override
        protected void set(VentusData md, Object prop, ICompElement obj, Double newVal) {
            Vector3d vec = (Vector3d)obj.getProperty(prop);
            Vector3d newVec = new Vector3d(vec);
            switch (this.d_ix) {
                case 0: {
                    newVec.x = newVal;
                    break;
                }
                case 1: {
                    newVec.y = newVal;
                    break;
                }
                default: {
                    newVec.z = newVal;
                }
            }
            if (!newVec.equals(vec)) {
                obj.setProperty(prop, newVec);
            }
        }
    }

    private static class FloorBoolConn
    extends PropConnections.BoolPropConnection {
        public FloorBoolConn(FloorOptions.Prop<Boolean> prop, guiMultiStateCheckBox cb) {
            this(prop, cb, (a, b, c) -> {});
        }

        public FloorBoolConn(FloorOptions.Prop<Boolean> prop, guiMultiStateCheckBox cb, TriConsumer<VentusData, Collection<? extends ICompElement>, Boolean> additionalAction) {
            super(new FloorProp<Boolean>(prop, additionalAction), cb);
        }

        @Override
        protected boolean isDataEmpty() {
            return false;
        }
    }

    private static class FloorProp<ValT>
    implements CompElementActions.IObjectProp<ICompElement, ValT> {
        private final FloorOptions.Prop<ValT> d_floorProp;
        private final TriConsumer<VentusData, Collection<? extends ICompElement>, ValT> d_additionalAction;

        public FloorProp(FloorOptions.Prop<ValT> floorProp) {
            this(floorProp, (d, objs, newVal) -> {});
        }

        public FloorProp(FloorOptions.Prop<ValT> floorProp, TriConsumer<VentusData, Collection<? extends ICompElement>, ValT> additionalAction) {
            this.d_floorProp = floorProp;
            this.d_additionalAction = additionalAction;
        }

        @Override
        public Object get(VentusData md, Collection<? extends ICompElement> objs) {
            return md.floorOptions.get(this.d_floorProp);
        }

        @Override
        public void set(VentusData md, Collection<? extends ICompElement> objs, ValT newVal) {
            Undo.begin(Intl.intl("Set Property"));
            Undo.insertUndoEntry_restore(md, md.floorOptions);
            md.floorOptions.set(this.d_floorProp, newVal);
            this.d_additionalAction.accept(md, objs, newVal);
            Undo.end(md);
        }
    }

    private static class AutoFloorDistUDConn
    extends PropConnections.UDPropConnection {
        public AutoFloorDistUDConn(FloorOptions.Prop<UnitDouble> prop, guiUnitDoubleField fld) {
            super(new FloorProp<UnitDouble>(prop, (md, objs, newVal) -> {
                Collection<Floor> floors = md.floors.getMembers(Floor.class);
                if (floors.size() == 1) {
                    Floor baseFloor = floors.iterator().next();
                    Application app = Application.getApp();
                    if (baseFloor.getChildren().size() == 0 && app != null) {
                        String msg = Intl.intl("Would you like to apply the new Default Height to the base level?");
                        String title = Intl.intl("Apply Default Height");
                        int opts = 0;
                        int result = JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, title, opts);
                        if (result == 0) {
                            baseFloor.setHeight((UnitDouble)newVal);
                        }
                    }
                }
            }), fld);
        }

        @Override
        protected boolean isDataEmpty() {
            return false;
        }
    }

    private static class ElevatorPriorityConn
    extends PropConnections.ASinglePropConnection<PriorityChooser<Floor>> {
        public ElevatorPriorityConn(Object prop, PriorityChooser<Floor> chooser) {
            super(prop, chooser);
            ((PriorityChooser)this.getControl()).getComm().addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    this.onControlChanged();
                }
            });
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, PriorityChooser<Floor> comp) {
            Object availFloorsObj = Composite.getProperty(Elevator.PROP_SERVABLE_FLOORS, this.getObjs());
            final Set availFloors = availFloorsObj instanceof Set ? (Set)availFloorsObj : Collections.EMPTY_SET;
            comp.setFilter(new Predicate<Floor>(){

                @Override
                public boolean test(Floor o) {
                    return availFloors.contains(o);
                }
            });
            Object priority = Composite.getProperty(prop, objs);
            comp.setPriority(priority instanceof List ? (List)priority : null);
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, PriorityChooser<Floor> comp) {
            List floorPriority = comp.getPriority();
            if (floorPriority == null) {
                return;
            }
            int defaultIndex = 0;
            for (int m = 0; m < floorPriority.size() - 1; ++m) {
                Floor f1 = floorPriority.get(m);
                Floor f2 = (Floor)floorPriority.get(m + 1);
                if (f1.getWorkingZ().compareTo(f2.getWorkingZ()) >= 0) continue;
                defaultIndex = m + 1;
            }
            if (defaultIndex == 0) {
                floorPriority = Collections.EMPTY_LIST;
            } else if (defaultIndex < floorPriority.size() - 1) {
                floorPriority = floorPriority.subList(0, defaultIndex);
            }
            this.setProp(prop, objs, floorPriority);
            this.initFromProp(prop, objs, comp);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            List floorPriority = (List)val;
            VentusData md = VentusApp.getApp().getData();
            Undo.begin(Intl.intl("Edit Floor Priority"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            Composite.setProperty(prop, floorPriority, objs);
            Undo.end(md);
        }
    }

    private static class ElevatorFloorConn
    extends PropConnections.ComboPropConn<Floor> {
        private final boolean isDischargeConn;
        private final Component[] sameWidthComps;

        public ElevatorFloorConn(CompElementActions.IObjectProp<ICompElement, Floor> prop, guiComboBox<Floor> control, boolean isDischargeConn, Component ... sameWidthComps) {
            super(prop, control);
            this.isDischargeConn = isDischargeConn;
            this.sameWidthComps = sameWidthComps;
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<Floor> comp) {
            IdentityHashSet<Floor> allServableFloors = null;
            for (Elevator elevator : SelectionRibbonEditorPanel.getElevators(objs)) {
                Collection<Floor> serveFloors = elevator.getServableFloors();
                if (allServableFloors == null) {
                    allServableFloors = new IdentityHashSet<Floor>(serveFloors);
                    continue;
                }
                allServableFloors.retainAll(serveFloors);
            }
            final IdentityHashSet<Floor> availFloors = allServableFloors;
            IListenerStripper ls = guiUtil.stripListeners(comp);
            ((MerlinComboBox)comp).setFilter(new Predicate<Floor>(){

                @Override
                public boolean test(Floor o) {
                    return availFloors.contains(o);
                }
            });
            ls.restore();
            int cbWdith = comp.getPreferredSize().width;
            for (Component c : this.sameWidthComps) {
                Dimension d = c.getPreferredSize();
                c.setPreferredSize(new Dimension(cbWdith, d.height));
            }
            super.initFromProp(prop, objs, comp);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<Floor> comp) {
            if (comp.getSelectedIndex() < 0) {
                return;
            }
            if (!this.isDischargeConn) {
                super.setProp(prop, objs, comp);
                return;
            }
            VentusData md = VentusApp.getApp().getData();
            ITimingModel newTimingModel = null;
            try {
                int option = JOptionPane.showConfirmDialog(VentusApp.getApp().getActiveFrame(), Intl.intl("Would you like to re-calculate the floor pickup/discharge times?"), Intl.intl("Re-calculate Floor Timing?"), 1);
                if (option == 0) {
                    guiDialog timingDlg = new guiDialog((Window)VentusApp.getApp().getActiveFrame(), Intl.intl("Elevator Timing"), 9);
                    NewElevatorDlg.TimingPnl timingPnl = new NewElevatorDlg.TimingPnl();
                    timingDlg.getDialogPane().add(timingPnl);
                    timingPnl.load(CreateElevator.getLastTimingModel());
                    if (timingDlg.doModal() != 1) {
                        throw new CancellationException();
                    }
                    newTimingModel = timingPnl.save();
                } else if (option != 1) {
                    throw new CancellationException();
                }
            }
            catch (CancellationException e) {
                this.initFromProp(prop, objs, comp);
                return;
            }
            Undo.begin(Intl.intl("Set Discharge Floor"));
            ((CompElementActions.IObjectProp)prop).set(md, objs, comp.getSelectedItem());
            if (newTimingModel != null) {
                for (Elevator elevator : SelectionEditorPanel.filter(objs, Elevator.class)) {
                    CreateElevator.distributeFloorTimes(md, elevator, newTimingModel);
                }
            }
            this.initFromProp(prop, objs, comp);
            Undo.end(md);
        }
    }

    private static class ElevatorPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 2178416092442683841L;

        private ElevatorPnl() {
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            super.bind(SelectionRibbonEditorPanel.getElevators(objs));
        }
    }

    private static class SchematicNodeComboModel
    extends NodeComboModel<GeomComposite> {
        private static final long serialVersionUID = -5915100069213541260L;
        private static final String NEW_GROUP_ITEM = Intl.intl("<Add New...>");
        private final VentusData d_data;
        private final ListDataListener d_listener;

        public SchematicNodeComboModel(VentusData md) {
            super(md, GeomComposite.class, new RootFinder());
            this.d_data = md;
            this.d_listener = new ListDataListener(this){

                @Override
                public void contentsChanged(final ListDataEvent e) {
                    AMerlinOp op = new AMerlinOp(this){

                        @Override
                        public void run(VentusApp app, VentusData md) {
                            try (VentusData.WriteLock lock = md.lockWrite();){
                                Undo.begin(Intl.intl("Change Working Group"));
                                NodeComboModel model = (NodeComboModel)e.getSource();
                                SetWorkingGroup.setWorkingGroup(md, md.activeFloor(), (GeomComposite)model.getSelectedNode());
                                Undo.end(md);
                            }
                        }
                    };
                    UIHook.run(UIHook.getComponent(e), "SelectionEditorPane.SchematicNodeComboModel.ListDataListener.contentsChanged", op, 20);
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }
            };
            md.getEvents().addObserver(this);
        }

        @Override
        protected Collection<?> getObjects() {
            Collection<?> superObjs = super.getObjects();
            ArrayList<Object> objs = new ArrayList<Object>(superObjs.size() + 2);
            objs.add(NEW_GROUP_ITEM);
            objs.add(new JSeparator(0));
            objs.addAll(superObjs);
            return objs;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject == NEW_GROUP_ITEM) {
                AMerlinOp op = new AMerlinOp(this){

                    @Override
                    public void run(VentusApp app, VentusData md) {
                        Floor activeFloor = md.floors.getActive();
                        NewGroup.addNewGroup(VentusApp.getApp(), md, Arrays.asList(activeFloor), activeFloor);
                    }
                };
                UIHook.run(null, "SelectionEditorPanel.SchematicNodeComboModel.setSelectedItem", op, 20);
            } else {
                super.setSelectedItem(anObject);
            }
        }

        @Override
        public void update(Events events) {
            this.removeListDataListener(this.d_listener);
            super.update(events);
            boolean update = false;
            for (EventChannel<FloorComposite> eventChannel : events.getAffectedChannels(FloorComposite.class, new Class[0])) {
                if (!eventChannel.hasChangedObjs(FloorComposite.ACTIVE_FLOOR_CHANGED)) continue;
                update = true;
                break;
            }
            for (EventChannel<Composite> eventChannel : events.getAffectedChannels(Floor.class, new Class[0])) {
                if (!eventChannel.hasChangedObjs(Floor.WORKING_GROUP_CHANGED)) continue;
                update = true;
                break;
            }
            if (update) {
                this.setSelectedNode(this.d_data.activeFloor().getWorkingGeomGroup());
            }
            this.addListDataListener(this.d_listener);
        }

        private static class RootFinder
        implements NodeComboModel.RootFinder<GeomComposite> {
            private RootFinder() {
            }

            @Override
            public Collection<? extends GeomComposite<?>> getRoots(VentusData md) {
                return Arrays.asList(md.activeFloor());
            }

            @Override
            public boolean includeRoot() {
                return true;
            }

            @Override
            public Predicate<? super GeomComposite> getFilter(VentusData md) {
                return Predicates.alwaysTrue();
            }
        }
    }

    private static class CorridorDoorPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 2279557250990357514L;
        private final Object d_doorProp;
        private List<ICompElement> d_boundDoors;

        public CorridorDoorPnl(Object doorProp) {
            this.d_doorProp = doorProp;
            MerlinUDF fldTopWid = new MerlinUDF(4);
            fldTopWid.aliasValue(SchematicCorridor.DOOR_STAIR_WIDTH, Intl.intl("STAIR_WIDTH"));
            PropConnections.UDPropConnection connTopWid = new PropConnections.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(SchematicCorridor.DoorInfo.WIDTH), fldTopWid);
            this.addConnection(connTopWid);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Width:"), fldTopWid, 0, 1.0);
            SelectionRibbonEditorPanel.addCorridorDoorState(this, gb);
            gb.finalizeRows();
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_boundDoors = new ArrayList<ICompElement>();
            for (SchematicCorridor corr : theUtil.filter(objs, SchematicCorridor.class)) {
                corr = (SchematicCorridor)corr.clone();
                SchematicCorridor.DoorInfo di = this.d_doorProp == SchematicCorridor.TOP_DOOR ? corr.getTopDoor() : corr.getBottomDoor();
                this.d_boundDoors.add(di);
            }
            super.bind(this.d_boundDoors);
        }

        public void save(VentusData md, Collection<ICompElement> objs) {
            if (this.d_boundDoors == null) {
                return;
            }
            IFilteredCollection<SchematicCorridor> corridors = theUtil.filter(objs, SchematicCorridor.class);
            Undo.insertUndoEntry_propRestore(md, corridors, this.d_doorProp);
            assert (corridors.size() == this.d_boundDoors.size());
            int ix = 0;
            for (SchematicCorridor corr : corridors) {
                corr.setProperty(this.d_doorProp, this.d_boundDoors.get(ix++));
            }
        }

        @Override
        public void release() {
            super.release();
            this.d_boundDoors = null;
        }
    }

    private static class DoorWidthProp
    extends CompElementActions.DefProp<ICompElement, Double> {
        public DoorWidthProp(Object prop) {
            super(prop);
        }

        @Override
        protected void saveState(VentusData md, Object prop, Collection<? extends ICompElement> objs, Double newVal) {
            List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(prop, objs);
            Undo.insertUndoEntry_restore(md, theUtil.filter(modObjs, IRestorable.class));
        }
    }
}

