/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinUDF;
import ventus.manip.RotateManip;
import ventus.mv.gui.ATransformPanel;
import ventus.mv.gui.LocationPanel;
import ventus.mv.gui.VectorPanel;

public class RotatePanel
extends ATransformPanel<RotateManip> {
    private static final long serialVersionUID = -7001468233547839179L;
    private final BasePanel d_locPanel = new BasePanel();
    private final AxisPnl d_axisPanel = new AxisPnl();
    private final AnglePanel d_anglePanel = new AnglePanel();

    public RotatePanel(VentusData data) {
        super(data, Integer.MAX_VALUE);
        this.addSeparator();
        this.addSection(this.d_locPanel);
        this.addSeparator();
        this.addSection(this.d_axisPanel);
        this.addSeparator();
        this.addSection(this.d_anglePanel);
        this.addCompletionPanel();
    }

    @Override
    protected String getXformName() {
        return Intl.intl("Rotate");
    }

    private static class BasePanel
    extends LocationPanel<RotateManip> {
        private static final long serialVersionUID = -2727682185410657540L;

        public BasePanel() {
            super(Intl.intl("Rotate Base X"), Intl.intl("Rotate Base Y"), Intl.intl("Rotate Base Z"), RotateManip.CANCELLED, RotateManip.OBJS_TRANSFORMED, RotateManip.TRANSFORM_CHANGED);
        }

        @Override
        protected void updateToProps(RotateManip props) {
            props.setBase(this.getValue());
        }

        @Override
        protected void updateFromProps(RotateManip props) {
            this.setValue(props.getBase());
        }
    }

    private static class AxisPnl
    extends VectorPanel<RotateManip> {
        private static final long serialVersionUID = -1221575794825770050L;

        public AxisPnl() {
            super(Intl.intl("Rotate Axis X"), Intl.intl("Rotate Axis Y"), Intl.intl("Rotate Axis Z"), RotateManip.CANCELLED, RotateManip.OBJS_TRANSFORMED, RotateManip.TRANSFORM_CHANGED);
        }

        @Override
        protected void updateToProps(RotateManip props) {
            props.setRotateAxis(this.getValue());
        }

        @Override
        protected void updateFromProps(RotateManip props) {
            this.setValue(props.getAxis());
        }
    }

    private static class AnglePanel
    extends APropEditPanel<RotateManip> {
        private static final long serialVersionUID = -8536934343446714244L;
        private final MerlinUDF d_angleFld = this.initValueField(new MerlinUDF(5), new IPropEditCommand[0]);

        public AnglePanel() {
            super(RotateManip.CANCELLED, RotateManip.OBJS_TRANSFORMED, RotateManip.TRANSFORM_CHANGED);
            GridBagUtil.add(this, new guiLabel(Intl.intl("Angle:")), 0, 0, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_angleFld, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        }

        @Override
        protected void updateToProps(RotateManip props) {
            props.setAngle((UnitDouble)this.d_angleFld.getValue());
        }

        @Override
        protected void updateFromProps(RotateManip props) {
            UnitDouble angle = props.getAngle();
            this.d_angleFld.setValue(angle);
        }
    }
}

