/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextArea;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.RenameAction;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.actions.Visibility;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.INamed;
import ventus.data.ImportedGeom;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.data.schematics.elevators.Elevator;
import ventus.data.value.IFunction1d;
import ventus.data.value.IVariant;
import ventus.data.value.Schedule;
import ventus.geom.GeomUtil;
import ventus.gui.MaterialBtn;
import ventus.gui.MerlinComboBox;
import ventus.gui.guiUtil;
import ventus.gui.value.IVariantEditor;
import ventus.gui.value.ScheduleField;
import ventus.mv.gui.SelectionEditorPanel;
import ventus.unitsystem.UnitSystem;
import ventus.util.MerlinUtil;

public class PropConnections {
    public static <ObjT extends ICompElement, PropT> void setPropRecursive(String actionName, CompElementActions.IObjectProp<ObjT, PropT> prop, Collection<? extends ObjT> objs, PropT newVal) {
        Undo.begin(actionName);
        VentusData md = VentusApp.getApp().getData();
        prop.set(md, objs, newVal);
        Undo.end(VentusApp.getApp().getData());
    }

    public static <ObjT extends ICompElement, PropT> void setPropRecursive(String actionName, Object prop, Collection<? extends ObjT> objs, PropT newVal) {
        PropConnections.setPropRecursive(actionName, (CompElementActions.IObjectProp)prop, objs, newVal);
    }

    private static <T> Collection<T> filter(Collection<?> objs, Class<T> clazz) {
        return theUtil.filter(objs, clazz);
    }

    private static Set<Elevator> getElevators(Collection<? extends ICompElement> objs) {
        LinkedIdentityHashSet<Elevator> elevators = new LinkedIdentityHashSet<Elevator>();
        for (ICompElement iCompElement : objs) {
            if (iCompElement instanceof Elevator) {
                elevators.add((Elevator)iCompElement);
                continue;
            }
            if (!(iCompElement instanceof Composite)) continue;
            elevators.addAll(((Composite)iCompElement).getDeepMembers(Elevator.class));
        }
        return elevators;
    }

    public static class ColorConn
    extends ASinglePropConnection<ColorButton>
    implements Observer {
        public ColorConn(ColorButton cb) {
            this(cb, VentusData.COLOR);
        }

        public ColorConn(ColorButton cb, Object prop) {
            super(new CompElementActions.DefProp(prop), cb);
            cb.addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, ColorButton comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(VentusApp.getApp().getData(), objs);
            if (val == null) {
                comp.setColor(Color.WHITE);
            } else if (val instanceof Color) {
                comp.setColor((Color)val);
            } else {
                comp.setColor(null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, ColorButton comp) {
            Color color = comp.getColor();
            if (color != null) {
                PropConnections.setPropRecursive(Intl.intl("Set Color"), (CompElementActions.IObjectProp)prop, objs, color);
            }
        }
    }

    public static class ScheduleProp
    extends ASinglePropConnection<ScheduleField> {
        private final ScheduleField d_varEditor;
        private boolean d_modified;

        public ScheduleProp(CompElementActions.IObjectProp<ICompElement, Schedule> prop, ScheduleField varEditor) {
            super(prop, varEditor);
            this.d_varEditor = varEditor;
            this.d_modified = false;
            varEditor.addPropertyChangeListener("value", e -> {
                this.d_modified = true;
                this.onControlChanged();
                this.initFromProp();
            });
        }

        @Override
        protected boolean isModified(ScheduleField comp) {
            return this.d_modified;
        }

        @Override
        protected void setModified(ScheduleField comp, boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, ScheduleField comp) {
            SelectionEditorPanel.setPropRecursive(String.format(Intl.intl("Edit %s"), this.d_varEditor.getPropName()), (CompElementActions.IObjectProp)prop, objs, this.d_varEditor.getValue());
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, ScheduleField comp) {
            Schedule schedule;
            Object value = ((CompElementActions.IObjectProp)prop).get(VentusApp.getAppData(), objs);
            Schedule d_currVal = value instanceof Schedule ? (schedule = (Schedule)value) : null;
            this.d_varEditor.setValue(d_currVal);
            this.setModified(comp, false);
        }
    }

    public static class VariantProp<ValType>
    extends ASinglePropConnection<HTMLBtn> {
        private final String d_propDesc;
        private final IVariantEditor<ValType> d_varEditor;
        private IVariant<ValType> d_currVal;
        private boolean d_modified;

        public VariantProp(String propDesc, CompElementActions.IObjectProp<ICompElement, IVariant<ValType>> prop, HTMLBtn btn, IVariantEditor<ValType> varEditor) {
            super(prop, btn);
            this.d_varEditor = varEditor;
            this.d_propDesc = propDesc;
            this.d_modified = false;
            btn.addActionListener(e -> this.edit(prop));
        }

        private void edit(Object prop) {
            IVariant<ValType> newVal;
            guiPanel editorPnl = this.d_varEditor.getEditorPanel(UnitSystem.getType(1, true));
            this.d_varEditor.load(editorPnl, this.d_currVal);
            JFrame parent = Application.getApp() != null ? Application.getApp().getActiveFrame() : null;
            String title = String.format(Intl.intl("Edit %s"), this.d_propDesc);
            guiDialog dlg = new guiDialog((Window)parent, title, 9);
            guiPanel c = dlg.getDialogPane();
            c.setLayout(new BorderLayout());
            c.add((Component)editorPnl, "Center");
            if (dlg.doModal() == 1 && dlg.isModified() && (newVal = this.d_varEditor.save(editorPnl)) != null && !Objects.equals(this.d_currVal, newVal)) {
                this.d_modified = true;
                this.d_currVal = newVal;
                this.onControlChanged();
                this.initFromProp();
            }
        }

        @Override
        protected boolean isModified(HTMLBtn comp) {
            return this.d_modified;
        }

        @Override
        protected void setModified(HTMLBtn comp, boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, HTMLBtn comp) {
            SelectionEditorPanel.setPropRecursive(String.format(Intl.intl("Edit %s"), this.d_propDesc), (CompElementActions.IObjectProp)prop, objs, this.d_currVal);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, HTMLBtn comp) {
            Object value = ((CompElementActions.IObjectProp)prop).get(VentusApp.getApp().getData(), objs);
            IVariant iVariant = this.d_currVal = value instanceof IVariant ? (IVariant)value : (IVariant)null;
            if (this.d_currVal != null) {
                comp.setText(this.d_varEditor.describe(this.d_currVal));
            } else {
                comp.setText("&lt;" + Intl.intl("varies") + "&gt;");
            }
            this.setModified(comp, false);
        }
    }

    public static class ValEditorConn<T, CompT extends JComponent>
    extends ASinglePropConnection<JComponent>
    implements Observer {
        private final IValEditor<T> d_editor;

        public ValEditorConn(CompElementActions.IObjectProp<ICompElement, IFunction1d> prop, IValEditor<T> editor) {
            super(prop, editor.getComponent());
            this.d_editor = editor;
            VentusApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            Object obj = ((CompElementActions.IObjectProp)prop).get(VentusApp.getApp().getData(), objs);
            Class<T> type = this.d_editor.getType();
            this.d_editor.setValue(type.isInstance(obj) ? (Object)type.cast(obj) : null);
            if (comp instanceof Modifiable) {
                ((Modifiable)((Object)comp)).setModified(false);
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            if (val != null) {
                SelectionEditorPanel.setPropRecursive(Intl.intl("Edit Property"), (CompElementActions.IObjectProp)prop, objs, val);
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            this.setProp(prop, objs, (Object)this.d_editor.getValue());
        }
    }

    public static class BoolPropConnection
    extends ASinglePropConnection<guiMultiStateCheckBox> {
        public BoolPropConnection(CompElementActions.IObjectProp<ICompElement, Boolean> prop, guiMultiStateCheckBox control) {
            super(prop, control);
            control.addItemListener(this);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiMultiStateCheckBox comp) {
            if (comp.getState() != 2) {
                Boolean newval = comp.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                this.apply((CompElementActions.IObjectProp)prop, objs, newval);
            }
        }

        public void apply(CompElementActions.IObjectProp<ICompElement, Boolean> prop, Collection<? extends ICompElement> objs, Boolean val) {
            PropConnections.setPropRecursive(Intl.intl("Set Property"), prop, objs, val);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiMultiStateCheckBox comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(VentusApp.getApp().getData(), objs);
            if (val instanceof Boolean) {
                comp.setMode(0);
                Boolean b = (Boolean)val;
                comp.setSelected(b);
            } else {
                comp.setMode(1);
                comp.setState(2);
                ItemEvent evt = new ItemEvent(comp.getModel(), 2000, comp.getModel(), 2);
                for (ItemListener il : comp.getItemListeners()) {
                    il.itemStateChanged(evt);
                }
            }
            comp.setModified(false);
        }
    }

    public static class VisPropConnection
    extends BoolPropConnection {
        public VisPropConnection(guiMultiStateCheckBox control) {
            super((CompElementActions.IObjectProp<ICompElement, Boolean>)new CompElementActions.DefProp<ICompElement, Boolean>(VentusData.VISIBILITY){

                @Override
                public void set(VentusData md, Collection<? extends ICompElement> objs, Boolean newVal) {
                    Collection<Object> toShow = Collections.EMPTY_LIST;
                    Collection<Object> toHide = Collections.EMPTY_LIST;
                    if (newVal.booleanValue()) {
                        toShow = objs;
                    } else {
                        toHide = objs;
                    }
                    Visibility.setVisibility(VentusApp.getApp().getData(), toShow, toHide, true);
                }
            }, control);
        }
    }

    public static class MaterialConn
    extends ASinglePropConnection<MaterialBtn>
    implements IObserver {
        public MaterialConn(MaterialBtn btn) {
            super(new MaterialProp(), btn);
            btn.addObserver(this, true);
        }

        @Override
        public void update(IObservable source, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, MaterialBtn comp) {
            Material mat = (Material)comp.getMaterial();
            PropConnections.setPropRecursive(Intl.intl("Set Material"), (CompElementActions.IObjectProp)prop, objs, mat);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, MaterialBtn comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(VentusApp.getApp().getData(), objs);
            if (val instanceof Material || val == null) {
                comp.setMaterial((Material)val);
            } else {
                comp.setMultiple();
            }
            comp.setModified(false);
        }
    }

    private static class MaterialProp
    extends CompElementActions.DefProp<ICompElement, IMaterial> {
        public MaterialProp() {
            super(VentusData.MATERIAL);
        }

        @Override
        public Object get(VentusData md, Collection<? extends ICompElement> objs) {
            return super.get(md, CompElementActions.flattenToLocallyDefined(this.getProp(), objs));
        }

        private IMaterial[] getMats(VentusData md, Object prop, ICompElement obj) {
            IMaterial[] mats = (IMaterial[])obj.getProperty(prop);
            if (mats.length > 1 && MerlinUtil.isUniform(mats)) {
                mats = new IMaterial[]{mats[0]};
            }
            return mats;
        }

        @Override
        protected Object get(VentusData md, Object prop, ICompElement obj) {
            IMaterial[] mats = this.getMats(md, prop, obj);
            if (mats.length == 0) {
                return null;
            }
            if (mats.length == 1) {
                return mats[0];
            }
            return ICompElement.NON_UNIFORM;
        }

        @Override
        public void set(VentusData md, Collection<? extends ICompElement> objs, IMaterial newVal) {
            super.set(md, CompElementActions.flattenToLocallyDefined(this.getProp(), objs), newVal);
        }

        @Override
        protected void set(VentusData md, Object prop, ICompElement obj, IMaterial newVal) {
            IMaterial[] oldMats = this.getMats(md, prop, obj);
            if (oldMats.length == 1 && oldMats[0] == newVal) {
                return;
            }
            if (obj.getPropTypes(1).contains(ImportedGeom.PROP_GEOM)) {
                IGeomNode newGeom = (IGeomNode)obj.getProperty(ImportedGeom.PROP_GEOM);
                newGeom = GeomUtil.finalizeTexCoords(newGeom, MaterialProp.needsTexCoords(newVal));
                obj.setProperty(ImportedGeom.PROP_GEOM, newGeom);
            }
            obj.setProperty(prop, new IMaterial[]{newVal});
        }

        private static boolean needsTexCoords(IMaterial mat) {
            if (mat == null) {
                return false;
            }
            return mat.getAttributes().hasTexture();
        }

        @Override
        protected void saveState(VentusData md, Object prop, Collection<? extends ICompElement> objs, IMaterial newVal) {
            Undo.insertUndoEntry_propRestore(md, objs, VentusData.MATERIAL);
            if (Composite.getPropTypes(0, objs).contains(ImportedGeom.PROP_GEOM)) {
                Undo.insertUndoEntry_propRestore(md, objs, ImportedGeom.PROP_GEOM);
            }
        }
    }

    public static class IntPropConn
    extends NumberPropConn<Integer> {
        public IntPropConn(CompElementActions.IObjectProp<ICompElement, Integer> prop, guiIntField control) {
            super(prop, control, Integer.class);
        }
    }

    public static class DoublePropConn
    extends NumberPropConn<Double> {
        public DoublePropConn(CompElementActions.IObjectProp<ICompElement, Double> prop, guiDoubleField control) {
            super(prop, control, Double.class);
        }
    }

    public static class UDPropConnection
    extends NumberPropConn<UnitDouble> {
        public UDPropConnection(CompElementActions.IObjectProp<ICompElement, UnitDouble> prop, guiUnitDoubleField control) {
            super(prop, control, UnitDouble.class);
        }
    }

    public static class DToUDProp<ObjT>
    implements CompElementActions.IObjectProp<ObjT, UnitDouble> {
        private final Unit d_storageUnit;
        private final CompElementActions.IObjectProp<ObjT, Double> d_dProp;

        public DToUDProp(Unit storageUnit, CompElementActions.IObjectProp<ObjT, Double> dProp) {
            this.d_storageUnit = storageUnit;
            this.d_dProp = dProp;
        }

        @Override
        public Object get(VentusData md, Collection<? extends ObjT> objs) {
            Object v = this.d_dProp.get(md, objs);
            return v instanceof Double ? new UnitDouble((Double)v, this.d_storageUnit) : v;
        }

        @Override
        public void set(VentusData md, Collection<? extends ObjT> objs, UnitDouble newVal) {
            this.d_dProp.set(md, objs, newVal.getValue(this.d_storageUnit));
        }
    }

    public static class NumberPropConn<NT>
    extends ASinglePropConnection<guiValueField<NT>> {
        private final Class<NT> d_type;

        public NumberPropConn(CompElementActions.IObjectProp<ICompElement, NT> prop, guiValueField<NT> control, Class<NT> type) {
            super(prop, control);
            this.d_type = type;
            control.setEmptyAllowed(true);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiValueField<NT> comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(VentusApp.getApp().getData(), objs);
            this.initFromVal(val, comp);
        }

        public void initFromVal(Object val, guiValueField<NT> comp) {
            if (this.d_type.isInstance(val)) {
                comp.setValue(this.d_type.cast(val));
            } else {
                comp.setValue(null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiValueField<NT> comp) {
            if (comp.validateData(false, true)) {
                if (comp.getValue() != null) {
                    this.apply((CompElementActions.IObjectProp)prop, objs, comp.getValue());
                    this.initFromProp(prop, objs, comp);
                }
            } else {
                comp.setValue(comp.getValue());
            }
            comp.selectAll();
        }

        protected void apply(CompElementActions.IObjectProp<ICompElement, NT> prop, Collection<? extends ICompElement> objs, NT val) {
            PropConnections.setPropRecursive(Intl.intl("Set Property"), prop, objs, val);
        }
    }

    public static class ComboPropConn<T>
    extends ASinglePropConnection<guiComboBox<T>> {
        private final String d_actionName;

        public ComboPropConn(CompElementActions.IObjectProp<ICompElement, T> prop, guiComboBox<T> control) {
            this(Intl.intl("Set Property"), prop, control);
        }

        public ComboPropConn(String actionName, CompElementActions.IObjectProp<ICompElement, T> prop, guiComboBox<T> control) {
            super(prop, control);
            this.d_actionName = actionName;
            control.addItemListener(this);
            if (control instanceof MerlinComboBox) {
                this.setUpdateLock(((MerlinComboBox)control).getUpdateLock());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.isLocked()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.onControlChanged();
                    }
                });
            }
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<T> comp) {
            IListenerStripper ls = guiUtil.stripListeners(comp);
            Object val = ((CompElementActions.IObjectProp)prop).get(VentusApp.getApp().getData(), objs);
            if (val == ICompElement.NON_UNIFORM || val == ICompElement.NOT_SUPPORTED) {
                comp.setSelectedItem(null);
            } else {
                comp.setSelectedItem(val);
            }
            comp.setModified(false);
            ls.restore();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<T> comp) {
            if (!comp.isEditable() && comp.getSelectedIndex() < 0) {
                return;
            }
            PropConnections.setPropRecursive(this.d_actionName, (CompElementActions.IObjectProp)prop, objs, comp.getSelectedItem());
            this.initFromProp(prop, objs, comp);
        }
    }

    public static class SelectNamedPropConnection
    extends ASinglePropConnection<HTMLBtn> {
        public SelectNamedPropConnection(Object prop, HTMLBtn control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, HTMLBtn comp) {
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, HTMLBtn comp) {
            Object val = Composite.getProperty(prop, objs);
            comp.setText("");
            comp.setVisible(false);
            if (val instanceof INamed) {
                INamed named = (INamed)val;
                comp.setText(named.getName());
                comp.setVisible(true);
                comp.addActionListener(new SelectNamedAction(named));
            }
        }

        private static class SelectNamedAction
        extends AMerlinOp
        implements ActionListener {
            private static INamed d_named;

            public SelectNamedAction(INamed named) {
                d_named = named;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                UIHook.run(UIHook.getComponent(e), "SelectNamedAction", this, 0);
            }

            @Override
            public void run(VentusApp app, VentusData md) {
                try (VentusData.WriteLock lock = md.lockWrite();){
                    Undo.begin(Intl.intl("Select Object"));
                    Undo.insertUndoEntry_restoreSelection(md);
                    md.selection.set(d_named);
                    Undo.end(md);
                }
            }
        }
    }

    public static class NamePropConnection
    extends TextPropConnection {
        public NamePropConnection(guiTextField control) {
            super((Object)NamedMerlinObj.NAME, control);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object newText) {
            boolean updateAll = RenameAction.rename(VentusApp.getApp().getData(), null, objs, (String)newText);
            if (!updateAll) {
                this.initFromProp(prop, objs, (guiTextField)this.getControl());
            }
        }
    }

    public static class TextPropConnection
    extends ASinglePropConnection<guiTextField> {
        public TextPropConnection(Object prop, guiTextField control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiTextField comp) {
            Object val = Composite.getProperty(prop, objs);
            if (val instanceof String) {
                String s = (String)val;
                comp.setValue(s);
                comp.setCaretPosition(0);
            } else {
                comp.setText("");
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiTextField comp) {
            if (!comp.getText().isEmpty() && comp.isModified() && comp.validateData(false, true)) {
                VentusData md = VentusApp.getApp().getData();
                assert (md != null);
                this.setProp(prop, objs, comp.getValue());
                comp.setModified(false);
            }
            comp.selectAll();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object newText) {
            VentusData md = VentusApp.getApp().getData();
            Undo.begin(Intl.intl("Set Property"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            Composite.setProperty(prop, newText, objs);
            Undo.end(md);
        }
    }

    public static class StringPropConnection
    extends ASinglePropConnection<guiTextArea> {
        public StringPropConnection(Object prop, guiTextArea control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiTextArea comp) {
            Object val = Composite.getProperty(prop, objs);
            if (val instanceof String) {
                String s = (String)val;
                comp.setValue(s);
                comp.setCaretPosition(0);
            } else {
                comp.setText("");
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiTextArea comp) {
            if (!comp.getText().isEmpty() && comp.isModified() && comp.validateData(false, true)) {
                VentusData md = VentusApp.getApp().getData();
                assert (md != null);
                this.setProp(prop, objs, comp.getValue());
                comp.setModified(false);
            }
            comp.selectAll();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object newText) {
            VentusData md = VentusApp.getApp().getData();
            Undo.begin(Intl.intl("Set Property"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            Composite.setProperty(prop, newText, objs);
            Undo.end(md);
        }
    }

    public static abstract class AMultiPropConnection<T extends JComponent>
    extends APropConnection<T> {
        private final Collection<Object> d_props;

        public AMultiPropConnection(Collection<Object> props, T control) {
            super(control);
            this.d_props = props;
        }

        @Override
        public void commit() {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (this.isDataEmpty() || !this.isModified(this.d_control)) {
                    return;
                }
                VentusData md = VentusApp.getApp().getData();
                md.pauseUpdates();
                this.setProps(this.d_props, this.d_data, this.d_control);
                md.resumeUpdates();
                this.setModified(this.d_control, false);
            }
            finally {
                this.d_lock.release();
            }
        }

        @Override
        protected void initFromProp() {
            this.initFromProp(this.d_props, this.d_data, this.d_control);
        }

        public abstract void setProps(Collection<Object> var1, Collection<? extends ICompElement> var2, T var3);

        public abstract void initFromProp(Collection<Object> var1, Collection<? extends ICompElement> var2, T var3);
    }

    public static abstract class ASinglePropConnection<T extends JComponent>
    extends APropConnection<T> {
        private final Object d_prop;

        public ASinglePropConnection(Object prop, T control) {
            super(control);
            this.d_prop = prop;
        }

        @Override
        public void commit() {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (this.isDataEmpty() || !this.isModified(this.d_control)) {
                    return;
                }
                VentusData md = VentusApp.getApp().getData();
                md.pauseUpdates();
                this.setProp(this.d_prop, this.d_data, this.d_control);
                md.resumeUpdates();
                this.setModified(this.d_control, false);
            }
            finally {
                this.d_lock.release();
            }
        }

        @Override
        protected void initFromProp() {
            this.initFromProp(this.d_prop, this.d_data, this.d_control);
        }

        public abstract void setProp(Object var1, Collection<? extends ICompElement> var2, T var3);

        public abstract void initFromProp(Object var1, Collection<? extends ICompElement> var2, T var3);
    }

    public static abstract class APropConnection<T extends JComponent>
    extends APropEditorListener
    implements IPropConnection {
        protected T d_control;
        protected Collection<ICompElement> d_data;
        private final Action d_listenerAction;
        protected Semaphore d_lock;
        protected boolean d_live;

        protected APropConnection(T control) {
            this.d_control = control;
            this.d_live = true;
            this.d_lock = new Semaphore(1);
            this.d_listenerAction = new AbstractAction(){
                private static final long serialVersionUID = 3563125676559170424L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.onControlChanged();
                }
            };
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            ((JComponent)this.d_control).getInputMap().put(enter, "enter");
            ((JComponent)this.d_control).getActionMap().put("enter", this.d_listenerAction);
        }

        public T getControl() {
            return this.d_control;
        }

        public void setUpdateLock(Semaphore lock) {
            this.d_lock = lock;
        }

        public Semaphore getUpdateLock() {
            return this.d_lock;
        }

        protected boolean isLocked() {
            return this.d_lock.availablePermits() == 0;
        }

        public Collection<ICompElement> getObjs() {
            return this.d_data;
        }

        protected boolean isDataEmpty() {
            return this.d_data == null || this.d_data.isEmpty();
        }

        protected boolean isModified(T comp) {
            return !(this.d_control instanceof Modifiable) || ((Modifiable)this.d_control).isModified();
        }

        protected void setModified(T comp, boolean modified) {
            if (comp instanceof Modifiable) {
                ((Modifiable)comp).setModified(modified);
            }
        }

        @Override
        public void update(Events events) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (this.isDataEmpty()) {
                    return;
                }
                this.initFromProp();
            }
            finally {
                this.d_lock.release();
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
        }

        public void setLive(boolean live) {
            this.d_live = live;
        }

        public boolean isLive() {
            return this.d_live;
        }

        @Override
        public void onControlChanged() {
            if (this.d_live) {
                this.commit();
            }
        }

        @Override
        public void release() {
            this.d_data = Collections.EMPTY_LIST;
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_data = objs;
            Runnable r = () -> {
                if (!this.d_lock.tryAcquire()) {
                    return;
                }
                try {
                    if (this.isDataEmpty()) {
                        return;
                    }
                    this.initFromProp();
                }
                finally {
                    this.d_lock.release();
                }
            };
            SwingUtilities.invokeLater(r);
        }

        protected abstract void initFromProp();
    }

    public static abstract class APropEditorListener
    implements ItemListener,
    FocusListener,
    KeyListener,
    ActionListener,
    IEventObserver {
        public abstract void onControlChanged();

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.onControlChanged();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                this.onControlChanged();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.onControlChanged();
        }
    }

    public static interface IPropConnection
    extends IEventObserver {
        public void bind(Collection<ICompElement> var1);

        public void release();

        public void commit();
    }
}

