/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.util.Arrays;
import org.jscience.physics.units.NonSI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import ventus.Intl;
import ventus.builders.CorridorBuilder;
import ventus.builders.StairBuilder;
import ventus.builders.StairUtil;
import ventus.geom.Geometry;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinUDF;
import ventus.mv.gui.NewCorridorPanel;

public class NewStairPanel
extends NewCorridorPanel<StairBuilder> {
    private static final long serialVersionUID = 6455894077367713841L;

    public NewStairPanel(CorridorBuilder.Mode mode) {
        super(mode, Arrays.asList(new RiseRunPanel()), Arrays.asList(new StepTerm(), new NewCorridorPanel.RunTerm(), new NewCorridorPanel.RiseTerm(), new NewCorridorPanel.LengthTerm()));
    }

    private static class RiseRunPanel
    extends APropEditPanel<StairBuilder> {
        private static final long serialVersionUID = 2284278508270651555L;
        private final guiUnitDoubleField d_rise = this.initValueField(new MerlinUDF(7.0, NonSI.INCH), new IPropEditCommand[0]);
        private final guiUnitDoubleField d_run = this.initValueField(new MerlinUDF(11.0, NonSI.INCH), new IPropEditCommand[0]);

        public RiseRunPanel() {
            super(StairBuilder.TRISE_CHANGED, StairBuilder.TRUN_CHANGED);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Tread Rise:"), this.d_rise);
            gb.addRow(Intl.intl("Tread Run:"), this.d_run);
        }

        @Override
        protected void updateToProps(StairBuilder props) {
            props.pause();
            props.setTreadRise((UnitDouble)this.d_rise.getValue());
            props.setTreadRun((UnitDouble)this.d_run.getValue());
            props.resume();
        }

        @Override
        protected void updateFromProps(StairBuilder props) {
            this.d_rise.setValue(props.getTreadRise());
            this.d_run.setValue(props.getTreadRun());
        }
    }

    private static class StepTerm
    extends NewCorridorPanel.ATermInfo<StairUtil.StepCountTermCrit, guiDoubleField> {
        public StepTerm() {
            super(StairUtil.StepCountTermCrit.class, new guiDoubleField(17.0, DoubleVR.above(0.0, false)), Intl.intl("Step Count:"));
            ((guiDoubleField)this.getComponent()).setColumns(6);
        }

        @Override
        public void load(StairUtil.StepCountTermCrit criteria) {
            ((guiDoubleField)this.getComponent()).setValue(criteria.d_numSteps);
        }

        @Override
        public StairUtil.StepCountTermCrit save(NewCorridorPanel<?> corrPnl) {
            return new StairUtil.StepCountTermCrit((Double)((guiDoubleField)this.getComponent()).getValue(), ((StairBuilder)corrPnl.props()).getTreadRise().getValue(Geometry.LENGTH_UNIT));
        }
    }
}

