/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.gui;

import java.awt.Component;
import java.util.Observable;
import javax.swing.JButton;
import org.jscience.physics.units.NonSI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.builders.DoorBuilder;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinUDF;
import ventus.mv.gui.LocationPanel;

public class NewDoorPanel
extends APropEditPanel<DoorBuilder> {
    private static final long serialVersionUID = -7832886089168466864L;
    private final CenterPanel d_center;
    private final PropPanel d_prop = new PropPanel();
    private final CreatePanel d_create;

    public NewDoorPanel() {
        super(new Object[0]);
        this.addSection(this.d_prop);
        this.addSeparator();
        this.d_center = new CenterPanel();
        this.addSection(this.d_center);
        this.addSeparator();
        this.d_create = new CreatePanel();
        this.addSection(this.d_create);
    }

    private static class PropPanel
    extends LocationPanel<DoorBuilder> {
        private static final long serialVersionUID = -457243059364116851L;

        public PropPanel() {
            super(6, DoorBuilder.LOC_CHANGED);
        }

        @Override
        protected void updateFromProps(DoorBuilder props) {
            this.setValue(((DoorBuilder)this.props()).getP1());
        }

        @Override
        protected void updateToProps(DoorBuilder props) {
            ((DoorBuilder)this.props()).setP1(this.getValue());
        }
    }

    private static class CenterPanel
    extends APropEditPanel<DoorBuilder> {
        private static final long serialVersionUID = 3050940591206678075L;
        private final guiUnitDoubleField d_minWidth = this.initValueField(new MerlinUDF(0.0, NonSI.INCH), new IPropEditCommand[0]);
        private final guiUnitDoubleField d_maxWidth = this.initValueField(new MerlinUDF(0.0, NonSI.INCH), new IPropEditCommand[0]);
        private final guiUnitDoubleField d_maxDepth = this.initValueField(new MerlinUDF(0.0, NonSI.INCH), new IPropEditCommand[0]);

        public CenterPanel() {
            super(DoorBuilder.WIDTH_CHANGED, DoorBuilder.DEPTH_CHANGED);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Min Width:"), this.d_minWidth);
            gb.addRow(Intl.intl("Max Width:"), this.d_maxWidth);
            gb.addRow(Intl.intl("Max Depth:"), this.d_maxDepth);
        }

        @Override
        protected void updateFromProps(DoorBuilder props) {
            this.d_minWidth.setValue(((DoorBuilder)this.props()).getMinWidth());
            this.d_maxWidth.setValue(((DoorBuilder)this.props()).getMaxWidth());
            this.d_maxDepth.setValue(((DoorBuilder)this.props()).getMaxDepth());
        }

        @Override
        protected void updateToProps(DoorBuilder props) {
            ((DoorBuilder)this.props()).setMinWidth((UnitDouble)this.d_minWidth.getValue());
            ((DoorBuilder)this.props()).setMaxWidth((UnitDouble)this.d_maxWidth.getValue());
            ((DoorBuilder)this.props()).setMaxDepth((UnitDouble)this.d_maxDepth.getValue());
        }
    }

    private static class CreatePanel
    extends APropEditPanel<DoorBuilder> {
        private static final long serialVersionUID = 4952220825964613489L;
        private final JButton d_createBtn = this.initButton(new JButton(Intl.intl("Create Door")), new IPropEditCommand(){

            @Override
            public void updateProp(Component c, boolean hardValidate) {
                if (!this.validateData(hardValidate, hardValidate)) {
                    return;
                }
                ((DoorBuilder)this.props()).addDoor(c);
            }
        });

        public CreatePanel() {
            super(new Object[0]);
            this.add(this.d_createBtn);
        }

        protected void propsChanged(DoorBuilder newProps) {
            this.d_createBtn.setEnabled(newProps.isValidDoor());
        }

        @Override
        public void update(Observable o, Object arg) {
            this.d_createBtn.setEnabled(((DoorBuilder)this.props()).isValidDoor());
        }
    }
}

