/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.awt.Color;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Observable;
import javax.vecmath.Point2d;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import ventus.builders.PlanarGeomBuilder;
import ventus.data.ImportedGeom;
import ventus.geom.Geometry;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.APropsDisplay;
import ventus.mv.displays.IMerlinDisplay;
import ventus.mv.displays.RoomToolEdgeDisplay;

public class PlanarGeomBuilderDisplay
extends APropsDisplay<PlanarGeomBuilder> {
    private final RoomToolEdgeDisplay d_edgeDisplay = new RoomToolEdgeDisplay(super.getDisplay());
    private PlanarGeomBuilder d_props;

    public PlanarGeomBuilderDisplay(ModelView mv) {
        super(mv);
    }

    @Override
    protected Object[] getInterestingChanges() {
        return new Object[0];
    }

    @Override
    protected IMerlinGeomSrc constructGeom(PlanarGeomBuilder builder) {
        Shape outline = builder.getShape();
        if (outline == null) {
            return null;
        }
        ShapeGeom geom = new ShapeGeom(outline, this.getPlane(builder));
        IPrimProps.Edge props = new IPrimProps.Edge(this.getColor(), 3.0, IPrimProps.DEF_STIPPLE, 0);
        return new ImportedGeom("", new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), (IPrimProps)props));
    }

    protected Shape getOutline(PlanarGeomBuilder builder) {
        return builder.getShape();
    }

    protected Plane3d getPlane(PlanarGeomBuilder builder) {
        double z = builder.getZLoc().getValue(Geometry.LENGTH_UNIT);
        return new Plane3d(0.0, 0.0, 1.0, -z);
    }

    protected Color getColor() {
        return Color.GREEN;
    }

    @Override
    public IMerlinDisplay getDisplay() {
        return this.d_edgeDisplay;
    }

    @Override
    public void update(Observable o, Object arg) {
        super.update(o, arg);
        ArrayList<Point2d> points = new ArrayList<Point2d>();
        this.d_props.updatePoints(points);
        UnitDouble zLoc = this.d_props.getZLoc();
        Unit u = zLoc.getUnit();
        this.d_edgeDisplay.updatePoints(points, u, zLoc.getRawValue());
        this.d_edgeDisplay.update();
    }

    @Override
    public void setProps(PlanarGeomBuilder props) {
        this.d_props = props;
        this.d_edgeDisplay.setProps(props);
        super.setProps(props);
    }
}

