/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import thunderheadeng.geometry.AABox;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.scene3d.nativebuffered.CachedRenderOptions;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.ClearableBackground;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.OverlayLayout;
import thunderheadeng.scene3d.nativebuffered.SceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.SceneRenderOptionsCopier;
import thunderheadeng.scene3d.nativebuffered.SceneRenderer;
import thunderheadeng.scene3d.transformpreview.CompositeTransformPreview;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.data.ImportedGeom;
import ventus.data.VentusData;
import ventus.data.camera.ICameraObj;
import ventus.data.schematics.elevators.Elevator;
import ventus.data.schematics.elevators.IElevatorComp;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.feature.comps.ISceneItem;
import ventus.mv.ModelView;
import ventus.mv.displays.FloorDispMgr;
import ventus.mv.displays.GeomDispMgr;
import ventus.mv.displays.IMerlinDispMgr;
import ventus.mv.displays.ImageDispMgr;
import ventus.mv.displays.scenefinders.DefSceneProvider;
import ventus.mv.displays.scenefinders.ISceneProvider;

public class GlobalDisplayMgr
implements IMerlinDispMgr<Object> {
    private static final float Z_RESOLVE_DIST = 1.0f;
    private static final IScenePropsProvider MAIN_PROPS = GlobalDisplayMgr.overrideProps(ISceneRenderOptions.SOLID_POLYGON_OFFSET, new float[]{2.0f, 2.0f}, ISceneRenderOptions.DRAW_OUTLINES, false, ISceneRenderOptions.DRAW_SELECTED_FACES_OUTLINE, false);
    private static final IScenePropsProvider BG_PROPS = (mainCamera, props, scene) -> {
        SceneRenderOptions bgprops;
        if (mainCamera instanceof OrthoCamera) {
            bgprops = new SceneRenderOptions();
            bgprops.setLightModel(ISceneRenderOptions.LightModel.DISABLED);
        } else {
            bgprops = props.clone();
        }
        bgprops.setDrawWireframe(false);
        bgprops.setDrawOutlines(false);
        bgprops.set(ISceneRenderOptions.SOLID_POLYGON_OFFSET, new float[]{3.0f, 3.0f});
        return bgprops;
    };
    private static final IScenePropsProvider IMPORT_PROPS = GlobalDisplayMgr.overrideProps(ISceneRenderOptions.SOLID_POLYGON_OFFSET, new float[]{3.0f, 3.0f}, new Object[0]);
    private static final IScenePropsProvider SELF_PROPS = (cam, props, scene) -> scene.getDrawProps();
    public final SceneInfo mainScene = new SceneInfo(MAIN_PROPS, SO.NO_CLIP);
    public final SceneInfo bgimageScene = new SceneInfo(BG_PROPS, new SO[0]);
    public final SceneInfo gridScene = new SceneInfo(SELF_PROPS, SO.NO_CLIP, SO.EXCLUDE_BOUNDS_ALWAYS);
    public final SceneInfo originScene = new SceneInfo(SELF_PROPS, SO.NO_CLIP, SO.EXCLUDE_BOUNDS_ALWAYS);
    public final SceneInfo importedGeomScene = new SceneInfo(IMPORT_PROPS, new SO[0]);
    public final SceneInfo elevatorScene = new SceneInfo(MAIN_PROPS, new SO[0]);
    public final SceneInfo handleScene = new SceneInfo(SELF_PROPS, SO.NO_CLIP, SO.EXCLUDE_BOUNDS_ALWAYS);
    public final SceneInfo toolScene = new SceneInfo(SELF_PROPS, SO.NO_CLIP, SO.EXCLUDE_BOUNDS_ALWAYS);
    public final SceneInfo cameraScene = new SceneInfo(IMPORT_PROPS, SO.NO_CLIP, SO.EXCLUDE_BOUNDS);
    public final Collection<SceneInfo> featureScenes = new ArrayList<SceneInfo>();
    private final List<ManagerEntry<?>> d_managers;
    private final Map<Class<?>, List<ManagerEntry<?>>> d_typeEntries;
    private final Map<ModelScene, SceneInfo> d_sceneInfos = new LinkedIdentityHashMap<ModelScene, SceneInfo>();

    private static ISceneRenderOptions mirrorProps(SceneRenderOptions props, Predicate<IPropertySet.Prop<?>> filter) {
        return new SceneRenderOptionsCopier(props, filter);
    }

    public static <T> IScenePropsProvider overrideProps(IPropertySet.Prop<T> prop1, T overrideVal1, Object ... additionalOverrides) {
        return (cam, base, scene) -> {
            IPropertySet.Prop[] overrideProps = new IPropertySet.Prop[additionalOverrides.length / 2 + 1];
            overrideProps[0] = prop1;
            for (int m = 0; m < additionalOverrides.length; m += 2) {
                overrideProps[m / 2 + 1] = (IPropertySet.Prop)additionalOverrides[m];
            }
            ISceneRenderOptions opts = GlobalDisplayMgr.mirrorProps(base, Filters.reject(overrideProps));
            opts.set(prop1, overrideVal1);
            int m = 0;
            while (m < additionalOverrides.length) {
                IPropertySet.Prop prop = (IPropertySet.Prop)additionalOverrides[m++];
                Object val = additionalOverrides[m++];
                opts.set(prop, val);
            }
            return opts;
        };
    }

    public GlobalDisplayMgr(VentusData md, ModelView mv) {
        List<SceneInfo> allScenes = theUtil.getAllDeclaredMembers(GlobalDisplayMgr.class, this, SceneInfo.class, theUtil.PUBLIC_FINAL);
        for (SceneInfo si2 : allScenes) {
            this.d_sceneInfos.put(si2.scene, si2);
        }
        this.handleScene.scene.getDrawProps().setLightModel(ISceneRenderOptions.LightModel.DISABLED);
        this.handleScene.scene.getDrawProps().setDepthTestEnabled(false);
        this.handleScene.scene.getDrawProps().setAutoClip(false);
        this.toolScene.scene.getDrawProps().setLightModel(ISceneRenderOptions.LightModel.DISABLED);
        this.toolScene.scene.getDrawProps().setDrawOutlines(false);
        this.toolScene.scene.getDrawProps().setDepthTestEnabled(false);
        this.toolScene.scene.getDrawProps().setAutoClip(false);
        this.gridScene.scene.getDrawProps().setDepthTestEnabled(false);
        this.gridScene.scene.getDrawProps().setAutoClip(false);
        this.originScene.scene.getDrawProps().setDepthTestEnabled(false);
        this.originScene.scene.getDrawProps().setAutoClip(false);
        this.d_managers = new ArrayList();
        this.d_typeEntries = new HashMap();
        Consumer<IMerlinDispMgr> add = mgr -> {
            ManagerEntry entry = new ManagerEntry(mgr, true);
            this.d_managers.add(entry);
            this.d_typeEntries.computeIfAbsent(mgr.getType(), t -> new ArrayList()).add(entry);
        };
        add.accept(new GeomDispMgr<ImportedGeom>(md, mv, ImportedGeom.class, new DefSceneProvider(this.importedGeomScene.scene)));
        add.accept(new ImageDispMgr(md, mv, this.bgimageScene.scene));
        add.accept(new GeomDispMgr<ISchematicComp>(md, mv, ISchematicComp.class, GlobalDisplayMgr.getSchematicSceneFinder(this.mainScene.scene, this.elevatorScene.scene)));
        add.accept(new GeomDispMgr<Elevator>(md, mv, Elevator.class, new DefSceneProvider(this.elevatorScene.scene)));
        add.accept(new GeomDispMgr<ICameraObj>(md, mv, ICameraObj.class, new DefSceneProvider(this.cameraScene.scene)));
        VentusApp.getApp().getComponents(ISceneItem.class).forEach(i -> {
            Pair<SceneInfo, IMerlinDispMgr<?>> info = i.createDisplayManager(mv, md);
            this.featureScenes.add((SceneInfo)info.v1);
            add.accept((IMerlinDispMgr)info.v2);
            this.d_sceneInfos.put(((SceneInfo)info.v1).scene, (SceneInfo)info.v1);
        });
        Collection clipScenes = this.d_sceneInfos.values().stream().filter(si -> !si.get(SO.NO_CLIP)).map(si -> si.scene).collect(Collectors.toList());
        add.accept(new FloorDispMgr(md, clipScenes));
    }

    public boolean isClippedByFloor(Object o) {
        boolean[] result = new boolean[]{false};
        this.getScenes(o, (ModelScene scene) -> {
            result[0] = result[0] || Optional.ofNullable(this.d_sceneInfos.get(scene)).map(si -> !si.get(SO.NO_CLIP)).orElse(false) != false;
        });
        return result[0];
    }

    public Predicate<Object> getWireframeTester() {
        return obj -> {
            boolean[] result = new boolean[]{false};
            this.getScenes(obj, (ModelScene scene) -> {
                result[0] = result[0] || Optional.ofNullable(this.d_sceneInfos.get(scene)).map(si -> si.isWireframe()).orElse(false) != false;
            });
            return result[0];
        };
    }

    @Override
    public void getScenes(Object obj, Consumer<ModelScene> scenes) {
        for (ManagerEntry<?> entry : this.getManagers(obj.getClass())) {
            if (!entry.mgr.isManaged(obj)) continue;
            entry.mgr.getScenes(obj, scenes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ManagerEntry<?>> getManagers(Class<?> type) {
        Map<Class<?>, List<ManagerEntry<?>>> map = this.d_typeEntries;
        synchronized (map) {
            List<ManagerEntry<?>> entries = this.d_typeEntries.get(type);
            if (entries != null) {
                return entries;
            }
            LinkedIdentityHashSet entrySet = new LinkedIdentityHashSet();
            theUtil.findObjectsForClass(this.d_typeEntries, type, mentries -> entrySet.addAll(mentries));
            ArrayList result = entrySet.isEmpty() ? Collections.emptyList() : new ArrayList(entrySet);
            this.d_typeEntries.put(type, result);
            return result;
        }
    }

    public static void initLayout3D(OverlayLayout layout, Collection<GlobalDisplayMgr> mgrs) {
        if (mgrs.isEmpty()) {
            return;
        }
        layout.add(new ClearableBackground(false, true));
        layout.add(GlobalDisplayMgr.getMultiSceneRenderer(mgrs, mgr -> mgr.mainScene, mgr -> Stream.concat(Stream.of(mgr.importedGeomScene, mgr.bgimageScene, mgr.elevatorScene, mgr.mainScene, mgr.handleScene, mgr.cameraScene), mgr.featureScenes.stream())));
        layout.add(GlobalDisplayMgr.getSceneRenderer(mgrs, mgr -> mgr.toolScene));
    }

    public static void initLayout2D(OverlayLayout layout, Collection<GlobalDisplayMgr> mgrs) {
        layout.add(new ClearableBackground(false, true));
        layout.add(GlobalDisplayMgr.getSceneRenderer(mgrs, mgr -> mgr.bgimageScene));
        layout.add(GlobalDisplayMgr.getMultiSceneRenderer(mgrs, mgr -> Stream.of(mgr.gridScene, mgr.originScene)));
        layout.add(new ClearableBackground(false, true));
        layout.add(GlobalDisplayMgr.getMultiSceneRenderer(mgrs, mgr -> mgr.mainScene, mgr -> Stream.concat(Stream.of(mgr.importedGeomScene, mgr.elevatorScene, mgr.mainScene, mgr.handleScene, mgr.cameraScene), mgr.featureScenes.stream())));
        layout.add(GlobalDisplayMgr.getSceneRenderer(mgrs, mgr -> mgr.toolScene));
    }

    private static <T> List<T> toList(Stream<T> stream) {
        return stream.collect(Collectors.toList());
    }

    private static SceneRenderer getMultiSceneRenderer(Collection<GlobalDisplayMgr> mgrs, Function<GlobalDisplayMgr, Stream<SceneInfo>> getScenes) {
        return new SceneRenderer(GlobalDisplayMgr.toList(mgrs.stream().flatMap(getScenes).map(si -> si.scene)));
    }

    private static SceneRenderer getMultiSceneRenderer(Collection<GlobalDisplayMgr> mgrs, Function<GlobalDisplayMgr, SceneInfo> cameraScene, Function<GlobalDisplayMgr, Stream<SceneInfo>> getScenes) {
        return new SceneRenderer(cameraScene.apply((GlobalDisplayMgr)mgrs.iterator().next()).scene.getCamera(), GlobalDisplayMgr.toList(mgrs.stream().flatMap(getScenes).map(si -> si.scene)));
    }

    private static SceneRenderer getSceneRenderer(Collection<GlobalDisplayMgr> mgrs, Function<GlobalDisplayMgr, SceneInfo> getScene) {
        return new SceneRenderer(GlobalDisplayMgr.toList(mgrs.stream().map(mgr -> ((SceneInfo)getScene.apply(mgr)).scene)));
    }

    public void updateDrawProps(Camera mainCamera, SceneRenderOptions props) {
        for (SceneInfo si : this.d_sceneInfos.values()) {
            ISceneRenderOptions sceneProps = (ISceneRenderOptions)si.createSceneProps.apply(mainCamera, props, si.scene);
            si.setProps(sceneProps);
        }
    }

    public void setMainCamera(Camera camera) {
        this.mainScene.scene.setCamera(camera);
        this.elevatorScene.scene.setCamera(camera.createCopyCam());
        this.importedGeomScene.scene.setCamera(camera.createCopyCam());
        this.bgimageScene.scene.setCamera(camera.createCopyCam());
        this.gridScene.scene.setCamera(camera.createCopyCam());
        this.originScene.scene.setCamera(camera.createCopyCam());
        this.handleScene.scene.setCamera(camera.createCopyCam());
        this.toolScene.scene.setCamera(camera.createCopyCam());
        this.cameraScene.scene.setCamera(camera.createCopyCam());
    }

    public AABox getModelSceneBounds(boolean useExcluded) {
        BoundsCalculator bc = new BoundsCalculator();
        bc.add(this.mainScene.scene);
        bc.add(this.elevatorScene.scene);
        bc.add(this.importedGeomScene.scene);
        bc.add(this.bgimageScene.scene);
        if (useExcluded) {
            bc.add(this.cameraScene.scene);
        }
        return bc.getBounds();
    }

    private static ISceneProvider<ISchematicComp> getSchematicSceneFinder(final ModelScene schematicScene, final ModelScene elevatorScene) {
        final Predicate<ISchematicComp> IS_AN_ELEVATOR_COMP = o -> o instanceof IElevatorComp;
        final Predicate<ISchematicComp> NOT_AN_ELEVATOR_COMP = o -> !(o instanceof IElevatorComp);
        return new ISceneProvider<ISchematicComp>(){

            @Override
            public Collection<? extends ModelScene> getPossibleScenes() {
                return Arrays.asList(schematicScene, elevatorScene);
            }

            @Override
            public Predicate<ISchematicComp> getFilter(ModelScene scene) {
                return scene == schematicScene ? NOT_AN_ELEVATOR_COMP : IS_AN_ELEVATOR_COMP;
            }

            @Override
            public ModelScene getScene(ISchematicComp obj) {
                return IS_AN_ELEVATOR_COMP.test(obj) ? elevatorScene : schematicScene;
            }
        };
    }

    public Collection<IMerlinDispMgr<?>> getManagers() {
        return theUtil.map(this.d_managers, obj -> obj.mgr);
    }

    @Override
    public Predicate<Object> getFilter() {
        return Filters.acceptAll();
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @Override
    public void removeAll() {
        for (ManagerEntry<?> mgr : this.d_managers) {
            mgr.mgr.removeAll();
        }
    }

    private static <T> Collection<T> filter(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        return theUtil.filter(objs, mgr.getType(), mgr.getFilter());
    }

    private static <T> void filterAddDisplays(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.addDisplays(GlobalDisplayMgr.filter(mgr, objs));
    }

    private static <T> void filterUpdateDisplays(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.updateDisplays(GlobalDisplayMgr.filter(mgr, objs));
    }

    private static <T> void filterRemoveDisplays(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.removeDisplays(GlobalDisplayMgr.filter(mgr, objs));
    }

    private static <T> void filterRemoveFromScene(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.removeFromScene(GlobalDisplayMgr.filter(mgr, objs));
    }

    private static <T> void filterAddToScene(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.addToScene(GlobalDisplayMgr.filter(mgr, objs));
    }

    private static <T> void filterUpdateVisibility(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.updateVisibility(GlobalDisplayMgr.filter(mgr, objs));
    }

    @Override
    public void addDisplays(Collection<?> objs) {
        for (ManagerEntry<?> mgr : this.d_managers) {
            GlobalDisplayMgr.filterAddDisplays(mgr.mgr, objs);
        }
    }

    @Override
    public void updateDisplays(Collection<?> objs) {
        for (ManagerEntry<?> mgr : this.d_managers) {
            GlobalDisplayMgr.filterUpdateDisplays(mgr.mgr, objs);
        }
    }

    @Override
    public void removeDisplays(Collection<?> objs) {
        for (ManagerEntry<?> mgr : this.d_managers) {
            GlobalDisplayMgr.filterRemoveDisplays(mgr.mgr, objs);
        }
    }

    @Override
    public void removeFromScene(Collection<?> objs) {
        for (ManagerEntry<?> mgr : this.d_managers) {
            GlobalDisplayMgr.filterRemoveFromScene(mgr.mgr, objs);
        }
    }

    @Override
    public void addToScene(Collection<?> objs) {
        for (ManagerEntry<?> mgr : this.d_managers) {
            GlobalDisplayMgr.filterAddToScene(mgr.mgr, objs);
        }
    }

    @Override
    public void updateVisibility(Collection<?> objs) {
        for (ManagerEntry<?> mgr : this.d_managers) {
            GlobalDisplayMgr.filterUpdateVisibility(mgr.mgr, objs);
        }
    }

    @Override
    public void update(Events events) {
        for (ManagerEntry<?> mgr : this.d_managers) {
            mgr.mgr.update(events);
        }
    }

    @Override
    public void updateAll() {
        for (ManagerEntry<?> mgr : this.d_managers) {
            mgr.mgr.updateAll();
        }
    }

    @Override
    public void getScenes(Consumer<ModelScene> scenes) {
        this.d_managers.forEach(mgr -> mgr.mgr.getScenes(scenes));
    }

    @Override
    public ITransformPreview getTransformPreview(IDisplayMgr<? super Object> copyMgr, Collection<?> objs, boolean copyMode) {
        assert (copyMgr instanceof GlobalDisplayMgr);
        if (!(copyMgr instanceof GlobalDisplayMgr)) {
            throw new UnsupportedOperationException();
        }
        GlobalDisplayMgr copyDispMgr = (GlobalDisplayMgr)copyMgr;
        ArrayList<ITransformPreview> transformers = new ArrayList<ITransformPreview>();
        assert (this.d_managers.size() == copyDispMgr.d_managers.size());
        for (int m = 0; m < this.d_managers.size(); ++m) {
            ManagerEntry<?> entry = this.d_managers.get(m);
            IMerlinDispMgr mgr = entry.mgr;
            Collection fobjs = GlobalDisplayMgr.filter(mgr, objs);
            if (fobjs.isEmpty()) continue;
            ITransformPreview xformer = mgr.getTransformPreview(copyDispMgr.d_managers.get((int)m).mgr, fobjs, copyMode);
            transformers.add(xformer);
        }
        if (transformers.size() == 1) {
            return (ITransformPreview)transformers.get(0);
        }
        return new CompositeTransformPreview(transformers);
    }

    public static interface IScenePropsProvider
    extends TriFunction<Camera, SceneRenderOptions, ModelScene, ISceneRenderOptions> {
    }

    public static class SceneInfo {
        public final ModelScene scene = new ModelScene();
        public final EnumSet<SO> options;
        public final IScenePropsProvider createSceneProps;
        public CachedRenderOptions currProps;

        public SceneInfo(IScenePropsProvider createSceneProps, SO ... options) {
            this.createSceneProps = createSceneProps;
            this.options = EnumSet.noneOf(SO.class);
            this.options.addAll(Arrays.asList(options));
            this.currProps = this.initOptions(this.scene.getDrawProps());
        }

        public boolean isWireframe() {
            return this.currProps.get(ISceneRenderOptions.DRAW_WIREFRAME);
        }

        public boolean get(SO opt) {
            return this.options.contains((Object)opt);
        }

        public void setProps(ISceneRenderOptions opts) {
            this.scene.setDrawProps(opts.getNativeProps());
            this.currProps = this.initOptions(opts);
        }

        public CachedRenderOptions initOptions(ISceneRenderOptions opts) {
            return new CachedRenderOptions(opts, Filters.accept(ISceneRenderOptions.DRAW_WIREFRAME));
        }
    }

    public static enum SO {
        EXCLUDE_BOUNDS,
        EXCLUDE_BOUNDS_ALWAYS,
        NO_CLIP;

    }

    public static class ManagerEntry<T> {
        public final IMerlinDispMgr<T> mgr;

        public ManagerEntry(IMerlinDispMgr<T> mgr, boolean clipByFloor) {
            this.mgr = mgr;
        }
    }
}

