/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.displays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.data.DisplayFilter;
import ventus.data.VentusData;
import ventus.mv.displays.IMerlinDispMgr;
import ventus.mv.displays.IMerlinDisplay;
import ventus.mv.displays.scenefinders.ISceneProvider;

public abstract class AMerlinDispMgr<MerlinT, DispT extends IMerlinDisplay>
implements IMerlinDispMgr<MerlinT> {
    private final VentusData d_md;
    private final Class<MerlinT> d_type;
    private final Predicate<MerlinT> d_filter;
    private final ISceneProvider<MerlinT> d_sceneFinder;
    private final Map<MerlinT, DispT> d_dispMap = new LinkedIdentityHashMap<MerlinT, DispT>();

    public AMerlinDispMgr(VentusData md, Class<MerlinT> type, ISceneProvider<MerlinT> sceneFinder) {
        this(md, type, Filters.acceptAll(), sceneFinder);
    }

    public AMerlinDispMgr(VentusData md, Class<MerlinT> type, Predicate<MerlinT> filter, ISceneProvider<MerlinT> sceneFinder) {
        this.d_md = md;
        this.d_sceneFinder = sceneFinder;
        this.d_type = type;
        this.d_filter = filter;
    }

    public ISceneProvider<MerlinT> getSceneProvider() {
        return this.d_sceneFinder;
    }

    @Override
    public void getScenes(Consumer<ModelScene> scenes) {
        this.d_sceneFinder.getPossibleScenes().forEach(scenes);
    }

    @Override
    public void getScenes(MerlinT obj, Consumer<ModelScene> scenes) {
        ModelScene scene = this.d_sceneFinder.getScene(obj);
        if (scene != null) {
            scenes.accept(scene);
        }
    }

    public VentusData getData() {
        return this.d_md;
    }

    @Override
    public Class<MerlinT> getType() {
        return this.d_type;
    }

    protected abstract DispT createDisplay(MerlinT var1, boolean var2, boolean var3);

    @Override
    public Predicate<MerlinT> getFilter() {
        return this.d_filter;
    }

    protected List<IDisplayable> getDisplays(Collection<DispT> disps) {
        ArrayList<IDisplayable> displays = new ArrayList<IDisplayable>(disps.size());
        for (IMerlinDisplay obj : disps) {
            displays.addAll(Arrays.asList(obj.getDisplayObjs()));
        }
        return displays;
    }

    protected void addDisplays(ModelScene scene, Collection<? extends MerlinT> objs, Collection<DispT> disps) {
        scene.addObjects(this.getDisplays(disps));
    }

    protected void removeDisplays(ModelScene scene, Collection<DispT> disps) {
        scene.removeObjects(this.getDisplays(disps));
    }

    @Override
    public void updateAll() {
        this.updateDisplays((Collection<? extends MerlinT>)this.getObjs());
    }

    public DispT getDisplay(MerlinT obj) {
        return (DispT)((IMerlinDisplay)this.d_dispMap.get(obj));
    }

    public Collection<DispT> getDisplays() {
        return this.d_dispMap.values();
    }

    public Collection<MerlinT> getObjs() {
        return this.d_dispMap.keySet();
    }

    @Override
    public void update(Events events) {
        IEventRecord<MerlinT> oevts = events.getEvents(this.getType(), new Class[0]).filter(this.d_filter);
        this.addDisplays((Collection<? extends MerlinT>)oevts.getAddedObjs());
        this.removeDisplays((Collection<? extends MerlinT>)oevts.getRemovedObjs());
        this.updateDisplays(oevts);
        this.updateVisIfModified(events);
    }

    private boolean testUpdateVis(Events events) {
        for (EventChannel<DisplayFilter> channel : events.getAffectedChannels(DisplayFilter.class, new Class[0])) {
            Set<Object> changedTypes = channel.getChanges();
            for (Object type : changedTypes) {
                if (!(type instanceof Class) || !((Class)type).isAssignableFrom(this.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public void updateVisIfModified(Events events) {
        if (this.testUpdateVis(events)) {
            this.updateVisibility((Collection<? extends MerlinT>)this.getObjs());
        }
    }

    @Override
    public void addDisplays(Collection<? extends MerlinT> objs) {
        if (objs.isEmpty()) {
            return;
        }
        for (ModelScene scene : this.d_sceneFinder.getPossibleScenes()) {
            IFilteredCollection sobjs = theUtil.filter(objs, this.getType(), this.d_sceneFinder.getFilter(scene));
            ArrayList<DispT> displays = new ArrayList<DispT>(sobjs.size());
            for (Object obj : sobjs) {
                assert (!this.d_dispMap.containsKey(obj));
                DispT disp = this.createDisplay(obj, this.isVisible(obj), this.isSelected(obj));
                this.d_dispMap.put(obj, disp);
                displays.add(disp);
            }
            this.addDisplays(scene, sobjs, displays);
        }
    }

    @Override
    public void removeDisplays(Collection<? extends MerlinT> objs) {
        if (objs.isEmpty()) {
            return;
        }
        ArrayList<IMerlinDisplay> disps = new ArrayList<IMerlinDisplay>(objs.size());
        for (MerlinT obj : objs) {
            IMerlinDisplay disp = (IMerlinDisplay)this.d_dispMap.remove(obj);
            assert (disp != null);
            disps.add(disp);
        }
        for (ModelScene scene : this.d_sceneFinder.getPossibleScenes()) {
            this.removeDisplays(scene, disps);
        }
    }

    @Override
    protected void updateDisplays(IEventRecord<? extends MerlinT> events) {
        Set<? extends MerlinT> visObjs = events.getChangedObjs(VentusData.VISIBILITY);
        Set<? extends MerlinT> selObjs = events.getChangedObjs(VentusData.SELECTION_CHANGED);
        Set<MerlinT> genObjs = events.getChangedNotOfType(VentusData.SELECTION_CHANGED, VentusData.VISIBILITY);
        if (!genObjs.isEmpty()) {
            LinkedIdentityHashSet<Object> tobjs = new LinkedIdentityHashSet<MerlinT>(visObjs);
            tobjs.removeAll(genObjs);
            visObjs = tobjs;
            tobjs = new LinkedIdentityHashSet<MerlinT>(selObjs);
            tobjs.removeAll(genObjs);
            selObjs = tobjs;
        }
        this.updateVisibility((Collection<? extends MerlinT>)visObjs);
        this.updateSelection(selObjs);
        this.updateDisplays((Collection<? extends MerlinT>)genObjs);
    }

    @Override
    public void updateDisplays(Collection<? extends MerlinT> objs) {
        for (MerlinT obj : objs) {
            DispT disp = this.getDisplay(obj);
            if (disp == null) continue;
            this.updateDisplay(obj, disp);
        }
    }

    protected void updateDisplay(MerlinT obj, DispT disp) {
        disp.update();
        this.updateSelection(obj, disp);
        this.updateVisibility(obj, disp);
    }

    @Override
    public void updateVisibility(Collection<? extends MerlinT> objs) {
        for (MerlinT obj : objs) {
            DispT display = this.getDisplay(obj);
            if (display == null) continue;
            this.updateVisibility(obj, display);
        }
    }

    protected void updateVisibility(MerlinT obj, DispT display) {
        display.setVisible(this.isVisible(obj));
    }

    protected boolean isVisible(MerlinT obj) {
        return this.d_md.isVisible(obj);
    }

    protected void updateSelection(Collection<? extends MerlinT> objs) {
        for (MerlinT obj : objs) {
            DispT display = this.getDisplay(obj);
            if (display == null) continue;
            this.updateSelection(obj, display);
        }
    }

    protected void updateSelection(MerlinT obj, DispT display) {
        display.setSelected(this.isSelected(obj));
    }

    protected boolean isSelected(MerlinT obj) {
        return this.d_md.selection.isSelected(obj) || this.d_md.selection.isProxySelected(obj);
    }

    @Override
    public void removeAll() {
        this.removeDisplays((Collection<? extends MerlinT>)new ArrayList<MerlinT>(this.getObjs()));
    }

    protected List<DispT> getDisplays(ModelScene scene, Collection<? extends MerlinT> objs) {
        IFilteredCollection sobjs = theUtil.filter(objs, this.getType(), this.d_sceneFinder.getFilter(scene));
        ArrayList<IMerlinDisplay> displays = new ArrayList<IMerlinDisplay>(sobjs.size());
        for (Object obj : sobjs) {
            IMerlinDisplay disp = (IMerlinDisplay)this.d_dispMap.get(obj);
            if (disp == null) continue;
            displays.add(disp);
        }
        return displays;
    }

    @Override
    public void removeFromScene(Collection<? extends MerlinT> objs) {
        for (ModelScene scene : this.d_sceneFinder.getPossibleScenes()) {
            this.removeDisplays(scene, this.getDisplays(scene, objs));
        }
    }

    @Override
    public void addToScene(Collection<? extends MerlinT> objs) {
        for (ModelScene scene : this.d_sceneFinder.getPossibleScenes()) {
            this.addDisplays(scene, objs, this.getDisplays(scene, objs));
        }
    }
}

