/*
 * Decompiled with CFR 0.152.
 */
package ventus.io.contamx;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import thunderheadeng.io.TableBuilder;
import thunderheadeng.util.Global;
import ventus.io.contamx.PrjData;

public class PrjWriter {
    private static String unsafe(String str) {
        return StringUtils.truncate(str, 15).replaceAll("(?U)[^\\p{IsAlphabetic}\\-_0-9]", "_");
    }

    private static void printRow(TableBuilder tb, Object ... objs) {
        for (int i = 0; i < objs.length; ++i) {
            Object obj = objs[i];
            if (obj instanceof Double) {
                tb.add(Global.format((double)((Double)obj), 6));
                continue;
            }
            if (obj instanceof Integer) {
                tb.add(((Integer)obj).toString());
                continue;
            }
            if (obj instanceof String) {
                tb.add((String)obj);
                continue;
            }
            assert (false) : "Invalid output object type.";
        }
        tb.nextRow();
    }

    public static void writePrjFile(PrintWriter writer, PrjData data) {
        try {
            Global.setLocale(Locale.US);
            PrjWriter.writePrjFileImpl(writer, data);
        }
        finally {
            Global.setLocale(Locale.getDefault());
        }
    }

    private static void writePrjFileImpl(PrintWriter writer, PrjData data) {
        TableBuilder outputTable = new TableBuilder();
        outputTable.setLeftAlignRule(str -> str.startsWith("!") || str.startsWith("null !"));
        PrjWriter.printRow(outputTable, data.name, data.version, data.echo);
        PrjWriter.printRow(outputTable, new Object[0]);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! rows", "cols", "ud", "uf", "T", "uT", "N", "wH", "u", "Ao", "a");
        PrjWriter.printRow(outputTable, data.rows, data.cols, data.ud, data.uf, data.T, data.uT, data.N, data.wH, data.u, data.Ao, data.a);
        PrjWriter.printRow(outputTable, "! scale", "us", "orgRow", "orgCol", "invYaxis", "showGeom");
        PrjWriter.printRow(outputTable, data.scale, data.us, data.orgRow, data.orgCol, data.invYaxis, data.showGeom);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! Ta", "Pb", "Ws", "Wd", "rh", "day", "u..");
        PrjWriter.printRow(outputTable, data.steadyStateSim.Ta, data.steadyStateSim.Pb, data.steadyStateSim.Ws, data.steadyStateSim.Wd, data.steadyStateSim.rh, data.steadyStateSim.day, data.steadyStateSim.unitsCollection[0], data.steadyStateSim.unitsCollection[1], data.steadyStateSim.unitsCollection[2], data.steadyStateSim.unitsCollection[3], "! steady simulation");
        PrjWriter.printRow(outputTable, data.windPresTest.Ta, data.windPresTest.Pb, data.windPresTest.Ws, data.windPresTest.Wd, data.windPresTest.rh, data.windPresTest.day, data.windPresTest.unitsCollection[0], data.windPresTest.unitsCollection[1], data.windPresTest.unitsCollection[2], data.windPresTest.unitsCollection[3], "! wind pressure test");
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "null ! no weather file");
        PrjWriter.printRow(outputTable, "null ! no contaminant file");
        PrjWriter.printRow(outputTable, "null ! no continuous values file");
        PrjWriter.printRow(outputTable, "null ! no discrete values file");
        PrjWriter.printRow(outputTable, "null ! no WPC file");
        PrjWriter.printRow(outputTable, "null ! no EWC file");
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "WPC description");
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! Xref", "Yref", "Zref", "angle", "u");
        PrjWriter.printRow(outputTable, data.Xref, data.Yref, data.Zref, data.angle, data.u);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! epsP", "epsS", "tShift", "dStart", "dEnd", "wp", "mf", "wpctrig");
        PrjWriter.printRow(outputTable, data.epsP, data.epsS, data.tShift, data.dStart, data.dEnd, data.wp, data.mf, data.wpctrig);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! latd", "longtd", "tznr", "altd", "Tgrnd", "u..");
        PrjWriter.printRow(outputTable, data.latd, data.longtd, data.tznr, data.altd, data.Tgrnd, data.utg, data.u_a);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! sim_af", "afcalc", "afmaxi", "afrcnvg", "afacnvg", "afrelax", "uac", "Pbldg", "uPb");
        PrjWriter.printRow(outputTable, data.sim_af, data.afcalc, data.afmaxi, data.afrcnvg, data.afacnvg, data.afrelax, data.uac, data.Pbldg, data.uPb);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! slae", "rs", "aflmaxi", "aflcnvg", "aflinit", "Tadj");
        PrjWriter.printRow(outputTable, data.slae, data.rs, data.aflmaxi, data.aflcnvg, data.aflinit, data.Tadj);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! sim_mf", "slae", "rs", "maxi", "relcnvg", "abscnvg", "relax", "gamma", "ucc");
        PrjWriter.printRow(outputTable, data.cyclic.sim_mf, "", "", data.cyclic.maxi, data.cyclic.relcnvg, data.cyclic.abscnvg, data.cyclic.relax, "", data.cyclic.ucc, "! (cyclic)");
        PrjWriter.printRow(outputTable, "", data.nonTrace.slae, data.nonTrace.rs, data.nonTrace.maxi, data.nonTrace.relcnvg, data.nonTrace.abscnvg, data.nonTrace.relax, data.nonTrace.gamma, data.nonTrace.ucc, "! (non-trace)");
        PrjWriter.printRow(outputTable, "", data.trace.slae, data.trace.rs, data.trace.maxi, data.trace.relcnvg, data.trace.abscnvg, data.trace.relax, data.trace.gamma, data.trace.ucc, "! (trace)");
        PrjWriter.printRow(outputTable, "", data.cvodeSolver.slae, data.cvodeSolver.rs, data.cvodeSolver.maxi, data.cvodeSolver.relcnvg, data.cvodeSolver.abscnvg, data.cvodeSolver.relax, "", data.cvodeSolver.ucc, "! (cvode)");
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! mf_solver", "sim_1dz", "sim_1dd", "celldx", "sim_vjt", "udx");
        PrjWriter.printRow(outputTable, data.mfSolver, data.sim1dz, data.sim1dd, data.celldx, data.simVjt, data.udx);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! cvode", "rcnvg", "acnvg", "dtmax");
        PrjWriter.printRow(outputTable, data.cvode, data.rcnvg, data.acnvg, data.dtmax);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! tsdens", "relax", "tsmaxi", "cnvgSS", "densZP", "stackD", "dodMdt");
        PrjWriter.printRow(outputTable, data.tsdens, data.relax, data.tsmaxi, data.cnvgSS, data.densZP, data.stackD, data.dodMdt);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! date_st", "time_st", "date_0", "time_0", "date_1", "time_1", "t_step", "t_list", "t_scrn");
        PrjWriter.printRow(outputTable, data.dateSt, data.timeSt, data.date0, data.time0, data.date1, data.time1, data.tStep, data.tList, data.tScrn);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! restart", "date", "time");
        PrjWriter.printRow(outputTable, data.restart, data.date, data.time);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! list", "doDlg", "pfsave", "zfsave", "zcsave");
        PrjWriter.printRow(outputTable, data.list, data.doDlg, data.pfsave, data.zfsave, data.zcsave);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! vol", "ach", "-bw", "cbw", "exp", "-bw", "age", "-bw");
        PrjWriter.printRow(outputTable, data.achvol, data.achsave, data.abwsave, data.cbwsave, data.expsave, data.ebwsave, data.zaasave, data.zbwsave);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! rzf", "rzm", "rz1", "csm", "srf", "log");
        PrjWriter.printRow(outputTable, data.rzf, data.rzm, data.rz1, data.csm, data.srf, data.log);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! bcx", "dcx", "pfq", "zfq", "zcq");
        PrjWriter.printRow(outputTable, data.bcx, data.dcx, data.pfq, data.zfq, data.zcq);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! dens", "grav");
        PrjWriter.printRow(outputTable, data.dens, data.grav);
        writer.println(outputTable.flush());
        writer.println("! 0  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 <- extra[]");
        writer.println(data.extra);
        PrjWriter.printRow(outputTable, data.nrvals, "! rvals:");
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! valZ", "valD", "valC");
        PrjWriter.printRow(outputTable, data.valZ, data.valD, data.valC);
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! cfd", "cfdcnvg", "var", "zref", "maxi", "dtcmo", "solv", "smooth", "cnvgUVW", "cnvgT");
        PrjWriter.printRow(outputTable, data.cfd, data.cfdcnvg, data.var, data.zref, data.maxi, data.dtcmo, data.solv, data.smooth, data.cnvgUVW, data.cnvgT);
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nctm, "! contaminants:");
        writer.println(outputTable.flush());
        if (data.nctm > 0) {
            for (Integer n : data.contaminantsList) {
                PrjWriter.printRow(outputTable, n);
            }
            writer.println(outputTable.flush());
        }
        PrjWriter.printRow(outputTable, data.nspcs, "! species:");
        writer.println(outputTable.flush());
        if (data.nspcs > 0) {
            PrjWriter.printRow(outputTable, "! #", "s", "t", "molwt", "mdiam", "edens", "decay", "Dm", "CCdef", "Cp", "Kuv", "u[5]", "", "", "", "", "name");
            for (PrjData.Species species : data.speciesList) {
                PrjWriter.printRow(outputTable, species.nr, species.sflag, species.ntflag, species.molwt, species.mdiam, species.edens, species.decay, species.Dm, species.ccdef, species.Cp, species.Kuv, species.ucc, species.umd, species.ued, species.udm, species.ucp, PrjWriter.unsafe(species.name));
                PrjWriter.printRow(outputTable, species.description);
            }
            writer.println(outputTable.flush());
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nlev, "! levels plus icon data:");
        writer.println(outputTable.flush());
        PrjWriter.printRow(outputTable, "! #", "refHt", "delHt", "nicon", "u_rfht", "u_dlht", "name");
        for (int j = 0; j < data.nlev; ++j) {
            PrjData.Level level = data.levelList.get(j);
            PrjWriter.printRow(outputTable, level.nr, level.refHt, level.delHt, level.ni, level.u_rfht, level.u_dlht, PrjWriter.unsafe(level.levelName));
            PrjWriter.printRow(outputTable, "!", "icn", "col", "row", "#");
            for (int ni = 0; ni < level.ni; ++ni) {
                PrjData.Icon icon = level.icons[ni];
                PrjWriter.printRow(outputTable, icon.iconType, icon.colPos, icon.rowPos, icon.nrNum);
            }
        }
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.ndsch, "! day-schedules:");
        writer.println(outputTable.flush());
        if (data.ndsch > 0) {
            PrjWriter.printRow(outputTable, "! #", "npts", "shap", "utyp", "ucnv", "name");
            for (PrjData.DaySchedule daySchedule : data.dayScheduleList) {
                PrjWriter.printRow(outputTable, daySchedule.nr, daySchedule.npts, daySchedule.shape, daySchedule.utyp, daySchedule.ucnv, PrjWriter.unsafe(daySchedule.name));
                PrjWriter.printRow(outputTable, PrjWriter.unsafe(daySchedule.desc));
                for (PrjData.SchedulePoint point : daySchedule.pts) {
                    PrjWriter.printRow(outputTable, point.time, point.ctrl);
                }
            }
            writer.println(outputTable.flush());
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nwsch, "! week-schedules:");
        writer.println(outputTable.flush());
        if (data.nwsch > 0) {
            PrjWriter.printRow(outputTable, "! #", "utyp", "ucnv", "name");
            for (PrjData.WeekSchedule weekSchedule : data.weekScheduleList) {
                PrjWriter.printRow(outputTable, weekSchedule.nr, weekSchedule.utyp, weekSchedule.ucnv, PrjWriter.unsafe(weekSchedule.name));
                PrjWriter.printRow(outputTable, PrjWriter.unsafe(weekSchedule.desc));
                Object[] daySchedules = new Object[weekSchedule.j.length];
                for (int k = 0; k < weekSchedule.j.length; ++k) {
                    daySchedules[k] = weekSchedule.j[k];
                }
                PrjWriter.printRow(outputTable, daySchedules);
                writer.println(outputTable.flush());
            }
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nwpf, "! wind pressure profiles:");
        writer.println(outputTable.flush());
        for (PrjData.WindProfile windProfile : data.windProfileList) {
            PrjWriter.printRow(outputTable, windProfile.nr, windProfile.npts, windProfile.graphLineType, PrjWriter.unsafe(windProfile.name));
            PrjWriter.printRow(outputTable, PrjWriter.unsafe(windProfile.description));
            for (int i = 0; i < windProfile.npts; ++i) {
                PrjWriter.printRow(outputTable, windProfile.degrees.get(i), windProfile.coefficient.get(i));
            }
            writer.println(outputTable.flush());
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nkinr, "! kinetic reactions:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nflte, "! filter elements:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nfilt, "! filters:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.ncse, "! source/sink elements:");
        writer.println(outputTable.flush());
        for (PrjData.SourceSinkElem sourceSinkElem : data.sourceSinkElementList) {
            PrjWriter.printRow(outputTable, sourceSinkElem.nr, PrjWriter.unsafe(sourceSinkElem.spcs), sourceSinkElem.ctype, PrjWriter.unsafe(sourceSinkElem.name));
            PrjWriter.printRow(outputTable, sourceSinkElem.desc);
            if (sourceSinkElem.ctype.equals("ccf")) {
                PrjData.SourceSinkTypeCsCcf ccf = data.csCcfMap.get(sourceSinkElem.nr);
                PrjWriter.printRow(outputTable, ccf.G, ccf.D, ccf.u_G, ccf.u_D);
            }
            writer.println(outputTable.flush());
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nafe, "! flow elements:");
        writer.println(outputTable.flush());
        for (PrjData.AirFlowElem airFlowElem : data.airFlowList) {
            PrjWriter.printRow(outputTable, airFlowElem.nr, airFlowElem.icon, airFlowElem.type, PrjWriter.unsafe(airFlowElem.name));
            if (airFlowElem.type.equals("plr_orfc")) {
                PrjData.AirFlowTypePlrOrf orf = data.plrOrfMap.get(airFlowElem.nr);
                PrjWriter.printRow(outputTable, "lam", "turb", "expt", "area", "dia", "coef", "Re", "u_A", "u_D");
                PrjWriter.printRow(outputTable, orf.lam, orf.turb, orf.expt, orf.area, orf.dia, orf.coef, orf.Re, orf.uA, orf.uD);
                continue;
            }
            if (airFlowElem.type.equals("plr_leak1") || airFlowElem.type.equals("plr_leak2") || airFlowElem.type.equals("plr_leak3")) {
                PrjData.AirFlowTypePlrLeakArea leakArea = data.plrLeakAreaMap.get(airFlowElem.nr);
                PrjWriter.printRow(outputTable, "lam", "turb", "expt", "coef", "pres", "area1", "area2", "area3", "u_A1", "u_A2", "u_A3", "u_dP");
                PrjWriter.printRow(outputTable, leakArea.lam, leakArea.turb, leakArea.expt, leakArea.coef, leakArea.pres, leakArea.area1, leakArea.area2, leakArea.area3, leakArea.uA1, leakArea.uA2, leakArea.uA3, leakArea.udP);
                continue;
            }
            if (airFlowElem.type.equals("plr_shaft")) {
                PrjData.AirFlowTypePlrShaft plrShaftElem = data.plrShaftMap.get(airFlowElem.nr);
                PrjWriter.printRow(outputTable, "lam", "turb", "expt", "Ht", "area", "perim", "rough", "u_A", "u_D", "u_P", "u_R");
                PrjWriter.printRow(outputTable, plrShaftElem.lam, plrShaftElem.turb, plrShaftElem.expt, plrShaftElem.Ht, plrShaftElem.area, plrShaftElem.perim, plrShaftElem.rough, plrShaftElem.uA, plrShaftElem.uD, plrShaftElem.uP, plrShaftElem.uR);
                continue;
            }
            if (airFlowElem.type.equals("plr_stair")) {
                PrjData.AirFlowTypePlrStair plrStairElem = data.plrStairMap.get(airFlowElem.nr);
                PrjWriter.printRow(outputTable, "lam", "turb", "expt", "Ht", "Area", "peo", "tread", "u_A", "u_D");
                PrjWriter.printRow(outputTable, plrStairElem.lam, plrStairElem.turb, plrStairElem.expt, plrStairElem.Ht, plrStairElem.area, plrStairElem.peo, plrStairElem.tread, plrStairElem.uA, plrStairElem.uD);
                continue;
            }
            if (!airFlowElem.type.equals("srv_jwa")) continue;
            PrjWriter.printRow(outputTable, "Flow", "dP", "f");
            PrjData.AirFlowTypeSelfRegulatingVent selfRegulatingVent = data.selfRegulatingVentMap.get(airFlowElem.nr);
            PrjWriter.printRow(outputTable, selfRegulatingVent.maxFlowRate, selfRegulatingVent.regulatingPressure, selfRegulatingVent.reverseFlowFraction, selfRegulatingVent.uF, selfRegulatingVent.uP);
        }
        if (!data.airFlowList.isEmpty()) {
            writer.println(outputTable.flush());
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.ndfe, "! duct elements:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nselmt, "! control super elements:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nctrl, "! control nodes:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nahs, "! simple AHS:");
        writer.println(outputTable.flush());
        if (data.nahs > 0) {
            PrjWriter.printRow(outputTable, "! #", "zr#", "zs#", "pr#", "ps#", "px#", "color", "name");
            for (PrjData.AHS aHS : data.ahsList) {
                PrjWriter.printRow(outputTable, aHS.nr, aHS.zoneR, aHS.zoneS, aHS.pathR, aHS.pathS, aHS.pathX, aHS.color, PrjWriter.unsafe(aHS.name));
                PrjWriter.printRow(outputTable, PrjWriter.unsafe(aHS.desc));
            }
            writer.println(outputTable.flush());
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.zoneList.size(), "! zones:");
        writer.println(outputTable.flush());
        if (data.nzone > 0) {
            PrjWriter.printRow(outputTable, "! Z#", "f", "s#", "c#", "k#", "l#", "relHt", "Vol", "T0", "P0", "name", "clr", "uH", "uT", "uP", "uV", "axs", "vf_type", "vf_name");
            for (PrjData.Zone zone : data.zoneList) {
                PrjWriter.printRow(outputTable, zone.nr, zone.flags, zone.ps, zone.pc, zone.pk, zone.pl, zone.relHt, zone.vol, zone.T0, zone.P0, PrjWriter.unsafe(zone.name), zone.color, zone.u_Ht, zone.uT, zone.uP, zone.uV, zone.cdaxis, zone.cdvf, zone.cfd);
            }
            writer.println(outputTable.flush());
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nn, "! initial zone concentrations:");
        writer.println(outputTable.flush());
        if (data.nzone > 0 && data.nctm > 0) {
            ArrayList<String> headerColumns = new ArrayList<String>();
            headerColumns.add("! Z#");
            for (String contaminant : data.zoneConcentrationHeaders) {
                headerColumns.add(PrjWriter.unsafe(contaminant));
            }
            PrjWriter.printRow(outputTable, headerColumns.toArray());
            for (PrjData.ZoneConcentration zoneConcentration : data.zoneConcentrationList) {
                ArrayList<Number> row = new ArrayList<Number>();
                row.add(zoneConcentration.nr);
                row.addAll(zoneConcentration.concentrations);
                PrjWriter.printRow(outputTable, row.toArray());
            }
            writer.println(outputTable.flush());
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.npath, "! flow paths:");
        writer.println(outputTable.flush());
        if (data.npath > 0) {
            PrjWriter.printRow(outputTable, "! P#", "f", "n#", "m#", "e#", "f#", "w#", "a#", "s#", "c#", "l#", "X", "Y", "relHt", "mult", "wPset", "wPmod", "wazm", "Fahs", "Xmax", "Xmin", "icn", "dir", "color", "u_HT", "u_XY", "u_dp", "u_F", "vf_type", "cfd", "fp_name");
            for (PrjData.AirFlowPath airFlowPath : data.airFlowPathList) {
                PrjWriter.printRow(outputTable, airFlowPath.nr, airFlowPath.flags, airFlowPath.pzn, airFlowPath.pzm, airFlowPath.pe, airFlowPath.pf, airFlowPath.pw, airFlowPath.pa, airFlowPath.ps, airFlowPath.pc, airFlowPath.pld, airFlowPath.X, airFlowPath.Y, airFlowPath.relHt, airFlowPath.mult, airFlowPath.wPset, airFlowPath.wPmod, airFlowPath.wazm, airFlowPath.Fahs, airFlowPath.xmax, airFlowPath.xmin, airFlowPath.icon, airFlowPath.dir, airFlowPath.color, airFlowPath.u_Ht, airFlowPath.u_XY, airFlowPath.u_dp, airFlowPath.u_F, airFlowPath.cdvf, airFlowPath.cfd, airFlowPath.vntsDesc);
            }
            writer.println(outputTable.flush());
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.njct, "! duct junctions:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.numOfMassFractions, "! initial junction concentrations:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.ndct, "! duct segments:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.ncss, "! source/sinks:");
        writer.println(outputTable.flush());
        if (data.ncss > 0) {
            PrjWriter.printRow(outputTable, "! #", "Z#", "e#", "s#", "c#", "mult", "CC0", "(X, Y, H)min", "", "", "(X, Y, H)max", "", "", "u[1]", "cdvf", "<cdvf name>", "cfd", "<cfd name>");
            for (PrjData.SourceSink sourceSink : data.sourceSinkList) {
                PrjWriter.printRow(outputTable, sourceSink.nr, sourceSink.pz, sourceSink.pe, sourceSink.ps, sourceSink.pc, sourceSink.mult, sourceSink.CC0, sourceSink.Xmin, sourceSink.Ymin, sourceSink.Hmin, sourceSink.Xmax, sourceSink.Ymax, sourceSink.Hmax, sourceSink.u_XYZ, sourceSink.vf_type, sourceSink.vf_node_name, sourceSink.cfd, sourceSink.name);
            }
            writer.println(outputTable.flush());
        }
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nosch, "! occupancy schedules:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.npexp, "! exposures:");
        writer.println(outputTable.flush());
        writer.println("-999");
        PrjWriter.printRow(outputTable, data.nnote, "! annotations:");
        writer.println(outputTable.flush());
        writer.println("-999");
        writer.println("* end project file.");
    }
}

