/*
 * Decompiled with CFR 0.152.
 */
package ventus.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import thunderheadeng.TeciIO;
import thunderheadeng.io.LegacyDictionary;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusIO;
import ventus.legacy.v0000.data.schematics.FloorSort;

public class VentusOIS
extends ObjectInputStream {
    private static final Logger LOGGER = Logger.getLogger(VentusOIS.class.getName());
    private final int d_version;
    private String d_revision;
    private final TeciIO d_teciio;
    private final LegacyDictionary d_classLookup;
    private final WarningReport<Warning> d_warnings;
    private final Collection<IInputStreamFeatureHandler> d_featureHandlers;
    private final boolean d_resetResultsIds;
    public static final DecisionMaker DM_DEFAULT = new DecisionMaker();

    public VentusOIS(InputStream in, boolean resetResultsIds, Collection<IInputStreamFeatureHandler> helpers) throws IOException {
        super(in);
        int version;
        this.d_featureHandlers = helpers;
        this.d_resetResultsIds = resetResultsIds;
        this.d_version = version = this.readInt();
        this.d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
        int teciver = this.readInt();
        this.d_teciio = new TeciIO(teciver);
        try {
            this.d_revision = (String)this.readObject();
        }
        catch (ClassNotFoundException e) {
            assert (false);
            this.d_revision = "";
        }
        this.enableResolveObject(true);
        this.d_classLookup = this.initLegDictionary(version);
    }

    public static int getVersion(ObjectInputStream is) {
        return is instanceof VentusOIS ? ((VentusOIS)is).getVersion() : Integer.MAX_VALUE;
    }

    public static boolean isPrior(ObjectInputStream is, VentusIO.Version version) {
        return VentusOIS.getVersion(is) < version.num;
    }

    public static boolean isVersion(ObjectInputStream is, VentusIO.Version version) {
        return VentusOIS.getVersion(is) == version.num;
    }

    public static boolean isLater(ObjectInputStream is, VentusIO.Version version) {
        return VentusOIS.getVersion(is) > version.num;
    }

    public static boolean isSameOrLater(ObjectInputStream is, VentusIO.Version version) {
        return VentusOIS.getVersion(is) >= version.num;
    }

    public static boolean isBetween(ObjectInputStream is, VentusIO.Version version1Inc, VentusIO.Version version2NInc) {
        int version = VentusOIS.getVersion(is);
        return version1Inc.num <= version && version < version2NInc.num;
    }

    public boolean getResetResultsIds() {
        return this.d_resetResultsIds;
    }

    public WarningReport<Warning> getWarnings() {
        return this.d_warnings;
    }

    public boolean canOpenVersion() {
        return true;
    }

    public boolean isNewer() {
        return this.d_version > VentusIO.Version.curr().num;
    }

    public int getVersion() {
        return this.d_version;
    }

    public String getRevision() {
        return this.d_revision;
    }

    public VentusData readModel(DecisionMaker decisionMaker) throws IOException, ClassNotFoundException {
        LOGGER.log(Level.FINE, "Loading model (v " + this.d_version + ") " + this.d_revision + "...");
        if (!this.canOpenVersion()) {
            throw new IOException(String.format(Intl.intl("[%s] Unsupported model version."), this.getClass().getName()));
        }
        VentusData vd = (VentusData)this.readObject();
        boolean modified = false;
        for (IInputStreamFeatureHandler handler : this.d_featureHandlers) {
            modified |= handler.applyAlwaysFirstUpdates(decisionMaker, this.getWarnings(), vd);
        }
        ChangeTracker changes = new ChangeTracker();
        for (VentusIO.Version version : VentusIO.Version.values()) {
            for (IInputStreamFeatureHandler handler : this.d_featureHandlers) {
                modified |= handler.applyVersionUpdates(version.num, this.d_version, decisionMaker, changes, this.getWarnings(), vd);
            }
        }
        for (IInputStreamFeatureHandler handler : this.d_featureHandlers) {
            modified |= handler.applyAlwaysPostUpdates(decisionMaker, this.getWarnings(), vd);
        }
        vd.modified = modified;
        return vd;
    }

    private void addWarning(String warning, String actionTaken) {
        this.d_warnings.addWarning(new Warning(warning, actionTaken));
    }

    private LegacyDictionary initLegDictionary(int version) {
        LegacyDictionary ld = new LegacyDictionary(version);
        this.d_featureHandlers.forEach(handler -> handler.registerLegacyClass(ld));
        TriConsumer<VentusIO.Version, String, Class> add = (versionOfChange, legClass, newClass) -> ld.addLegClass(versionOfChange.num, (String)legClass, (Class)newClass);
        add.accept(VentusIO.Version.VER_ALPHA, "ventus.data.schematics.FloorSort", FloorSort.class);
        return ld;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        String name = osc.getName();
        Class clazz = this.d_classLookup.resolveClass(name);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.d_teciio.resolveClass(osc);
        if (clazz != null) {
            return clazz;
        }
        return super.resolveClass(osc);
    }

    @Override
    protected Object resolveObject(Object obj) {
        List resolver = this.d_featureHandlers.stream().filter(handler -> handler.isResolveObject(this.getVersion(), obj)).collect(Collectors.toList());
        assert (resolver.size() <= 1);
        if (!resolver.isEmpty()) {
            return ((IInputStreamFeatureHandler)resolver.getFirst()).getResolveObject(obj);
        }
        return this.d_teciio.resolveObject(obj);
    }

    public static <T extends ICompElement> void findAndReplaceComposites(Composite<T> root, Function<String, Composite<T>> compFactory) {
        ArrayList<Composite> removeList = new ArrayList<Composite>();
        ArrayList<Composite<T>> addList = new ArrayList<Composite<T>>();
        for (IMerlinObj child : root.getChildren()) {
            if (!(child instanceof Composite)) continue;
            Composite childComp = (Composite)child;
            Composite<T> newNode = compFactory.apply(((Composite)child).getName());
            newNode.addAll(childComp.getMembers());
            removeList.add(childComp);
            addList.add(newNode);
            VentusOIS.findAndReplaceComposites(newNode, compFactory);
        }
        root.removeAll(removeList);
        root.addAll(addList);
    }

    public static class DecisionMaker {
    }

    public static class ChangeTracker {
        public final Map<Integer, Collection<ICompElement>> changeObjs = new HashMap<Integer, Collection<ICompElement>>();
    }
}

