/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui.value;

import java.awt.Dimension;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.data.value.Schedule;

public class ScheduleEditorPnl
extends guiPanel {
    private static final long serialVersionUID = 1L;
    private final guiFormattedFld<UnitDouble> d_initValFld;
    private final Unit d_valUnit;
    private final guiComboBox<Schedule.ScheduleType> d_shapeCB;
    private final guiTable d_table;

    protected ScheduleEditorPnl(IUnitSrc timeUnit, ValueField<UnitDouble> valFld) {
        String[] headers = new String[]{Intl.intl("Time"), Intl.intl("Value")};
        guiTableEditor ed = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{UnitDouble.class, UnitDouble.class}), 30);
        this.d_table = ed.getTable();
        this.d_table.setNullValuesAllowed(false);
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(timeUnit.getUnit(), time -> time.get(NonSI.HOUR) <= 24.0, false));
        this.d_initValFld = valFld;
        this.d_valUnit = ((UnitDoubleFormat)this.d_initValFld.getFormat()).getUnitType().getUnit();
        this.d_table.getColumnModel().getColumn(1).setCellEditor(new guiTable.UnitDoubleEditor(this.d_valUnit));
        this.d_shapeCB = guiUtil.newCombo(shape -> new Pair<String, Object>(shape.name, null), Arrays.stream(Schedule.ScheduleType.values()).filter(shape -> shape.hasEntries).collect(Collectors.toList()));
        this.d_table.autoSizeColumns(500);
        this.d_table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.d_table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, Math.min(500, this.d_table.getPreferredSize().height)));
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(Intl.intl("Initial Value:"), this.d_initValFld);
        gb.addRow(Intl.intl("Shape:"), this.d_shapeCB);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Timed Values")));
        gb.addRow(ed, new double[]{1.0, 1.0}, new int[]{0, 1});
        gb.finalizeRows();
    }

    private UnitDouble getValue(int row) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        Object val = model.getValueAt(row, 1);
        return (UnitDouble)val;
    }

    private void setValue(int row, UnitDouble value) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        model.setValueAt(value, row, 1);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        Predicate<UnitDouble> filter = this.d_initValFld.getFilter();
        if (filter != null) {
            int col = 1;
            int numRows = this.d_table.getModel().getRowCount();
            for (int m = 0; m < numRows; ++m) {
                if (filter.test(this.getValue(m))) continue;
                if (showWarn) {
                    String msg = String.format(Intl.intl("Error in table at row %d, col %d:%n%s"), m + 1, col + 1, filter);
                    JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid Value"), 2);
                }
                return false;
            }
        }
        return true;
    }

    public void load(Schedule schedule) {
        if (schedule == null) {
            this.d_initValFld.setValue(null);
        } else {
            UnitDouble initValue = schedule.getInitialValue();
            Schedule.Entry[] entries = schedule.getEntries();
            this.d_initValFld.setValue(initValue);
            this.d_shapeCB.setSelectedItem((Object)schedule.type);
            guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
            for (int i = 0; i < entries.length; ++i) {
                Schedule.Entry entry = entries[i];
                model.setValueAt(entry.t, i, 0);
                this.setValue(i, entry.val.convert(this.d_valUnit));
            }
        }
        this.setModified(false);
    }

    public Schedule save() {
        UnitDouble initVal = this.d_initValFld.getValue();
        if (initVal == null) {
            return null;
        }
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int rows = model.getRowCount();
        List<Schedule.Entry> entries = new ArrayList<Schedule.Entry>(rows);
        for (int i = 0; i < rows; ++i) {
            UnitDouble val;
            UnitDouble t = (UnitDouble)model.getValueAt(i, 0);
            if (t == null || (val = this.getValue(i)) == null) continue;
            entries.add(new Schedule.Entry(t, val));
        }
        if (!entries.isEmpty() && ((Schedule.Entry)entries.getFirst()).t.equals(new UnitDouble(0.0, SI.SECOND))) {
            initVal = ((Schedule.Entry)entries.getFirst()).val;
            entries = entries.subList(1, entries.size());
        }
        Schedule.ScheduleType scheduleType = this.d_shapeCB.getSelectedItem();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TRAPEZOIDAL", "RECTANGULAR"}, (Schedule.ScheduleType)scheduleType, n)) {
            case 0 -> Schedule.newTrapezoidal(initVal, entries.toArray(new Schedule.Entry[0]));
            case 1 -> Schedule.newRectangular(initVal, entries.toArray(new Schedule.Entry[0]));
            default -> Schedule.newRectangular(initVal, entries.toArray(new Schedule.Entry[0]));
        };
    }
}

