/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import thunderheadeng.gui.dialogs.ShowObjectsDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import ventus.VentusApp;
import ventus.actions.MerlinOpImpl;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.gui.guiUtil;
import ventus.util.MerlinUtil;

public class ShowObjectsDlg
extends ShowObjectsDialog<IMerlinObj> {
    private static final long serialVersionUID = 1L;

    public ShowObjectsDlg(Window owner, VentusData md, String title, String undoDesc, Collection<? extends IMerlinObj> objs) {
        super(owner, title, ShowObjectsDlg.getCallback(md, undoDesc), objs);
    }

    private static ShowObjectsDialog.ICallback<IMerlinObj> getCallback(final VentusData vd, final String undoDesc) {
        return new ShowObjectsDialog.ICallback<IMerlinObj>(){

            @Override
            public Events getEvents() {
                return vd.getEvents();
            }

            @Override
            public boolean isSelectionEvent(IEventRecord<?> events) {
                return events.containsChange(VentusData.SELECTION_CHANGED);
            }

            @Override
            public boolean isDecorationEvent(IEventRecord<?> events) {
                return events.containsChange(NamedMerlinObj.NAME);
            }

            @Override
            public boolean isSelected(IMerlinObj obj) {
                return vd.selection.isSelected(obj);
            }

            @Override
            public void setSelection(ShowObjectsDialog<IMerlinObj> dlg, Collection<? extends IMerlinObj> objs) {
                MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                    try (VentusData.WriteLock lock = md.lockWrite();){
                        Undo.begin(undoDesc);
                        Undo.insertUndoEntry_restoreSelection(md);
                        md.selection.clear();
                        md.selection.selectAll(objs);
                        Undo.end(md);
                    }
                });
                UIHook.run(dlg, "ShowObjectsDlg.updateSelAction.valueChanged", op, 0);
            }

            @Override
            public void decorateCells(DefaultListCellRenderer r, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                guiUtil.decorateCellRenderer(vd, list::repaint, value, r, isSelected, cellHasFocus);
                r.setText(MerlinUtil.getName(value));
            }

            @Override
            public JPopupMenu getContextMenu(MouseEvent e) {
                return VentusApp.getApp().getContextMenu();
            }
        };
    }
}

