/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Window;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorOptions;
import ventus.gui.MerlinUDF;
import ventus.util.MerlinUtil;

public class NewFloorDlg
extends guiDialog {
    private static final long serialVersionUID = -867758707452381313L;
    private final MerlinUDF d_zlocFld = new MerlinUDF(0);
    private final guiCheckBox d_setActiveCB;
    private final guiCheckBox d_sortCompsCB;

    public NewFloorDlg(JFrame parent) {
        super((Window)parent, Intl.intl("New Level"), 9);
        this.d_zlocFld.setValue(this.predictNextFloorLoc());
        this.d_setActiveCB = new guiCheckBox(Intl.intl("Set as active level."));
        this.d_sortCompsCB = new guiCheckBox(Intl.intl("Resort existing schematics components into new level."));
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Enter level Location:"), this.d_zlocFld);
        gb.addRow(this.d_setActiveCB, 2);
        gb.addRow(this.d_sortCompsCB, 2);
        gb.finalizeRows();
    }

    private UnitDouble predictNextFloorLoc() {
        VentusData md = VentusApp.getApp().getData();
        UnitDouble defDist = md.floorOptions.get(FloorOptions.MIN_AUTO_FLOOR_DIST);
        if (md.floors.getMembers().size() == 1) {
            Floor existing = (Floor)md.floors.getMembers().iterator().next();
            UnitDouble loc = existing.getWorkingZ();
            return loc.add(defDist);
        }
        assert (md.floors.getMembers().size() > 1);
        Floor[] floors = md.floors.getMembers().toArray(new Floor[md.floors.getMembers().size()]);
        Arrays.sort(floors, Comparator.comparing(Floor::getWorkingZ));
        UnitDouble lastloc = floors[floors.length - 1].getWorkingZ();
        UnitDouble nextLastLoc = floors[floors.length - 2].getWorkingZ();
        UnitDouble newloc = lastloc.add(lastloc.sub(nextLastLoc));
        if (newloc.equals(lastloc)) {
            return lastloc.add(defDist);
        }
        return newloc;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        VentusData md = VentusApp.getApp().getData();
        UnitDouble loc = (UnitDouble)this.d_zlocFld.getValue();
        for (Floor floor : md.floors.getDeepMembers(Floor.class)) {
            if (!floor.getWorkingZ().equals(loc)) continue;
            if (showWarn) {
                String msg = String.format(Intl.intl("A level already exists at Z=%s."), MerlinUtil.format(loc, 0));
                String title = Intl.intl("Invalid Location");
                JOptionPane.showMessageDialog(this, msg, title, 0);
            }
            return false;
        }
        return true;
    }

    public void setFloorLoc(UnitDouble loc) {
        this.d_zlocFld.setValue(loc);
    }

    public void setAutoResort(boolean autoResort) {
        this.d_sortCompsCB.setSelected(autoResort);
    }

    public boolean setActive() {
        return this.d_setActiveCB.isSelected();
    }

    public UnitDouble getFloorLoc() {
        return (UnitDouble)this.d_zlocFld.getValue();
    }

    public boolean getAutoResort() {
        return this.d_sortCompsCB.isSelected();
    }
}

