/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.gui.SearchField;
import ventus.gui.guiUtil;
import ventus.gui.value.APopupValEditor;
import ventus.util.MerlinUtil;

public class DistributionEditor<T extends IMerlinObj>
extends APopupValEditor<IUrn<T>>
implements IEventObserver {
    private static final long serialVersionUID = 1L;
    private static final int SHOW_SEL_CROSSOVER = 10;
    private final VentusData d_data;
    private boolean d_modified = false;
    private final JEditorPane d_editor;
    private final String d_desc;
    private final Composite<? extends ICompElement> d_root;
    private final Class<T> d_clazz;
    private final Predicate<T> d_filter;
    private List<T> d_availObjs;
    private Function<VentusData, Collection<T>> d_getExtraObjs;

    public DistributionEditor(VentusData md, String desc, Composite<? extends ICompElement> root, Class<T> clazz, Predicate<T> availFilter) {
        super(IUrn.class);
        this.d_data = md;
        this.d_desc = desc;
        this.d_root = root;
        this.d_clazz = clazz;
        this.d_filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        this.d_editor = guiUtil.newHTMLLabel();
        this.d_editor.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && DistributionEditor.this.d_editor.isEnabled()) {
                    DistributionEditor.this.editValue();
                }
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        this.add(gb);
        gb.finalizeRows();
        this.d_data.getEvents().addObserver(this);
        this.updateAvailable();
        this.d_editor.setPreferredSize(new Dimension(160, this.d_editor.getPreferredSize().height));
        this.setValue(UrnUtil.newUrn(Collections.emptyMap()));
        this.updateAvailable();
        this.setModified(false);
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(this.d_editor, 1.0);
    }

    @Override
    public boolean editValue() {
        IUrn val = (IUrn)this.getValue();
        this.updateAvailable();
        boolean showSelDef = this.d_availObjs.size() > 10 && val != null && val.getWeights().values().stream().anyMatch(d -> d != 0.0);
        Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        DistDlg dlg = new DistDlg(parent, this.d_desc, this.d_root, this.d_getExtraObjs, showSelDef);
        this.applyButtonLabels(dlg);
        dlg.setAvailObjs(this.d_availObjs);
        dlg.setDistribution(val != null ? val.getWeights() : null);
        if (dlg.doModal() != 1) {
            return false;
        }
        this.setValue(UrnUtil.newUrn(dlg.getDistribution()));
        return true;
    }

    @Override
    public void update(Events events) {
        if (events.isAffected(this.d_clazz)) {
            this.updateAvailable();
        }
    }

    public void updateAvailable() {
        this.d_availObjs = this.getAllAvailableObjs();
        IUrn val = (IUrn)this.getValue();
        if (val != null && !this.d_availObjs.isEmpty()) {
            Map weights = val.getWeights();
            LinkedIdentityHashMap distribution = new LinkedIdentityHashMap(weights);
            distribution.keySet().retainAll(new IdentityHashSet<T>(this.d_availObjs));
            double total = DistributionEditor.sum(distribution.values());
            if (theUtil.lt(total, 1.0, 1.0E-6)) {
                assert (!this.d_availObjs.isEmpty());
                IMerlinObj firstObj = (IMerlinObj)this.d_availObjs.get(0);
                double fracForFirst = distribution.containsKey(firstObj) ? (Double)distribution.get(firstObj) : 0.0;
                double remain = 1.0 - (total -= fracForFirst);
                distribution.put(firstObj, remain);
            }
            this.setValue(UrnUtil.newUrn(distribution));
        }
        this.updateDesc();
    }

    public void setExtraObjs(Function<VentusData, Collection<T>> getExtraObjs) {
        this.d_getExtraObjs = getExtraObjs;
    }

    private static double sum(Collection<Double> values) {
        double total = 0.0;
        for (Double frac : values) {
            total += frac.doubleValue();
        }
        return total;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    private List<T> getAllAvailableObjs() {
        ArrayList<IMerlinObj> all = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : this.d_root.getDeepMembers(this.d_clazz)) {
            if (!this.d_filter.test(obj)) continue;
            all.add(obj);
        }
        Collections.sort(all, ObjSorter.INSTANCE);
        if (this.d_getExtraObjs != null) {
            ArrayList<T> allObjs = new ArrayList<T>(theUtil.filter(this.d_getExtraObjs.apply((VentusData)this.d_root.getDomain()), this.d_filter));
            allObjs.addAll(all);
            all = allObjs;
        }
        return all;
    }

    public List<T> getAvailable() {
        return this.d_availObjs;
    }

    public void setAvailable(List<T> avail) {
        this.d_availObjs = avail;
        this.updateDesc();
    }

    @Override
    public void loadValue(IUrn<T> value) {
        this.updateDesc();
    }

    @Override
    protected IUrn<T> saveValue() {
        return (IUrn)this.getValue();
    }

    protected void updateDesc() {
        boolean isShortened;
        Map dist;
        Object desc = null;
        Map map = dist = this.getValue() != null ? ((IUrn)this.getValue()).getWeights() : null;
        if (dist == null) {
            desc = Intl.intl("[mixed]");
        } else if (dist.isEmpty()) {
            desc = Intl.intl("[none]");
        } else if (dist.size() == 1) {
            desc = MerlinUtil.getName((IMerlinObj)dist.keySet().iterator().next());
        } else {
            ArrayList objList = new ArrayList(dist.keySet());
            Collections.sort(objList, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    double frac1 = (Double)dist.get(o1);
                    double frac2 = (Double)dist.get(o2);
                    int comp = Double.compare(frac2, frac1);
                    if (comp != 0) {
                        return comp;
                    }
                    comp = MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
                    return comp;
                }
            });
            desc = "";
            for (IMerlinObj obj : objList) {
                if (!((String)desc).isEmpty()) {
                    desc = (String)desc + "; ";
                }
                desc = (String)desc + String.format(Intl.intl("%.1f%% %s"), dist.get(obj) * 100.0, MerlinUtil.getName(obj));
            }
        }
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        Object displayDesc = guiUtil.shorten((String)desc, 150, fm);
        boolean bl = isShortened = !((String)displayDesc).equals(desc);
        if (this.d_availObjs.size() > 1 || dist != null && dist.isEmpty() && !this.d_availObjs.isEmpty()) {
            displayDesc = "<html><a href=\"blank\">" + (String)displayDesc + "</a></html>";
        }
        this.d_editor.setText((String)displayDesc);
        if (isShortened) {
            this.d_editor.setToolTipText((String)desc);
        } else {
            this.d_editor.setToolTipText(null);
        }
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.updateDesc();
    }

    private static class DistDlg<T extends IMerlinObj>
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private final guiTable d_table;
        private final Composite<? extends ICompElement> d_root;
        private final SearchField<T> d_searchFld;
        private final guiCheckBox d_showOnlyNonZero;
        private final guiCheckBox d_showPathBox;
        private final HTMLBtn d_showingCountLbl;
        private List<T> d_availObjs = Collections.emptyList();

        public DistDlg(Window parent, String desc, Composite<? extends ICompElement> root, final Function<VentusData, Collection<T>> getExtraObjs, boolean showOnlySelDef) {
            super(parent, desc, 9);
            this.d_root = root;
            this.d_searchFld = new SearchField<IMerlinObj>(() -> this.d_availObjs.stream(), obj -> this.format(obj));
            this.d_showOnlyNonZero = new guiCheckBox(Intl.intl("Display only non-zero rows"), showOnlySelDef);
            this.d_showOnlyNonZero.setToolTipText(Intl.intl("If checked, only rows with non-zero distributions are displayed. Uncheck to display all available rows."));
            this.d_showPathBox = new guiCheckBox(Intl.intl("Show group labels"), false);
            this.d_showPathBox.setToolTipText(Intl.intl("If checked, group labels are shown with the names of the objects."));
            this.d_showPathBox.addItemListener(e -> this.getModel().fireTableRowsUpdated(0, this.getModel().getAvailObjs().size() - 1));
            this.d_showOnlyNonZero.addActionListener(e -> {
                if (this.d_showOnlyNonZero.isSelected() && !this.d_searchFld.isEmpty()) {
                    this.d_searchFld.clear();
                } else {
                    this.updateTable();
                }
            });
            this.d_showingCountLbl = new HTMLBtn("");
            this.d_showingCountLbl.setToolTipText(Intl.intl("Click to display all."));
            this.d_showingCountLbl.addActionListener(e -> {
                this.d_showOnlyNonZero.setSelected(false);
                this.d_searchFld.clear();
                this.updateTable();
            });
            this.d_searchFld.addObserver((o, evt) -> {
                if (evt == SearchField.SHOW_ALL_MATCHES) {
                    this.d_showOnlyNonZero.setSelected(false);
                }
                this.updateTable();
            }, false);
            JButton evenDistBtn = new JButton(Intl.intl("Distribute Evenly..."));
            evenDistBtn.addActionListener(e -> this.distributeEvenly(evenDistBtn));
            JButton clearBtn = new JButton(Intl.intl("Clear..."));
            clearBtn.addActionListener(e -> this.clearDistribution(clearBtn));
            ObjTableModel tm = new ObjTableModel();
            this.d_table = new guiTable(tm, 0);
            this.d_table.setRowSelectionAllowed(true);
            this.d_table.setColumnSelectionAllowed(true);
            this.d_table.getColumnModel().getColumn(0).setHeaderValue(Intl.intl("%"));
            TableColumn objCol = this.d_table.getColumnModel().getColumn(1);
            objCol.setHeaderValue(desc);
            objCol.setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (getExtraObjs != null && ((Collection)getExtraObjs.apply((VentusData)d_root.getDomain())).contains(value)) {
                        comp.setFont(comp.getFont().deriveFont(2));
                    }
                    this.setText(this.format((IMerlinObj)value));
                    return comp;
                }
            });
            guiLabel countLbl = new guiLabel("test");
            countLbl.setFont(countLbl.getFont().deriveFont(1));
            this.d_table.getModel().addTableModelListener(e -> {
                String text;
                Color color = countLbl.getForeground();
                if (!this.d_table.validateData(false, false)) {
                    text = Intl.intl("Invalid table entry.");
                    color = Color.RED;
                } else {
                    double percent = this.getModel().getSumPercent();
                    text = String.format(Intl.intl("Total distribution: %.1f%%"), percent);
                    color = Color.BLACK;
                }
                countLbl.setText(text);
                countLbl.setForeground(color);
            });
            JScrollPane sp = new JScrollPane(this.d_table);
            sp.setPreferredSize(new Dimension(150, 120));
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addFilledRow(this.d_searchFld);
            gb.addRow(sp, new double[]{1.0, 1.0}, 0);
            gb.addFilledRow(countLbl);
            gb.addRow(clearBtn, evenDistBtn);
            gb.addFilledRow(this.d_showingCountLbl);
            gb.addRow(this.d_showOnlyNonZero, 0);
            gb.addRow(this.d_showPathBox, 0);
            this.d_table.autoSizeColumns();
            this.setResizable(true);
        }

        private ObjTableModel<T> getModel() {
            return (ObjTableModel)this.d_table.getModel();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            for (Map.Entry<T, Double> entry : this.getModel().getDistributions().entrySet()) {
                double val = entry.getValue();
                if (!(val < 0.0) && !(val > 1.0)) continue;
                if (showWarn) {
                    DistDlg.showInvalidEntryMessage(this, Intl.intl("Each percentage must be >= 0 and <= 100."));
                }
                return false;
            }
            double totalPercent = this.getModel().getSumPercent();
            if (!theUtil.eq(totalPercent, 100.0, 1.0E-6)) {
                if (showWarn) {
                    DistDlg.showInvalidEntryMessage(this, Intl.intl("The total distribution must add to 100%."));
                }
                return false;
            }
            return true;
        }

        private List<T> getSelectedItems() {
            int[] selRows = this.d_table.getSelectedRows();
            ArrayList<IMerlinObj> items = new ArrayList<IMerlinObj>(selRows.length);
            for (int selRow : selRows) {
                items.add((IMerlinObj)this.getModel().getAvailObjs().get(selRow));
            }
            return items;
        }

        private void getActionItems(Component c, List<Action> additionalActions, String selName, String visName, String allName, Consumer<Collection<T>> consumer) {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.addAll(additionalActions);
            if (this.d_table.getSelectedRowCount() > 0) {
                actions.add(new guiAction(selName, e -> consumer.accept(this.getSelectedItems())));
            }
            if (this.getModel().getAvailObjs().size() < this.d_availObjs.size()) {
                actions.add(new guiAction(visName, e -> consumer.accept(this.getModel().getAvailObjs())));
            }
            actions.add(new guiAction(allName, e -> consumer.accept(this.d_availObjs)));
            if (actions.size() > 1) {
                JPopupMenu menu = new JPopupMenu();
                for (Action action : actions) {
                    menu.add(action);
                }
                menu.show(c, 0, c.getHeight());
            } else {
                ((Action)actions.get(0)).actionPerformed(null);
            }
        }

        private void distributeEvenly(Component c) {
            ArrayList<Action> additionalActions = new ArrayList<Action>();
            double sum = this.getModel().getSum();
            if (theUtil.lt(sum, 1.0, 1.0E-6) && sum > 0.0) {
                Consumer<Collection> distRemaining = items -> {
                    if (items.isEmpty()) {
                        return;
                    }
                    double dist = (1.0 - sum) / (double)items.size();
                    LinkedIdentityHashMap<T, Double> newVals = new LinkedIdentityHashMap<T, Double>(this.getModel().getDistributions());
                    for (IMerlinObj item : items) {
                        newVals.merge(item, dist, Double::sum);
                    }
                    this.getModel().setDistributions(newVals);
                };
                if (this.d_table.getSelectedRowCount() > 0) {
                    additionalActions.add(new guiAction(String.format(Intl.intl("Distribute remaining %.1f%% to selected rows"), (1.0 - sum) * 100.0), e -> distRemaining.accept(this.getSelectedItems())));
                }
                if (this.getModel().getAvailObjs().size() < this.d_availObjs.size()) {
                    additionalActions.add(new guiAction(String.format(Intl.intl("Distribute remaining %.1f%% to displayed rows"), (1.0 - sum) * 100.0), e -> distRemaining.accept(this.getModel().getAvailObjs())));
                }
            }
            this.getActionItems(c, additionalActions, Intl.intl("Distribute 100.0% to selected rows"), Intl.intl("Distribute 100.0% to displayed rows"), Intl.intl("Distribute 100.0% to all rows"), items -> {
                LinkedIdentityHashMap<IMerlinObj, Double> values = new LinkedIdentityHashMap<IMerlinObj, Double>();
                if (items.isEmpty()) {
                    this.getModel().setDistributions(Collections.emptyMap());
                    return;
                }
                double val = 1.0 / (double)items.size();
                for (IMerlinObj item : items) {
                    values.put(item, val);
                }
                this.getModel().setDistributions(values);
            });
        }

        private void clearDistribution(Component c) {
            this.getActionItems(c, Collections.emptyList(), Intl.intl("Clear selected rows"), Intl.intl("Clear displayed rows"), Intl.intl("Clear all rows"), items -> {
                if (items.isEmpty()) {
                    return;
                }
                LinkedIdentityHashMap<T, Double> dist = new LinkedIdentityHashMap<T, Double>(this.getModel().getDistributions());
                dist.keySet().removeAll(items instanceof Set ? items : new IdentityHashSet(items));
                this.getModel().setDistributions(dist);
            });
        }

        private String format(T mobj) {
            if (this.d_showPathBox.isSelected()) {
                return MerlinUtil.getNameWithBreadcrumbs(this.d_root, mobj);
            }
            return MerlinUtil.getName(mobj);
        }

        public void setAvailObjs(List<T> availObjs) {
            this.d_availObjs = availObjs;
            this.updateTable();
        }

        public void setDistribution(Map<T, Double> objs) {
            this.updateTable(objs);
        }

        public Map<T, Double> getDistribution() {
            return this.getModel().getDistributions();
        }

        private void updateTable() {
            Map<T, Double> objs = this.getModel().getDistributions();
            this.updateTable(objs);
        }

        private void updateTable(Map<T, Double> objs) {
            Predicate filter = this.d_showOnlyNonZero.isSelected() && objs != null ? o -> objs.getOrDefault(o, 0.0) != 0.0 : Predicates.alwaysTrue();
            filter = Predicates.and(filter, this.d_searchFld.getFilter());
            IFilteredCollection<T> availObjs = theUtil.filter(this.d_availObjs, filter);
            ObjTableModel<T> model = this.getModel();
            model.setAvailObjs(new ArrayList<T>(availObjs), objs != null ? objs : Collections.emptyMap());
            if (this.getModel().getAvailObjs().size() < this.d_availObjs.size()) {
                this.d_showingCountLbl.setText(String.format(Intl.intl("Displaying %1$d/%2$d rows"), this.getModel().getAvailObjs().size(), this.d_availObjs.size()));
                this.d_showingCountLbl.setVisible(true);
            } else {
                this.d_showingCountLbl.setVisible(false);
            }
        }

        private static class ObjTableModel<T>
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private List<T> d_availObjs;
            private Map<T, Double> d_distributions;

            public ObjTableModel() {
                this(Collections.emptyList(), Collections.emptyMap());
            }

            public ObjTableModel(List<T> availObjs, Map<T, Double> initSelObjs) {
                this.d_availObjs = availObjs;
                this.d_distributions = this.constructMap(initSelObjs);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Double.class;
                    }
                    case 1: {
                        return Object.class;
                    }
                }
                return super.getColumnClass(columnIndex);
            }

            private Map<T, Double> constructMap(Map<T, Double> initVal) {
                LinkedIdentityHashMap<T, Double> result = new LinkedIdentityHashMap<T, Double>(initVal.size());
                for (Map.Entry<T, Double> entry : initVal.entrySet()) {
                    if (entry.getValue() == 0.0) continue;
                    result.put(entry.getKey(), entry.getValue());
                }
                return result;
            }

            public void setAvailObjs(List<T> objs, Map<T, Double> distributions) {
                this.d_availObjs = objs;
                if (distributions != this.d_distributions) {
                    this.d_distributions = this.constructMap(distributions);
                }
                this.fireTableDataChanged();
            }

            public List<T> getAvailObjs() {
                return Collections.unmodifiableList(this.d_availObjs);
            }

            public Map<T, Double> getDistributions() {
                return Collections.unmodifiableMap(this.d_distributions);
            }

            public void setDistributions(Map<T, Double> distributions) {
                this.d_distributions = this.constructMap(distributions);
                if (!this.d_availObjs.isEmpty()) {
                    this.fireTableRowsUpdated(0, this.d_availObjs.size() - 1);
                }
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }

            @Override
            public int getRowCount() {
                return this.d_availObjs.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.d_distributions.getOrDefault(this.d_availObjs.get(rowIndex), 0.0) * 100.0;
                    }
                    case 1: {
                        return this.d_availObjs.get(rowIndex);
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        Double dval = (Double)aValue;
                        if (dval != null && dval != 0.0) {
                            this.d_distributions.put(this.d_availObjs.get(rowIndex), dval * 0.01);
                        } else {
                            this.d_distributions.remove(this.d_availObjs.get(rowIndex));
                        }
                        this.fireTableCellUpdated(rowIndex, columnIndex);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }

            public double getSumPercent() {
                return this.getSum() * 100.0;
            }

            public double getSum() {
                return this.d_distributions.values().stream().mapToDouble(d -> d).sum();
            }
        }
    }

    private static class ObjSorter<T extends IMerlinObj>
    implements Comparator<T> {
        public static final ObjSorter<IMerlinObj> INSTANCE = new ObjSorter();

        private ObjSorter() {
        }

        @Override
        public int compare(T o1, T o2) {
            return MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
        }
    }
}

