/*
 * Decompiled with CFR 0.152.
 */
package ventus.geom;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Pair;

public class PointEntityGeom
extends GeomGroup {
    private static final long serialVersionUID = 1L;
    public final Point3d location;
    public final double size;
    private static final CachedValue<Mesh> s_unitCube = new CachedValue();
    private static final CachedValue<Mesh> s_unitCubeOutline = new CachedValue();

    public PointEntityGeom(Point3d location, double size) {
        super(PointEntityGeom.generateGeoms(location, size));
        this.location = location;
        this.size = size;
    }

    public PointEntityGeom newPoint(Point3d loc) {
        return new PointEntityGeom(loc, this.size);
    }

    private static List<IGeom> generateGeoms(Point3d location, double size) {
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        ITransform xform = TransformUtil.translate(location);
        xform = xform.concatenate(TransformUtil.scale(size, size, size));
        geoms.add(PointEntityGeom.generateCube().transform(xform.getInfo(), 0));
        geoms.add(PointEntityGeom.generateCubeOutline().transform(xform.getInfo(), 0));
        return geoms;
    }

    private static Mesh generateCube() {
        return s_unitCube.get(() -> {
            Point3d[] verts = new Point3d[]{new Point3d(-0.5, -0.5, -0.5), new Point3d(0.5, -0.5, -0.5), new Point3d(0.5, 0.5, -0.5), new Point3d(-0.5, 0.5, -0.5), new Point3d(-0.5, -0.5, 0.5), new Point3d(0.5, -0.5, 0.5), new Point3d(0.5, 0.5, 0.5), new Point3d(-0.5, 0.5, 0.5)};
            int[] indices = new int[]{0, 1, 3, 3, 1, 2, 1, 5, 2, 2, 5, 6, 5, 4, 6, 6, 4, 7, 4, 0, 7, 7, 0, 3, 3, 2, 7, 7, 2, 6, 4, 5, 0, 0, 5, 1};
            return new Mesh(verts, indices, 2);
        });
    }

    private static Mesh generateCubeOutline() {
        return s_unitCubeOutline.get(() -> {
            Point3d[] verts = new Point3d[]{new Point3d(-0.5, -0.5, -0.5), new Point3d(0.5, -0.5, -0.5), new Point3d(0.5, 0.5, -0.5), new Point3d(-0.5, 0.5, -0.5), new Point3d(-0.5, -0.5, 0.5), new Point3d(0.5, -0.5, 0.5), new Point3d(0.5, 0.5, 0.5), new Point3d(-0.5, 0.5, 0.5)};
            int[] indices = new int[]{0, 1, 1, 2, 2, 3, 3, 0, 4, 5, 5, 6, 6, 7, 7, 4, 0, 4, 1, 5, 2, 6, 3, 7};
            return new Mesh(verts, indices, 1);
        });
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        return this.newPoint(Util3D.xform(ti.getMatrix(), this.location));
    }

    @Override
    public void generateManipHandles(Consumer<? super IHandle> handles) {
        handles.accept(new Handle(this));
    }

    protected static class Handle
    implements IHandle {
        private PointEntityGeom geom;

        public Handle(PointEntityGeom geom) {
            this.geom = geom;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj != null && obj.getClass().equals(this.getClass());
        }

        public int hashCode() {
            return 0x9F5D8152 ^ this.geom.location.hashCode();
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(this.geom);
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public Object modify(Point3d newLoc) {
            this.geom = this.geom.newPoint(newLoc);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }
}

