/*
 * Decompiled with CFR 0.152.
 */
package ventus.geom;

import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.Vertex;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ModelConstrictor {
    public static List<List<Point3d>> findConstrictionEdges(Model model, IEdgeClassifier ecfr, double searchDist) {
        if (searchDist == 0.0) {
            return Collections.EMPTY_LIST;
        }
        LinkedIdentityHashMap<Vertex, EdgeUse[]> constEdges = new LinkedIdentityHashMap<Vertex, EdgeUse[]>();
        for (Vertex v : model.getVerts()) {
            EdgeUse[] constriction = ModelConstrictor.getConstrictionEdges(v, ecfr);
            if (constriction == null) continue;
            constEdges.put(v, constriction);
        }
        if (constEdges.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Map<Face, Set<Face>> faceAdjMap = ModelConstrictor.constructAdjacencyMap(model, ecfr);
        List<List<Point3d>> constrictionEdges = searchDist > ModelConstrictor.getExtents(model.getBoundingBox()) ? ModelConstrictor.findMaxConstrictionEdges(model, faceAdjMap, constEdges, ecfr) : ModelConstrictor.findConstrictionEdges(model, faceAdjMap, constEdges, searchDist, ecfr);
        constrictionEdges = ModelConstrictor.cullLineSegs(constrictionEdges);
        return constrictionEdges;
    }

    private static double getExtents(AABox bounds) {
        return bounds.getMin().distance(bounds.getMax());
    }

    private static List<List<Point3d>> findConstrictionEdges(Model model, Map<Face, Set<Face>> faceAdjMap, Map<Vertex, EdgeUse[]> constVerts, double searchDist, IEdgeClassifier ecfr) {
        double searchDistSq = searchDist * searchDist;
        double zSearchDist = ModelConstrictor.calcMaxZSearchDist(model.getFaces(), searchDist);
        HashSet<Trace> traces = new HashSet<Trace>();
        ArrayList<List<Point3d>> constrictionEdges = new ArrayList<List<Point3d>>();
        for (Vertex v : constVerts.keySet()) {
            boolean is360;
            AABox bb = new AABox(v.loc.x - searchDist, v.loc.y - searchDist, v.loc.z - zSearchDist, v.loc.x + searchDist, v.loc.y + searchDist, v.loc.z + zSearchDist);
            List<Edge> nearEdges = model.findEdges(bb);
            List<Vertex> nearVerts = model.findVerts(bb);
            if (nearEdges.isEmpty() && nearVerts.isEmpty()) continue;
            EdgeUse[] edges = constVerts.get(v);
            boolean bl = is360 = edges.length == 0;
            if (!is360) {
                Vector2d tan1 = ModelConstrictor.getXYTangent(edges[0], 0.0);
                Vector2d tan2 = ModelConstrictor.getXYTangent(edges[1], 1.0);
                is360 = tan1.epsilonEquals(tan2, 1.0E-9);
            }
            Point2d v2d = ModelConstrictor.to2d(v.loc);
            for (Edge edge : nearEdges) {
                List<Point3d> linesegs;
                Trace trace;
                Point3d p;
                double dist2d;
                if (!ecfr.isSplitTarget(edge) || edges.length > 0 && (edge == edges[0].edge || edge == edges[1].edge) || !ModelConstrictor.areConnected(edge, v, faceAdjMap) || theUtil.eq(edge.v1.loc.x, edge.v2.loc.x, 1.0E-9) && theUtil.eq(edge.v1.loc.y, edge.v2.loc.y, 1.0E-9)) continue;
                Point3d p0 = edge.curve.get(0.0);
                Vector3d dir = Util3D.vector(edge.v1.loc, edge.v2.loc);
                double neart = Inter2D.nearestTOnLine(ModelConstrictor.to2d(p0), new Vector2d(dir.x, dir.y), v2d);
                if (Double.isNaN(neart = Util.clampTIfValid(neart, 0.0, 1.0, 1.0E-9)) || !theUtil.le(dist2d = ModelConstrictor.length2dsq(Arrays.asList(v.loc, p = Util3D.linePoint(p0, dir, neart))), searchDistSq, 1.0E-6) || !is360 && !ModelConstrictor.isBetween(v, edges[0], edges[1], p) || !traces.add(trace = new Trace(v.loc, p)) || (linesegs = ModelConstrictor.traceToBoundary(model, v, edge, p, ecfr)).isEmpty()) continue;
                constrictionEdges.add(linesegs);
            }
            for (Vertex vert : nearVerts) {
                List<Point3d> linesegs;
                Trace trace;
                double dist2d;
                if (vert == v || !constVerts.containsKey(vert) || !ModelConstrictor.areConnected(v, vert, faceAdjMap) || !theUtil.le(dist2d = ModelConstrictor.length2dsq(Arrays.asList(v.loc, vert.loc)), searchDistSq, 1.0E-6) || !is360 && !ModelConstrictor.isBetween(v, edges[0], edges[1], vert.loc) || !traces.add(trace = new Trace(v.loc, vert.loc)) || (linesegs = ModelConstrictor.traceToBoundary(model, v, null, vert.loc, ecfr)).isEmpty()) continue;
                constrictionEdges.add(linesegs);
            }
        }
        return constrictionEdges;
    }

    private static double calcMaxZSearchDist(Collection<Face> faces, double xySearchDist) {
        double maxZDist = 0.0;
        for (Face face : faces) {
            Vector3d normal = face.plane.getNormal();
            double d = theUtil.eq0(normal.z, 1.0E-9) ? ModelConstrictor.calcVerticalZSearchDist(face) : xySearchDist * Math.sqrt(normal.x * normal.x + normal.y * normal.y) / normal.z;
            double dist = d;
            if (!(dist > maxZDist)) continue;
            maxZDist = dist;
        }
        return maxZDist;
    }

    private static double calcVerticalZSearchDist(Face vertFace) {
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        IdentityHashSet closed = new IdentityHashSet();
        open.push(vertFace);
        closed.add(vertFace);
        double minZ = Double.MAX_VALUE;
        double maxZ = -1.7976931348623157E308;
        while (!open.isEmpty()) {
            Face f = (Face)open.pop();
            AABox bounds = f.getBounds();
            if (bounds.getMinZ() < minZ) {
                minZ = bounds.getMinZ();
            }
            if (bounds.getMaxZ() > maxZ) {
                maxZ = bounds.getMaxZ();
            }
            for (FaceLoop loop : f.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    for (Face adjFace : eu.edge.faces) {
                        if (!closed.add(adjFace) || !theUtil.eq0(adjFace.plane.z, 1.0E-9)) continue;
                        open.push(adjFace);
                    }
                }
            }
        }
        return minZ < maxZ ? maxZ - minZ : 0.0;
    }

    private static List<List<Point3d>> findMaxConstrictionEdges(Model model, Map<Face, Set<Face>> faceAdjMap, Map<Vertex, EdgeUse[]> constrictionVerts, IEdgeClassifier ecfr) {
        RTree<Vertex> constVertTree = new RTree<Vertex>();
        for (Vertex v : constrictionVerts.keySet()) {
            constVertTree.insert(new AABox(v.loc), v);
        }
        ArrayList foundVerts = new ArrayList();
        CollResult findResult = new CollResult(foundVerts);
        LinkedIdentityHashMap<Vertex, ArrayList<Edge>> vertNearEdgeMap = new LinkedIdentityHashMap<Vertex, ArrayList<Edge>>();
        for (Edge edge : model.getEdges()) {
            ITest<AABox> test;
            if (!ecfr.isBoundary(edge)) continue;
            double dx = edge.v2.loc.x - edge.v1.loc.x;
            double dy = edge.v2.loc.y - edge.v1.loc.y;
            boolean dx0 = theUtil.eq0(dx, 1.0E-9);
            boolean dy0 = theUtil.eq0(dy, 1.0E-9);
            if (dx0 && dy0) continue;
            if (dx0 || dy0) {
                AABox modelbb = model.getBoundingBox();
                AABox testbb = dx0 ? new AABox(modelbb.getMinX(), Math.min(edge.v1.loc.y, edge.v2.loc.y), modelbb.getMinZ(), modelbb.getMaxX(), Math.max(edge.v1.loc.y, edge.v2.loc.y), modelbb.getMaxZ()) : new AABox(Math.min(edge.v1.loc.x, edge.v2.loc.x), modelbb.getMinY(), modelbb.getMinZ(), Math.max(edge.v1.loc.x, edge.v2.loc.x), modelbb.getMaxY(), modelbb.getMaxZ());
                test = new AABoxTest(testbb, 1.0E-6);
            } else {
                Vector3d vec = new Vector3d(-dx, -dy, 0.0);
                vec.normalize();
                Vector3d tolvec = new Vector3d(vec.x * 1.0E-9, vec.y * 1.0E-9, 0.0);
                Plane3d plane1 = new Plane3d(vec, Util3D.add(edge.v1.loc, (Tuple3d)tolvec));
                vec.negate();
                tolvec.negate();
                Plane3d plane2 = new Plane3d(vec, Util3D.add(edge.v2.loc, (Tuple3d)tolvec));
                test = new ConvexHull(plane1, plane2);
            }
            foundVerts.clear();
            constVertTree.find(test, findResult);
            for (Vertex vert : foundVerts) {
                if (!ModelConstrictor.areConnected(edge, vert, faceAdjMap)) continue;
                ArrayList<Edge> nearEdges = (ArrayList<Edge>)vertNearEdgeMap.get(vert);
                if (nearEdges == null) {
                    nearEdges = new ArrayList<Edge>(2);
                    vertNearEdgeMap.put(vert, nearEdges);
                }
                nearEdges.add(edge);
            }
        }
        ArrayList<List<Point3d>> constrictionEdges = new ArrayList<List<Point3d>>();
        for (Map.Entry entry : vertNearEdgeMap.entrySet()) {
            boolean is360;
            Vertex v = (Vertex)entry.getKey();
            List nearEdges = (List)entry.getValue();
            EdgeUse[] edges = constrictionVerts.get(v);
            boolean bl = is360 = edges.length == 0;
            if (!is360) {
                Vector2d tan1 = ModelConstrictor.getXYTangent(edges[0], 0.0);
                Vector2d tan2 = ModelConstrictor.getXYTangent(edges[1], 1.0);
                is360 = tan1.epsilonEquals(tan2, 1.0E-9);
            }
            Point2d v2d = ModelConstrictor.to2d(v.loc);
            for (Edge edge : nearEdges) {
                List<Point3d> linesegs;
                Point3d p0 = edge.curve.get(0.0);
                Vector3d dir = edge.curve.getTangent(0.0);
                double neart = Inter2D.nearestTOnLine(ModelConstrictor.to2d(p0), new Vector2d(dir.x, dir.y), v2d);
                Point3d p = Util3D.linePoint(p0, dir, neart);
                if (!is360 && !ModelConstrictor.isBetween(v, edges[0], edges[1], p) || (linesegs = ModelConstrictor.traceToBoundary(model, v, edge, p, ecfr)).isEmpty()) continue;
                constrictionEdges.add(linesegs);
            }
        }
        return constrictionEdges;
    }

    private static boolean areConnected(Edge edge, Vertex vert, Map<Face, Set<Face>> adjMap) {
        for (Face face1 : edge.faces) {
            Set<Face> adjFaces = adjMap.get(face1);
            for (Edge e2 : vert.edges) {
                for (Face face2 : e2.faces) {
                    if (face1 != face2 && !adjFaces.contains(face2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean areConnected(Vertex vert1, Vertex vert2, Map<Face, Set<Face>> adjMap) {
        for (Edge e1 : vert1.edges) {
            if (!ModelConstrictor.areConnected(e1, vert2, adjMap)) continue;
            return true;
        }
        return false;
    }

    private static Map<Face, Set<Face>> constructAdjacencyMap(Model model, IEdgeClassifier ecfr) {
        if (model.getFaces().isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        LinkedIdentityHashMap<Face, Set<Face>> result = new LinkedIdentityHashMap<Face, Set<Face>>();
        for (Face face : model.getFaces()) {
            if (result.containsKey(face)) continue;
            ArrayDeque<Face> open = new ArrayDeque<Face>();
            LinkedIdentityHashSet closed = new LinkedIdentityHashSet();
            open.push(face);
            closed.add(face);
            while (!open.isEmpty()) {
                Face curr = (Face)open.pop();
                for (FaceLoop loop : curr.edgeLoops) {
                    for (EdgeUse eu : loop.edges) {
                        if (ecfr.isBoundary(eu.edge)) continue;
                        for (Face adj : eu.edge.faces) {
                            if (!closed.add(adj)) continue;
                            open.push(adj);
                        }
                    }
                }
            }
            for (Face closedFace : closed) {
                result.put(closedFace, closed);
            }
        }
        return result;
    }

    private static List<List<Point3d>> cullLineSegs(List<List<Point3d>> allLineSegs) {
        RTree<List<Point3d>> lsTree = new RTree<List<Point3d>>();
        for (List<Point3d> ls : allLineSegs) {
            AABox bounds = ModelConstrictor.bounds(ls);
            lsTree.insert(bounds, ls);
        }
        ArrayList lsSearchList = new ArrayList();
        CollResult searchResult = new CollResult(lsSearchList);
        Pair[] sortedLines = new Pair[allLineSegs.size()];
        for (int m = 0; m < allLineSegs.size(); ++m) {
            double len = ModelConstrictor.length2dsq(allLineSegs.get(m));
            sortedLines[m] = new Pair<Double, List<Point3d>>(len, allLineSegs.get(m));
        }
        Arrays.sort(sortedLines, new Comparator<Pair<Double, List<Point3d>>>(){

            @Override
            public int compare(Pair<Double, List<Point3d>> o1, Pair<Double, List<Point3d>> o2) {
                return ((Double)o1.v1).compareTo((Double)o2.v1);
            }
        });
        IdentityHashSet culledLS = new IdentityHashSet();
        ArrayList<List<Point3d>> result = new ArrayList<List<Point3d>>(allLineSegs.size());
        for (int m = 0; m < sortedLines.length; ++m) {
            Pair ls1 = sortedLines[m];
            if (!culledLS.add((List)ls1.v2)) continue;
            lsSearchList.clear();
            lsTree.find(new AABoxTest(ModelConstrictor.bounds((List)ls1.v2), 1.0E-6), searchResult);
            for (List ls2 : lsSearchList) {
                if (ls2 == ls1.v2 || !ModelConstrictor.intersect((List)ls1.v2, ls2)) continue;
                culledLS.add(ls2);
            }
            result.add((List)ls1.v2);
        }
        return result;
    }

    private static AABox bounds(List<Point3d> ls) {
        AABox bounds = new AABox();
        for (int m = 0; m < ls.size(); ++m) {
            bounds.add(ls.get(m));
        }
        return bounds;
    }

    private static boolean intersect(List<Point3d> ls1, List<Point3d> ls2) {
        for (int m = 0; m < ls1.size() - 1; ++m) {
            Point3d l1a = ls1.get(m);
            Point3d l1b = ls1.get(m + 1);
            for (int n = 0; n < ls2.size() - 1; ++n) {
                Point3d l2b;
                Point3d l2a = ls2.get(n);
                double[] isect = Inter3D.getLineSegLineSegIntersection(l1a, l1b, l2a, l2b = ls2.get(n + 1), 1.0E-6, 1.0E-6);
                if (isect == null || m == 0 && theUtil.eq0(isect[0], 1.0E-6) || m == ls1.size() - 2 && theUtil.eq(isect[0], 1.0, 1.0E-6) || n == 0 && theUtil.eq0(isect[1], 1.0E-6) || n == ls2.size() - 2 && theUtil.eq(isect[1], 1.0, 1.0E-6)) continue;
                return true;
            }
        }
        return false;
    }

    private static double length2dsq(List<Point3d> ls) {
        if (ls.size() < 2) {
            return 0.0;
        }
        Point3d p1 = ls.get(0);
        Point3d p2 = ls.get(ls.size() - 1);
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        return dx * dx + dy * dy;
    }

    private static boolean isBetween(Vertex v, EdgeUse eu1, EdgeUse eu2, Point3d p) {
        double dx = p.x - v.loc.x;
        double dy = p.y - v.loc.y;
        Vector2d tan1 = ModelConstrictor.getXYTangent(eu1, 0.0);
        double angle1 = Util2D.sAngle(tan1.x, tan1.y, dx, dy);
        if (angle1 < 0.0) {
            angle1 += Math.PI * 2;
        }
        if (theUtil.eq0(angle1, 1.0E-9)) {
            return false;
        }
        Vector2d tan2 = ModelConstrictor.getXYTangent(eu2, 1.0);
        double angle2 = Util2D.sAngle(tan1.x, tan1.y, tan2.x, tan2.y);
        if (angle2 < 0.0) {
            angle2 += Math.PI * 2;
        }
        return theUtil.lt(angle1, angle2, 1.0E-9);
    }

    private static Vector2d getXYTangent(EdgeUse eu, double t) {
        Vector3d tan = eu.getTangent(t);
        if (t == 1.0) {
            tan.negate();
        }
        return new Vector2d(tan.x, tan.y);
    }

    private static String toString(EdgeUse[] eu) {
        Object str = "{";
        for (int m = 0; m < eu.length; ++m) {
            str = (String)str + "EdgeUse: " + eu[m].v1().toString() + "->" + eu[m].v2().toString();
            if (m == eu.length - 1) continue;
            str = (String)str + ", ";
        }
        str = (String)str + "}";
        return str;
    }

    private static EdgeUse[] getConstrictionEdges(Vertex v, IEdgeClassifier ecfr) {
        if (!ModelConstrictor.isBoundaryVert(v, ecfr)) {
            return null;
        }
        boolean verticalFaces = false;
        boolean planarFaces = false;
        for (Edge edge : v.edges) {
            for (Face f : edge.faces) {
                if (theUtil.eq0(f.plane.z, 1.0E-9)) {
                    verticalFaces = true;
                } else {
                    planarFaces = true;
                }
                if (!verticalFaces || !planarFaces) continue;
                break;
            }
            if (!verticalFaces || !planarFaces) continue;
            break;
        }
        if (!planarFaces) {
            return null;
        }
        if (verticalFaces) {
            return new EdgeUse[0];
        }
        ArrayList<EdgeUse> eus = new ArrayList<EdgeUse>();
        for (Edge edge : v.edges) {
            if (!ecfr.isBoundary(edge)) continue;
            for (Face face : edge.faces) {
                ModelConstrictor.getEdgeUses(face, edge, eus);
            }
        }
        if (eus.size() % 2 != 0) {
            return new EdgeUse[0];
        }
        ArrayList<Pair<EdgeUse, Double>> arrayList = new ArrayList<Pair<EdgeUse, Double>>(eus.size() / 2);
        ArrayList<Pair<EdgeUse, Double>> negEdgeAngles = new ArrayList<Pair<EdgeUse, Double>>(eus.size() / 2);
        Iterator<Face> iterator = eus.iterator();
        while (iterator.hasNext()) {
            EdgeUse edgeUse;
            EdgeUse testeu = edgeUse = (EdgeUse)((Object)iterator.next());
            if (edgeUse.v2() == v) {
                testeu = edgeUse.reverse();
            }
            Vector3d dir = testeu.getTangent(0.0);
            double xAngle = Util2D.sAngle(1.0, 0.0, dir.x, dir.y);
            Pair<EdgeUse, Double> edgeAngle = new Pair<EdgeUse, Double>(edgeUse, xAngle);
            if (edgeUse.v1() == v) {
                arrayList.add(edgeAngle);
                continue;
            }
            negEdgeAngles.add(edgeAngle);
        }
        if (arrayList.size() != negEdgeAngles.size()) {
            return new EdgeUse[0];
        }
        for (Pair pair : arrayList) {
            EdgeUse eu1 = (EdgeUse)pair.v1;
            EdgeUse eu2 = null;
            double angle1 = (Double)pair.v2;
            double minDiff = Double.MAX_VALUE;
            for (Pair pair2 : negEdgeAngles) {
                double angle2 = (Double)pair2.v2;
                double diff = angle2 - angle1;
                if (theUtil.lt0(diff, 1.0E-9)) {
                    diff += Math.PI * 2;
                }
                if (theUtil.eq0(diff, 1.0E-9)) {
                    diff = Math.PI * 2;
                }
                if (!(diff < minDiff)) continue;
                minDiff = diff;
                eu2 = (EdgeUse)pair2.v1;
            }
            if (!theUtil.gt(minDiff, Math.PI, 1.0E-9) || eu2 == null) continue;
            return new EdgeUse[]{eu1, eu2};
        }
        return null;
    }

    private static void getEdgeUses(Face f, Edge edge, List<EdgeUse> eus) {
        for (FaceLoop loop : f.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                if (eu.edge != edge) continue;
                eus.add(eu);
            }
        }
    }

    private static boolean isBoundaryVert(Vertex v, IEdgeClassifier ecfr) {
        for (Edge edge : v.edges) {
            if (!ecfr.isBoundary(edge)) continue;
            return true;
        }
        return false;
    }

    private static List<Point3d> traceToBoundary(Model model, Vertex v, Edge bedge, Point3d pOnEdge, IEdgeClassifier ecfr) {
        Vector3d dir = new Vector3d(pOnEdge.x - v.loc.x, pOnEdge.y - v.loc.y, 0.0);
        Point2d p12d = ModelConstrictor.to2d(v.loc);
        Point2d p22d = ModelConstrictor.to2d(pOnEdge);
        ArrayDeque<TraceNode> open = new ArrayDeque<TraceNode>();
        IdentityHashSet closed = new IdentityHashSet();
        IdentityHashSet closedEdges = new IdentityHashSet();
        for (Edge edge : v.edges) {
            for (Face face : edge.faces) {
                if (!closed.add(face)) continue;
                open.push(new TraceNode(null, face, v.loc, 0.0));
            }
        }
        Point2d e1 = new Point2d();
        Point2d e2 = new Point2d();
        EdgeTreeTest test = new EdgeTreeTest();
        while (!open.isEmpty()) {
            AbstractCollection potEdges;
            TraceNode node = (TraceNode)open.pop();
            Face face = node.face;
            if (theUtil.eq0(face.plane.z, 1.0E-9)) {
                potEdges = new LinkedIdentityHashSet();
                for (FaceLoop loop : face.edgeLoops) {
                    for (EdgeUse edgeUse : loop.edges) {
                        potEdges.add(edgeUse.edge);
                    }
                }
            } else {
                if (!test.set(face, node.p, pOnEdge)) continue;
                List<Edge> edges = model.findEdge(test);
                potEdges = new ArrayList();
                for (Edge e : edges) {
                    if (!e.faces.contains(face)) continue;
                    potEdges.add(e);
                }
            }
            double earlyIsect = 1.0;
            ArrayList<Pair<Edge, Double>> isects = new ArrayList<Pair<Edge, Double>>();
            for (Edge edge : potEdges) {
                if (ecfr.isInternal(edge) && edge.faces.size() < 2 || !closedEdges.add(edge)) continue;
                boolean isBoundary = ecfr.isBoundary(edge);
                ModelConstrictor.to2d(edge.curve.get(0.0), e1);
                ModelConstrictor.to2d(edge.curve.get(1.0), e2);
                double[] st = ModelConstrictor.isect(p12d, p22d, e1, e2);
                if (st == null || !theUtil.gt(st[0], 0.0, 1.0E-9) || !theUtil.ge(st[0], node.t, 1.0E-9) || !theUtil.le(st[0], earlyIsect, 1.0E-9)) continue;
                if (theUtil.eq(st[0], node.t, 1.0E-9) && !isBoundary && !theUtil.eq0(face.plane.z, 1.0E-9)) {
                    for (Face adjFace : edge.faces) {
                        if (!closed.add(adjFace)) continue;
                        open.push(new TraceNode(node, adjFace, node.p, node.t));
                    }
                    continue;
                }
                if (theUtil.lt(st[0], earlyIsect, 1.0E-9)) {
                    isects.clear();
                }
                earlyIsect = st[0];
                isects.add(new Pair<Edge, Double>(edge, st[1]));
            }
            if (isects.isEmpty()) continue;
            if (node.parent == null) {
                Point3d point3d = Util3D.linePoint(v.loc, dir, earlyIsect * 0.5);
                ModelConstrictor.projectAlongZ(point3d, point3d, face.plane);
                if (model.testPointOnFace((Face)face, (Point3d)point3d).outside) continue;
            }
            for (Pair pair : isects) {
                Point3d isectLoc = ((Edge)pair.v1).curve.get((Double)pair.v2);
                if (bedge != null && pair.v1 == bedge || bedge == null && pOnEdge.epsilonEquals(isectLoc, 1.0E-9)) {
                    TraceNode finalNode = new TraceNode(node, face, pOnEdge, 1.0);
                    return finalNode.toList();
                }
                if (ecfr.isBoundary((Edge)pair.v1)) continue;
                if (theUtil.gt0((Double)pair.v2, 1.0E-9) && theUtil.lt((Double)pair.v2, 1.0, 1.0E-9) && !ecfr.canSplit((Edge)pair.v1)) {
                    return Collections.EMPTY_LIST;
                }
                for (Face adjFace : ((Edge)pair.v1).faces) {
                    if (!closed.add(adjFace)) continue;
                    open.push(new TraceNode(node, adjFace, isectLoc, earlyIsect));
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static double[] isect(Point2d l1a, Point2d l1b, Point2d l2a, Point2d l2b) {
        double[] st = Inter2D.isectLineLine(l1a, Util2D.vector(l1a, l1b), l2a, Util2D.vector(l2a, l2b), 1.0E-12);
        if (st == null) {
            double vx = l1b.x - l1a.x;
            double vy = l1b.y - l1a.y;
            double distsq = Inter2D.distSqToNearestPtOnLine(l1a.x, l1a.y, vx, vy, l2a.x, l2a.y);
            if (theUtil.eq0(distsq, 1.0E-9)) {
                double t1 = Inter2D.nearestTOnLine(l1a.x, l1a.y, vx, vy, l2a.x, l2a.y);
                double t2 = Inter2D.nearestTOnLine(l1a.x, l1a.y, vx, vy, l2b.x, l2b.y);
                double t1l2 = 0.0;
                if (t2 < t1) {
                    double temp = t2;
                    t2 = t1;
                    t1 = temp;
                    t1l2 = 1.0;
                }
                if (theUtil.le(t1, 1.0, 1.0E-9) && theUtil.ge0(t2, 1.0E-9)) {
                    return new double[]{Math.max(0.0, t1), t1l2};
                }
            }
            return null;
        }
        if (!Util.clampTIfValid(st, 0.0, 1.0, 1.0E-9)) {
            return null;
        }
        return st;
    }

    private static void projectAlongZ(Point3d pOut, Point3d pIn, Plane3d plane) {
        if (plane.z == 0.0) {
            pOut.set(pIn);
            return;
        }
        double newz = -(plane.w + plane.x * pIn.x + plane.y * pIn.y) / plane.z;
        pOut.set(pIn.x, pIn.y, newz);
    }

    private static void to2d(Point3d p, Point2d p2d) {
        p2d.set(p.x, p.y);
    }

    private static Point2d to2d(Point3d p) {
        return new Point2d(p.x, p.y);
    }

    public static interface IEdgeClassifier {
        public boolean isBoundary(Edge var1);

        public boolean isInternal(Edge var1);

        public boolean canSplit(Edge var1);

        public boolean isSplitTarget(Edge var1);
    }

    private static class Trace {
        public final Point3d p1;
        public final Point3d p2;

        public Trace(Point3d p1, Point3d p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Trace)) {
                return false;
            }
            Trace trace = (Trace)obj;
            return this.p1.epsilonEquals(trace.p1, 1.0E-9) && this.p2.epsilonEquals(trace.p2, 1.0E-9) || this.p1.epsilonEquals(trace.p2, 1.0E-9) && this.p2.epsilonEquals(trace.p1, 1.0E-9);
        }

        public int hashCode() {
            return Util3D.round(this.p1, 6).hashCode() ^ Util3D.round(this.p2, 6).hashCode();
        }
    }

    private static class TraceNode {
        public final TraceNode parent;
        public final Face face;
        public final Point3d p;
        public final double t;

        public TraceNode(TraceNode parent, Face face, Point3d p, double t) {
            this.parent = parent;
            this.p = p;
            this.face = face;
            this.t = t;
        }

        public List<Point3d> toList() {
            ArrayList<Point3d> points = new ArrayList<Point3d>();
            TraceNode node = this;
            while (node != null) {
                points.add(node.p);
                node = node.parent;
            }
            return points;
        }
    }

    private static class EdgeTreeTest
    implements ITest<AABox> {
        public AABox bounds;
        public Point3d p1;
        public Point3d p2;
        public Vector3d dir;

        public boolean set(Face face, Point3d p1, Point3d p2) {
            AABox fbounds = face.getBounds();
            p1 = new Point3d(p1);
            ModelConstrictor.projectAlongZ(p1, p1, face.plane);
            p2 = new Point3d(p2);
            ModelConstrictor.projectAlongZ(p2, p2, face.plane);
            Vector3d dir = Util3D.vector(p1, p2);
            double[] isect = Inter3D.lineAABoxIsect(p1, dir, fbounds.getMin(), fbounds.getMax(), 1.0E-9);
            if (isect == null) {
                return false;
            }
            double mint = Math.max(0.0, isect[0]);
            double maxt = Math.min(1.0, isect[1]);
            this.p1 = Util3D.linePoint(p1, dir, mint);
            this.p2 = Util3D.linePoint(p1, dir, maxt);
            this.dir = Util3D.vector(this.p1, this.p2);
            if (this.p1.epsilonEquals(this.p2, 1.0E-9)) {
                this.bounds = new AABox(p1);
                return true;
            }
            Vector3d testVec = Util3D.normalize(this.dir);
            if (theUtil.eq(Math.abs(testVec.dot(GeomConstants.VEC3D_XPOS)), 1.0, 0.001) || theUtil.eq(Math.abs(testVec.dot(GeomConstants.VEC3D_YPOS)), 1.0, 0.001) || theUtil.eq(Math.abs(testVec.dot(GeomConstants.VEC3D_ZPOS)), 1.0, 0.001)) {
                this.bounds = new AABox();
                this.bounds.add(this.p1, this.p2);
            } else {
                this.bounds = null;
            }
            return true;
        }

        @Override
        public Containment test(AABox bb) {
            if (this.bounds != null) {
                return this.bounds.test(bb, 1.0E-9);
            }
            double[] isect = Inter3D.lineAABoxIsect(this.p1, this.dir, bb.getMin(), bb.getMax(), 1.0E-9);
            if (isect == null) {
                return Containment.OUTSIDE;
            }
            return theUtil.le(isect[0], 1.0, 1.0E-9) && theUtil.ge0(isect[1], 1.0E-9) ? Containment.INTERSECTS : Containment.OUTSIDE;
        }
    }
}

