/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.zone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.Events;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.CompElementActions;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.MerlinSelectionModel;
import ventus.data.RestorableProperties;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.data.value.Schedule;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.simparams.SimParamsProps;
import ventus.gui.value.ScheduleField;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;

public class ZoneRibbon
implements ISelectionRibbon {
    private final ArrayList<SelectionEditorPanel.EditorPanel> d_sections = new ArrayList();

    private void createSections() {
        this.d_sections.add(new RoomTypeSect());
        this.d_sections.add(new RoomPropSect());
    }

    @Override
    public boolean isEnabled(Set<Object> shared, Set<Object> unshared) {
        MerlinSelectionModel selection = Objects.requireNonNull(VentusApp.getAppData()).selection;
        return selection.isExclusive(SchematicRoom.class);
    }

    @Override
    public Collection<SelectionEditorPanel.EditorPanel> getSections() {
        if (this.d_sections.isEmpty()) {
            this.createSections();
        }
        return this.d_sections;
    }

    private static class RoomTypeSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -7690179246229293050L;
        private final guiComboBox<ISchematicRoom.Type> d_type = guiUtil.newCombo(t -> t == null ? new Pair<String, String>(Intl.intl("<mixed>"), null) : ventus.gui.guiUtil.encodeToHtmlLabel(t.name, t.desc), ISchematicRoom.Type.values());

        public RoomTypeSect() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Room Type:"), this.d_type);
            this.addConnection(new PropConnections.ComboPropConn<ISchematicRoom.Type>(new CompElementActions.DefProp(ISchematicRoom.TYPE), this.d_type));
        }
    }

    private static class RoomPropSect
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -7690179246229293050L;
        private final ScheduleField d_fldTemp = new ScheduleField("Temperature", 14);
        private final guiMultiStateCheckBox tempOverwrite = new guiMultiStateCheckBox(Intl.intl("Temperature:"));
        private final guiMultiStateCheckBox pressureOverwrite;

        public RoomPropSect() {
            LinkStatus.link((AbstractButton)this.tempOverwrite, this.d_fldTemp);
            this.pressureOverwrite = new guiMultiStateCheckBox(Intl.intl("Pressure:"));
            guiLabel pressureVariable = new guiLabel(Intl.intl("Variable"));
            LinkStatus.link((AbstractButton)this.pressureOverwrite, pressureVariable);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(this.tempOverwrite, this.d_fldTemp);
            gb.addRow(this.pressureOverwrite, pressureVariable);
            this.pressureOverwrite.setSelected(true);
            this.pressureOverwrite.setEnabled(false);
            pressureVariable.setEnabled(false);
            this.addConnection(new TempConne(this.d_fldTemp));
            this.addConnection(new PropConnections.BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(SchematicRoom.TEMP_DEFINEDLOCALLY), this.tempOverwrite));
        }

        private void updateState() {
            Collection<ICompElement> objs = this.getObjects();
            Object type = Composite.getProperty(ISchematicRoom.TYPE, objs);
            this.setVisible(type instanceof ISchematicRoom.Type && (ISchematicRoom.Type)((Object)type) == ISchematicRoom.Type.ZONE);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            super.bind(objs);
            this.updateState();
        }

        @Override
        public void update(Events events) {
            super.update(events);
            if (events.getEvents(ISchematicRoom.class, new Class[0]).hasChangedObjs()) {
                this.updateState();
            }
        }

        private class TempConne
        extends PropConnections.ScheduleProp {
            public TempConne(ScheduleField control) {
                super(new CompElementActions.DefProp<ICompElement, Schedule>(SchematicRoom.TEMPERATURE_SCHEDULE), control);
            }

            @Override
            public void update(Events events) {
                MerlinSelectionModel sel;
                Set room;
                if ((events.getEvents(VentusData.class, new Class[0]).containsChange(VentusData.SIM_PARAMS_CHANGED) || events.getEvents(SchematicRoom.class, new Class[0]).containsChange(VentusData.SELECTION_CHANGED)) && !((SchematicRoom)(room = (sel = Objects.requireNonNull(VentusApp.getAppData()).selection).getSelected(SchematicRoom.class)).iterator().next()).getTempDefinedLocally()) {
                    RestorableProperties simData = (RestorableProperties)VentusApp.getAppData().getComponentData("SimParams.data");
                    RoomPropSect.this.d_fldTemp.setValue(Schedule.newConstant(simData.get(SimParamsProps.defaultZoneTemp)));
                }
            }
        }
    }
}

