/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.windprofiles;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.PlotData;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.data.ICompElement;
import ventus.data.IRestorable;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.property.Function1dProp;
import ventus.data.value.IFunction1d;
import ventus.data.value.PiecewiseFunction1d;
import ventus.feature.tags.TagsUtil;

public class WindProfile
extends NamedMerlinObj
implements Serializable,
ICompElement,
IRestorable,
ISurrogate,
IDirectDependent<VentusData> {
    static final long serialVersionUID = 1L;
    public static final TypedProp<String> DESC = new TypedProp<String>((Object)"WindProfile.DESC", "");
    public static final PlotData EMPTY_PROFILE = WindProfile.getEmptyProfile();
    public static final IFunction1d WIND_PROFILE_FUNCTION = PiecewiseFunction1d.newFunction(EMPTY_PROFILE);
    public static final TypedProp<IFunction1d> FUNC = new TypedProp<IFunction1d>((Object)"WindProfile.FUNC", WIND_PROFILE_FUNCTION);
    public static final TypedProp<Boolean> IS_DEFAULT = new TypedProp<Boolean>((Object)"WindProfile.IS_DEFAULT", false);
    public static final TypedProp<CurveType> GRAPH_TYPE = new TypedProp<CurveType>((Object)"WindProfile.GRAPH_TYPE", CurveType.LINEAR);
    public static final Function1dProp PROP_FUNDAMENTAL = WindProfile.newFundamentalProp("WindProfile.FUNDAMENTAL", Intl.intl("Wind Profile"), Intl.intl("Description"), Intl.intl("Wind Profiles"), WIND_PROFILE_FUNCTION);
    public static final Set<Object> PROP_TYPES = new LinkedHashSet<Object>();
    private PropertySet d_properties = new PropertySet();

    private static Function1dProp newFundamentalProp(String name, String desc, String longDesc, String displayName, IFunction1d defFunction) {
        Function<Component, IFunction1d> f = comp -> defFunction;
        Function1dProp.PredefFunction[] predef = new Function1dProp.PredefFunction[]{new Function1dProp.PredefFunction(Intl.intl("wind profiles"), Intl.intl("Load default profile..."), f)};
        return new Function1dProp((Object)name, defFunction, desc, longDesc, displayName, new Function1dProp.Var(Intl.intl("Angle [deg]"), 10, UnitDoubleVR.between(0.0, 360.0, Unit.ONE, true, true)), new Function1dProp.Var(Intl.intl("Coefficient"), 10, UnitDoubleVR.between(-1.0, 1.0, Unit.ONE, true, true)), new UnitDouble[]{new UnitDouble(0.0, Unit.ONE), new UnitDouble(-1.0, Unit.ONE), new UnitDouble(360.0, Unit.ONE), new UnitDouble(1.0, Unit.ONE)}, predef);
    }

    public WindProfile(String name, String desc, IFunction1d func) {
        this.d_properties.set(NAME, name);
        this.d_properties.set(DESC, desc);
        this.d_properties.set(FUNC, func);
        this.d_properties.set(IS_DEFAULT, true);
    }

    public WindProfile(String name) {
        this.d_properties.set(NAME, name);
        this.d_properties.set(FUNC, WIND_PROFILE_FUNCTION);
        this.d_properties.set(IS_DEFAULT, false);
        this.d_properties.set(GRAPH_TYPE, CurveType.LINEAR);
    }

    public <T> T get(TypedProp<T> prop) {
        return this.d_properties.get(prop);
    }

    public <T> void set(TypedProp<T> prop, T value) {
        if (!PROP_TYPES.contains(prop)) {
            return;
        }
        this.pauseUpdates();
        this.d_properties.set(prop, value);
        this.changedEvt(prop);
        this.resumeUpdates();
    }

    @Override
    public String getName() {
        return (String)this.get(NAME);
    }

    @Override
    public void setName(String name) {
        this.set(NAME, name);
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (!(comparable instanceof WindProfile)) {
            return false;
        }
        if (this == comparable) {
            return true;
        }
        WindProfile other = (WindProfile)comparable;
        return other.getProperty(NAME).equals(this.getProperty(NAME));
    }

    public boolean isMatch(WindProfile other, Predicate<? super IPropertySet.Prop<?>> propFilter) {
        Predicate<IPropertySet.Prop> test = prop -> !propFilter.test((IPropertySet.Prop<?>)prop) || Objects.equals(other.getProperty(prop), this.getProperty(prop));
        return test.test(NAME) && test.test(DESC) && test.test(FUNC) && test.test(IS_DEFAULT) && test.test(GRAPH_TYPE);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof WindProfile)) {
            return;
        }
        WindProfile element = (WindProfile)obj;
        this.d_properties = element.d_properties;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        WindProfile element = (WindProfile)super.clone();
        element.d_properties = this.d_properties.clone();
        return element;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (!(property instanceof TypedProp)) {
            return;
        }
        this.set((TypedProp)property, value);
    }

    @Override
    public Object getProperty(Object property) {
        if (!(property instanceof TypedProp)) {
            return NOT_SUPPORTED;
        }
        return this.get((TypedProp)property);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        TypedProp<String> oldName = new TypedProp<String>((Object)"WindProfile.NAME", "");
        if (this.d_properties.isDefined(oldName)) {
            this.d_properties.set(NAME, this.d_properties.get(oldName));
            this.d_properties.remove(oldName);
        }
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (Collection)this.get(VentusData.TAGS));
    }

    @Override
    public void replaceDependency(VentusData md, Object old, Object replacement) {
        TagsUtil.replaceDependency(this, old, replacement);
    }

    private static PlotData getEmptyProfile() {
        return new PlotData(Unit.ONE, Unit.ONE, false, new double[]{0.0, 0.7, 90.0, -0.7, 180.0, -0.4, 270.0, -0.7, 360.0, 0.7});
    }

    static {
        PROP_TYPES.add(NamedMerlinObj.NAME);
        PROP_TYPES.add(DESC);
        PROP_TYPES.add(FUNC);
        PROP_TYPES.add(IS_DEFAULT);
        PROP_TYPES.add(GRAPH_TYPE);
        PROP_TYPES.add(VentusData.TAGS);
    }

    public static enum CurveType {
        LINEAR(Intl.intl("1-Linear"), Intl.intl("Linear"), 2, 1),
        CUBIC(Intl.intl("2-Cubic"), Intl.intl("Cubic Spline"), 3, 2),
        TRIG(Intl.intl("3-Trigonometric"), Intl.intl("Trigonometric"), 5, 3);

        public final String name;
        public final String desc;
        public final int minPointsReq;
        public final int prjLineType;

        private CurveType(String name, String desc, int p, int type) {
            this.name = name;
            this.desc = desc;
            this.minPointsReq = p;
            this.prjLineType = type;
        }
    }

    static enum Types {
        CURVE1(CurveType.LINEAR),
        CURVE2(CurveType.CUBIC),
        CURVE3(CurveType.TRIG);

        CurveType resolveAs;

        private Types(CurveType resolveAs) {
            this.resolveAs = resolveAs;
        }
    }
}

