/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.tags;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.Intl;
import ventus.actions.Undo;
import ventus.data.ICompElement;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsRoot;

public class TagsUtil {
    private static final RejectReservedPrefixes REJECT_RESERVED = new RejectReservedPrefixes("vt_");

    public static Set<String> tagsAsStrings(Set<Tag> tags) {
        return tags.stream().map(tag -> tag.getName()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Tag> getExistingTags(Set<String> tagIds, VentusData vd, Consumer<String> unconverted) {
        return TagsUtil.getTagsCustom(tagIds, vd, (existingTags, lowTagStr) -> {
            Tag existing = (Tag)existingTags.get(lowTagStr);
            if (existing == null) {
                unconverted.accept((String)lowTagStr);
            }
            return existing;
        });
    }

    public static LinkedHashSet<Tag> parse(String text, boolean allowEmpty, boolean allowPredefined, Set<String> predefinedTags) throws ParseException {
        List tags = Stream.of(text.split("[ ,;]+")).filter(Predicate.not(String::isBlank)).map(s -> new Tag(s.toLowerCase(Locale.ROOT))).collect(Collectors.toCollection(ArrayList::new));
        if (!allowEmpty && tags.isEmpty()) {
            throw new ParseException(Intl.intl("At least one tag must be specified."), 0);
        }
        return new LinkedHashSet<Tag>(tags);
    }

    public static String formatTags(Set<Tag> tags) {
        return TagsUtil.joinTags(" ", tags);
    }

    public static String joinTags(String delimeter, Set<Tag> tags) {
        return tags.stream().map(NamedMerlinObj::getName).collect(Collectors.joining(delimeter));
    }

    public static Set<Tag> getOrCreateTags(Set<String> tagIds, VentusData vd) {
        LinkedIdentityHashSet newTags = new LinkedIdentityHashSet();
        Set<Tag> result = TagsUtil.getTagsCustom(tagIds, vd, (existingTags, lowTagStr) -> {
            if (existingTags.containsKey(lowTagStr)) {
                return (Tag)existingTags.get(lowTagStr);
            }
            Tag newTag = new Tag((String)lowTagStr);
            newTags.add(newTag);
            return newTag;
        });
        if (!newTags.isEmpty()) {
            TagsRoot root = (TagsRoot)vd.getComponentData("Tags.data");
            Undo.InsertOp<Tag> op = new Undo.InsertOp<Tag>(root, newTags, root.getMembers().size());
            Undo.insertEntry(vd, op.perform());
        }
        return result;
    }

    private static Set<Tag> getTagsCustom(Set<String> tagIds, VentusData vd, BiFunction<Map<String, Tag>, String, Tag> convertTag) {
        TagsRoot root = (TagsRoot)vd.getComponentData("Tags.data");
        Map<String, Tag> existingTags = root.flatten(Tag.class).stream().collect(Collectors.toMap(tag -> tag.getName().toLowerCase(), tag -> tag));
        LinkedHashSet tags = tagIds.stream().map(String::toLowerCase).map(stag -> (Tag)convertTag.apply(existingTags, (String)stag)).filter(tag -> tag != null).collect(Collectors.toCollection(LinkedHashSet::new));
        return tags;
    }

    public static boolean replaceDependency(ICompElement obj, Object old, Object replacement) {
        return TagsUtil.replaceDependency(VentusData.TAGS, obj, old, replacement);
    }

    public static boolean replaceDependency(IPropertySet.Prop<Set<Tag>> tagsProp, ICompElement obj, Object old, Object replacement) {
        Set oldTags = obj.getProp(tagsProp).orElse(Collections.emptySet());
        if (oldTags.contains(old)) {
            Set<Object> newTags = new LinkedIdentityHashSet(oldTags);
            newTags.remove(old);
            if (replacement instanceof Tag) {
                Tag newTag = (Tag)replacement;
                newTags.add(newTag);
            }
            if (newTags.isEmpty()) {
                newTags = Collections.emptySet();
            } else if (newTags.size() == 1) {
                newTags = Collections.singleton((Tag)newTags.iterator().next());
            }
            obj.setProp(tagsProp, newTags);
            return true;
        }
        return false;
    }

    private static final class RejectReservedPrefixes
    implements Predicate<Tag> {
        private final HashSet<String> reservedPrefixes = new HashSet();

        public RejectReservedPrefixes(String ... reservedPrefixes) {
            this.reservedPrefixes.addAll(Arrays.asList(reservedPrefixes));
        }

        @Override
        public boolean test(Tag tag) {
            String lower = tag.toString().toLowerCase(Locale.ROOT);
            return this.reservedPrefixes.stream().noneMatch(lower::startsWith);
        }

        public String toString() {
            return String.format(Intl.intl("Tags must not start with \"%s\"."), String.join((CharSequence)",", this.reservedPrefixes));
        }
    }
}

