/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.tags;

import java.awt.Insets;
import java.util.Collection;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.GroupedSequence;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.CompElementActions;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.ICompElement;
import ventus.data.VentusData;
import ventus.feature.comps.INameRibbonPropProvider;
import ventus.feature.tags.MixedTagsAddOp;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsField;
import ventus.feature.tags.TagsUtil;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;

public class TagsRibbon
implements INameRibbonPropProvider {
    @Override
    public boolean isEnabled(Set<Object> shared, Set<Object> unshared) {
        return shared.contains(VentusData.TAGS);
    }

    @Override
    public void addPropAdders(GroupedSequence adders) {
        adders.add(5, TagsRibbon::addTagsProp);
    }

    private static void addTagsProp(SelectionEditorPanel.EditorPanel panel, GridBagHelper gb) {
        TagsField tagEditor = new TagsField();
        tagEditor.setRequestFocusOnFailedValidate(false);
        tagEditor.setColumns(10);
        panel.addConnection(new TagsPropConnection((Object)VentusData.TAGS, tagEditor));
        JButton addBtn = new JButton("+");
        addBtn.setToolTipText(Intl.intl("Adds tags to the selected objects. Tags are specified in a separate window."));
        addBtn.setMargin(new Insets(0, 0, 0, 0));
        addBtn.addActionListener(e -> UIHook.run(UIHook.getComponent(e), "Add Tags", MixedTagsAddOp.UI_HOOK_ADD.getMerOp(), 0));
        JButton remBtn = new JButton("-");
        remBtn.setToolTipText(Intl.intl("Removes tags from the selected objects. Tags are specified in a separate window."));
        remBtn.setMargin(new Insets(0, 0, 0, 0));
        remBtn.addActionListener(e -> UIHook.run(UIHook.getComponent(e), "Remove Tags", MixedTagsAddOp.UI_HOOK_REMOVE.getMerOp(), 0));
        gb.add(guiUtil.lbl(Intl.intl("Tags:"), Intl.intl("Defines labels that can be applied to the object to quickly find it later and group with like items.")));
        gb.add(tagEditor, 1.0);
        gb.colSpace = 2;
        gb.add(remBtn);
        gb.colSpace = 1;
        gb.add(addBtn);
        gb.nextRow();
    }

    private static class TagsPropConnection
    extends PropConnections.ASinglePropConnection<TagsField> {
        public TagsPropConnection(Object prop, TagsField control) {
            super(new CompElementActions.DefProp(prop), control);
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            control.getInputMap().remove(enter);
            control.addValueCommitListener(evt -> super.onControlChanged());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, TagsField comp) {
            Set tagStrings = (Set)comp.getValue();
            Undo.begin(Intl.intl("Set Tags"));
            VentusData vd = VentusApp.getApp().getData();
            Set<Tag> tagsToAssign = TagsUtil.getOrCreateTags(tagStrings, vd);
            CompElementActions.IObjectProp typedProp = (CompElementActions.IObjectProp)prop;
            typedProp.set(vd, objs, tagsToAssign);
            Undo.end(vd);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, TagsField comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(VentusApp.getApp().getData(), objs);
            if (val instanceof Set) {
                Set tagSet = (Set)val;
                comp.setTypedValue(TagsUtil.tagsAsStrings(tagSet));
            } else {
                comp.setValue(null);
            }
            comp.setModified(false);
        }
    }
}

