/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.species;

import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.feature.species.Species;

public class SpeciesRoot
extends Composite<Species> {
    static final long serialVersionUID = 1L;
    private NameGenerator d_nameGen = new NameGenerator(Intl.intl("Species"));

    public SpeciesRoot() {
        super(Intl.intl("Species"));
    }

    public void reset() {
        this.clear();
        this.d_nameGen.reset();
    }

    @Override
    public void restoreFrom(Object obj) {
        super.restoreFrom(obj);
        if (obj instanceof SpeciesRoot) {
            SpeciesRoot root = (SpeciesRoot)obj;
            this.d_nameGen = root.d_nameGen;
        }
    }

    public String nextName() {
        String name = this.d_nameGen.generateName();
        this.d_nameGen.registerName(name);
        return name;
    }

    public NameGenerator getNameGenerator() {
        return this.d_nameGen;
    }

    @Override
    public void add(ICompElement elem) {
        super.add(elem);
        this.d_nameGen.registerName(elem.getName());
    }

    @Override
    public Composite<Species> newGroup(String name) {
        return new SpeciesNode(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Species Group");
    }

    static class SpeciesNode
    extends Composite<Species> {
        private static final long serialVersionUID = 1L;

        public SpeciesNode(String name) {
            super(name);
        }

        @Override
        public Composite<Species> newGroup(String name) {
            return new SpeciesNode(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Species Group");
        }
    }
}

