/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.species;

import java.util.ArrayList;
import java.util.Map;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.species.Species;
import ventus.feature.species.SpeciesRoot;
import ventus.io.contamx.PrjData;

public class SpeciesPrjDataWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.BEFORE_NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        SpeciesRoot root = (SpeciesRoot)md.getComponentData("Species.data");
        ArrayList<Species> speciesList = new ArrayList<Species>(root.flatten(Species.class));
        for (int i = 0; i < speciesList.size(); ++i) {
            Species spec = (Species)speciesList.get(i);
            PrjData.Species prjSpecies = new PrjData.Species(spec);
            prjSpecies.name = spec.getName();
            prjSpecies.description = spec.get(Species.DESC);
            prjSpecies.nr = i + 1;
            prjSpecies.sflag = 1;
            prjSpecies.ntflag = spec.get(Species.TRACE_CONTAMINANT) == Species.TraceContaminant.NON_TRACE ? 1 : 0;
            prjSpecies.molwt = spec.get(Species.MOLAR_MASS).get(SI.KILOGRAM.divide(SI.KILO(SI.MOLE)));
            prjSpecies.mdiam = spec.get(Species.MEAN_DIAMETER).get(SI.METER);
            prjSpecies.edens = spec.get(Species.EFFECTIVE_DENSITY).get(SI.KILOGRAM.divide(SI.METER.pow(3)));
            prjSpecies.decay = spec.get(Species.DECAY_RATE).get(Unit.ONE.divide(SI.SECOND));
            prjSpecies.Dm = spec.get(Species.DIFFUSION_COEFFICIENT).get(SI.METER.pow(2).divide(SI.SECOND));
            prjSpecies.ccdef = spec.get(Species.DEFAULT_CONCENTRATION).get(SI.KILOGRAM.divide(SI.KILOGRAM));
            prjSpecies.Cp = spec.get(Species.SPECIFIC_HEAT).get(SI.JOULE.divide(SI.KILOGRAM.multiply(SI.KELVIN)));
            prjSpecies.Kuv = spec.get(Species.UVGI_SUSCEPTIBILITY_CONSTANT).get(SI.METER.pow(2).divide(SI.JOULE));
            prjSpecies.ucc = 0;
            prjSpecies.umd = 0;
            prjSpecies.ued = 0;
            prjSpecies.udm = 0;
            prjSpecies.ucp = 0;
            prjData.speciesList.add(prjSpecies);
            prjData.contaminantsList.add(prjSpecies.nr);
        }
        prjData.nspcs = prjData.speciesList.size();
        prjData.nctm = prjData.contaminantsList.size();
    }
}

