/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.species;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Delete;
import ventus.data.VentusData;
import ventus.feature.species.Species;
import ventus.feature.species.SpeciesData;
import ventus.feature.species.SpeciesEditor;
import ventus.feature.species.SpeciesManager;
import ventus.feature.species.SpeciesRoot;
import ventus.gui.ManagerDlg;
import ventus.unitsystem.UnitSystem;

public class SpeciesMgrDlg
extends ManagerDlg<Species, SpeciesManager> {
    private static final long serialVersionUID = 1L;
    private final JFrame d_owner;
    private final SpeciesEditor d_editor;
    private SpeciesManager d_manager;

    public SpeciesMgrDlg(JFrame owner, UnitSystem us) {
        super(owner, Intl.intl("Edit Species"), Species.class);
        this.d_owner = owner;
        this.d_editor = new SpeciesEditor(us);
        this.d_actions = new Action[]{this.newAction(Intl.intl("New..."), this::createNew), this.newAction(Intl.intl("Duplicate..."), this::duplicate), this.newAction(Intl.intl("Rename..."), this::renameSelected), this.newAction(Intl.intl("Delete..."), this::deleteSelected)};
        this.updateActions();
    }

    public void init(VentusData data, SpeciesManager manager, Species node) {
        super.init(data, manager, this.d_editor, this.d_actions);
        this.d_manager = manager;
        if (node == null) {
            this.getList().select(0);
        } else {
            this.getList().select(node);
        }
        this.d_editor.init((Species)this.getList().getSelectedItem());
    }

    private boolean nameExists(String name) {
        return this.d_manager.getRoot().flatten().stream().anyMatch(elem -> elem.getName().equalsIgnoreCase(name));
    }

    private boolean validateName(String existing, String name) {
        if (name.isEmpty() || name.isBlank()) {
            guiDialog.showInvalidEntryMessage(this, Intl.intl("Name must not be blank."));
            return false;
        }
        if (existing != null && existing.equals(name)) {
            return true;
        }
        if (this.nameExists(name)) {
            guiDialog.showInvalidEntryMessage(this, Intl.intl("A species with that name already exists."));
            return false;
        }
        return true;
    }

    public void createNew(ActionEvent event) {
        this.preSave();
        SpeciesRoot root = this.d_manager.getRoot();
        NameGenerator ng = root.getNameGenerator();
        final guiTextField nameField = new guiTextField(ng.generateValidName(Intl.intl("Species")));
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return SpeciesMgrDlg.this.validateName(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("New Species"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            root.add(new Species(nameField.getValue()));
            this.getList().updateModelView(this.d_manager);
        }
    }

    public void duplicate(ActionEvent event) {
        this.preSave();
        SpeciesRoot root = this.d_manager.getRoot();
        Species selected = (Species)this.getList().getSelectedItem();
        guiComboBox<Species> basedOnComboBox = new guiComboBox<Species>(this.d_manager.getSorted());
        basedOnComboBox.setSelectedItem(selected);
        final guiTextField nameField = new guiTextField();
        nameField.setText(root.getNameGenerator().generateValidName(selected.getName()));
        basedOnComboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 1 && !nameField.isModified()) {
                Species item = (Species)evt.getItem();
                nameField.setText(root.getNameGenerator().generateValidName(item.getName()));
            }
        });
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return SpeciesMgrDlg.this.validateName(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        namePanel.add((Component)new guiLabel(Intl.intl("Based On:")), "growx");
        namePanel.add(basedOnComboBox, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("Duplicate Species"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            String name = nameField.getValue();
            Species species = basedOnComboBox.getSelectedItem() != null ? basedOnComboBox.getSelectedItem().clone() : new Species(name);
            species.setName(name);
            root.add(species);
            this.getList().updateModelView(this.d_manager);
        }
    }

    public void renameSelected(ActionEvent event) {
        this.preSave();
        Species node = (Species)this.getList().getSelectedItem();
        String name = null;
        do {
            if ((name = (String)JOptionPane.showInputDialog(this, Intl.intl("Name:"), Intl.intl("Rename Species"), 3, SpeciesData.ICON, null, node.getName())) != null) continue;
            return;
        } while (!this.validateName(node.getName(), name));
        node.setName(name);
        this.getList().updateModelView(this.d_manager);
        this.d_editor.init(node);
    }

    public void deleteSelected(ActionEvent event) {
        Species node = (Species)this.getList().getSelectedItem();
        int selectedIndex = this.getList().getSelectedIx();
        Delete.DelStatus status = Delete.uiDelete(VentusApp.getApp(), this.getMerlinData(), Set.of(node), true);
        if (status.equals((Object)Delete.DelStatus.SUCCESS)) {
            this.getList().updateModelView(this.d_manager);
            this.getList().select(Math.max(0, selectedIndex - 1));
            Species selectedElement = (Species)this.getList().getSelectedItem();
            this.d_editor.init(selectedElement);
            if (selectedElement != null) {
                this.d_editor.getEditorPanel().setEnabled(true);
            }
        }
    }

    @Override
    public void updateActions() {
        Species item = (Species)this.getList().getSelectedItem();
        this.d_actions[0].setEnabled(this.d_manager != null);
        this.d_actions[1].setEnabled(this.d_manager != null && item != null);
        this.d_actions[2].setEnabled(this.d_manager != null && item != null);
        this.d_actions[3].setEnabled(this.d_manager != null && item != null);
    }

    public Action newAction(String name, ActionListener listener) {
        return new guiAction(name, listener);
    }
}

