/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.VentusApp;
import ventus.actions.CancelledException;
import ventus.actions.Delete;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.comps.DeleteHandler;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.species.Species;
import ventus.gui.MerlinComboBox;
import ventus.util.Dependencies;

public class SourceSinkElementSpeciesDeleteHandler
implements DeleteHandler {
    @Override
    public List<Delete.PropReplacement> getDeleteReplacments(Predicate<? super IMerlinObj> isDeleteObj, VentusApp app, VentusData vd) throws CancelledException {
        LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(vd, Species.class, isDeleteObj, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isDeleteObj);
        if (referencing.isEmpty()) {
            return List.of();
        }
        MerlinComboBox mcb = new MerlinComboBox(vd, Species.class, isDeleteObj.negate(), (IMerlinObj[])new Species[0]);
        Species repl = (Species)Delete.promptUserForReplacement(app, mcb, referenced);
        HashSet<SourceSinkElement> objsToChange = new HashSet<SourceSinkElement>(theUtil.filter(referencing, SourceSinkElement.class, obj -> obj.isSupportedLocally(SourceSinkElement.SPECIES)));
        return List.of(new Delete.PropReplacement(SourceSinkElement.SPECIES, objsToChange, repl));
    }
}

