/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Delete;
import ventus.data.VentusData;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.sourcesink.SourceSinkElementData;
import ventus.feature.sourcesink.SourceSinkElementEditor;
import ventus.feature.sourcesink.SourceSinkElementManager;
import ventus.feature.sourcesink.SourceSinkElementRoot;
import ventus.feature.species.Species;
import ventus.feature.species.SpeciesRoot;
import ventus.gui.ManagerDlg;
import ventus.unitsystem.UnitSystem;

public class SourceSinkElementMgrDlg
extends ManagerDlg<SourceSinkElement, SourceSinkElementManager> {
    private static final long serialVersionUID = 1L;
    private final JFrame d_owner;
    private final SourceSinkElementEditor d_editor;
    private SourceSinkElementManager d_manager;
    private final VentusData d_vd;

    public SourceSinkElementMgrDlg(JFrame owner, VentusData vd, UnitSystem us) {
        super(owner, Intl.intl("Edit Source/Sink Elements"), SourceSinkElement.class);
        this.d_owner = owner;
        this.d_editor = new SourceSinkElementEditor(vd, us);
        this.d_actions = new Action[]{this.newAction(Intl.intl("New..."), this::createNew), this.newAction(Intl.intl("Duplicate..."), this::duplicate), this.newAction(Intl.intl("Rename..."), this::renameSelected), this.newAction(Intl.intl("Delete..."), this::deleteSelected)};
        this.d_vd = vd;
        this.updateActions();
    }

    public void init(VentusData data, SourceSinkElementManager manager, SourceSinkElement node) {
        super.init(data, manager, this.d_editor, this.d_actions);
        this.d_manager = manager;
        if (node == null) {
            this.getList().select(0);
        } else {
            this.getList().select(node);
        }
        this.d_editor.init((SourceSinkElement)this.getList().getSelectedItem());
    }

    private boolean nameExists(String name) {
        return this.d_manager.getRoot().flatten().stream().anyMatch(elem -> elem.getName().equalsIgnoreCase(name));
    }

    private boolean validateName(String existing, String name) {
        if (name.isEmpty() || name.isBlank()) {
            guiDialog.showInvalidEntryMessage(this, Intl.intl("Name must not be blank."));
            return false;
        }
        if (existing != null && existing.equals(name)) {
            return true;
        }
        if (this.nameExists(name)) {
            guiDialog.showInvalidEntryMessage(this, Intl.intl("A source/sink element with that name already exists."));
            return false;
        }
        return true;
    }

    public void createNew(ActionEvent event) {
        this.preSave();
        SourceSinkElementRoot root = this.d_manager.getRoot();
        NameGenerator ng = root.getNameGenerator();
        final guiTextField nameField = new guiTextField(ng.generateValidName(Intl.intl("SourceSinkElement")));
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return SourceSinkElementMgrDlg.this.validateName(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("New Source/Sink Element"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            root.add(new SourceSinkElement(nameField.getValue(), this.getFirstSpecies()));
            this.getList().updateModelView(this.d_manager);
        }
    }

    private Species getFirstSpecies() {
        SpeciesRoot root = (SpeciesRoot)this.d_vd.getComponentData("Species.data");
        Collection<Species> speciesList = root.flatten(Species.class);
        if (speciesList.size() > 0) {
            return speciesList.iterator().next();
        }
        return null;
    }

    public void duplicate(ActionEvent event) {
        this.preSave();
        SourceSinkElementRoot root = this.d_manager.getRoot();
        SourceSinkElement selected = (SourceSinkElement)this.getList().getSelectedItem();
        guiComboBox<SourceSinkElement> basedOnComboBox = new guiComboBox<SourceSinkElement>(this.d_manager.getSorted());
        basedOnComboBox.setSelectedItem(selected);
        final guiTextField nameField = new guiTextField();
        nameField.setText(root.getNameGenerator().generateValidName(selected.getName()));
        basedOnComboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 1 && !nameField.isModified()) {
                SourceSinkElement item = (SourceSinkElement)evt.getItem();
                nameField.setText(root.getNameGenerator().generateValidName(item.getName()));
            }
        });
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return SourceSinkElementMgrDlg.this.validateName(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        namePanel.add((Component)new guiLabel(Intl.intl("Based On:")), "growx");
        namePanel.add(basedOnComboBox, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("Duplicate Source/Sink Element"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            String name = nameField.getValue();
            SourceSinkElement element = basedOnComboBox.getSelectedItem() != null ? basedOnComboBox.getSelectedItem().clone() : new SourceSinkElement(name, this.getFirstSpecies());
            element.setName(name);
            root.add(element);
            this.getList().updateModelView(this.d_manager);
        }
    }

    public void renameSelected(ActionEvent event) {
        this.preSave();
        SourceSinkElement node = (SourceSinkElement)this.getList().getSelectedItem();
        String name = null;
        do {
            if ((name = (String)JOptionPane.showInputDialog(this, Intl.intl("Name:"), Intl.intl("Rename Source/Sink Element"), 3, SourceSinkElementData.ICON, null, node.getName())) != null) continue;
            return;
        } while (!this.validateName(node.getName(), name));
        node.setName(name);
        this.getList().updateModelView(this.d_manager);
        this.d_editor.init(node);
    }

    public void deleteSelected(ActionEvent event) {
        SourceSinkElement node = (SourceSinkElement)this.getList().getSelectedItem();
        int selectedIndex = this.getList().getSelectedIx();
        Delete.DelStatus status = Delete.uiDelete(VentusApp.getApp(), this.getMerlinData(), Set.of(node), true);
        if (status.equals((Object)Delete.DelStatus.SUCCESS)) {
            this.getList().updateModelView(this.d_manager);
            this.getList().select(Math.max(0, selectedIndex - 1));
            SourceSinkElement selectedElement = (SourceSinkElement)this.getList().getSelectedItem();
            this.d_editor.init(selectedElement);
            if (selectedElement != null) {
                this.d_editor.getEditorPanel().setEnabled(true);
            }
        }
    }

    @Override
    public void updateActions() {
        SourceSinkElement item = (SourceSinkElement)this.getList().getSelectedItem();
        this.d_actions[0].setEnabled(this.d_manager != null);
        this.d_actions[1].setEnabled(this.d_manager != null && item != null);
        this.d_actions[2].setEnabled(this.d_manager != null && item != null);
        this.d_actions[3].setEnabled(this.d_manager != null && item != null);
    }

    public Action newAction(String name, ActionListener listener) {
        return new guiAction(name, listener);
    }
}

