/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.awt.Component;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddObject;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.sourcesink.SourceSink;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.feature.sourcesink.SourceSinkElementRoot;
import ventus.feature.sourcesink.SourceSinkRoot;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.APropsDisplay;
import ventus.util.MerlinProps;

public class SourceSinkBuilder
extends MerlinProps
implements IEventObserver {
    public static final Object COMPLETED = new Object();
    public static final Object[] VALID_PROPS = new Object[]{SourceSink.ROOM, SourceSink.ELEMENT};
    private final SourceSink sourceSink = new SourceSink("");

    public SourceSinkBuilder() {
        VentusApp.getAppData().getEvents().addObserver(this);
    }

    private SourceSinkElement getDefaultElement() {
        VentusData vd = VentusApp.getAppData();
        SourceSinkElementRoot elementRoot = (SourceSinkElementRoot)vd.getComponentData("SourceSinkElement.data");
        return elementRoot.getDefault();
    }

    @Override
    public void update(Events events) {
        IEventRecord<SourceSinkElement> rec = events.getEvents(SourceSinkElement.class, new Class[0]);
        if (rec.getRemovedObjs().contains(this.sourceSink.get(SourceSink.ELEMENT))) {
            this.sourceSink.set(SourceSink.ELEMENT, this.getDefaultElement());
        } else if (!rec.getAddedObjs().isEmpty() && this.sourceSink.get(SourceSink.ELEMENT) == null) {
            this.sourceSink.set(SourceSink.ELEMENT, this.getDefaultElement());
        }
    }

    public SourceSink getSourceSink() {
        return this.sourceSink;
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (!this.lock()) {
            return;
        }
        try {
            this.sourceSink.set((TypedProp)prop, val);
            this.firePropChanged(prop);
        }
        finally {
            this.release();
        }
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        TypedProp typedProp;
        if (prop instanceof TypedProp && SourceSink.PROP_TYPES.has(typedProp = (TypedProp)prop)) {
            return this.sourceSink.get(typedProp);
        }
        return super.get(prop);
    }

    public void setLocation(ISchematicRoom room, Vector3d normal, Point3d location) {
        this.pause();
        this.set(SourceSink.ROOM, room);
        this.set(SourceSink.LOCATION, location);
        this.set(SourceSink.ROOM_NORMAL, normal);
        this.resume();
    }

    public boolean isValid() {
        return this.get(SourceSink.ROOM) != null && this.get(SourceSink.ELEMENT) != null;
    }

    public void reset() {
        this.pause();
        this.set(SourceSink.ROOM, (ISchematicRoom)SourceSink.ROOM.defVal);
        this.set(SourceSink.LOCATION, (Point3d)SourceSink.LOCATION.defVal);
        this.set(SourceSink.ROOM_NORMAL, (Vector3d)SourceSink.ROOM_NORMAL.defVal);
        this.resume();
    }

    public void cancel() {
        this.reset();
    }

    public void create(Component c) {
        if (!this.isValid()) {
            return;
        }
        final SourceSink sourceSink = this.getSourceSink().clone();
        AMerlinOp op = new AMerlinOp(this){

            @Override
            public void run(VentusApp app, VentusData md) {
                SourceSinkRoot root = (SourceSinkRoot)md.getComponentData("SourceSink.data");
                if (root == null) {
                    return;
                }
                try (VentusData.WriteLock ignored = md.lockWrite();){
                    Undo.begin(Intl.intl("New Source/Sink"));
                    String nextName = sourceSink.getName().isEmpty() ? root.nextName() : sourceSink.getName();
                    sourceSink.setName(nextName);
                    AddObject.add((VentusData)md, (Composite)root, (int)root.getMembers().size(), (ICompElement[])new SourceSink[]{sourceSink});
                    Undo.end(md);
                }
            }
        };
        UIHook.run(c, "SourceSinkBuilder.create", op, 4);
        this.firePropChanged(COMPLETED);
    }

    public static class Display
    extends APropsDisplay<SourceSinkBuilder> {
        public Display(ModelView mv) {
            super(mv);
        }

        @Override
        protected IMerlinGeomSrc constructGeom(SourceSinkBuilder builder) {
            if (!builder.isValid()) {
                return null;
            }
            SourceSink sourceSink = builder.getSourceSink().clone();
            sourceSink.setName("");
            sourceSink.setVisible(true);
            return sourceSink;
        }

        @Override
        protected Object[] getInterestingChanges() {
            return new Object[]{SourceSink.LOCATION, SourceSink.ROOM_NORMAL, SourceSink.ELEMENT};
        }
    }
}

