/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.sourcesink;

import java.awt.Component;
import javax.vecmath.Vector3d;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitPoint3D;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.sourcesink.SourceSink;
import ventus.feature.sourcesink.SourceSinkBuilder;
import ventus.feature.sourcesink.SourceSinkElement;
import ventus.geom.Geometry;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinComboBox;
import ventus.mv.gui.CreatePanel;
import ventus.mv.gui.RoomLocPanel;

public class NewSourceSinkPanel
extends APropEditPanel<SourceSinkBuilder> {
    private static final long serialVersionUID = 1L;
    private final guiTextField d_nameFld = this.initValueField(new guiTextField(), new IPropEditCommand[0]);
    private final guiComboBox<SourceSinkElement> d_elementCB;

    public NewSourceSinkPanel(VentusData vd) {
        super(SourceSink.NAME, SourceSink.ELEMENT);
        this.d_nameFld.setToolTipText(Intl.intl("Name"));
        guiLabel elementLbl = guiUtil.lbl(Intl.intl("Element:"), Intl.intl("Select the Source/Sink element."));
        this.d_elementCB = this.initComboBox(new MerlinComboBox(vd, SourceSinkElement.class, (IMerlinObj[])new SourceSinkElement[0]));
        guiPanel d_namePnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(d_namePnl);
        gb.addRow(this.d_nameFld, 0, 1.0);
        guiPanel locPnl = new guiPanel();
        gb = new GridBagHelper(locPnl);
        RoomLocPanel<SourceSinkBuilder> locPanel = new RoomLocPanel<SourceSinkBuilder>((props, room, normal, loc) -> props.setLocation((ISchematicRoom)room, (Vector3d)normal, loc.getPoint3dValue(Geometry.LENGTH_UNIT)), props -> new UnitPoint3D(props.get(SourceSink.LOCATION), Geometry.LENGTH_UNIT), SourceSink.getRoomFilter(), SourceSink.LOCATION);
        gb.addRow(locPanel);
        guiPanel propsPnl = new guiPanel(new MigLayout("insets 0, align center"));
        propsPnl.add((Component)elementLbl, "aligny center");
        propsPnl.add(this.d_elementCB, "wmax 180px, wrap");
        CreatePanel<SourceSinkBuilder> createPnl = new CreatePanel<SourceSinkBuilder>(Intl.intl("Create"), SourceSinkBuilder::isValid, (btn, builder) -> builder.create((Component)btn), SourceSinkBuilder.VALID_PROPS);
        this.addSection(d_namePnl);
        this.addSeparator();
        this.addSection(propsPnl);
        this.addSeparator();
        this.addSection(locPnl);
        this.addSeparator();
        this.addSection(createPnl);
    }

    @Override
    protected void updateFromProps(SourceSinkBuilder props) {
        this.d_nameFld.setText(props.get(SourceSink.NAME));
        this.d_elementCB.setSelectedItem(props.get(SourceSink.ELEMENT));
    }

    @Override
    protected void updateToProps(SourceSinkBuilder props) {
        props.set(SourceSink.NAME, this.d_nameFld.getValue());
        props.set(SourceSink.ELEMENT, this.d_elementCB.getSelectedItem());
    }
}

