/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.simparams;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.data.RestorableProperties;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.simparams.SimParamsProps;
import ventus.unitsystem.UnitSystem;

public class EditSimParamsDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private final Map<String, EditorPanel> d_tabs = new LinkedHashMap<String, EditorPanel>();

    public EditSimParamsDlg(JFrame owner, UnitSystem usys, VentusData md) {
        super((Window)owner, Intl.intl("Simulation Parameters"), 9);
        this.d_tabs.put(Intl.intl("Time"), new TimeEditor());
        this.d_tabs.put(Intl.intl("Environment"), new WeatherEditor(usys, md));
        this.d_tabs.put(Intl.intl("Simulator"), new AirflowNumericEditor());
        JTabbedPane jtp = new JTabbedPane();
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            jtp.addTab(entry.getKey(), entry.getValue());
        }
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new BorderLayout());
        dlgPanel.add((Component)jtp, "Center");
    }

    public void load(RestorableProperties dm) {
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            entry.getValue().load(dm);
        }
        this.setModified(false);
    }

    public void store(RestorableProperties dm) {
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            entry.getValue().store(dm);
        }
    }

    private static class TimeEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private final guiComboBox<SimParamsProps.AirflowSimMethod> d_cbAirflowSimMethod;
        private final guiComboBox<SimParamsProps.ContaminantSimMethod> d_cbContaminantSimMethod;
        private final ValueField<UnitDouble> d_simTime;
        private final ValueField<UnitDouble> d_simTimestep;

        public TimeEditor() {
            guiLabel airflowSimLbl = guiUtil.lbl(Intl.intl("Airflow Simulation Method:"), Intl.intl("Whether to run a steady-state or transient simulation of airflows."));
            this.d_cbAirflowSimMethod = guiUtil.newCombo(method -> new Pair<String, String>(method.name, method.desc), SimParamsProps.AirflowSimMethod.values());
            guiLabel contaminantSimLbl = guiUtil.lbl(Intl.intl("Contaminant Simulation Method:"), Intl.intl("Whether to run a steady-state or transient simulation of contaminants."));
            this.d_cbContaminantSimMethod = guiUtil.newCombo(method -> new Pair<String, String>(method.name, method.desc), SimParamsProps.ContaminantSimMethod.values());
            guiLabel simulationTimeLbl = guiUtil.lbl(Intl.intl("Simulation Time:"), Intl.intl("Length of a transient simulation."));
            this.d_simTime = ValueFields.udFld(new UnitDouble(0.0, SI.SECOND), (Predicate<UnitDouble>)UnitDoubleVR.between(0.0, 24.0, NonSI.HOUR, true, true));
            guiLabel simulationTimestepLbl = guiUtil.lbl(Intl.intl("Timestep:"), Intl.intl("Time between each calculation in a transient simulation."));
            this.d_simTimestep = ValueFields.udFld(new UnitDouble(0.0, SI.SECOND), (Predicate<UnitDouble>)UnitDoubleVR.between(new UnitDouble(1.0, SI.SECOND), new UnitDouble(24.0, NonSI.HOUR), true, true));
            Runnable updateTimesEnabled = () -> {
                boolean enabled = this.d_cbAirflowSimMethod.getSelectedItem() == SimParamsProps.AirflowSimMethod.TRANSIENT || this.d_cbContaminantSimMethod.getSelectedItem() == SimParamsProps.ContaminantSimMethod.TRANSIENT;
                this.d_simTime.setEnabled(enabled);
                this.d_simTimestep.setEnabled(enabled);
            };
            this.d_cbAirflowSimMethod.addActionListener(e -> {
                if (this.d_cbAirflowSimMethod.getSelectedItem() == SimParamsProps.AirflowSimMethod.TRANSIENT) {
                    this.d_cbContaminantSimMethod.setSelectedItem((Object)SimParamsProps.ContaminantSimMethod.TRANSIENT);
                }
                updateTimesEnabled.run();
            });
            this.d_cbContaminantSimMethod.addActionListener(e -> {
                if (this.d_cbContaminantSimMethod.getSelectedItem() == SimParamsProps.ContaminantSimMethod.STEADY) {
                    this.d_cbAirflowSimMethod.setSelectedItem((Object)SimParamsProps.AirflowSimMethod.STEADY);
                }
                updateTimesEnabled.run();
            });
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addTitle(Intl.intl("Simulation Method"));
            gb.indent();
            gb.addRow(airflowSimLbl, this.d_cbAirflowSimMethod);
            gb.addRow(contaminantSimLbl, this.d_cbContaminantSimMethod);
            gb.unindent();
            gb.addTitle(Intl.intl("Simulation Time"));
            gb.indent();
            gb.addRow(simulationTimeLbl, this.d_simTime);
            gb.addRow(simulationTimestepLbl, this.d_simTimestep);
            gb.unindent();
            gb.finalizeRows();
        }

        @Override
        public void load(RestorableProperties dm) {
            this.d_cbAirflowSimMethod.setSelectedItem((Object)dm.get(SimParamsProps.airflowSimMethod));
            this.d_cbContaminantSimMethod.setSelectedItem((Object)dm.get(SimParamsProps.contaminantSimMethod));
            this.d_simTime.setValue(dm.get(SimParamsProps.simulationTime));
            this.d_simTimestep.setValue(dm.get(SimParamsProps.simulationTimestep));
        }

        @Override
        public void store(RestorableProperties dm) {
            dm.set(SimParamsProps.airflowSimMethod, this.d_cbAirflowSimMethod.getSelectedItem());
            dm.set(SimParamsProps.contaminantSimMethod, this.d_cbContaminantSimMethod.getSelectedItem());
            dm.set(SimParamsProps.simulationTime, (UnitDouble)this.d_simTime.getValue());
            dm.set(SimParamsProps.simulationTimestep, (UnitDouble)this.d_simTimestep.getValue());
        }
    }

    private static class WeatherEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private final ValueField<UnitDouble> defaultZoneTemp;
        private final VentusData d_md;

        public WeatherEditor(UnitSystem usys, VentusData md) {
            this.defaultZoneTemp = ValueFields.udFld(0.0, DoubleVR.UNBOUNDED, usys.getTemperature());
            this.d_md = md;
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(Intl.intl("Default Zone and Junction Temperature:"), this.defaultZoneTemp);
            gb.finalizeRows();
        }

        @Override
        public void load(RestorableProperties dm) {
            this.defaultZoneTemp.setValue(dm.get(SimParamsProps.defaultZoneTemp));
        }

        @Override
        public void store(RestorableProperties dm) {
            dm.set(SimParamsProps.defaultZoneTemp, (UnitDouble)this.defaultZoneTemp.getValue());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            boolean modified = this.defaultZoneTemp.isModified();
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            ArrayList<SchematicRoom> localpropList = new ArrayList<SchematicRoom>();
            if (modified) {
                for (SchematicRoom obj : this.d_md.floors.flattenRooms(SchematicRoom.class, ISchematicRoom.Type.ZONE)) {
                    if (!obj.getTempDefinedLocally()) continue;
                    localpropList.add(obj);
                }
                if (!localpropList.isEmpty()) {
                    Object message = localpropList.size() == 1 ? String.format(Intl.intl("Zone <b>%1$s</b> has a custom zone temperature defined and will not be<br>affected by the default temp change."), ((SchematicRoom)localpropList.get(0)).getName()) : String.format(Intl.intl("%1$d zones have a custom zone temperature defined and will not be<br>affected by the default temp change."), localpropList.size());
                    message = "<html>" + (String)message + "</html>";
                    guiPanel panel = new guiPanel();
                    GridBagHelper gb = new GridBagHelper(panel);
                    gb.addFilledRow(message);
                    gb.finalizeRows();
                    JOptionPane.showMessageDialog(this, panel, Intl.intl("Custom Zones"), 2);
                }
            }
            return true;
        }
    }

    private static class AirflowNumericEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private final guiCheckBox d_ckRunSteady = new guiCheckBox(Intl.intl("Run steady state initialization to convergence"));
        private final guiCheckBox d_ckVaryDensity;
        private final ValueField<Integer> maxField;

        public AirflowNumericEditor() {
            this.d_ckRunSteady.setToolTipText(Intl.intl("We need some tool tip text here."));
            this.d_ckVaryDensity = new guiCheckBox(Intl.intl("Vary density during time step"));
            this.d_ckVaryDensity.setToolTipText(Intl.intl("We need some tool tip text here."));
            guiLabel maxIterationPerStep = new guiLabel(Intl.intl("Max iterations per time step:"));
            maxIterationPerStep.setToolTipText(Intl.intl("We need some tool tip text here."));
            this.maxField = ValueFields.intFld(IntVR.ge(0));
            LinkStatus.link((AbstractButton)this.d_ckVaryDensity, maxIterationPerStep, this.maxField);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addTitle(Intl.intl("Density Control Parameters"));
            gb.indent();
            gb.addRow(this.d_ckRunSteady, 0);
            gb.addRow(this.d_ckVaryDensity, 0);
            gb.addIdentRow(maxIterationPerStep, this.maxField);
            gb.unindent();
            gb.finalizeRows();
        }

        @Override
        public void load(RestorableProperties dm) {
            this.d_ckRunSteady.setSelected(dm.get(SimParamsProps.runSteady));
            this.d_ckVaryDensity.setSelected(dm.get(SimParamsProps.varyDensity));
            this.maxField.setValue(dm.get(SimParamsProps.maxIteration));
        }

        @Override
        public void store(RestorableProperties dm) {
            dm.set(SimParamsProps.runSteady, this.d_ckRunSteady.isSelected());
            dm.set(SimParamsProps.varyDensity, this.d_ckVaryDensity.isSelected());
            dm.set(SimParamsProps.maxIteration, (Integer)this.maxField.getValue());
        }
    }

    private static abstract class EditorPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;

        private EditorPanel() {
        }

        public abstract void load(RestorableProperties var1);

        public abstract void store(RestorableProperties var1);
    }
}

