/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.results;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.results.DataTable;
import ventus.feature.results.NodeProps;
import ventus.geom.Geometry;
import ventus.geom.IMerlinGeomSrc;
import ventus.io.contamx.PrjData;

public interface DataNode
extends ICompElement {

    public static class ZoneVisLeaf
    extends NamedMerlinObj
    implements DataNode {
        private static final long serialVersionUID = 1L;
        private final double[] d_times;
        private final double[] d_temperatures;
        private final double[] d_pressures;
        private final double[] d_densities;
        private final Map<String, double[]> d_concentrations;
        private final Unit d_temperatureUnit;
        private final Unit d_pressureUnit;
        private final Unit d_densityUnit;
        private final IPropertySet d_props = new PropertySet();
        private transient double d_temperature;
        private transient double d_pressure;
        private transient double d_density;
        private transient Map<String, Double> d_concentration;

        public ZoneVisLeaf(String name, double[] times, Unit temperatureUnit, double[] temperatures, Unit pressureUnit, double[] pressures, Unit densityUnit, double[] densities, Map<String, double[]> concentrations) {
            super(name);
            this.d_props.set(NodeProps.IS_VISIBLE, false);
            this.d_props.set(NodeProps.IS_STALE, false);
            this.d_times = times;
            this.d_temperatures = temperatures;
            this.d_pressures = pressures;
            this.d_densities = densities;
            this.d_concentrations = concentrations;
            this.d_temperatureUnit = temperatureUnit;
            this.d_pressureUnit = pressureUnit;
            this.d_densityUnit = densityUnit;
            this.d_temperature = this.d_temperatures[0];
            this.d_pressure = this.d_pressures[0];
            this.d_density = this.d_densities[0];
            this.d_concentration = new HashMap<String, Double>();
            for (Map.Entry<String, double[]> concentration : this.d_concentrations.entrySet()) {
                this.d_concentration.put(concentration.getKey(), concentration.getValue()[0]);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.d_temperature = this.d_temperatures[0];
            this.d_pressure = this.d_pressures[0];
            this.d_density = this.d_densities[0];
            this.d_concentration = new HashMap<String, Double>();
            for (Map.Entry<String, double[]> concentration : this.d_concentrations.entrySet()) {
                this.d_concentration.put(concentration.getKey(), concentration.getValue()[0]);
            }
        }

        public boolean isStale() {
            return this.d_props.get(NodeProps.IS_STALE);
        }

        public void setStale(boolean stale) {
            this.d_props.set(NodeProps.IS_STALE, stale);
        }

        @Override
        public Set<Object> getPropTypes(int options) {
            return Set.of(NamedMerlinObj.NAME, VentusData.VISIBILITY);
        }

        @Override
        public <T> void setProperty(Object property, T value) {
            if (property == NamedMerlinObj.NAME) {
                this.setName((String)value);
            } else {
                this.d_props.set((IPropertySet.Prop)property, value);
            }
        }

        @Override
        public Object getProperty(Object property) {
            if (property == NamedMerlinObj.NAME) {
                return this.getName();
            }
            if (this.getPropTypes(0).contains(property)) {
                return this.d_props.get((IPropertySet.Prop)property);
            }
            return null;
        }

        public double[] getTimes() {
            return this.d_times;
        }

        public double[] getTemperatures() {
            return this.d_temperatures;
        }

        public double[] getPressures() {
            return this.d_pressures;
        }

        public double[] getDensities() {
            return this.d_densities;
        }

        public Set<String> getConcentrationKeys() {
            return this.d_concentrations.keySet();
        }

        public double[] getConcentrations(String key) {
            return this.d_concentrations.get(key);
        }

        public UnitDouble getTemperature() {
            return new UnitDouble(this.d_temperature, this.d_temperatureUnit);
        }

        public UnitDouble getPressure() {
            return new UnitDouble(this.d_pressure, this.d_pressureUnit);
        }

        public UnitDouble getDensity() {
            return new UnitDouble(this.d_density, this.d_densityUnit);
        }

        public String getSimulationName() {
            return this.getParentObject(SimulationRoot.class).map(simRoot -> simRoot.getName()).orElse(Intl.intl("unknown"));
        }

        public Object getCorrespondingRoom() {
            return this.getParentObject(ZoneVisRoot.class).map(visRoot -> visRoot.findCorrespondingRoom(this)).orElse(null);
        }

        private <T extends IMerlinObj> Optional<T> getParentObject(Class<T> parentClass) {
            Object nextParent = this.getParent();
            while (nextParent != null && !parentClass.isAssignableFrom(nextParent.getClass())) {
                if (nextParent instanceof IMerlinObj) {
                    IMerlinObj nextParentAsMerlinObj = (IMerlinObj)nextParent;
                    nextParent = nextParentAsMerlinObj.getParent();
                    continue;
                }
                return Optional.empty();
            }
            return Optional.ofNullable((IMerlinObj)nextParent);
        }
    }

    public static class ZoneVisRoot
    extends Composite<DataNode>
    implements DataNode {
        private static final long serialVersionUID = 1L;
        private final BidiMap<Object, ZoneVisLeaf> d_visLeafMap = new DualHashBidiMap<Object, ZoneVisLeaf>();

        public ZoneVisRoot(String name) {
            super(name);
        }

        public void addLeaf(SchematicRoom room, ZoneVisLeaf leaf) {
            this.d_visLeafMap.put(room, leaf);
            this.add(leaf);
        }

        public ZoneVisLeaf findCorrespondingLeaf(Object room) {
            return (ZoneVisLeaf)this.d_visLeafMap.get(room);
        }

        public Object findCorrespondingRoom(ZoneVisLeaf leaf) {
            return this.d_visLeafMap.getKey(leaf);
        }

        @Override
        public Composite<DataNode> newGroup(String name) {
            return null;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (this.d_visLeafMap == null) {
                try {
                    theUtil.assignFinalField(this, ZoneVisRoot.class, "d_visLeafMap", new DualHashBidiMap());
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
            }
        }
    }

    public static class VisLeaf
    extends NamedMerlinObj
    implements DataNode,
    IMerlinGeomSrc {
        private static final long serialVersionUID = 1L;
        private static final Color COLOR_DP = Color.MAGENTA;
        private static final Color COLOR_FLOW0 = Color.GREEN;
        private final double[] d_times;
        private final double[] d_dps;
        private final double[] d_flow0s;
        private final Unit d_dpUnit;
        private transient double d_dp;
        private transient double d_dpInterp;
        private Point3d d_dpRoot;
        private Vector3d d_dpDir;
        private final Unit d_flow0Unit;
        private transient double d_flow0;
        private transient double d_flow0Interp;
        private Point3d d_flow0Root;
        private Vector3d d_flow0Dir;
        private final IPropertySet d_props = new PropertySet();

        public VisLeaf(String name, double[] times, double[] dps, double[] flow0s, Unit dpUnit, Point3d dpRoot, Vector3d dpDir, Unit flow0Unit, Point3d flow0Root, Vector3d flow0Dir) {
            super(name);
            this.d_props.set(NodeProps.IS_VISIBLE, false);
            this.d_props.set(NodeProps.IS_STALE, false);
            this.d_times = times;
            this.d_dps = dps;
            this.d_flow0s = flow0s;
            this.d_dpInterp = this.d_dp = dps[0];
            this.d_dpUnit = dpUnit;
            this.d_dpRoot = dpRoot;
            this.d_dpDir = dpDir;
            this.d_flow0Interp = this.d_flow0 = flow0s[0];
            this.d_flow0Unit = flow0Unit;
            this.d_flow0Root = flow0Root;
            this.d_flow0Dir = flow0Dir;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.d_times == null) {
                try {
                    UnitDouble dp = (UnitDouble)this.d_props.get(NodeProps.DP);
                    Point3d dpRoot = (Point3d)this.d_props.get(NodeProps.DP_ROOT);
                    Vector3d dpDir = (Vector3d)this.d_props.get(NodeProps.DP_DIR);
                    UnitDouble flow0 = (UnitDouble)this.d_props.get(NodeProps.FLOW0);
                    Point3d flow0Root = (Point3d)this.d_props.get(NodeProps.FLOW0_ROOT);
                    Vector3d flow0Dir = (Vector3d)this.d_props.get(NodeProps.FLOW0_DIR);
                    this.d_props.remove(NodeProps.DP);
                    this.d_props.remove(NodeProps.DP_ROOT);
                    this.d_props.remove(NodeProps.DP_DIR);
                    this.d_props.remove(NodeProps.FLOW0);
                    this.d_props.remove(NodeProps.FLOW0_ROOT);
                    this.d_props.remove(NodeProps.FLOW0_DIR);
                    theUtil.assignFinalField(this, VisLeaf.class, "d_dpUnit", dp.getUnit());
                    this.d_dpRoot = dpRoot;
                    dpDir.scale(1.0 / dp.getRawValue());
                    this.d_dpDir = dpDir;
                    theUtil.assignFinalField(this, VisLeaf.class, "d_flow0Unit", flow0.getUnit());
                    this.d_flow0Root = flow0Root;
                    flow0Dir.scale(1.0 / flow0.getRawValue());
                    this.d_flow0Dir = flow0Dir;
                    theUtil.assignFinalField(this, VisLeaf.class, "d_times", new double[]{0.0});
                    theUtil.assignFinalField(this, VisLeaf.class, "d_dps", new double[]{dp.getRawValue()});
                    theUtil.assignFinalField(this, VisLeaf.class, "d_flow0s", new double[]{flow0.getRawValue()});
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IOException(e.getCause());
                }
            }
            this.d_dpInterp = this.d_dp = this.d_dps[0];
            this.d_flow0Interp = this.d_flow0 = this.d_flow0s[0];
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            PropsBuilder pb = new PropsBuilder();
            pb.add(new IPrimProps.Edge(COLOR_DP, 6.0, IPrimProps.DEF_STIPPLE, 0), 1);
            pb.add(new IPrimProps.Edge(COLOR_FLOW0, 6.0, IPrimProps.DEF_STIPPLE, 0), 1);
            return new DisplayGeom(this.getGeom(), pb);
        }

        public UnitDouble getPrimaryFlow() {
            return (UnitDouble)this.getProperty(NodeProps.FLOW0);
        }

        public UnitDouble getDifferentialPressure() {
            return (UnitDouble)this.getProperty(NodeProps.DP);
        }

        public double[] getTimes() {
            return this.d_times;
        }

        public double[] getDifferentialPressures() {
            return this.d_dps;
        }

        public double[] getPrimaryFlows() {
            return this.d_flow0s;
        }

        public UnitDouble getElevation() {
            return new UnitDouble(((Point3d)this.getProperty((Object)NodeProps.DP_ROOT)).z, Geometry.LENGTH_UNIT);
        }

        public boolean isStale() {
            return this.d_props.get(NodeProps.IS_STALE);
        }

        public void setStale(boolean stale) {
            this.d_props.set(NodeProps.IS_STALE, stale);
        }

        @Override
        public boolean isVisible() {
            return this.d_props.get(NodeProps.IS_VISIBLE);
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible != this.isVisible()) {
                this.d_props.set(NodeProps.IS_VISIBLE, visible);
                this.changedEvt(this, VentusData.VISIBILITY);
            }
        }

        @Override
        public void setGeom(IGeomNode geom) {
        }

        @Override
        public IGeomNode getGeom() {
            double offset = 0.05;
            double lengthMult = 2.5;
            Point3d a = new Point3d(this.d_dpRoot);
            Vector3d dir = new Vector3d(this.d_dpDir);
            dir.scale(2.5);
            dir.scale(this.d_dpInterp);
            Point3d b = Util3D.linePoint(a, dir, 1.0);
            this.offset(1.5707963267948966, 0.05, a, b);
            LineSeg dp = new LineSeg(a, b);
            a = new Point3d(this.d_flow0Root);
            dir = new Vector3d(this.d_flow0Dir);
            dir.scale(2.5);
            dir.scale(this.d_flow0Interp);
            b = Util3D.linePoint(a, dir, 1.0);
            this.offset(-1.5707963267948966, 0.05, a, b);
            LineSeg flow0 = new LineSeg(a, b);
            IGeom geom = GeomUtil.group(dp, flow0);
            return GeomNodeUtil.newNode(geom);
        }

        private void offset(double angle, double distMeters, Point3d a, Point3d b) {
            Vector3d v = Util3D.vector(a, b);
            if (Util3D.safeNormalize(v, 0.0) == 0.0) {
                return;
            }
            v = Util3D.rotate(v, Util3D.VEC3D_ZPOS, angle);
            v.scale(distMeters);
            a.add(v);
            b.add(v);
        }

        @Override
        public Set<Object> getPropTypes(int options) {
            return Set.of(NamedMerlinObj.NAME, VentusData.VISIBILITY, NodeProps.DP, NodeProps.FLOW0, NodeProps.DP_ROOT);
        }

        @Override
        public <T> void setProperty(Object property, T value) {
            if (property == VentusData.VISIBILITY) {
                this.setVisible((Boolean)value);
            } else if (property == NamedMerlinObj.NAME) {
                this.setName((String)value);
            } else if (property == NodeProps.DP) {
                this.d_dp = ((UnitDouble)value).get(this.d_dpUnit);
            } else if (property == NodeProps.DP_ROOT) {
                this.d_dpRoot = (Point3d)value;
            } else if (property == NodeProps.DP_DIR) {
                this.d_dpDir = (Vector3d)value;
            } else if (property == NodeProps.FLOW0) {
                this.d_flow0 = ((UnitDouble)value).get(this.d_flow0Unit);
            } else if (property == NodeProps.FLOW0_ROOT) {
                this.d_flow0Root = (Point3d)value;
            } else if (property == NodeProps.FLOW0_DIR) {
                this.d_flow0Dir = (Vector3d)value;
            } else {
                this.d_props.set((IPropertySet.Prop)property, value);
            }
        }

        @Override
        public Object getProperty(Object property) {
            if (property == VentusData.VISIBILITY) {
                return this.isVisible();
            }
            if (property == NamedMerlinObj.NAME) {
                return this.getName();
            }
            if (property == NodeProps.DP) {
                return new UnitDouble(this.d_dp, this.d_dpUnit);
            }
            if (property == NodeProps.DP_ROOT) {
                return this.d_dpRoot;
            }
            if (property == NodeProps.DP_DIR) {
                return this.d_dpDir;
            }
            if (property == NodeProps.FLOW0) {
                return new UnitDouble(this.d_flow0, this.d_flow0Unit);
            }
            if (property == NodeProps.FLOW0_ROOT) {
                return this.d_flow0Root;
            }
            if (property == NodeProps.FLOW0_DIR) {
                return this.d_flow0Dir;
            }
            if (this.getPropTypes(0).contains(property)) {
                return this.d_props.get((IPropertySet.Prop)property);
            }
            return null;
        }

        public String getSimulationName() {
            return this.getParentObject(SimulationRoot.class).map(simRoot -> simRoot.getName()).orElse(Intl.intl("unknown"));
        }

        public Object getCorrespondingFlowpath() {
            return this.getParentObject(VisRoot.class).map(visRoot -> visRoot.findCorrespondingFlowpath(this)).orElse(null);
        }

        private <T extends IMerlinObj> Optional<T> getParentObject(Class<T> parentClass) {
            Object nextParent = this.getParent();
            while (nextParent != null && !parentClass.isAssignableFrom(nextParent.getClass())) {
                if (nextParent instanceof IMerlinObj) {
                    IMerlinObj nextParentAsMerlinObj = (IMerlinObj)nextParent;
                    nextParent = nextParentAsMerlinObj.getParent();
                    continue;
                }
                return Optional.empty();
            }
            return Optional.ofNullable((IMerlinObj)nextParent);
        }

        public void setAnimationData(double dp, double dpInterp, double flow0, double flow0Interp) {
            this.d_dp = dp;
            this.d_dpInterp = dpInterp;
            this.d_flow0 = flow0;
            this.d_flow0Interp = flow0Interp;
            this.changedEvt(NodeProps.DP, NodeProps.FLOW0);
        }
    }

    public static class VisRoot
    extends Composite<DataNode>
    implements DataNode {
        private static final long serialVersionUID = 1L;
        private final BidiMap<Object, VisLeaf> d_visLeafMap = new DualHashBidiMap<Object, VisLeaf>();

        public VisRoot(String name) {
            super(name);
        }

        public void addLeaf(FlowPath path, VisLeaf leaf) {
            this.d_visLeafMap.put(path, leaf);
            this.add(leaf);
        }

        public VisLeaf findCorrespondingLeaf(Object flowpath) {
            return (VisLeaf)this.d_visLeafMap.get(flowpath);
        }

        public Object findCorrespondingFlowpath(VisLeaf leaf) {
            return this.d_visLeafMap.getKey(leaf);
        }

        @Override
        public Composite<DataNode> newGroup(String name) {
            return null;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (this.d_visLeafMap == null) {
                try {
                    theUtil.assignFinalField(this, VisRoot.class, "d_visLeafMap", new DualHashBidiMap());
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
            }
            if (this.getName().equals(Intl.intl("Vector Data"))) {
                this.setName(Intl.intl("Path Data"));
            }
        }
    }

    public static class MergedData
    extends NamedMerlinObj
    implements DataNode {
        private static final long serialVersionUID = 1L;
        private DataTable d_table;

        public MergedData(String name) {
            super(name);
            this.reset();
        }

        public void reset() {
            this.d_table = DataTable.EMPTY;
        }

        public void appendData(DataTable dt) {
            this.d_table = this.d_table.append(dt);
        }

        public DataTable getData() {
            return this.d_table;
        }

        @Override
        public Set<Object> getPropTypes(int options) {
            return Set.of();
        }

        @Override
        public <T> void setProperty(Object property, T value) {
        }

        @Override
        public Object getProperty(Object property) {
            return null;
        }
    }

    public static class XLogData
    extends TextData {
        private static final long serialVersionUID = 6961783786712149071L;
        private final boolean d_hasErrors;

        public XLogData(String name, String fullPath, String content, int code) {
            super(name, fullPath, content);
            this.d_hasErrors = code != 0;
        }

        public boolean hasErrors() {
            return this.d_hasErrors;
        }
    }

    public static class TextData
    extends NamedMerlinObj
    implements DataNode {
        private static final long serialVersionUID = 1L;
        private final IPropertySet d_props = new PropertySet();

        public TextData(String name, String fullPath, String content) {
            super(name);
            this.d_props.set(NodeProps.STR_PATH, fullPath);
            this.d_props.set(NodeProps.STR_CONTENT, content);
            this.getProp(null);
        }

        public <T> T get(TypedProp<T> prop) {
            return this.d_props.get(prop);
        }

        @Override
        public Set<Object> getPropTypes(int options) {
            return Set.of();
        }

        @Override
        public <T> void setProperty(Object property, T value) {
        }

        @Override
        public Object getProperty(Object property) {
            return null;
        }
    }

    public static class SimulationRoot
    extends Composite<DataNode>
    implements DataNode {
        private static final long serialVersionUID = 1L;
        private final IPropertySet d_props = new PropertySet();

        public SimulationRoot(String name, String prjFilePath, PrjData prjInputData) {
            super(name);
            this.d_props.set(NodeProps.STR_PATH, prjFilePath);
            this.d_props.set(NodeProps.PRJDATA, prjInputData);
        }

        @Override
        public Composite<DataNode> newGroup(String name) {
            return null;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    public static class ResultsRoot
    extends Composite<DataNode>
    implements DataNode {
        private static final long serialVersionUID = 1L;
        public final MergedData nodeZoneFlows = new MergedData(Intl.intl("Node-Zone Data"));
        public final MergedData linkPathData = new MergedData(Intl.intl("Link-Path Flows"));

        public ResultsRoot() {
            super(Intl.intl("Results"));
            this.addAll(this.nodeZoneFlows, this.linkPathData);
        }

        @Override
        public void clear() {
            super.clear();
            this.nodeZoneFlows.reset();
            this.linkPathData.reset();
            this.addAll(this.nodeZoneFlows, this.linkPathData);
        }

        @Override
        public Composite<DataNode> newGroup(String name) {
            return null;
        }

        public Collection<VisLeaf> getLeavesForFlowpath(Object flowpath) {
            if (flowpath == null) {
                return Collections.emptySet();
            }
            HashSet<VisLeaf> leaves = new HashSet<VisLeaf>();
            for (VisRoot visRoot : this.flatten(VisRoot.class)) {
                leaves.add(visRoot.findCorrespondingLeaf(flowpath));
            }
            return leaves;
        }

        public Object getFlowpathForVisleaf(VisLeaf visleaf) {
            if (visleaf == null) {
                return null;
            }
            for (VisRoot visRoot : this.flatten(VisRoot.class)) {
                if (!visRoot.containsDeep(visleaf)) continue;
                return visRoot.findCorrespondingFlowpath(visleaf);
            }
            return null;
        }

        public Collection<ZoneVisLeaf> getLeavesForZone(Object zone) {
            if (zone == null) {
                return Collections.emptySet();
            }
            HashSet<ZoneVisLeaf> leaves = new HashSet<ZoneVisLeaf>();
            for (ZoneVisRoot visRoot : this.flatten(ZoneVisRoot.class)) {
                leaves.add(visRoot.findCorrespondingLeaf(zone));
            }
            return leaves;
        }

        public Object getZoneForVisleaf(ZoneVisLeaf visleaf) {
            if (visleaf == null) {
                return null;
            }
            for (ZoneVisRoot visRoot : this.flatten(ZoneVisRoot.class)) {
                if (!visRoot.containsDeep(visleaf)) continue;
                return visRoot.findCorrespondingRoom(visleaf);
            }
            return null;
        }
    }
}

