/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.levels;

import java.util.ArrayList;
import java.util.Collection;
import thunderheadeng.util.WarningReport;
import ventus.data.GeomComposite;
import ventus.data.ICompElement;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.windprofiles.WindProfile;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusOIS;

public class LevelsOISHandler
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyVersionUpdates(int updateVer, int streamVer, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        if (updateVer == 204 && streamVer < 204) {
            ArrayList<ICompElement> removedObjs = new ArrayList<ICompElement>();
            for (Floor floor : vd.floors.flatten(Floor.class)) {
                VentusOIS.findAndReplaceComposites(floor, name -> new GeomComposite((String)name));
                LevelsOISHandler.markAndRemoveStrandedObjs(floor, removedObjs);
            }
            changes.changeObjs.putIfAbsent(204, new ArrayList());
            changes.changeObjs.get(204).addAll(removedObjs);
        }
        return false;
    }

    private static boolean isStrandedObj(ICompElement child) {
        return child instanceof AHSPoint || child instanceof FlowElement || child instanceof FlowPath || child instanceof WindProfile;
    }

    private static void markAndRemoveStrandedObjs(GeomComposite root, Collection<ICompElement> markedObjs) {
        ArrayList<ICompElement> toRemove = new ArrayList<ICompElement>();
        Collection<ICompElement> children = root.getMembers();
        for (ICompElement child : children) {
            if (child instanceof GeomComposite) {
                LevelsOISHandler.markAndRemoveStrandedObjs((GeomComposite)child, markedObjs);
                continue;
            }
            if (!LevelsOISHandler.isStrandedObj(child)) continue;
            markedObjs.add(child);
            toRemove.add(child);
        }
        root.removeAll(toRemove);
    }
}

