/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.builders.ToolName;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.comps.FeatureUtil;
import ventus.feature.comps.ITool;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathBuilder;
import ventus.feature.flowpaths.NewFlowPathPanel;
import ventus.gui.APropEditPanel;
import ventus.gui.guiUtil;
import ventus.mv.ModelView;
import ventus.mv.tools.IConditionallyEnabledTool;
import ventus.mv.tools.MerlinTool;
import ventus.mv.tools.RoomLocFunc;

public class NewFlowPath1Pt
implements ITool<FlowPathBuilder> {
    public static final ImageIcon icon_route_1pt = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(FlowPath.class, "icons/route-1pt.svg"), 16);
    private FlowPathBuilder d_builder;
    private FlowPathBuilder.Display d_display;
    private ModelView d_mv;
    private Tool d_tool;
    private NewFlowPathPanel d_panel;

    @Override
    public void init(ModelView mv) {
        this.d_mv = mv;
        this.d_builder = new FlowPathBuilder();
        this.d_display = new FlowPathBuilder.Display(mv);
        this.d_tool = new Tool(mv);
        this.d_panel = new NewFlowPathPanel(mv.getData(), FlowPathBuilder.Mode.ONE_POINT);
    }

    @Override
    public ModelScene getScene() {
        return this.d_mv.getToolScene();
    }

    @Override
    public APropEditPanel<FlowPathBuilder> getPanel() {
        return this.d_panel;
    }

    @Override
    public FlowPathBuilder getBuilder() {
        return this.d_builder;
    }

    public FlowPathBuilder.Display getDisplay() {
        return this.d_display;
    }

    @Override
    public MerlinTool<FlowPathBuilder> getTool() {
        return this.d_tool;
    }

    @Override
    public String getName() {
        return ToolName.NEW_FLOW_PATH.get();
    }

    @Override
    public String getTooltip() {
        return Intl.intl("Create a flow path by choosing one point on a face");
    }

    @Override
    public Icon getIcon() {
        return icon_route_1pt;
    }

    @Override
    public void addToolbarItem(GroupedSequence root) {
        root.getNode("create").add(20, (Object)this.d_tool);
    }

    public static class Tool
    extends MerlinTool<FlowPathBuilder>
    implements IConditionallyEnabledTool {
        public Tool(ModelView mv) {
            super(mv, new RoomLocFunc<Tool>((tool, locs) -> {
                Iterator it = locs.iterator();
                RoomLocFunc.Location loc1 = (RoomLocFunc.Location)it.next();
                ISchematicRoom.IWallComponent wall1 = theUtil.cast(loc1.component, ISchematicRoom.IWallComponent.class).orElse(null);
                if (!loc1.isValid() || wall1 == null) {
                    ((FlowPathBuilder)tool.props()).setLocation(loc1.room, loc1.normal, loc1.loc, wall1);
                    return;
                }
                RoomLocFunc.Location loc2 = null;
                while (it.hasNext()) {
                    RoomLocFunc.Location loc = (RoomLocFunc.Location)it.next();
                    if (!loc.loc.epsilonEquals(loc1.loc, 1.0E-9)) break;
                    if (!loc.isValid() || loc.room == loc1.room || !theUtil.cast(loc.component, ISchematicRoom.IWallComponent.class).isPresent()) continue;
                    loc2 = loc;
                    break;
                }
                if (loc2 != null) {
                    ISchematicRoom.IWallComponent wall2 = theUtil.cast(loc2.component, ISchematicRoom.IWallComponent.class).orElse(null);
                    ((FlowPathBuilder)tool.props()).setLocation(loc1.room, loc2.room, wall1, wall2, loc1.normal, loc2.normal, loc1.loc, loc2.loc);
                } else {
                    ((FlowPathBuilder)tool.props()).setLocation(loc1.room, loc1.normal, loc1.loc, wall1);
                }
            }, (tool, comp) -> tool.finish(), (r, c) -> true));
            this.clearSnapInfo();
        }

        @Override
        public void reset() {
            super.reset();
            ((FlowPathBuilder)this.props()).reset(false);
        }

        @Override
        public void finish() {
            ((FlowPathBuilder)this.props()).create();
            super.finish();
        }

        @Override
        public boolean cancel() {
            ((FlowPathBuilder)this.props()).cancel();
            return super.cancel();
        }

        @Override
        public void deactivate() {
            ((FlowPathBuilder)this.props()).reset(true);
            super.deactivate();
        }

        @Override
        public boolean isEnabled(VentusData vd) {
            return !vd.floors.flatten(SchematicRoom.class).isEmpty() && !((FlowElementRoot)vd.getComponentData(FlowElementData.GUID)).flatten(FlowElement.class).isEmpty();
        }
    }
}

