/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.CancelledException;
import ventus.actions.Delete;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.comps.DeleteHandler;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.windprofiles.WindProfile;
import ventus.gui.MerlinComboBox;
import ventus.util.Dependencies;

public class FlowPathWindProfDeleteHandler
implements DeleteHandler {
    @Override
    public List<Delete.PropReplacement> getDeleteReplacments(Predicate<? super IMerlinObj> isDeleteObj, VentusApp app, VentusData md) throws CancelledException {
        LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, WindProfile.class, isDeleteObj, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isDeleteObj);
        if (referencing.isEmpty()) {
            return List.of();
        }
        MerlinComboBox mcb = new MerlinComboBox(md, WindProfile.class, isDeleteObj.negate(), (IMerlinObj[])new WindProfile[]{null});
        mcb.setNullName(Intl.intl("None"));
        Set deleteObjSet = md.getComponentData("WindProfile.data").getChildren().stream().filter(obj -> obj instanceof WindProfile).map(obj -> (WindProfile)obj).collect(Collectors.toSet());
        WindProfile repl = (WindProfile)Delete.promptUserForReplacement(app, mcb, deleteObjSet);
        HashSet<FlowPath> objsToChange = new HashSet<FlowPath>(theUtil.filter(referencing, FlowPath.class, obj -> obj.isSupportedLocally(FlowPath.WIND_PROFILE)));
        Delete.PropReplacement replaceWindProfile = new Delete.PropReplacement(FlowPath.WIND_PROFILE, objsToChange, repl);
        Delete.PropReplacement resetWindToConstant = new Delete.PropReplacement(FlowPath.CONSTANT_WIND_PRESSURE, objsToChange, Boolean.TRUE);
        if (repl != null) {
            return List.of(replaceWindProfile);
        }
        return List.of(replaceWindProfile, resetWindToConstant);
    }
}

