/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.EnumSet;
import javax.swing.Icon;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.actions.AMerlinBoolAction;
import ventus.data.VentusData;
import ventus.feature.comps.ISceneItem;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathDispProps;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.feature.flowpaths.FlowPathsFeature;
import ventus.geom.IMerlinDispProps;
import ventus.mv.FilterAction;
import ventus.mv.ModelView;
import ventus.mv.displays.GeomDispMgr;
import ventus.mv.displays.GlobalDisplayMgr;
import ventus.mv.displays.IMerlinDispMgr;
import ventus.mv.displays.scenefinders.DefSceneProvider;

public class FlowPathSceneItem
implements ISceneItem {
    public static final GlobalDisplayMgr.IScenePropsProvider PROPS = GlobalDisplayMgr.overrideProps(ISceneRenderOptions.SOLID_POLYGON_OFFSET, new float[]{1.0f, 1.0f}, ISceneRenderOptions.DRAW_OUTLINES, false, ISceneRenderOptions.DRAW_SELECTED_FACES_OUTLINE, false, ISceneRenderOptions.OPACITY_FACTOR, Float.valueOf(1.0f));

    @Override
    public Pair<GlobalDisplayMgr.SceneInfo, IMerlinDispMgr<?>> createDisplayManager(ModelView mv, VentusData md) {
        GlobalDisplayMgr.SceneInfo info = new GlobalDisplayMgr.SceneInfo(PROPS, new GlobalDisplayMgr.SO[0]);
        return new Pair(info, new GeomDispMgr<FlowPath>(md, mv, FlowPath.class, new DefSceneProvider(info.scene)));
    }

    @Override
    public void addFilterItems(ModelView mv, GroupedSequence root) {
        root.addAll(30, new FilterAction<FlowPath>(Intl.intl("Show Flowpaths"), FlowPathsFeature.ICON, true, FlowPath.class), new SetFlowpathDisplayOptionAction(mv.getDisplayProps(), Intl.intl("Show Flow Path Coverage"), FlowPathDispProps.ICON, false, EnumSet.of(FlowPathDispProps.Options.SHOW_AREA_CALCULATION)));
    }

    private static class SetFlowpathDisplayOptionAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final IMerlinDispProps d_props;
        private final EnumSet<FlowPathDispProps.Options> d_options;

        public SetFlowpathDisplayOptionAction(IMerlinDispProps props, String desc, Icon icon, boolean initValue, EnumSet<FlowPathDispProps.Options> options) {
            super(desc, initValue, icon);
            this.d_props = props;
            this.d_options = options;
        }

        @Override
        protected void work(VentusData data, boolean selected) {
            EnumSet<FlowPathDispProps.Options> options = this.d_props.get(FlowPathDispProps.OPTIONS);
            if (selected) {
                options.addAll(this.d_options);
            } else {
                options.removeAll(this.d_options);
            }
            this.d_props.set(FlowPathDispProps.OPTIONS, options);
            FlowPathRoot root = (FlowPathRoot)data.getComponentData("flowpaths.data");
            if (root != null) {
                VentusData vd = (VentusData)root.getDomain();
                if (vd != null) {
                    vd.pauseUpdates();
                }
                root.flatten(FlowPath.class).forEach(fp -> fp.changedEvt(new Object[0]));
                vd.resumeUpdates();
            }
        }
    }
}

