/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.feature.tags.Tag;
import ventus.feature.windprofiles.WindProfile;
import ventus.feature.windprofiles.WindProfileRoot;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;

public class FlowPathOISHandler
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyVersionUpdates(int updateVersionNumber, int streamVersionNumber, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        FlowPathRoot fproot;
        boolean modified = false;
        if (updateVersionNumber == VentusIO.Version.VER_208.num && streamVersionNumber < VentusIO.Version.VER_208.num) {
            WindProfileRoot wpRoot = (WindProfileRoot)vd.getComponentData("WindProfile.data");
            if (wpRoot == null) {
                return false;
            }
            LinkedIdentityHashSet newProfiles = new LinkedIdentityHashSet();
            fproot = (FlowPathRoot)vd.getComponentData("flowpaths.data");
            for (FlowPath flowPath : fproot.flatten(FlowPath.class)) {
                WindProfile wp2 = flowPath.get(FlowPath.WIND_PROFILE);
                if (wp2 == null || wpRoot.containsDeep(wp2)) continue;
                modified = true;
                Optional<WindProfile> existingProfile = wpRoot.flatten(WindProfile.class).stream().filter(existing -> existing.isMatch(wp2, Filters.reject(WindProfile.DESC))).findFirst();
                if (existingProfile.isPresent()) {
                    warns.addWarning(new Warning(String.format(Intl.intl("Flow Path, \"%1$s\", referenced a Wind Profile, \"%2$s\", that was not in the model."), flowPath.getName(), wp2.getName()), String.format(Intl.intl("Replaced the missing reference with existing Wind Profile, \"%s\"."), existingProfile.get().getName())));
                    flowPath.set(FlowPath.WIND_PROFILE, existingProfile.get());
                    continue;
                }
                warns.addWarning(new Warning(String.format(Intl.intl("Flow Path, \"%1$s\", referenced a Wind Profile, \"%2$s\", that was not in the model."), flowPath.getName(), wp2.getName()), Intl.intl("Added missing Wind Profile to the model.")));
                newProfiles.add(wp2);
            }
            if (!newProfiles.isEmpty()) {
                Set usedNames = wpRoot.flatten(WindProfile.class).stream().map(wp -> wp.getName()).collect(Collectors.toCollection(() -> new HashSet()));
                for (WindProfile newProf : newProfiles) {
                    String baseName = newProf.getName();
                    int i = 1;
                    String name = baseName;
                    while (usedNames.contains(name)) {
                        name = String.format("%s_%02d", baseName, i++);
                    }
                    if (name.equals(baseName)) continue;
                    usedNames.add(name);
                    newProf.setName(name);
                }
                wpRoot.addAll(newProfiles);
            }
        }
        if (updateVersionNumber == VentusIO.Version.VER_210.num && streamVersionNumber < VentusIO.Version.VER_210.num) {
            IdentityHashSet convertedTags = new IdentityHashSet();
            IdentityHashSet flowpathsWithTagRefs = new IdentityHashSet();
            fproot = (FlowPathRoot)vd.getComponentData("flowpaths.data");
            for (FlowPath flowPath : fproot.flatten(FlowPath.class)) {
                Set<Tag> tags = flowPath.getLegacyTags();
                if (tags.isEmpty()) continue;
                convertedTags.addAll(tags);
                flowPath.setTags(tags);
                flowpathsWithTagRefs.add(flowPath);
            }
            convertedTags.addAll(flowpathsWithTagRefs);
            changes.changeObjs.put(210, convertedTags);
        }
        return modified;
    }
}

