/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Set;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.tools.transform.ATransformTool;
import thunderheadeng.util.Events;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.comps.IContextMenuItem;
import ventus.mv.ModelView;

public class DebugOp
extends AMerlinOp
implements IContextMenuItem,
IEventObserver {
    private final UIHook uiHook = new UIHook(this, Intl.intl("&Debug Multiplier,-,Debug Multiplier"));
    private LinkedIdentityHashSet<GeomDisplay> geoms = new LinkedIdentityHashSet();

    @Override
    public void addContextMenuItem(GroupedSequence root) {
        root.getNode("create").add(this.uiHook);
    }

    @Override
    public void update(Events events) {
        IEventRecord<ISchematicRoom> revents = events.getEvents(ISchematicRoom.class, new Class[0]);
        if (revents.hasAddedObjs() || revents.hasRemovedObjs() || revents.containsChange(VentusData.SELECTION_CHANGED)) {
            VentusData md = VentusApp.getAppData();
            assert (md != null);
            this.updateEnabled(md);
        }
    }

    private void updateEnabled(VentusData md) {
        this.setEnabled(VentusApp.isDebug() && !md.selection.flatten(ISchematicRoom.class).isEmpty());
    }

    private void updateDisplay(VentusApp app, IGeomNode geom, IPropsSrc props) {
        ModelView mv = app.getModelView();
        GeomDisplay disp = new GeomDisplay(mv.getDisplayProps(), new ATransformTool.GeomSrc());
        ATransformTool.GeomSrc src = (ATransformTool.GeomSrc)disp.getSource();
        src.display = new DisplayGeom(geom.bakeIfRecommended(), props);
        disp.update();
        this.geoms.add(disp);
        mv.getMainScene().addSceneObjects(disp);
    }

    private void clearDisplay(VentusApp app) {
        ArrayList<GeomDisplay> toRemove = new ArrayList<GeomDisplay>(this.geoms);
        this.geoms = new LinkedIdentityHashSet();
        ModelView mv = app.getModelView();
        for (GeomDisplay geom : toRemove) {
            mv.getMainScene().removeSceneObjects(geom);
        }
    }

    public void draw(VentusApp app, VentusData md, Set<ISchematicRoom> selected) {
        if (selected.isEmpty()) {
            this.clearDisplay(app);
            return;
        }
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Set<ISchematicRoom> selected = md.selection.getSelected(ISchematicRoom.class);
        this.draw(app, md, selected);
    }

    private void debugRenderModel(VentusApp app, Model m, Color color, double offset) {
        ArrayList<APrimitive> geoms = new ArrayList<APrimitive>();
        PropsBuilder props = new PropsBuilder();
        for (Face face : m.getFaces()) {
            for (FaceLoop faceLoop : face.edgeLoops) {
                for (EdgeUse edgeUse : faceLoop.edges) {
                    Point3d p1 = new Point3d(edgeUse.v1().loc);
                    Point3d p2 = new Point3d(edgeUse.v2().loc);
                    p1.z += offset;
                    p2.z += offset;
                    geoms.add(new Point(p1));
                    props.add(new IPrimProps.Vertex(color, 5.0));
                    geoms.add(new Point(p2));
                    props.add(new IPrimProps.Vertex(color, 5.0));
                    geoms.add(new LineSeg(p1, p2));
                    props.add(new IPrimProps.Edge(color, 5.0, IPrimProps.DEF_STIPPLE, 0));
                }
            }
        }
        this.updateDisplay(app, GeomNodeUtil.newNode(new GeomGroup(geoms)), props.finalizeProps());
    }
}

