/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.comps;

import thunderheadeng.util.IPropertySet;
import ventus.data.PropProvider;
import ventus.data.RestorableProperties;
import ventus.data.VentusData;
import ventus.feature.comps.IDataModel;

public final class DefaultFlatDataModel
implements IDataModel {
    private final String d_guid;
    private final PropProvider d_propProvider;

    public DefaultFlatDataModel(String guid, Class<?> propClazz) {
        this.d_guid = guid;
        this.d_propProvider = new PropProvider(propClazz);
    }

    public RestorableProperties getProps(VentusData vd) {
        return (RestorableProperties)vd.getComponentData(this.d_guid);
    }

    @Override
    public void init(VentusData vd) {
        vd.setComponentData(this.d_guid, new RestorableProperties());
        this.reset(vd);
    }

    @Override
    public void reset(VentusData vd) {
        RestorableProperties props = (RestorableProperties)vd.getComponentData(this.d_guid);
        props.pauseUpdates();
        props.clear();
        for (IPropertySet.Prop<?> p : this.d_propProvider.ALL_PROPS) {
            props.set(p, p.defVal);
        }
        props.resumeUpdates();
    }

    @Override
    public void loadFrom(VentusData src, VentusData dest) {
        RestorableProperties srcProps = (RestorableProperties)src.getComponentData(this.d_guid);
        RestorableProperties destProps = (RestorableProperties)dest.getComponentData(this.d_guid);
        destProps.pauseUpdates();
        this.reset(dest);
        destProps.merge(srcProps);
        dest.setComponentData(this.d_guid, destProps);
        destProps.resumeUpdates();
    }
}

