/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahssimple;

import java.util.Collection;
import java.util.function.Function;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.feature.ahssimple.SimpleAHS;

public class SimpleAHSRoot
extends Composite<SimpleAHS> {
    static final long serialVersionUID = 1L;
    private NameGenerator d_nameGen = new NameGenerator(Intl.intl("SimpleAHS"));

    public SimpleAHSRoot() {
        super(Intl.intl("Air Handling Systems"));
        this.addDefaults();
    }

    public String getSuggestedName() {
        return this.d_nameGen.generateName();
    }

    @Override
    public void restoreFrom(Object obj) {
        super.restoreFrom(obj);
        if (!(obj instanceof SimpleAHSRoot)) {
            return;
        }
        SimpleAHSRoot root = (SimpleAHSRoot)obj;
        this.d_nameGen = root.d_nameGen;
    }

    @Override
    public Composite<SimpleAHS> newGroup(String name) {
        return new SimpleAHSNode(name);
    }

    @Override
    public void clear() {
        super.clear();
        this.d_nameGen.reset();
        this.addDefaults();
    }

    @Override
    public void add(ICompElement obj) {
        super.add(obj);
        this.d_nameGen.registerName(obj.getName());
    }

    private void addDefaults() {
        this.pauseUpdates();
        for (Default def : Default.values()) {
            this.add(def.create.apply(def));
        }
        this.resumeUpdates();
    }

    public SimpleAHS getDefault(Collection<SimpleAHS> systems) {
        SimpleAHS defSystem = systems.stream().filter(e -> e.get(SimpleAHS.DEFAULT_TYPE) != null).findFirst().orElse(null);
        if (defSystem != null) {
            return defSystem;
        }
        if (systems.size() > 0) {
            return systems.iterator().next();
        }
        assert (false);
        return null;
    }

    public SimpleAHS getDefault() {
        return this.getDefault(this.getDeepMembers(SimpleAHS.class));
    }

    static class SimpleAHSNode
    extends Composite<SimpleAHS> {
        public SimpleAHSNode(String name) {
            super(name);
        }

        @Override
        public Composite<SimpleAHS> newGroup(String name) {
            return new SimpleAHSNode(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Air Handling System Group");
        }
    }

    public static enum Default {
        GLOBAL(type -> {
            SimpleAHS global = new SimpleAHS("<global>", (Default)((Object)type));
            return global;
        });

        public final Function<Default, SimpleAHS> create;

        private Default(Function<Default, SimpleAHS> create) {
            this.create = create;
        }
    }
}

