/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.schematics.ISchematicObj;
import ventus.feature.ahs.AHSPoint;

public class AHSRoot
extends Composite<AHSPoint> {
    static final long serialVersionUID = 1L;
    private NameGenerator d_nameGen = new NameGenerator(Intl.intl("Supply"));
    private NameGenerator d_returnNameGen = new NameGenerator(Intl.intl("Return"));

    public AHSRoot() {
        super(Intl.intl("AHS Zone Points"));
    }

    public void reset() {
        this.clear();
        this.d_nameGen.reset();
        this.d_returnNameGen.reset();
    }

    @Override
    public void restoreFrom(Object obj) {
        super.restoreFrom(obj);
        if (!(obj instanceof AHSRoot)) {
            return;
        }
        AHSRoot root = (AHSRoot)obj;
        this.d_nameGen = root.d_nameGen;
        this.d_returnNameGen = root.d_returnNameGen;
    }

    public String nextName(AHSPoint.Types type) {
        NameGenerator ngen = this.getNameGenerator(type);
        String name = ngen.generateName();
        ngen.registerName(name);
        return name;
    }

    public NameGenerator getNameGenerator(AHSPoint.Types type) {
        switch (type) {
            case RETURN: {
                return this.d_returnNameGen;
            }
            case SUPPLY: {
                return this.d_nameGen;
            }
        }
        assert (false);
        return this.d_nameGen;
    }

    @Override
    public Composite<AHSPoint> newGroup(String name) {
        return new AHSNode(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("AHS Zone Points Group");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
            obj.readTopology(in);
        }
        if (this.d_returnNameGen == null) {
            AHSRoot tempRoot = new AHSRoot();
            this.d_nameGen.setBaseName(tempRoot.d_nameGen.getBaseName());
            this.d_returnNameGen = new NameGenerator(tempRoot.d_returnNameGen.getBaseName());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
            obj.writeTopology(out);
        }
    }

    static class AHSNode
    extends Composite<AHSPoint> {
        public AHSNode(String name) {
            super(name);
        }

        @Override
        public Composite<AHSPoint> newGroup(String name) {
            return new AHSNode(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("AHS Zone Points Group");
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
                obj.readTopology(in);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
                obj.writeTopology(out);
            }
        }
    }
}

