/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import thunderheadeng.util.WarningReport;
import ventus.data.ICompElement;
import ventus.data.VentusData;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.ahs.AHSRoot;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.ahssimple.SimpleAHSRoot;
import ventus.io.IInputStreamFeatureHandler;
import ventus.io.VentusOIS;

public class AHSPointOISHandler
implements IInputStreamFeatureHandler {
    @Override
    public boolean applyVersionUpdates(int updateVersion, int streamVersion, VentusOIS.DecisionMaker responseHandler, VentusOIS.ChangeTracker changes, WarningReport warns, VentusData vd) {
        AHSRoot root = (AHSRoot)vd.getComponentData("AHS.data");
        if (updateVersion == 204 && streamVersion < 204) {
            VentusOIS.findAndReplaceComposites(root, name -> new AHSRoot.AHSNode((String)name));
        }
        if (updateVersion == 205 && streamVersion < 205 && changes.changeObjs.containsKey(204)) {
            for (ICompElement obj : changes.changeObjs.get(204)) {
                if (!(obj instanceof AHSPoint)) continue;
                root.add(obj);
            }
        }
        if (updateVersion == 213 && streamVersion < 213) {
            SimpleAHSRoot ahsRoot = (SimpleAHSRoot)vd.getComponentData("SimpleAHS.data");
            SimpleAHS defaultAHS = ahsRoot.getDefault();
            AHSRoot ahsPointRoot = (AHSRoot)vd.getComponentData("AHS.data");
            for (AHSPoint point : ahsPointRoot.flatten(AHSPoint.class)) {
                point.setAHS(defaultAHS);
            }
            return true;
        }
        return false;
    }
}

