/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.props.TypedPropSet;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.geom.GeomUtil;
import ventus.geom.PointEntityGeom;
import ventus.mv.tools.RoomSnapConstraint;

public class AHSPoint
extends NamedMerlinObj
implements Serializable,
ISchematicObj,
ICyclicSurrogate,
IDirectDependent<VentusData>,
IObserver {
    private static final long serialVersionUID = 1L;
    public static final TypedPropSet<AHSPoint> PROP_TYPES = new TypedPropSet();
    public static final TypedProp<String> NAME = PROP_TYPES.add(NamedMerlinObj.NAME, NamedMerlinObj::getName, NamedMerlinObj::setName, new TypedPropSet.Options[0]);
    public static final TypedProp<Boolean> VISIBILITY = PROP_TYPES.add(VentusData.VISIBILITY, AHSPoint::isVisible, AHSPoint::setVisible, new TypedPropSet.Options[0]);
    public static final TypedProp<Boolean> ENABLED = PROP_TYPES.add(VentusData.ENABLED, AHSPoint::isEnabled, AHSPoint::setEnabled, new TypedPropSet.Options[0]);
    public static final TypedProp<Set<Tag>> TAGS = PROP_TYPES.add(VentusData.TAGS, AHSPoint::getTags, AHSPoint::setTags, new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> SIZE = PROP_TYPES.add((Object)"AHS.SIZE", new UnitDouble(1.0, SI.METER), new TypedPropSet.Options[0]);
    public static final TypedProp<ISchematicRoom> ROOM = PROP_TYPES.add(new TypedProp<ISchematicRoom>((Object)"AHS.ROOM", ISchematicRoom.class), TypedPropSet.Options.NO_RESTORE, TypedPropSet.Options.TRANSIENT, TypedPropSet.Options.WEAK_DEPENDENT);
    public static final TypedProp<Point3d> LOCATION = PROP_TYPES.add((Object)"AHS.LOCATION", new Point3d(0.0, 0.0, 0.0), new TypedPropSet.Options[0]);
    public static final TypedProp<Vector3d> ROOM_NORMAL = PROP_TYPES.add((Object)"AHS.ROOM_NORMAL", new Vector3d(0.0, 0.0, 1.0), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> DESIGN_FLOW_RATE = PROP_TYPES.add((Object)"AHS.DESIGN_FLOW_RATE", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.SECOND)), new TypedPropSet.Options[0]);
    public static final TypedProp<Types> TYPES = PROP_TYPES.add((Object)"AHS.TYPES", Types.SUPPLY, new TypedPropSet.Options[0]);
    public static final TypedProp<SimpleAHS> AHS = PROP_TYPES.add(new TypedProp<SimpleAHS>((Object)"AHSPoint.AHS", SimpleAHS.class), AHSPoint::getAHS, AHSPoint::setAHS, TypedPropSet.Options.STRONG_DEPENDENT);
    private PropertySet d_properties = new PropertySet();
    private transient PropertySet d_transientProps = new PropertySet();

    public AHSPoint(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.d_transientProps = new PropertySet();
        if (this.d_properties.isDefined(ROOM)) {
            this.d_transientProps.setIfNotDefault(ROOM, this.d_properties.get(ROOM));
            this.d_properties.remove(ROOM);
        }
    }

    @Override
    public void update(IObservable source, Object event) {
        if (!source.equals(this.get(AHS))) {
            return;
        }
        this.changedEvt(AHS);
    }

    @Override
    public AHSPoint clone() {
        AHSPoint ahs = (AHSPoint)super.clone();
        ahs.d_properties = this.d_properties.clone();
        ahs.d_transientProps = this.d_transientProps.clone();
        return ahs;
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        AHSPoint ahs = (AHSPoint)comparable;
        if (!this.getName().equals(ahs.getName())) {
            return false;
        }
        for (TypedProp<?> prop : PROP_TYPES.props()) {
            if (theUtil.equal(this.get(prop), ahs.get(prop), comparedSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.get(ROOM));
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.set(ROOM, (ISchematicRoom)ois.readObject());
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof AHSPoint)) {
            return;
        }
        AHSPoint ahs = (AHSPoint)obj;
        this.pauseUpdates();
        this.setName(ahs.getName());
        PROP_TYPES.restoreFrom(this, this.d_properties, ahs.d_properties, this.d_transientProps, ahs.d_transientProps);
        this.changedEvt(VentusData.TOPOLOGY);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.keys();
    }

    @Override
    public <T> Optional<Nullable<T>> getNullableProp(IPropertySet.Prop<T> prop) {
        if (prop instanceof TypedProp) {
            return PROP_TYPES.getValue(this, this.d_properties, this.d_transientProps, (TypedProp)prop);
        }
        return Optional.empty();
    }

    public <T> T get(TypedProp<T> prop) {
        Optional<Nullable<T>> val = PROP_TYPES.getValue(this, this.d_properties, this.d_transientProps, prop);
        return val.isPresent() ? (T)val.get().val : null;
    }

    public <T> void set(TypedProp<T> prop, T value) {
        PROP_TYPES.setValue(this, this.d_properties, this.d_transientProps, prop, value);
    }

    protected <T> boolean setToPropertySet(TypedProp<T> prop, T value) {
        return PROP_TYPES.compareAndSetDirect(this, this.d_properties, this.d_transientProps, prop, value);
    }

    public boolean isEnabled() {
        return this.d_properties.get(ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.pauseUpdates();
        if (this.setToPropertySet(ENABLED, enabled)) {
            this.changedEvt(VentusData.VISIBILITY, EventChannel.EVT_GENERAL, VentusData.TOPOLOGY);
        }
        this.resumeUpdates();
    }

    public SimpleAHS getAHS() {
        return this.d_properties.get(AHS);
    }

    public void setAHS(SimpleAHS ahs) {
        this.d_properties.set(AHS, ahs);
        this.changedEvt(AHS);
    }

    public Set<Tag> getTags() {
        return this.d_properties.get(VentusData.TAGS);
    }

    public void setTags(Set<Tag> tags) {
        this.setToPropertySet(VentusData.TAGS, tags);
    }

    public boolean getInvalid() {
        return this.get(ROOM) == null;
    }

    @Override
    public <T> void setProperty(Object key, T value) {
        if (key.equals(VentusData.TAGS)) {
            this.setTags((Set)value);
            return;
        }
        TypedProp<T> prop = PROP_TYPES.getStrict(key, value);
        if (prop == null) {
            return;
        }
        this.set(prop, value);
    }

    @Override
    public Object getProperty(Object key) {
        TypedProp<?> prop = PROP_TYPES.get(key);
        if (prop == null) {
            return NOT_SUPPORTED;
        }
        return this.get(prop);
    }

    @Override
    public boolean isVisible() {
        return this.d_properties.get(VISIBILITY) != false && this.get(ENABLED) != false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.setToPropertySet(VISIBILITY, visible);
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        return this.get(ROOM) != null ? Collections.singleton(this.get(ROOM)) : Collections.emptyList();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return this.get(ROOM) == null;
    }

    @Override
    public void disconnectFrom(ISchematicObj conn) {
        if (conn == this.get(ROOM)) {
            this.set(ROOM, null);
            this.pauseUpdates();
            this.set(ROOM_NORMAL, GeomConstants.VEC3D_ZPOS);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public void connectTo(ISchematicObj conn) {
    }

    @Override
    public boolean updateTopo() {
        Point3d location = this.get(LOCATION);
        GeomUtil.FindResult room = GeomUtil.findRoom((VentusData)this.getDomain(), new Point3d(location.x, location.y, location.z + 1.0E-6), new Point3d(location.x, location.y, location.z - 1.0E-6), 1, AHSPoint.getRoomFilter());
        if (room != null) {
            this.pauseUpdates();
            this.set(ROOM, room.room);
            this.set(ROOM_NORMAL, room.faceNormal);
            this.set(LOCATION, room.p);
            this.resumeUpdates();
        }
        return true;
    }

    public static BiPredicate<? super ISchematicRoom, ? super ISchematicRoom.IComponent> getRoomFilter() {
        return (room, comp) -> room.getType() == ISchematicRoom.Type.ZONE && !(comp instanceof ISchematicRoom.IWallComponent);
    }

    public static boolean requiresLocation(IPropertySet props) {
        switch (props.get(TYPES).ordinal()) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPointGeom());
    }

    private AHSPointGeom getPointGeom() {
        return new AHSPointGeom((VentusData)this.getDomain(), this.get(LOCATION));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof PointEntityGeom) {
            PointEntityGeom p = (PointEntityGeom)geom;
            this.set(LOCATION, p.location);
        }
        this.markTopoDirty();
    }

    private void markTopoDirty() {
        this.changedEvt(VentusData.TOPOLOGY);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder gprops = new PropsBuilder();
        switch (this.get(TYPES).ordinal()) {
            case 0: {
                gprops.add(new IPrimProps.Face(Color.RED, null, 0), 12);
                break;
            }
            case 1: {
                gprops.add(new IPrimProps.Face(Color.GREEN, null, 0), 12);
            }
        }
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0), 18);
        return new DisplayGeom(geom, gprops);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getTags());
        PROP_TYPES.takeDepSnapshot(this, this.d_properties, this.d_transientProps, deps);
        deps.add(DLink.STRONG, this.getProperty(AHS));
    }

    @Override
    public void replaceDependency(VentusData md, Object old, Object replacement) {
        TagsUtil.replaceDependency(this, old, replacement);
        PROP_TYPES.replaceDependency(this, this.d_properties, this.d_transientProps, old, replacement);
    }

    public static enum Types {
        SUPPLY(Intl.intl("Supply"), Intl.intl("Supply Zone Point")),
        RETURN(Intl.intl("Return"), Intl.intl("Return Zone Point"));

        public final String name;
        public final String desc;

        private Types(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }

    private static class AHSPointGeom
    extends PointEntityGeom {
        private static final long serialVersionUID = 1L;
        private final VentusData vd;

        public AHSPointGeom(VentusData vd, Point3d loc) {
            super(loc, 0.6);
            this.vd = vd;
        }

        @Override
        public AHSPointGeom newPoint(Point3d loc) {
            return new AHSPointGeom(this.vd, loc);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new Handle());
        }

        public class Handle
        extends PointEntityGeom.Handle {
            public Handle() {
                super(AHSPointGeom.this);
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return new RoomSnapConstraint(AHSPointGeom.this.vd, null, AHSPoint.getRoomFilter());
            }
        }
    }
}

