/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.elem.IPrimElements;
import thunderheadeng.geometry.objs.node.AGeomNode;
import thunderheadeng.geometry.objs.node.GeomNodeGroup;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.ProxyIsectCollector;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.SoftCachedValue;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.data.AMerlinObj;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ASchematicComp;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.ISchematicConnector;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.ISchematicRoomColorSrc;
import ventus.data.schematics.geom.RoomUtil;
import ventus.data.schematics.geom.SchematicCorridor;
import ventus.data.schematics.geom.SchematicDoor;
import ventus.data.schematics.geom.SchematicModelGeom;
import ventus.data.value.Schedule;
import ventus.geom.GeomUtil;
import ventus.geom.Geometry;
import ventus.geom.IMerlinDispProps;
import ventus.io.inferno.InfernoGeom;
import ventus.io.inferno.InfernoType;
import ventus.mv.MerlinColors;
import ventus.unitsystem.SIUS;
import ventus.util.Dependencies;

public class SchematicRoom
extends ASchematicComp
implements Serializable,
ISchematicRoom,
IDirectDependent<VentusData> {
    static final long serialVersionUID = 1L;
    public static final Logger LOGGER = Logger.getLogger(SchematicRoom.class.getSimpleName());
    private static final Color COLOR = new Color(0.86f, 0.83f, 1.0f);
    public static final Elements.ElemProp<Boolean> PICKABLE_ELEM = new Elements.ElemProp<Boolean>(-349025687, "SchematicRoom.PICKABLE_ELEM", Boolean.class, new ElementUniform<Boolean>(true));
    public static final int DEFAULT_CLEANUP_OPTIONS = 23;
    public static final Object AREA_ADDED = "CopPolyNavGeom.AREA_ADDED";
    public static final Object AREA_SUBTRACTED = "CopPolyNavGeom.AREA_SUBTRACTED";
    public static final Object CLEARED = "CopPolyNavGeom.CLEARED";
    @Deprecated
    public static final Object TEMPERATURE = "SchematicRoom.TEMPERATURE";
    public static final Object TEMPERATURE_SCHEDULE = "SchematicRoom.TEMPERATURE_SCHEDULE";
    public static final Object TEMP_DEFINEDLOCALLY = "SchematicRoom.TEMP_OVERWRITE";
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(ASchematicComp.PROP_TYPES, AREA, VOLUME, HEIGHT, TEMPERATURE, TEMPERATURE_SCHEDULE, TEMP_DEFINEDLOCALLY, TYPE);
    private static final Matrix4d s_identity = new Matrix4d();
    @SkipDep
    private Model d_geometry;
    private CachedValue<Boolean> d_overlapsSelf;
    @SkipDep
    private SoftCachedValue<Model> d_displayModel;
    @SkipDep
    private SoftCachedValue<IGeomNode> d_wallGeom;
    @SkipDep
    private SoftCachedValue<IPropsSrc> d_wallDrawProps;
    private Set<String> d_tags;
    @Deprecated
    private UnitDouble d_temperature = null;
    private Schedule d_temperatureSchedule;
    private boolean d_tempDefinedLocally;
    private ISchematicRoom.Type d_type = ISchematicRoom.Type.ZONE;
    private IMaterial d_material;
    @SkipDep
    private transient Set<ISchematicObj> d_topology;

    public SchematicRoom(String name) {
        this(name, new Model(), 0);
    }

    public SchematicRoom(String name, Model geometry) {
        this(name, geometry, 23);
    }

    public SchematicRoom(String name, Model geometry, int cleanupOptions) {
        super(name);
        MerlinColors colorMgr;
        super.setColor(COLOR);
        this.d_overlapsSelf = new CachedValue();
        this.d_displayModel = new SoftCachedValue();
        this.d_wallGeom = new SoftCachedValue();
        this.d_wallDrawProps = new SoftCachedValue();
        this.d_geometry = geometry;
        this.d_geometry = RoomUtil.cleanup(this.d_geometry, cleanupOptions, Predicates.alwaysTrue());
        this.d_topology = new LinkedIdentityHashSet<ISchematicObj>();
        this.d_tags = Collections.emptySet();
        this.d_temperatureSchedule = Schedule.newConstant(new UnitDouble(20.0, SI.CELSIUS));
        this.d_tempDefinedLocally = false;
        Runnable markWallPropsDirty = () -> this.markCachesDirty(false, false, true, false, new Object[0]);
        VentusApp app = VentusApp.getApp();
        MerlinColors merlinColors = colorMgr = app == null ? null : app.getColorManager();
        if (colorMgr != null) {
            colorMgr.addColorChangedListener(c -> markWallPropsDirty.run());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_type = ISchematicRoom.Type.ZONE;
        in.defaultReadObject();
        this.d_topology = new LinkedIdentityHashSet<ISchematicObj>();
        if (this.d_temperatureSchedule == null) {
            this.d_temperatureSchedule = Schedule.newConstant(this.d_temperature);
            this.d_temperature = null;
        }
    }

    public Schedule getTemperatureSchedule() {
        return this.d_temperatureSchedule;
    }

    public void setTemperatureSchedule(Schedule temp) {
        this.d_temperatureSchedule = temp;
        this.changedEvt(TEMPERATURE_SCHEDULE);
    }

    public boolean getTempDefinedLocally() {
        return this.d_tempDefinedLocally;
    }

    public void setTempDefinedLocally(Boolean flag) {
        this.d_tempDefinedLocally = flag;
        this.changedEvt(TEMP_DEFINEDLOCALLY);
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_topology);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_topology = (Set)ois.readObject();
    }

    private void markCachesDirty(boolean displayModel, boolean wallGeom, boolean wallDrawProps, boolean overlap, Object ... changes) {
        if (displayModel) {
            this.d_displayModel.clear();
        }
        if (wallGeom) {
            this.d_wallGeom.clear();
        }
        if (wallDrawProps) {
            this.d_wallDrawProps.clear();
        }
        if (overlap) {
            this.d_overlapsSelf.clear();
        }
        this.changedEvt(changes);
    }

    private void markGeomCachesDirty(Object ... changes) {
        this.markCachesDirty(true, true, true, true, new Object[0]);
    }

    @Override
    public void floorHeightChanged() {
        if (this.getType().hasWalls) {
            this.markCachesDirty(false, true, true, false, new Object[0]);
        }
    }

    @Override
    public Object getRestoreObj() {
        return this.clone(true, true, null);
    }

    @Override
    public void restoreFrom(Object obj) {
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.markTopoDirty();
        SchematicRoom rm = (SchematicRoom)obj;
        this.d_geometry = rm.d_geometry.clone();
        this.d_overlapsSelf = rm.d_overlapsSelf;
        this.d_material = rm.d_material;
        this.d_temperatureSchedule = rm.d_temperatureSchedule;
        this.d_tempDefinedLocally = rm.d_tempDefinedLocally;
        this.markCachesDirty(true, true, true, false, new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public boolean surrogateEquals(Object obj) {
        return this.surrogateEqualsHelper(obj);
    }

    private int surrogateHashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + theUtil.hashCode(this.getArea());
        hash = 31 * hash + theUtil.hashCode(this.d_geometry.getBoundingBox());
        return hash;
    }

    @Override
    protected boolean surrogateEqualsHelper(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SchematicRoom)) {
            return false;
        }
        SchematicRoom room = (SchematicRoom)obj;
        return super.surrogateEqualsHelper(room) && this.getArea().equals(room.getArea()) && this.d_geometry.getBoundingBox().equals(room.d_geometry.getBoundingBox());
    }

    public SchematicRoom clone(boolean deep, boolean cloneGeom, Map<IMerlinObj, IMerlinObj> cloneMap) {
        SchematicRoom clone = (SchematicRoom)super.clone();
        if (cloneGeom) {
            clone.d_geometry = this.d_geometry.clone();
        }
        clone.d_topology = new LinkedIdentityHashSet<ISchematicObj>();
        clone.d_overlapsSelf = this.d_overlapsSelf.clone();
        clone.d_wallDrawProps = this.d_wallDrawProps.clone();
        clone.d_wallGeom = this.d_wallGeom.clone();
        clone.d_displayModel = this.d_displayModel.clone();
        clone.markCachesDirty(true, true, true, false, new Object[0]);
        return clone;
    }

    @Override
    public SchematicRoom clone() {
        return this.clone(false, true, null);
    }

    @Override
    public boolean updateTopo() {
        return true;
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return true;
    }

    private void markTopoDirty() {
        this.changedEvt(VentusData.TOPOLOGY);
    }

    public boolean isConnected(ISchematicObj obj) {
        return this.d_topology.contains(obj);
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        return this.d_topology;
    }

    @Override
    public void connectTo(ISchematicObj conn) {
        this.d_topology.add(conn);
        if (conn instanceof ISchematicConnector || conn instanceof SchematicCorridor) {
            this.markGeomCachesDirty(new Object[0]);
        } else {
            this.markCachesDirty(false, false, true, false, VentusData.CONNECTION);
        }
    }

    @Override
    public void disconnectFrom(ISchematicObj conn) {
        this.d_topology.remove(conn);
        if (conn instanceof ISchematicConnector || conn instanceof SchematicCorridor) {
            this.markGeomCachesDirty(new Object[0]);
        } else {
            this.markCachesDirty(false, false, true, false, VentusData.CONNECTION);
        }
    }

    @Override
    public void getConnectors(Collection<? super ISchematicConnector> connectors) {
    }

    @Override
    public Model getModel() {
        return this.d_geometry;
    }

    @Override
    public boolean isModelCached() {
        return true;
    }

    public void setModel(Model geometry) {
        this.d_geometry = geometry;
        this.markTopoDirty();
        this.markGeomCachesDirty(new Object[0]);
    }

    public boolean getModificationsAllowed() {
        return true;
    }

    public boolean add(SchematicRoom comp2) {
        Model model1 = this.d_geometry.clone();
        Model model2 = comp2.d_geometry.clone();
        int t1 = Integer.MAX_VALUE;
        int t2 = 0x7FFFFFFE;
        for (Face face : model2.getFaces()) {
            face.addGroup(t2);
        }
        for (Face face : model1.getFaces()) {
            face.addGroup(t1);
        }
        model1.merge(model2);
        ArrayList<Edge> sharedEdges = new ArrayList<Edge>();
        for (Edge edge : model1.getEdges()) {
            if (edge.faces.size() <= 1) continue;
            boolean bl = false;
            boolean m2Found = false;
            for (Face face : edge.faces) {
                if (face.partOfGroup(t1)) {
                    bl = true;
                }
                if (!face.partOfGroup(t2)) continue;
                m2Found = true;
            }
            if (!bl || !m2Found) continue;
            sharedEdges.add(edge);
        }
        if (sharedEdges.isEmpty()) {
            return false;
        }
        int[] nArray = new int[]{0};
        for (Edge edge : sharedEdges) {
            if (!edge.partOfGroup(1) && !edge.partOfGroup(t2)) continue;
            edge.groups = nArray;
        }
        int[] nArray2 = new int[]{t1, t2};
        for (Face face : model1.getFaces()) {
            face.removeGroups(nArray2);
        }
        this.d_geometry = model1;
        this.pauseUpdates();
        this.markTopoDirty();
        this.markGeomCachesDirty(new Object[0]);
        this.resumeUpdates();
        return true;
    }

    public boolean sub(SchematicRoom comp2) {
        return this.subtract(comp2.getModel(), false);
    }

    public boolean subVolume(Model volume) {
        return this.subtract(volume, true);
    }

    private static boolean delFace(Model model1, Model subModel, Face face, boolean isVolume) {
        if (face.partOfGroup(Integer.MAX_VALUE)) {
            return true;
        }
        if (!isVolume) {
            return false;
        }
        Point3d testP = model1.findPointInFace(face);
        return testP == null || subModel.contains(testP);
    }

    public List<Face> haveCommonFaces(Model subModel, boolean isVolume) {
        Model model2 = subModel.clone();
        int[] tempGroup = new int[]{Integer.MAX_VALUE};
        for (Face face : model2.getFaces()) {
            face.groups = tempGroup;
        }
        Model model1 = this.d_geometry.clone();
        model1.merge(model2);
        return this.haveCommonFaces(model1, model2, isVolume, new ArrayList<Face>());
    }

    private List<Face> haveCommonFaces(Model mergeModel, Model subModel, boolean isVolume, List<Face> delFaces) {
        ArrayList<Face> commonFaces = new ArrayList<Face>();
        for (Face face : mergeModel.getFaces()) {
            if (!SchematicRoom.delFace(mergeModel, subModel, face, isVolume)) continue;
            delFaces.add(face);
            if (!face.partOfGroup(0)) continue;
            commonFaces.add(face);
        }
        return commonFaces;
    }

    public boolean subtract(Model subModel, boolean isVolume) {
        Model model2 = subModel.clone();
        int[] tempGroup = new int[]{Integer.MAX_VALUE};
        for (Face face : model2.getFaces()) {
            face.groups = tempGroup;
        }
        Model model1 = this.d_geometry.clone();
        model1.merge(model2);
        ArrayList<Face> delFaces = new ArrayList<Face>();
        if (this.haveCommonFaces(model1, subModel, isVolume, delFaces).isEmpty()) {
            return false;
        }
        for (Face delFace : delFaces) {
            model1.deleteFace(delFace, true, true);
        }
        int[] boundGroup = new int[]{1};
        for (Edge edge : model1.getEdges()) {
            Face face;
            if (edge.faces.size() != 1 || (face = edge.faces.get(0)).isInternalEdge(edge)) continue;
            edge.groups = boundGroup;
        }
        this.pauseUpdates();
        this.d_geometry = model1;
        this.markTopoDirty();
        this.markGeomCachesDirty(new Object[0]);
        this.resumeUpdates();
        return true;
    }

    private static LineSeg3D toLineSeg3D(LineSeg ls) {
        return new LineSeg3D(ls.p1, ls.p2);
    }

    public Predicate<Edge> getInUseEdgeFilter() {
        final LinkedHashSet inUseEdges = new LinkedHashSet();
        final BiFunction<Point3d, Point3d, LineSeg3D> round = (ep1, ep2) -> new LineSeg3D(Util3D.round(ep1, 9), Util3D.round(ep2, 9));
        Consumer<LineSeg3D> addEdge = e -> inUseEdges.add((LineSeg3D)round.apply(e.p1, e.p2));
        for (SchematicDoor door : theUtil.filter(this.getDoors(), SchematicDoor.class)) {
            if (door.getRoom1() == this) {
                addEdge.accept(door.getEdge1());
            }
            if (door.getRoom2() != this) continue;
            addEdge.accept(door.getEdge2());
        }
        for (SchematicCorridor corr : this.getCorridors()) {
            SchematicCorridor.DoorInfo d1 = corr.getDoor1();
            SchematicCorridor.DoorInfo d2 = corr.getDoor2();
            if (d1.getRoom() == this) {
                addEdge.accept(SchematicRoom.toLineSeg3D(d1.getEdge()));
            }
            if (d2.getRoom() != this) continue;
            addEdge.accept(SchematicRoom.toLineSeg3D(d2.getEdge()));
        }
        if (inUseEdges.isEmpty()) {
            return Predicates.alwaysFalse();
        }
        return new Predicate<Edge>(){

            @Override
            public boolean test(Edge o) {
                if (!o.curve.isLinear()) {
                    return false;
                }
                return inUseEdges.contains(round.apply(o.v1.loc, o.v2.loc)) || inUseEdges.contains(round.apply(o.curve.get(0.0), o.curve.get(1.0)));
            }
        };
    }

    public Model cleanup(Model model) {
        return RoomUtil.cleanup(model, 31, this.getInUseEdgeFilter());
    }

    private void cleanupModel() {
        Model cleaned;
        Model original = this.getModel();
        if (original != (cleaned = this.cleanup(original))) {
            this.setModel(cleaned);
        }
    }

    public static void cleanup(VentusData md, Collection<? extends SchematicRoom> rooms) {
        if (!rooms.isEmpty()) {
            md.updateTopology();
            rooms.forEach(SchematicRoom::cleanupModel);
        }
    }

    public List<SchematicRoom> addBoundary(Collection<? extends ICurve> boundary, double edgeError) {
        this.d_geometry.addEdges(Integer.MAX_VALUE, SchematicRoom.toParms(boundary, edgeError));
        ArrayList<Edge> toDelete = new ArrayList<Edge>();
        int[] boundaryid = new int[]{1};
        for (Edge edge : this.d_geometry.getEdges()) {
            boolean newEdge = edge.partOfGroup(Integer.MAX_VALUE);
            if (newEdge && edge.faces.isEmpty()) {
                toDelete.add(edge);
                continue;
            }
            if (!newEdge) continue;
            edge.groups = boundaryid;
        }
        for (Edge delEdge : toDelete) {
            this.d_geometry.deleteEdge(delEdge, true);
        }
        this.markTopoDirty();
        this.markGeomCachesDirty(new Object[0]);
        List<SchematicRoom> separated = this.separate();
        return separated;
    }

    @Override
    public IGeomNode getGeom() {
        IGeomNode base = this.getFloorGeom();
        IGeomNode walls = this.getWallGeom();
        return new RoomGeom(base, walls);
    }

    @Override
    public void pickBox(final IBoxCollector result, IIsectFilter filter, ConvexHull region, IDisplayProps dispProps) {
        IBoxCollector skipNonPickable = new IBoxCollector(){

            @Override
            public void addNonFace(Object obj, int primIx, IPrimElements primElements) throws CancelObjectPicking {
                if (!primElements.getElement(PICKABLE_ELEM).orElse(true).booleanValue()) {
                    return;
                }
                result.addNonFace(obj, primIx, primElements);
            }

            @Override
            public void addFace(Object obj, int primIx, Supplier<Pair<Point3d, Vector3d>> getPointAndNormal, IPrimElements faceElements, IPrimProps faceProps) throws CancelObjectPicking {
                if (!faceElements.getElement(PICKABLE_ELEM).orElse(true).booleanValue()) {
                    return;
                }
                result.addFace(obj, primIx, getPointAndNormal, faceElements, faceProps);
            }
        };
        super.pickBox(skipNonPickable, filter, region, dispProps);
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester, IDisplayProps dprops) {
        ProxyIsectCollector skipNonPickable = new ProxyIsectCollector(this, isects){

            @Override
            public void addNonFace(Object obj, Point3d p, GeomType type, int primIx, IPrimElements primElements) {
                if (!primElements.getElement(PICKABLE_ELEM).orElse(true).booleanValue()) {
                    return;
                }
                this.base.addNonFace(obj, p, type, primIx, primElements);
            }

            @Override
            public void addFace(Object obj, Point3d p, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal, IPrimElements faceElements, IPrimProps faceProps) {
                if (!faceElements.getElement(PICKABLE_ELEM).orElse(true).booleanValue()) {
                    return;
                }
                this.base.addFace(obj, p, primIx, getPrim, getNormal, faceElements, faceProps);
            }
        };
        super.pickPoints(skipNonPickable, filter, rayBegin, rayDirN, maxDist, tester, dprops);
    }

    public IGeomNode getFloorGeom() {
        return this.getFloorGeom(this.d_geometry, false);
    }

    private IGeomNode getFloorGeom(Model roomModel, boolean displayable) {
        int options = 1;
        if (displayable) {
            options |= 4;
        }
        if (this.getModificationsAllowed()) {
            options |= 2;
        }
        SchematicModelGeom geom = new SchematicModelGeom(roomModel, displayable ? Filters.rejectAll(Edge.class) : this.getInUseEdgeFilter(), Predicates.alwaysTrue(), this.getBoundaryEdgeFilter(), options);
        IPropertySet elements = Elements.newElements();
        elements.setIfNotDefault(COMPONENT_ELEMENT, new ElementUniform<ISchematicRoom.DefaultFloorComponent>(DEFAULT_FLOOR_COMPONENT));
        elements.setIfNotDefault(Elements.CREASE, Elements.NO_CREASE);
        elements = Elements.finalizeElements(elements);
        return GeomNodeUtil.newNode(geom, elements);
    }

    @Override
    public void setGeom(IGeomNode node) {
        assert (node instanceof RoomGeom);
        if (!(node instanceof RoomGeom)) {
            return;
        }
        RoomGeom rg = (RoomGeom)node;
        this.setGeom(rg.room.transform(rg.getLocalTransform().getInfo()).flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        assert (geom instanceof SchematicModelGeom);
        if (!(geom instanceof SchematicModelGeom)) {
            return;
        }
        SchematicModelGeom mg = (SchematicModelGeom)geom;
        this.d_geometry = mg.model;
        this.markTopoDirty();
        this.markGeomCachesDirty(new Object[0]);
    }

    private IPrimProps getFaceProps(IMerlinDispProps props) {
        return props.getFaceProps(this, IMerlinDispProps.SchematicType.ROOM, this.d_material, this.getColor(), this.getOpacity());
    }

    private IPrimProps getBoundaryProps(IMerlinDispProps props) {
        return props.getEdgeProps(this, IMerlinDispProps.SchematicType.BOUNDARY, null, this.getOpacity());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps dprops) {
        if (!(dprops instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps props = (IMerlinDispProps)dprops;
        Model displayModel = this.d_displayModel.get(() -> {
            ArrayList<IParametric3D> sharedEdges = new ArrayList<IParametric3D>();
            for (ISchematicConnector conn : this.getDoors(true)) {
                sharedEdges.addAll(conn.getSharedEdges(this));
            }
            for (SchematicCorridor corr : this.getCorridors(true)) {
                sharedEdges.addAll(corr.getSharedEdges(this));
            }
            if (sharedEdges.isEmpty()) {
                return this.d_geometry;
            }
            Model dispModel = this.d_geometry.clone();
            dispModel.addEdges(Integer.MAX_VALUE, sharedEdges);
            int[] group = new int[]{0};
            for (Edge edge : dispModel.getEdges()) {
                if (!edge.partOfGroup(Integer.MAX_VALUE)) continue;
                edge.groups = group;
            }
            return dispModel;
        });
        IGeomNode floorGeom = this.getFloorGeom(displayModel, true);
        int numFaces = floorGeom.getNumPrims(1);
        int numBEdges = floorGeom.getNumPrims(2);
        IPrimProps fprops = this.getFaceProps(props);
        IPrimProps bprops = this.getBoundaryProps(props);
        PropsBuilder floorProps = new PropsBuilder();
        floorProps.add(fprops, numFaces);
        floorProps.add(bprops, numBEdges);
        return this.getDisplayAndPickableGeom(props, floorGeom, floorProps, false, () -> {});
    }

    @Override
    public void setDomain(VentusData domain, IMerlinObj parent) {
        if (domain != this.getDomain()) {
            super.setDomain(domain, parent);
            this.markCachesDirty(false, true, true, false, new Object[0]);
        }
    }

    private IGeomNode getWallGeom() {
        return this.d_wallGeom.get(() -> {
            if (!this.getType().hasWalls) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            Floor level = this.getLevel();
            if (level == null) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            Vector3d offset = new Vector3d(0.0, 0.0, level.getHeight().get(Geometry.LENGTH_UNIT));
            LinkedHashMap<Point3d, Integer> points = new LinkedHashMap<Point3d, Integer>();
            Function<Point3d, Integer> nextIx = p -> points.size();
            ArrayList<Integer> faceIxes = new ArrayList<Integer>();
            ArrayList<Integer> borderEdgeIxes = new ArrayList<Integer>();
            ArrayList<Wall> components = new ArrayList<Wall>();
            ArrayList<Vector3d> normals = new ArrayList<Vector3d>();
            for (Face face : this.d_geometry.getFaces()) {
                for (FaceLoop loop : face.edgeLoops) {
                    for (EdgeUse eu : loop.edges) {
                        if (!eu.edge.partOfGroup(1)) continue;
                        Point3d p1 = eu.v1().loc;
                        Point3d p2 = eu.v2().loc;
                        Point3d p2a = Util3D.add(p2, (Tuple3d)offset);
                        Point3d p1a = Util3D.add(p1, (Tuple3d)offset);
                        List<Point3d> facePoints = Arrays.asList(p1, p2, p2a, p1a);
                        Plane3d plane = Util3D.simplePolygonPlane(facePoints, true, 1.0E-12);
                        if (plane == null) continue;
                        for (Point3d p3 : facePoints) {
                            faceIxes.add(points.computeIfAbsent(p3, nextIx));
                        }
                        components.add(new Wall(face, eu));
                        normals.add(plane.getNormal());
                        borderEdgeIxes.add((Integer)points.get(p2));
                        borderEdgeIxes.add((Integer)points.get(p2a));
                        borderEdgeIxes.add((Integer)points.get(p2a));
                        borderEdgeIxes.add((Integer)points.get(p1a));
                    }
                }
            }
            if (faceIxes.isEmpty()) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            ArrayList<GeomNodeLeaf> nodes = new ArrayList<GeomNodeLeaf>(2);
            Point3d[] pointsArr = (Point3d[])theUtil.toArray(points.keySet());
            Mesh mesh = new Mesh(pointsArr, theUtil.toIntArray(faceIxes), 3);
            IPropertySet elements = Elements.newElements();
            elements.setIfNotDefault(ISchematicRoom.COMPONENT_ELEMENT, new ElementMesh<ISchematicRoom.IComponent>(ElementMesh.Mapping.PER_PRIM, (ISchematicRoom.IComponent[])theUtil.toArray(components), 1));
            elements.setIfNotDefault(Elements.NORMAL, new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM, (Vector3d[])theUtil.toArray(normals), 1));
            elements.setIfNotDefault(Elements.ORIENT, Elements.CCW);
            elements.setIfNotDefault(Elements.CREASE, Elements.ALL_CREASE);
            GeomNodeLeaf faceNode = GeomNodeUtil.newNode(mesh, Elements.finalizeElements(elements));
            nodes.add(faceNode);
            mesh = new Mesh(pointsArr, theUtil.toIntArray(borderEdgeIxes), 1);
            elements = Elements.newElements();
            elements.setIfNotDefault(PICKABLE_ELEM, new ElementUniform<Boolean>(false));
            elements = Elements.finalizeElements(elements);
            GeomNodeLeaf edgesNode = GeomNodeUtil.newNode(mesh, elements);
            nodes.add(edgesNode);
            GeomNodeGroup result = GeomNodeUtil.newNode(nodes);
            return result;
        });
    }

    private IPropsSrc getWallDisplayProps(IMerlinDispProps mprops, IGeomNode wallGeom) {
        Function<Color, IPrimProps> getFaceProps = color -> mprops.getFaceProps(this, IMerlinDispProps.SchematicType.ROOM, this.d_material, (Color)color, this.getOpacity());
        return this.d_wallDrawProps.get(() -> {
            HashMap componentColors = new HashMap();
            for (ISchematicRoomColorSrc colorSrc : this.getConnections(ISchematicRoomColorSrc.class)) {
                colorSrc.getRoomColors(this, (w, c) -> componentColors.computeIfAbsent(w, wall -> (IPrimProps)getFaceProps.apply((Color)c)));
            }
            IPrimProps edgeProps = this.getBoundaryProps(mprops);
            IPrimProps defaultWallFaceProps = (IPrimProps)getFaceProps.apply(this.getColor() == null ? null : theUtil.generateRandomOffsetColor(this.getColor(), 0.3f, 0L));
            PropsBuilder props = new PropsBuilder();
            Iterator<IGeomNode> nodeIt = wallGeom.flatIterator();
            while (nodeIt.hasNext()) {
                IGeomNode node = nodeIt.next();
                int numPrims = node.getLocalGeom().getNumPrims(7);
                if (numPrims == 0) continue;
                IPropertySet elements = node.getLocalElements();
                IElemSource components = (IElemSource)((Object)elements.get(ISchematicRoom.COMPONENT_ELEMENT));
                Iterator componentIt = components.getPerPrimIterator();
                for (int m = 0; m < numPrims; ++m) {
                    ISchematicRoom.IComponent comp = (ISchematicRoom.IComponent)componentIt.next();
                    if (!(comp instanceof Wall)) {
                        props.add(edgeProps);
                        continue;
                    }
                    Wall wall = (Wall)comp;
                    IPrimProps fprops = componentColors.getOrDefault(wall, defaultWallFaceProps);
                    props.add(fprops);
                }
            }
            return props.finalizeProps();
        });
    }

    private DisplayGeom getDisplayAndPickableGeom(IMerlinDispProps mprops, IGeomNode floorGeom, IPropsSrc floorProps, boolean pickable, Runnable validateProgress) {
        IGeomNode wallGeom = this.getWallGeom();
        IPropsSrc wallProps = this.getWallDisplayProps(mprops, wallGeom);
        if (pickable) {
            boolean wireframe = mprops.isWireframe(this);
            wallGeom = wallGeom.getPickable(validateProgress, wireframe);
        }
        IGeomNode geom = new RoomGeom(floorGeom, wallGeom);
        PropsBuilder propsBuilder = new PropsBuilder();
        propsBuilder.add(floorProps, floorGeom.getNumPrims(7));
        propsBuilder.add(wallProps, wallGeom.getNumPrims(7));
        IPropsSrc finalProps = propsBuilder.finalizeProps();
        if (!pickable) {
            geom = GeomUtil.finalizeTexCoords(geom, finalProps);
        }
        return new DisplayGeom(geom, finalProps);
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dispProps, Runnable validateProgress) {
        IGeomNode baseGeom = this.getFloorGeom();
        if (dispProps instanceof IMerlinDispProps) {
            return this.getDisplayAndPickableGeom((IMerlinDispProps)dispProps, baseGeom, DEF_PROPS, true, validateProgress);
        }
        return new DisplayGeom(this.getGeom().getPickable(validateProgress, dispProps.isWireframe(this)), IPickable.DEF_PROPS);
    }

    @Override
    public void getInfernoGeom(List<InfernoGeom> geoms, IMerlinDispProps dprops) {
        ArrayList<SchematicRoom> areas = new ArrayList<SchematicRoom>(1);
        SchematicRoom shape1 = this.clone();
        for (ISchematicConnector conn : this.getDoors()) {
            SchematicRoom extraGeom = conn.getExtraGeom(this);
            if (extraGeom == null) continue;
            areas.add(extraGeom);
        }
        for (SchematicRoom shape2 : areas) {
            shape1.sub(shape2);
            shape2.sub(this);
            shape1.add(shape2);
        }
        Model cleanedModel = RoomUtil.cleanup(shape1.getModel(), 23, Predicates.alwaysTrue(), true);
        shape1.setModel(cleanedModel);
        IGeom roomGeom = shape1.getFloorGeom().getLocalGeom();
        geoms.add(new InfernoGeom(this, InfernoType.OPEN, roomGeom, this.getFaceProps(dprops)));
        geoms.add(new InfernoGeom(this, InfernoType.BOUNDARY, roomGeom, this.getBoundaryProps(dprops)));
    }

    public List<SchematicRoom> separate() {
        List<Model> separatedModels = RoomUtil.separate(this.d_geometry);
        if (separatedModels.size() <= 1) {
            return Arrays.asList(this);
        }
        ArrayList<SchematicRoom> separatedRooms = new ArrayList<SchematicRoom>(separatedModels.size());
        for (Model model : separatedModels) {
            SchematicRoom newRoom = this.clone(false, false, null);
            newRoom.d_geometry = model;
            newRoom.setVisible(this.isVisible());
            newRoom.setColor(this.getColor());
            newRoom.setOpacity(this.getOpacity());
            separatedRooms.add(newRoom);
        }
        int biggestRoomIx = SchematicRoom.getBiggestRoom(separatedRooms);
        SchematicRoom biggestRoom = (SchematicRoom)separatedRooms.get(biggestRoomIx);
        separatedRooms.remove(biggestRoomIx);
        separatedRooms.add(0, biggestRoom);
        return separatedRooms;
    }

    private static int getBiggestRoom(List<SchematicRoom> rooms) {
        UnitDouble biggestRoomArea = new UnitDouble(-1.0, SIUS.unit(2));
        int biggestRoom = 0;
        for (int m = 0; m < rooms.size(); ++m) {
            UnitDouble area = rooms.get(m).getArea();
            if (area.compareTo(biggestRoomArea) <= 0) continue;
            biggestRoomArea = area;
            biggestRoom = m;
        }
        return biggestRoom;
    }

    public boolean overlapsSelf() {
        return this.d_overlapsSelf.get(() -> {
            theTimer timer = new theTimer();
            boolean overlapsSelf = RoomUtil.overlapsSelf(this.d_geometry);
            double time = timer.curr();
            System.out.printf("Recalculated overlap for %s: %g sec%n", this.getName(), time);
            return overlapsSelf;
        });
    }

    public Set<ISchematicConnector> getDoors(boolean excludeDisabled) {
        if (excludeDisabled) {
            return theUtil.filter(this.getDoors(), d -> !(d instanceof ASchematicComp) || ((ASchematicComp)((Object)d)).isEnabled());
        }
        return this.getDoors();
    }

    public Set<ISchematicConnector> getDoors() {
        return this.getTop(ISchematicConnector.class);
    }

    public Set<SchematicCorridor> getCorridors(boolean excludeDisabled) {
        if (excludeDisabled) {
            return theUtil.filter(this.getCorridors(), d -> d.isEnabled());
        }
        return this.getCorridors();
    }

    public Set<SchematicCorridor> getCorridors() {
        return this.getTop(SchematicCorridor.class);
    }

    private <T extends ISchematicObj> Set<T> getTop(Class<T> type) {
        return Collections.unmodifiableSet(new LinkedIdentityHashSet<T>(this.getConnections(type)));
    }

    @Override
    public <T> Collection<? extends T> getConnections(Class<T> type) {
        return theUtil.filter(this.d_topology, entry -> type.isAssignableFrom(entry.getClass()));
    }

    @Override
    public UnitDouble getArea() {
        double area = 0.0;
        for (Face face : this.d_geometry.getFaces()) {
            area += face.getArea();
        }
        UnitDouble areau = new UnitDouble(area, Geometry.AREA_UNIT);
        return areau;
    }

    public double getRoomArea() {
        return this.getArea().getRawValue();
    }

    public int subdivide(IFaceClassifier classifier, Collection<? extends ICurve> boundary, double edgeError, int newId) throws Exception {
        return this.subdivide(classifier, SchematicRoom.toParms(boundary, edgeError), newId);
    }

    protected static List<IParametric3D> toParms(Collection<? extends ICurve> curves, double edgeError) {
        ArrayList<IParametric3D> parms = new ArrayList<IParametric3D>(curves.size());
        for (ICurve iCurve : curves) {
            Mesh segments = iCurve.getSegments(edgeError);
            for (int m = 0; m < segments.indices.length; m += 2) {
                parms.add(new LineSeg3D(segments.vertices[segments.indices[m]], segments.vertices[segments.indices[m + 1]]));
            }
        }
        return parms;
    }

    public int subdivide(IFaceClassifier classifier, Collection<? extends IParametric3D> boundary, int newId) throws Exception {
        int tempEdgeId = Integer.MAX_VALUE;
        Predicate<Edge> boundaryEdgeTest = e -> e.partOfGroup(tempEdgeId);
        Model newGeom = this.d_geometry.clone();
        newGeom.addEdges(tempEdgeId, boundary);
        ArrayList<Edge> newEdges = new ArrayList<Edge>(newGeom.getGroup((int)tempEdgeId, (boolean)false, (boolean)true, (boolean)false).edges);
        LinkedIdentityHashSet closedFaces = new LinkedIdentityHashSet();
        for (Edge edge : newEdges) {
            for (Face f : edge.faces) {
                if (closedFaces.contains(f)) continue;
                Set<Face> touching = SchematicRoom.findTouchingFaces(f, boundaryEdgeTest, Predicates.alwaysFalse());
                closedFaces.addAll(touching);
                if (!classifier.test(newGeom, touching)) continue;
                int adjCount = 0;
                for (Face eface : edge.faces) {
                    if (!touching.contains(eface)) continue;
                    ++adjCount;
                }
                if (adjCount > 1) {
                    throw new Exception(String.format(Intl.intl("Boundary does not completely enclose a region in room %s."), this.getName()));
                }
                for (Face touchingFace : touching) {
                    touchingFace.addGroup(newId);
                }
            }
        }
        if (newGeom.getGroup((int)newId, (boolean)true, (boolean)false, (boolean)false).faces.isEmpty()) {
            return -1;
        }
        int[] remIds = new int[]{tempEdgeId};
        for (Edge edge : newEdges) {
            edge.removeGroups(remIds);
        }
        this.setGeom(new SchematicModelGeom(newGeom));
        return newId;
    }

    private static Set<Face> findTouchingFaces(Face seed, Predicate<Edge> boundaryEdgeTest, Predicate<Face> boundaryTriTest) {
        LinkedIdentityHashSet<Face> closed = new LinkedIdentityHashSet<Face>();
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        open.addLast(seed);
        closed.add(seed);
        while (!open.isEmpty()) {
            Face face = (Face)open.pollLast();
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (boundaryEdgeTest.test(eu.edge)) continue;
                    for (Face adjFace : eu.edge.faces) {
                        if (boundaryTriTest.test(adjFace) || !closed.add(adjFace)) continue;
                        open.addLast(adjFace);
                    }
                }
            }
        }
        return closed;
    }

    public IMaterial getMaterial() {
        return this.d_material;
    }

    public void setMaterial(IMaterial material) {
        if (Objects.equals(this.d_material, material)) {
            return;
        }
        this.d_material = material;
        this.markCachesDirty(false, false, true, false, new Object[0]);
    }

    @Override
    public void setColor(Color color) {
        if (!Objects.equals(this.getColor(), color)) {
            this.pauseUpdates();
            this.markCachesDirty(false, false, true, false, new Object[0]);
            super.setColor(color);
            this.resumeUpdates();
        }
    }

    @Override
    public void setOpacity(float opacity) {
        if (this.getOpacity() != opacity) {
            this.pauseUpdates();
            this.markCachesDirty(false, false, true, false, new Object[0]);
            super.setOpacity(opacity);
            this.resumeUpdates();
        }
    }

    @Override
    public ISchematicRoom.Type getType() {
        return this.d_type;
    }

    public void setType(ISchematicRoom.Type type) {
        if (this.d_type == type) {
            return;
        }
        this.d_type = type;
        this.markCachesDirty(true, true, true, false, VentusData.TOPOLOGY);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == AREA) {
            return this.getArea();
        }
        if (property == VOLUME) {
            return this.getVolume();
        }
        if (property == HEIGHT) {
            return this.getHeight();
        }
        if (property == TEMPERATURE_SCHEDULE) {
            return this.getTemperatureSchedule();
        }
        if (property == TEMP_DEFINEDLOCALLY) {
            return this.getTempDefinedLocally();
        }
        if (property == TYPE) {
            return this.getType();
        }
        return super.getProperty(property);
    }

    public void setProperty(Object property, Object value) {
        if (property == TEMPERATURE_SCHEDULE) {
            this.setTemperatureSchedule((Schedule)value);
            this.setTempDefinedLocally(true);
        } else if (property == TEMP_DEFINEDLOCALLY) {
            this.setTempDefinedLocally((Boolean)value);
        } else if (property == TYPE) {
            this.setType((ISchematicRoom.Type)((Object)value));
        } else {
            super.setProperty(property, value);
        }
    }

    @Override
    public Collection<AMerlinObj> getConnObjectsForEnable(VentusData md) {
        ArrayList<AMerlinObj> connObjects = new ArrayList<AMerlinObj>();
        for (ISchematicObj iSchematicObj : this.getConnections()) {
            if (iSchematicObj instanceof ISchematicComp) {
                connObjects.add((ASchematicComp)iSchematicObj);
            }
            if (!(iSchematicObj instanceof SchematicCorridor) && !(iSchematicObj instanceof SchematicDoor)) continue;
            connObjects.addAll(((ASchematicComp)iSchematicObj).getConnObjectsForEnable(md));
        }
        ArrayList allReferences = new ArrayList();
        Dependencies.getObjReferences(md, o -> o == this, (source, target) -> allReferences.add((AMerlinObj)source));
        return connObjects;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.WEAK, this.d_material);
    }

    @Override
    public void replaceDependency(VentusData md, Object old, Object replacement) {
        super.replaceDependency(md, old, replacement);
        if (old == this.d_material) {
            this.setMaterial((IMaterial)replacement);
        }
    }

    static {
        s_identity.setIdentity();
    }

    public static class RoomGeom
    extends AGeomNode {
        private static final long serialVersionUID = 1L;
        public final IGeomNode room;
        public final IGeomNode walls;

        public RoomGeom() {
            this(GeomNodeUtil.EMPTY_NODE, GeomNodeUtil.EMPTY_NODE);
        }

        public RoomGeom(IGeomNode roomGeom, IGeomNode wallGeom) {
            this((ITransform)TransformUtil.IDENTITY, roomGeom, wallGeom);
        }

        public RoomGeom(ITransform xform, IGeomNode roomGeom, IGeomNode wallGeom) {
            super(xform, EmptyGeom.INSTANCE, Elements.newElements());
            this.room = roomGeom;
            this.walls = wallGeom;
        }

        @Override
        public IGeomNode newNode(ITransform xform, IGeom geom, IPropertySet elements, Collection<? extends IGeomNode> children) {
            assert (geom.getNumPrims(7) == 0);
            assert (children.size() == 2);
            Iterator<? extends IGeomNode> childIt = children.iterator();
            return new RoomGeom(xform, childIt.next(), childIt.next());
        }

        @Override
        public Collection<? extends IGeomNode> getChildren() {
            return Arrays.asList(this.room, this.walls);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            IGeomNode.generateLocalHandles(this.room, handle -> {
                if (handle instanceof IGeomNode.Handle) {
                    handles.accept(new SearchGeomHandle((IGeomNode.Handle)handle));
                }
            });
        }

        public class SearchGeomHandle
        implements IHandle {
            public final IGeomNode.Handle base;

            public SearchGeomHandle(IGeomNode.Handle base) {
                this.base = base;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || !obj.getClass().equals(this.getClass())) {
                    return false;
                }
                return ((SearchGeomHandle)obj).base.equals(this.base);
            }

            @Override
            public IGeomNode getGeom() {
                return this.base.getGeom();
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return this.base.getPickFilter();
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return this.base.getConstraint(handleLoc);
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
                this.base.begin(handleLoc, constraint);
            }

            @Override
            public Object modify(Point3d newLoc) throws ManipException {
                return this.modifySearch(this.base.modify(newLoc));
            }

            @Override
            public Object end() {
                return this.modifySearch(this.base.end());
            }

            private RoomGeom modifySearch(IGeomNode newRoom) {
                return new RoomGeom(RoomGeom.this.getLocalTransform(), newRoom, RoomGeom.this.walls);
            }
        }
    }

    public static interface IFaceClassifier {
        public boolean test(Model var1, Collection<Face> var2);
    }

    public static class Wall
    implements ISchematicRoom.IWallComponent {
        private static final long serialVersionUID = 1L;
        public final Face face;
        public final EdgeUse edge;

        public Wall(Face face, EdgeUse edge) {
            this.face = face;
            this.edge = edge;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!Wall.class.isInstance(obj)) {
                return false;
            }
            Wall wall = (Wall)obj;
            return wall.edge.orient == this.edge.orient && wall.face == this.face && wall.edge.edge == this.edge.edge;
        }

        public int hashCode() {
            return 0xAF983 ^ Objects.hash(this.face, this.edge.orient, this.edge.edge);
        }

        @Override
        public Pair<Model, Face> toNmt(ISchematicRoom room, boolean modifiable) {
            Floor level = room.getLevel();
            if (level == null) {
                return null;
            }
            return RoomUtil.getWallNmtGeom(this.edge, level.getHeight());
        }

        @Override
        public IPolygon toPoly(ISchematicRoom room) {
            Floor level = room.getLevel();
            if (level == null) {
                return null;
            }
            return RoomUtil.getWallPoly(this.edge, level.getHeight());
        }

        @Override
        public Vector3d getNormal() {
            Vector3d edir = Util3D.vector(this.edge.v1().loc, this.edge.v2().loc);
            if (Util3D.safeNormalize(edir, 0.0) == 0.0) {
                return edir;
            }
            Vector3d normal = Util3D.cross(edir, Util3D.VEC3D_ZPOS);
            Util3D.safeNormalize(normal, 1.0E-12);
            return normal;
        }
    }
}

