/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.SchematicCorridor;
import ventus.data.schematics.geom.SchematicDoor;
import ventus.data.schematics.geom.SchematicRoom;

public class SchematicGeomUtil {
    public static Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> computeConflicts(VentusData md, Predicate<? super ISchematicComp> filter, boolean edge, boolean manifold, int numAllowedConns, LineSeg ... edges) {
        ArrayList<Pair<ISchematicComp, ISchematicComp.ConflictType>> conflicts = new ArrayList<Pair<ISchematicComp, ISchematicComp.ConflictType>>();
        if (edge) {
            conflicts.addAll(SchematicGeomUtil.computeEdgeOverlap(md, filter, edges));
        }
        if (manifold) {
            conflicts.addAll(SchematicGeomUtil.computeNonManifoldConnections(md, filter, numAllowedConns, edges));
        }
        return conflicts;
    }

    public static Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> computeEdgeOverlap(VentusData md, final Predicate<? super ISchematicComp> filter, LineSeg ... edges) {
        AABox bounds = new AABox();
        final ArrayList<Pair<ISchematicComp, ISchematicComp.ConflictType>> result = new ArrayList<Pair<ISchematicComp, ISchematicComp.ConflictType>>();
        for (final LineSeg edge : edges) {
            IResult<IDisplayableGeomSrc> fresult = new IResult<IDisplayableGeomSrc>(){

                @Override
                public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                    if (obj instanceof ISchematicComp && filter.test((ISchematicComp)obj) && SchematicGeomUtil.overlaps(edge, (ISchematicComp)obj)) {
                        result.add(new Pair<ISchematicComp, ISchematicComp.ConflictType>((ISchematicComp)obj, ISchematicComp.ConflictType.EDGE));
                    }
                }
            };
            bounds.reset();
            edge.getBoundingBox(bounds);
            md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(bounds, 1.0E-6), (IResult<? super IDisplayableGeomSrc>)fresult, 1);
        }
        return result;
    }

    public static boolean overlaps(LineSeg edge, ISchematicComp comp) {
        Point3d[] boundary = null;
        if (comp instanceof SchematicCorridor) {
            SchematicCorridor corr = (SchematicCorridor)comp;
            boundary = corr.getBoundary();
        } else if (comp instanceof SchematicDoor) {
            SchematicDoor door = (SchematicDoor)comp;
            boundary = door.getDoorGeom().getBoundary();
        }
        if (boundary == null) {
            return false;
        }
        for (int m = 0; m < boundary.length; m += 2) {
            double[] overlap = Inter3D.lineSeglineSegOverlap(edge.p1, edge.p2, boundary[m], boundary[m + 1], 1.0E-9, 1.0E-12);
            if (overlap == null || theUtil.eq(overlap[0], overlap[1], 1.0E-6)) continue;
            return true;
        }
        return false;
    }

    public static Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> computeNonManifoldConnections(VentusData md, final Predicate<? super ISchematicComp> filter, int numAllowedConns, LineSeg ... edges) {
        AABox bounds = new AABox();
        ArrayList<Pair<ISchematicComp, ISchematicComp.ConflictType>> result = new ArrayList<Pair<ISchematicComp, ISchematicComp.ConflictType>>();
        for (final LineSeg edge : edges) {
            final ArrayList adjRooms = new ArrayList();
            IResult<IDisplayableGeomSrc> fresult = new IResult<IDisplayableGeomSrc>(){

                @Override
                public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                    int count;
                    if (obj instanceof SchematicRoom && filter.test((SchematicRoom)obj) && (count = SchematicGeomUtil.getAdjacentCount((SchematicRoom)obj, edge)) > 0) {
                        adjRooms.add(new Pair<SchematicRoom, Integer>((SchematicRoom)obj, count));
                    }
                }
            };
            bounds.reset();
            edge.getBoundingBox(bounds);
            md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(bounds, 1.0E-6), (IResult<? super IDisplayableGeomSrc>)fresult, 1);
            int numConns = 0;
            for (Pair adj : adjRooms) {
                numConns += ((Integer)adj.v2).intValue();
            }
            if (numConns <= numAllowedConns) continue;
            for (Pair adj : adjRooms) {
                result.add(new Pair<ISchematicComp, ISchematicComp.ConflictType>((ISchematicComp)adj.v1, ISchematicComp.ConflictType.NON_MANIFOLD));
            }
        }
        return result;
    }

    public static int getAdjacentCount(SchematicRoom room, LineSeg edge) {
        List<Edge> nearEdges = room.getModel().findEdges(edge.getBoundingBox(new AABox()));
        int count = 0;
        for (Edge redge : nearEdges) {
            double[] overlap = Inter3D.lineSeglineSegOverlap(edge.p1, edge.p2, redge.v1.loc, redge.v2.loc, 1.0E-9, 1.0E-12);
            if (overlap == null || theUtil.eq(overlap[0], overlap[1], 1.0E-6)) continue;
            for (Face face : redge.faces) {
                if (face.isInternalEdge(redge)) {
                    count += 2;
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    public static boolean removeConflict(Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> conflicts, ISchematicObj obj) {
        Pair<ISchematicComp, ISchematicComp.ConflictType> next;
        if (!(obj instanceof ISchematicComp)) {
            return false;
        }
        boolean recalcNMConflicts = false;
        Iterator<Pair<ISchematicComp, ISchematicComp.ConflictType>> it = conflicts.iterator();
        while (it.hasNext()) {
            next = it.next();
            if (next.v1 != obj) continue;
            recalcNMConflicts |= next.v2 == ISchematicComp.ConflictType.NON_MANIFOLD;
            it.remove();
        }
        if (recalcNMConflicts) {
            it = conflicts.iterator();
            while (it.hasNext()) {
                next = it.next();
                if (next.v2 != ISchematicComp.ConflictType.NON_MANIFOLD) continue;
                it.remove();
            }
            return true;
        }
        return false;
    }
}

