/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.geom;

import java.awt.Color;
import java.util.Map;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.LinkedIdentityHashMap;
import ventus.Intl;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.geom.IMerlinDispProps;

public enum SchematicDoorDir {
    ALL(null, Intl.intl("Open")),
    NONE(null, Intl.intl("Closed")),
    EAST(new Vector2d(1.0, 0.0), Intl.intl("+X")),
    WEST(new Vector2d(-1.0, 0.0), Intl.intl("-X")),
    NORTH(new Vector2d(0.0, 1.0), Intl.intl("+Y")),
    SOUTH(new Vector2d(0.0, -1.0), Intl.intl("-Y"));

    public final Vector2d vec;
    public final String name;

    private SchematicDoorDir(Vector2d vec, String name) {
        this.vec = vec;
        this.name = name;
    }

    public SchematicDoorDir flip() {
        switch (this.ordinal()) {
            case 4: {
                return SOUTH;
            }
            case 5: {
                return NORTH;
            }
            case 2: {
                return WEST;
            }
            case 3: {
                return EAST;
            }
        }
        return ALL;
    }

    public static SchematicDoorDir toDir(Vector2d vec) {
        if (vec == null) {
            return ALL;
        }
        vec = new Vector2d(vec);
        vec.normalize();
        if (vec.x >= 0.5) {
            return EAST;
        }
        if (vec.x < -0.5) {
            return WEST;
        }
        if (vec.y >= 0.5) {
            return NORTH;
        }
        return SOUTH;
    }

    public Vector2d adjustForDoor(LineSeg doorSeg) {
        return SchematicDoorDir.adjustForDoor(this.vec, doorSeg);
    }

    public static Vector2d adjustForDoor(Vector2d onewayDir, LineSeg doorSeg) {
        if (onewayDir == null) {
            return null;
        }
        Vector3d doorDir = doorSeg.getTangent(0.0, ICurve.Orient.POSITIVE, true);
        Vector3d crossDir = Util3D.cross(GeomConstants.VEC3D_ZPOS, doorDir);
        Vector2d crossDir2d = new Vector2d(crossDir.x, crossDir.y);
        crossDir2d.normalize();
        if (onewayDir.dot(crossDir2d) < 0.0) {
            crossDir2d.negate();
        }
        return crossDir2d;
    }

    public static SchematicDoorDir toDir(LineSeg doorSeg, boolean into) {
        ICurve.Orient orient = into ? ICurve.Orient.POSITIVE : ICurve.Orient.NEGATIVE;
        Vector3d doorDir = doorSeg.getTangent(0.0, orient, true);
        Vector3d travelDir = Util3D.cross(GeomConstants.VEC3D_ZPOS, doorDir);
        Vector2d dir = new Vector2d(travelDir.x, travelDir.y);
        return SchematicDoorDir.toDir(dir);
    }

    public static IGeom generateDisplayGeom(ISchematicObj src, IMerlinDispProps dispProps, Vector2d onewayDir, Point3d[] boundary, ISchematicRoom adjRoom1, ISchematicRoom adjRoom2, PropsBuilder props) {
        Face adjFace;
        Point3d p2;
        Point3d p1;
        ISchematicRoom adjRoom;
        int doorOpts = dispProps.getDoorDrawOptions();
        if (onewayDir == null || (doorOpts & 1) == 0) {
            return EmptyGeom.INSTANCE;
        }
        Vector3d onewayDir3d = new Vector3d(onewayDir.x, onewayDir.y, 0.0);
        boolean dirPositive = Util3D.cross((Vector3d)onewayDir3d, (Vector3d)Util3D.vector((Point3d)boundary[boundary.length - 2], (Point3d)boundary[boundary.length - 1])).z >= 0.0;
        ISchematicRoom iSchematicRoom = adjRoom = dirPositive ? adjRoom2 : adjRoom1;
        if (boundary.length == 2) {
            p1 = boundary[0];
            p2 = boundary[1];
        } else if (!dirPositive) {
            p1 = boundary[0];
            p2 = boundary[1];
        } else {
            p1 = boundary[2];
            p2 = boundary[3];
        }
        double arrowSize = Math.min(Util.feetToMeters(2.0), 0.5 * p1.distance(p2));
        Point3d center = Util3D.getMidPoint(p1, p2);
        if (adjRoom != null && (adjFace = adjRoom.getModel().findFace(center)) != null) {
            Plane3d alignPlane = adjFace.plane;
            SchematicDoorDir.projectAlongZ(onewayDir3d, alignPlane, onewayDir3d, true);
        }
        Vector3d dir = Util3D.vectorN(p1, p2);
        dir.scale(arrowSize * 0.5);
        Point3d t1 = Util3D.add(center, (Tuple3d)dir);
        Point3d t2 = Util3D.add(center, (Tuple3d)Util3D.scale(onewayDir3d, arrowSize * 0.5));
        Point3d t3 = Util3D.sub(center, (Tuple3d)dir);
        Triangle t = new Triangle(t1, t2, t3);
        t = t.transform(TransformUtil.translate(0.0, 0.0, 0.003).getInfo(), 0);
        props.add(new IPrimProps.Face(Color.BLACK, null, 0));
        PolyLine outline = new PolyLine(t.p1, t.p2, t.p3, t.p1);
        props.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        return GeomUtil.group(t, outline);
    }

    private static Vector3d projectAlongZ(Vector3d result, Plane3d plane, Vector3d dir, boolean reLengthen) {
        if (dir.x == 0.0 && dir.y == 0.0 || plane.x * dir.x + plane.y * dir.y + plane.z * dir.z == 0.0) {
            result.set(dir.x, dir.y, dir.z);
            return result;
        }
        if (plane.z == 0.0) {
            result.set(0.0, 0.0, 1.0);
            return result;
        }
        double dirz = (-plane.x * dir.x - plane.y * dir.y) / plane.z;
        if (reLengthen) {
            double len = dir.length();
            result.set(dir.x, dir.y, dirz);
            result.normalize();
            result.scale(len);
        } else {
            result.set(dir.x, dir.y, dirz);
        }
        return result;
    }

    public static Map<SchematicDoorDir, String> getMap(Predicate<SchematicDoorDir> filter) {
        LinkedIdentityHashMap<SchematicDoorDir, String> map = new LinkedIdentityHashMap<SchematicDoorDir, String>();
        for (SchematicDoorDir state : SchematicDoorDir.values()) {
            if (!filter.test(state)) continue;
            map.put(state, state.name);
        }
        return map;
    }
}

