/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.elevators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.function.Predicate;
import thunderheadeng.util.TypeFilter;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.ICompElement;
import ventus.data.INameGenerator;
import ventus.data.SequentialNameGen;
import ventus.data.schematics.elevators.Elevator;
import ventus.data.schematics.elevators.ElevatorGroup;

public class ElevatorRoot
extends GeomComposite<Elevator> {
    private static final long serialVersionUID = 342354923948723948L;
    private INameGenerator d_nameGen = new SequentialNameGen(Intl.intl("Elevator"), 2);
    private static final Predicate<ICompElement> s_filter = new TypeFilter<ICompElement>(Elevator.class, ElevatorGroup.class);

    public ElevatorRoot() {
        super(Intl.intl("Elevators"));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_nameGen == null) {
            this.d_nameGen = new SequentialNameGen(Intl.intl("Elevator"), 2);
        }
    }

    public INameGenerator getNameGen() {
        return this.d_nameGen;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ElevatorRoot)) {
            return;
        }
        ElevatorRoot er = (ElevatorRoot)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.d_nameGen = er.d_nameGen;
        this.resumeUpdates();
    }

    @Override
    public void clear() {
        this.d_nameGen.reset();
        super.clear();
    }

    @Override
    public void add(ICompElement obj) {
        if (!(obj instanceof Elevator) && !(obj instanceof ElevatorGroup)) {
            return;
        }
        super.add(obj);
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new ElevatorGroup(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Elevator Group");
    }
}

