/*
 * Decompiled with CFR 0.152.
 */
package ventus.builders;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.IResponder;
import ventus.builders.ATwoPointBuilder;
import ventus.builders.RoomGeomBuilder;
import ventus.builders.WorkingPlane;
import ventus.data.VentusData;
import ventus.geom.Geometry;

public class WallSubBuilder
extends ATwoPointBuilder {
    public static final Object ALIGN = "WallSubBuilder.ALIGN";
    public static final Object WIDTH = "WallSubBuilder.WIDTH";
    public static final int WALL_ALIGN_LEFT = 0;
    public static final int WALL_ALIGN_CENTER = 1;
    public static final int WALL_ALIGN_RIGHT = 2;
    private int d_wallAlign = 2;
    private double d_wallWidth = 0.1524;

    public WallSubBuilder(VentusData data, IResponder<String> responder, WorkingPlane workingPlane) {
        super(data, workingPlane, new RoomGeomBuilder(RoomGeomBuilder.BooleanOp.SUBTRACT, responder));
    }

    public String getShapeName() {
        return null;
    }

    public void setAlignment(int align) {
        if (!this.lock()) {
            return;
        }
        this.d_wallAlign = align;
        this.firePropChanged(ALIGN);
        this.release();
    }

    public int getAlignment(int align) {
        return this.d_wallAlign;
    }

    public void setWidth(double width) {
        if (!this.lock()) {
            return;
        }
        this.d_wallWidth = width;
        this.firePropChanged(WIDTH);
        this.release();
    }

    public double getWidth() {
        return this.d_wallWidth;
    }

    @Override
    public Shape getShape() {
        switch (this.d_wallAlign) {
            case 0: {
                return this.getLeftAlignedWall();
            }
            case 1: {
                return this.getCenterAlignedWall();
            }
            case 2: {
                return this.getRightAlignedWall();
            }
        }
        assert (false);
        return null;
    }

    @Override
    public void updatePoints(ArrayList<Point2d> points) {
        points.add(this.getP1());
        points.add(this.getP2());
    }

    @Override
    public Point2d getMidpointLocation(int ix) {
        Point2d p1 = this.getP1();
        Point2d p2 = this.getP2();
        if (ix == 0) {
            return new Point2d((p2.x + p1.x) / 2.0, (p2.y + p1.y) / 2.0);
        }
        return new Point2d(0.0, 0.0);
    }

    @Override
    public ArrayList<String> getPointsAsStrings(Unit u) {
        ArrayList<String> texts = new ArrayList<String>();
        Point2d p1 = this.getP1();
        Point2d p2 = this.getP2();
        UnitDouble len = new UnitDouble(p1.distance(p2), Geometry.LENGTH_UNIT);
        String lString = Global.format(len, u, 1);
        texts.add(lString);
        return texts;
    }

    private static Vector2d offsetVec(Point2d p1, Point2d p2, double size) {
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        Vector2d r = new Vector2d(dy, -dx);
        r.normalize();
        r.scale(size);
        return r;
    }

    private Shape getLeftAlignedWall() {
        Point2d p1 = this.getP1();
        Point2d p2 = this.getP2();
        if (p1 == null || p2 == null) {
            return new Path2D.Double();
        }
        Vector2d lVec = WallSubBuilder.offsetVec(p2, p1, this.d_wallWidth);
        Point2d p3 = new Point2d(p2.x + lVec.x, p2.y + lVec.y);
        Point2d p4 = new Point2d(p1.x + lVec.x, p1.y + lVec.y);
        return WallSubBuilder.createRect(p1, p2, p3, p4);
    }

    private Shape getRightAlignedWall() {
        Point2d p1 = this.getP1();
        Point2d p2 = this.getP2();
        if (p1 == null || p2 == null) {
            return new Path2D.Double();
        }
        Vector2d rVec = WallSubBuilder.offsetVec(p1, p2, this.d_wallWidth);
        Point2d p3 = new Point2d(p2.x + rVec.x, p2.y + rVec.y);
        Point2d p4 = new Point2d(p1.x + rVec.x, p1.y + rVec.y);
        return WallSubBuilder.createRect(p4, p3, p2, p1);
    }

    private Shape getCenterAlignedWall() {
        Point2d p1p = this.getP1();
        Point2d p2p = this.getP2();
        if (p1p == null || p2p == null) {
            return new Path2D.Double();
        }
        double halfWidth = this.d_wallWidth * 0.5;
        Vector2d lVec = WallSubBuilder.offsetVec(p2p, p1p, halfWidth);
        Vector2d rVec = new Vector2d(-lVec.x, -lVec.y);
        return WallSubBuilder.createRect(new Point2d(p1p.x + rVec.x, p1p.y + rVec.y), new Point2d(p2p.x + rVec.x, p2p.y + rVec.y), new Point2d(p2p.x + lVec.x, p2p.y + lVec.y), new Point2d(p1p.x + lVec.x, p1p.y + lVec.y));
    }

    private static Shape createRect(Point2d p1, Point2d p2, Point2d p3, Point2d p4) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(p1.x, p1.y);
        path.lineTo(p2.x, p2.y);
        path.lineTo(p3.x, p3.y);
        path.lineTo(p4.x, p4.y);
        path.closePath();
        return path;
    }
}

