/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.importgeom;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtSolidUtil;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.util.Pair;
import ventus.geom.GeomUtil;

public class PyroUtil {
    public static final int GRIDFACE_MINX = 0;
    public static final int GRIDFACE_MAXX = 1;
    public static final int GRIDFACE_MINY = 2;
    public static final int GRIDFACE_MAXY = 3;
    public static final int GRIDFACE_MINZ = 4;
    public static final int GRIDFACE_MAXZ = 5;

    public static Model mergeGrids(List<AABox> gridBBs) {
        Model mergeModel = null;
        ArrayList<Face> delFaces = new ArrayList<Face>();
        for (int m = 0; m < gridBBs.size(); ++m) {
            Model model2 = PyroUtil.modelFromGrid(gridBBs.get(m), m);
            if (m == 0) {
                mergeModel = model2;
                continue;
            }
            Model model1 = mergeModel.clone();
            mergeModel.merge(model2);
            delFaces.clear();
            for (Face face : mergeModel.getFaces()) {
                if (!PyroUtil.isMergeDeleteFace(model1, model2, m, mergeModel, face)) continue;
                delFaces.add(face);
            }
            for (Face delFace : delFaces) {
                mergeModel.deleteFace(delFace, true, true);
            }
        }
        if (mergeModel == null) {
            mergeModel = new Model();
        }
        return mergeModel;
    }

    public static int encodeModelId(int gridid, int faceid) {
        assert (faceid < 6 && faceid >= 0);
        assert (gridid < (int)Math.pow(2.0, 29.0) && gridid >= 0);
        int id = faceid << 29;
        return id |= gridid;
    }

    public static int[] extractGridFaceId(int encodedModelId) {
        int gridid = 0x1FFFFFFF & encodedModelId;
        int faceid = encodedModelId >>> 29;
        return new int[]{gridid, faceid};
    }

    private static Model modelFromGrid(AABox grid, int gridid) {
        Model model = new Model();
        int[] faceids = new int[]{0, 1, 2, 3, 4, 5};
        Point3d[][] faces = grid.getFaces();
        assert (faces.length == faceids.length);
        for (int m = 0; m < 6; ++m) {
            Point3d[] face = faces[m];
            Plane3d plane = new Plane3d(true, face);
            ArrayList<LineSeg3D> curves = new ArrayList<LineSeg3D>(face.length);
            for (int n = 0; n < face.length; ++n) {
                Point3d p1 = face[n];
                Point3d p2 = face[(n + 1) % face.length];
                curves.add(new LineSeg3D(p1, p2));
            }
            int id = PyroUtil.encodeModelId(gridid, faceids[m]);
            GeomUtil.addFaceToModel(model, id, plane, curves);
        }
        return model;
    }

    private static boolean isMergeDeleteFace(Model model1, Model model2, int mod2Id, Model mergeModel, Face mergeFace) {
        boolean partOfMod1;
        boolean partOfMod2 = false;
        for (int groupid : mergeFace.groups) {
            if (PyroUtil.extractGridFaceId(groupid)[0] != mod2Id) continue;
            partOfMod2 = true;
            break;
        }
        boolean bl = partOfMod1 = !partOfMod2 || mergeFace.groups.length > 1;
        if (partOfMod1 && !partOfMod2 && NmtSolidUtil.faceInSolid(model2, mergeModel, mergeFace) || !partOfMod1 && partOfMod2 && NmtSolidUtil.faceInSolid(model1, mergeModel, mergeFace)) {
            return true;
        }
        if (partOfMod2 && partOfMod1) {
            Point3d pInFace = mergeModel.findPointInFace(mergeFace);
            if (pInFace == null) {
                return true;
            }
            Vector3d normal = mergeFace.plane.getNormal();
            Point3d testPoint1 = PyroUtil.findTestPoint(mergeModel, mergeFace, pInFace, normal);
            if (testPoint1 == null) {
                return false;
            }
            normal.negate();
            Point3d testPoint2 = PyroUtil.findTestPoint(mergeModel, mergeFace, pInFace, normal);
            if (testPoint2 == null) {
                return false;
            }
            return model1.contains(testPoint1) && model2.contains(testPoint2) || model1.contains(testPoint2) && model2.contains(testPoint1);
        }
        return false;
    }

    private static Point3d findTestPoint(Model model, Face ignoreFace, Point3d raysrc, Vector3d raydir) {
        AABox bb = model.getBoundingBox();
        double extents = bb.getMin().distance(bb.getMax()) * 2.0;
        Vector3d scaledDir = Util3D.scale(raydir, extents);
        Point3d p2 = Util3D.add(raysrc, (Tuple3d)scaledDir);
        LineSeg3D testCurve = new LineSeg3D(raysrc, p2);
        double neart = Double.MAX_VALUE;
        for (Face face : model.getFaces()) {
            Pair<Double, Model.FaceClassify>[] isects;
            if (face == ignoreFace || (isects = model.isect(testCurve, face, NmtUtil.acceptPointsOnFace(), 1.0E-6)).length <= 0 || !((Double)isects[0].v1 < neart)) continue;
            neart = (Double)isects[0].v1;
        }
        return testCurve.get(neart * 0.5);
    }

    public static void deleteNonFloorBoundaries(Model mergedGridModel) {
        ArrayList<Face> delFaces = new ArrayList<Face>();
        for (Face face : mergedGridModel.getFaces()) {
            boolean partOfMinZ = false;
            for (int groupid : face.groups) {
                int faceid = PyroUtil.extractGridFaceId(groupid)[1];
                if (faceid != 4) continue;
                partOfMinZ = true;
                break;
            }
            if (partOfMinZ) continue;
            delFaces.add(face);
        }
        for (Face delFace : delFaces) {
            mergedGridModel.deleteFace(delFace, true, true);
        }
    }

    public static List<Face> getGridFaces(Model mergedGrids, int gridid) {
        ArrayList<Face> faces = new ArrayList<Face>();
        block0: for (Face face : mergedGrids.getFaces()) {
            for (int groupid : face.groups) {
                if (PyroUtil.extractGridFaceId(groupid)[0] != gridid) continue;
                faces.add(face);
                continue block0;
            }
        }
        return faces;
    }
}

